/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.portletfaces.bridge.BridgeFactory;
import org.portletfaces.bridge.application.BridgeNavigationHandlerFactory;
import org.portletfaces.bridge.config.BridgeConfig;
import org.portletfaces.bridge.config.BridgeConfigConstants;
import org.portletfaces.bridge.container.PortletContainerFactory;
import org.portletfaces.bridge.context.BridgeContextFactory;
import org.portletfaces.bridge.helper.BooleanHelper;
import org.portletfaces.bridge.scope.BridgeRequestScopeFactory;
import org.portletfaces.bridge.scope.BridgeRequestScopeManagerFactory;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeConfigImpl
implements BridgeConfig {
    private static final String BRIDGE_CONTEXT_FACTORY = "bridge:bridge-context-factory";
    private static final String BRIDGE_FACTORY = "bridge:bridge-factory";
    private static final String BRIDGE_NAVIGATION_HANDLER_FACTORY = "bridge:bridge-navigation-handler-factory";
    private static final String BRIDGE_REQUEST_SCOPE_FACTORY = "bridge:bridge-request-scope-factory";
    private static final String BRIDGE_REQUEST_SCOPE_MANAGER_FACTORY = "bridge:bridge-request-scope-manager-factory";
    private static final String PORTLET_CONTAINER_FACTORY = "bridge:portlet-container-factory";
    private static final String META_INF_PATH = "META-INF/faces-config.xml";
    private static final String WEB_INF_PATH = "/WEB-INF/faces-config.xml";
    private static final Logger logger = LoggerFactory.getLogger(BridgeConfigImpl.class);
    private BridgeContextFactory bridgeContextFactory;
    private BridgeFactory bridgeFactory;
    private BridgeNavigationHandlerFactory bridgeNavigationHandlerFactory;
    private BridgeRequestScopeFactory bridgeRequestScopeFactory;
    private BridgeRequestScopeManagerFactory bridgeRequestScopeManagerFactory;
    private Set<String> excludedBridgeRequestScopeAttributes = new HashSet<String>();
    private PortletContainerFactory portletContainerFactory;
    private PortletContext portletContext;
    private Map<String, String[]> publicParameterMappings = new HashMap<String, String[]>();

    public BridgeConfigImpl(PortletConfig portletConfig) {
        this.portletContext = portletConfig.getPortletContext();
        try {
            InputStream inputStream;
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            boolean validating = false;
            saxParserFactory.setValidating(validating);
            saxParserFactory.setNamespaceAware(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            boolean defaultValue = false;
            String initParam = this.portletContext.getInitParameter(BridgeConfigConstants.CONTEXT_PARAM_REQUIRED_TO_RESOLVE_XML_ENTITIES);
            boolean resolveEntities = BooleanHelper.toBoolean(initParam, defaultValue);
            SAXEventHandler saxEventHandler = new SAXEventHandler(resolveEntities);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> facesConfigFiles = classLoader.getResources(META_INF_PATH);
            if (facesConfigFiles != null) {
                while (facesConfigFiles.hasMoreElements()) {
                    URL facesConfigURL = facesConfigFiles.nextElement();
                    logger.debug("Processing faces-config: [{0}]", facesConfigURL);
                    saxEventHandler.setFacesConfigURL(facesConfigURL);
                    InputStream inputStream2 = facesConfigURL.openStream();
                    try {
                        saxParser.parse(inputStream2, (DefaultHandler)saxEventHandler);
                        inputStream2.close();
                        saxParser.reset();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            if ((inputStream = this.portletContext.getResourceAsStream(WEB_INF_PATH)) != null) {
                saxParser.parse(inputStream, (DefaultHandler)saxEventHandler);
                inputStream.close();
            }
            if (this.bridgeFactory == null) {
                logger.error("Factory not found in any faces-config.xml files: [{0}]", BRIDGE_FACTORY);
            }
            if (this.bridgeContextFactory == null) {
                logger.error("Factory not found in any faces-config.xml files: [{0}]", BRIDGE_CONTEXT_FACTORY);
            }
            if (this.bridgeNavigationHandlerFactory == null) {
                logger.error("Factory not found in any faces-config.xml files: [{0}]", BRIDGE_NAVIGATION_HANDLER_FACTORY);
            }
            if (this.bridgeRequestScopeFactory == null) {
                logger.error("Factory not found in any faces-config.xml files: [{0}]", BRIDGE_REQUEST_SCOPE_FACTORY);
            }
            if (this.bridgeRequestScopeManagerFactory == null) {
                logger.error("Factory not found in any faces-config.xml files: [{0}]", BRIDGE_REQUEST_SCOPE_MANAGER_FACTORY);
            }
            if (this.portletContainerFactory == null) {
                logger.error("Factory not found in any faces-config.xml files: [{0}]", PORTLET_CONTAINER_FACTORY);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    protected Object newFactoryInstance(String className, Class<?> factoryClassType, Object wrappedFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object classInstance = null;
        if (classLoader != null && className != null) {
            Constructor<?>[] constructors;
            Class<?> factoryClass = classLoader.loadClass(className);
            Constructor<?> wrapperConstructor = null;
            for (Constructor<?> constructor : constructors = factoryClass.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes == null || parameterTypes.length != 1 || parameterTypes[0] != factoryClassType) continue;
                wrapperConstructor = constructor;
            }
            if (wrapperConstructor == null) {
                logger.debug("Creating instance with zero-arg constructor since wrapperConstructor=null");
                classInstance = factoryClass.newInstance();
            } else {
                logger.debug("Creating instance with one-arg constructor since wrapperConstructor=[{0}]", wrapperConstructor);
                classInstance = wrapperConstructor.newInstance(wrappedFactory);
            }
        }
        return classInstance;
    }

    @Override
    public Object getAttribute(String name) {
        Object value = null;
        if (name != null) {
            if (name.equals("org.portletfaces.bridge.context.BridgeContextFactory")) {
                value = this.bridgeContextFactory;
            } else if (name.equals("org.portletfaces.bridge.BridgeFactory")) {
                value = this.bridgeFactory;
            } else if (name.equals("org.portletfaces.bridge.application.BridgeNavigationHandlerFactory")) {
                value = this.bridgeNavigationHandlerFactory;
            } else if (name.equals("org.portletfaces.bridge.scope.BridgeRequestScopeFactory")) {
                value = this.bridgeRequestScopeFactory;
            } else if (name.equals("org.portletfaces.bridge.scope.BridgeRequestScopeManagerFactory")) {
                value = this.bridgeRequestScopeManagerFactory;
            } else if (name.equals("org.portletfaces.bridge.container.PortletContainerFactory")) {
                value = this.portletContainerFactory;
            }
        }
        return value;
    }

    @Override
    public String getContextParameter(String name) {
        return this.portletContext.getInitParameter(name);
    }

    @Override
    public Set<String> getExcludedBridgeRequestScopeAttributes() {
        return this.excludedBridgeRequestScopeAttributes;
    }

    @Override
    public Map<String, String[]> getPublicParameterMappings() {
        return this.publicParameterMappings;
    }

    @Override
    public String getViewIdFromViewPath(String viewPath) {
        return null;
    }

    private class SAXEventHandler
    extends DefaultHandler {
        private static final String EXCLUDED_ATTRIBUTE = "bridge:excluded-attribute";
        private static final String MODEL_EL = "model-el";
        private static final String PARAMETER = "parameter";
        private URL bridgeConfigURL;
        private StringBuilder content;
        private boolean parsingBridgeContextFactory = false;
        private boolean parsingBridgeFactory = false;
        private boolean parsingBridgeNavigationHandlerFactory = false;
        private boolean parsingBridgeRequestScopeFactory = false;
        private boolean parsingBridgeRequestScopeManagerFactory = false;
        private boolean parsingExcludedAttribute = false;
        private boolean parsingModelEL = false;
        private boolean parsingParameter = false;
        private boolean parsingPortletContainerFactory = false;
        private String parameter;
        private boolean resolveEntities = false;

        public SAXEventHandler(boolean resolveEntities) {
            this.resolveEntities = resolveEntities;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.content != null && ch != null && length > 0) {
                this.content.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            String factoryClassName;
            if (this.parsingBridgeContextFactory) {
                String factoryClassName2 = this.content.toString().trim();
                if (factoryClassName2.length() > 0) {
                    try {
                        BridgeContextFactory wrappedFactory = BridgeConfigImpl.this.bridgeContextFactory;
                        BridgeConfigImpl.this.bridgeContextFactory = (BridgeContextFactory)BridgeConfigImpl.this.newFactoryInstance(factoryClassName2, BridgeContextFactory.class, wrappedFactory);
                        logger.debug("Instantiated bridgeContextFactory=[{0}] wrappedFactory=[{1}]", factoryClassName2, wrappedFactory);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("{0} : factoryClassName=[{1}]", e.getClass().getName(), factoryClassName2);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            } else if (this.parsingBridgeFactory) {
                String factoryClassName3 = this.content.toString().trim();
                if (factoryClassName3.length() > 0) {
                    try {
                        BridgeFactory wrappedFactory = BridgeConfigImpl.this.bridgeFactory;
                        BridgeConfigImpl.this.bridgeFactory = (BridgeFactory)BridgeConfigImpl.this.newFactoryInstance(factoryClassName3, BridgeFactory.class, wrappedFactory);
                        logger.debug("Instantiated bridgeFactory=[{0}] wrappedFactory=[{1}]", factoryClassName3, wrappedFactory);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("{0} : factoryClassName=[{1}]", e.getClass().getName(), factoryClassName3);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            } else if (this.parsingBridgeNavigationHandlerFactory) {
                String factoryClassName4 = this.content.toString().trim();
                if (factoryClassName4.length() > 0) {
                    try {
                        BridgeNavigationHandlerFactory wrappedFactory = BridgeConfigImpl.this.bridgeNavigationHandlerFactory;
                        BridgeConfigImpl.this.bridgeNavigationHandlerFactory = (BridgeNavigationHandlerFactory)BridgeConfigImpl.this.newFactoryInstance(factoryClassName4, BridgeNavigationHandlerFactory.class, wrappedFactory);
                        logger.debug("Instantiated BridgeNavigationHandlerFactory=[{0}] wrappedFactory=[{1}]", factoryClassName4, wrappedFactory);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("{0} : factoryClassName=[{1}]", e.getClass().getName(), factoryClassName4);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            } else if (this.parsingBridgeRequestScopeFactory) {
                String factoryClassName5 = this.content.toString().trim();
                if (factoryClassName5.length() > 0) {
                    try {
                        BridgeRequestScopeFactory wrappedFactory = BridgeConfigImpl.this.bridgeRequestScopeFactory;
                        BridgeConfigImpl.this.bridgeRequestScopeFactory = (BridgeRequestScopeFactory)BridgeConfigImpl.this.newFactoryInstance(factoryClassName5, BridgeRequestScopeFactory.class, wrappedFactory);
                        logger.debug("Instantiated BridgeRequestScopeFactory=[{0}] wrappedFactory=[{1}]", factoryClassName5, wrappedFactory);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("{0} : factoryClassName=[{1}]", e.getClass().getName(), factoryClassName5);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            } else if (this.parsingBridgeRequestScopeManagerFactory) {
                String factoryClassName6 = this.content.toString().trim();
                if (factoryClassName6.length() > 0) {
                    try {
                        BridgeRequestScopeManagerFactory wrappedFactory = BridgeConfigImpl.this.bridgeRequestScopeManagerFactory;
                        BridgeConfigImpl.this.bridgeRequestScopeManagerFactory = (BridgeRequestScopeManagerFactory)BridgeConfigImpl.this.newFactoryInstance(factoryClassName6, BridgeRequestScopeManagerFactory.class, wrappedFactory);
                        logger.debug("Instantiated BridgeRequestScopeManagerFactory=[{0}] wrappedFactory=[{1}]", factoryClassName6, wrappedFactory);
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("{0} : factoryClassName=[{1}]", e.getClass().getName(), factoryClassName6);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            } else if (this.parsingExcludedAttribute) {
                String attributeName = this.content.toString().trim();
                if (attributeName.length() > 0) {
                    BridgeConfigImpl.this.excludedBridgeRequestScopeAttributes.add(attributeName);
                }
            } else if (this.parsingModelEL) {
                String additionalValue = this.content.toString().trim();
                if (additionalValue.length() > 0) {
                    String[] newValue = new String[]{additionalValue};
                    String[] existingValue = (String[])BridgeConfigImpl.this.publicParameterMappings.get(this.parameter);
                    if (existingValue != null) {
                        int total = existingValue.length + 1;
                        newValue = new String[total];
                        for (int i = 0; i < existingValue.length; ++i) {
                            newValue[i] = existingValue[i];
                        }
                        newValue[total - 1] = additionalValue;
                    }
                    BridgeConfigImpl.this.publicParameterMappings.put(this.parameter, newValue);
                }
            } else if (this.parsingParameter) {
                this.parameter = this.content.toString().trim();
            } else if (this.parsingPortletContainerFactory && (factoryClassName = this.content.toString().trim()).length() > 0) {
                try {
                    PortletContainerFactory wrappedFactory = BridgeConfigImpl.this.portletContainerFactory;
                    BridgeConfigImpl.this.portletContainerFactory = (PortletContainerFactory)BridgeConfigImpl.this.newFactoryInstance(factoryClassName, PortletContainerFactory.class, wrappedFactory);
                    logger.debug("Instantiated PortletContainerFactory=[{0}] wrappedFactory=[{1}]", factoryClassName, wrappedFactory);
                }
                catch (ClassNotFoundException e) {
                    logger.error("{0} : factoryClassName=[{1}]", e.getClass().getName(), factoryClassName);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
            this.content = null;
            this.parsingBridgeContextFactory = false;
            this.parsingBridgeFactory = false;
            this.parsingBridgeNavigationHandlerFactory = false;
            this.parsingBridgeRequestScopeFactory = false;
            this.parsingBridgeRequestScopeManagerFactory = false;
            this.parsingExcludedAttribute = false;
            this.parsingModelEL = false;
            this.parsingParameter = false;
            this.parsingPortletContainerFactory = false;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            InputSource inputSource = new InputSource(new StringReader(""));
            if (this.resolveEntities && (inputSource = super.resolveEntity(publicId, systemId)) == null) {
                try {
                    inputSource = new InputSource(new URL(systemId).openStream());
                }
                catch (IOException ioException) {
                    logger.trace("Unable to download publicId=[{0}], systemId=[{1}], referenced-in=[{2}]", publicId, systemId, this.bridgeConfigURL);
                }
            }
            return inputSource;
        }

        public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
            logger.trace("elementName=[]", elementName);
            this.content = new StringBuilder();
            if (elementName.equals(BridgeConfigImpl.BRIDGE_CONTEXT_FACTORY)) {
                this.parsingBridgeContextFactory = true;
            } else if (elementName.equals(BridgeConfigImpl.BRIDGE_FACTORY)) {
                this.parsingBridgeFactory = true;
            } else if (elementName.equals(BridgeConfigImpl.BRIDGE_NAVIGATION_HANDLER_FACTORY)) {
                this.parsingBridgeNavigationHandlerFactory = true;
            } else if (elementName.equals(BridgeConfigImpl.BRIDGE_REQUEST_SCOPE_FACTORY)) {
                this.parsingBridgeRequestScopeFactory = true;
            } else if (elementName.equals(BridgeConfigImpl.BRIDGE_REQUEST_SCOPE_MANAGER_FACTORY)) {
                this.parsingBridgeRequestScopeManagerFactory = true;
            } else if (elementName.equals(EXCLUDED_ATTRIBUTE)) {
                this.parsingExcludedAttribute = true;
            } else if (elementName.equals(MODEL_EL)) {
                this.parsingModelEL = true;
            } else if (elementName.equals(PARAMETER)) {
                this.parsingParameter = true;
            } else if (elementName.equals(BridgeConfigImpl.PORTLET_CONTAINER_FACTORY)) {
                this.parsingPortletContainerFactory = true;
            }
        }

        public void setFacesConfigURL(URL bridgeConfigURL) {
            this.bridgeConfigURL = bridgeConfigURL;
        }
    }
}

