/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.container;

import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.container.PortletContainer;
import org.portletfaces.bridge.container.PortletContainerFactory;
import org.portletfaces.bridge.container.PortletContainerImpl;
import org.portletfaces.bridge.container.liferay.PortletContainerLiferayImpl;
import org.portletfaces.bridge.container.pluto.PortletContainerPlutoImpl;
import org.portletfaces.bridge.container.websphere.PortletContainerWebSphereImpl;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.bridge.context.map.ApplicationMap;

public class PortletContainerFactoryImpl
extends PortletContainerFactory {
    private static final String OBJECT_NAME_PREFIX_LIFERAY = "com.liferay";
    private static final String OBJECT_NAME_PREFIX_PLUTO = "org.apache.pluto";
    private static final String OBJECT_NAME_PREFIX_WEBSPHERE = "com.ibm.ws";
    private static final String REQ_ATTR_PORTLET_CONTAINER = "org.portletfaces.bridge.portletContainer";
    private PortletContainerFactory wrappedFactory;

    public PortletContainerFactoryImpl() {
    }

    public PortletContainerFactoryImpl(PortletContainerFactory portletContainerFactory) {
        this.wrappedFactory = portletContainerFactory;
    }

    public PortletContainer getPortletContainer(BridgeContext bridgeContext) {
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        PortletResponse portletResponse = bridgeContext.getPortletResponse();
        PortletContainer portletContainer = (PortletContainer)portletRequest.getAttribute(REQ_ATTR_PORTLET_CONTAINER);
        if (portletContainer == null) {
            if (this.wrappedFactory != null) {
                portletContainer = this.wrappedFactory.getPortletContainer(bridgeContext);
            }
            if (portletContainer == null) {
                ApplicationMap applicationMap = (ApplicationMap)portletRequest.getAttribute("org.portletfaces.bridge.ApplicationMap");
                String responseNamespace = (String)bridgeContext.getAttribute("org.portletfaces.bridge.responseNamespace");
                Bridge.PortletPhase portletRequestPhase = bridgeContext.getPortletRequestPhase();
                portletContainer = this.isLiferayObject(portletRequest) ? new PortletContainerLiferayImpl(portletRequest, portletResponse, portletRequestPhase, responseNamespace, applicationMap) : (this.isPlutoObject(portletRequest) ? new PortletContainerPlutoImpl(portletRequest, portletResponse, portletRequestPhase, responseNamespace, applicationMap) : (this.isWebSphereObject(portletRequest) ? new PortletContainerWebSphereImpl(portletRequest, portletResponse, portletRequestPhase, responseNamespace, applicationMap) : new PortletContainerImpl(portletRequest, portletResponse, portletRequestPhase, responseNamespace, applicationMap)));
            }
            portletRequest.setAttribute(REQ_ATTR_PORTLET_CONTAINER, (Object)portletContainer);
        }
        if (portletContainer != null) {
            portletContainer.setPortletRequest(portletRequest);
            portletContainer.setPortletResponse(portletResponse);
        }
        return portletContainer;
    }

    protected boolean isLiferayObject(Object obj) {
        if (obj != null) {
            return obj.getClass().getName().startsWith(OBJECT_NAME_PREFIX_LIFERAY);
        }
        return false;
    }

    protected boolean isPlutoObject(Object obj) {
        if (obj != null) {
            return obj.getClass().getName().startsWith(OBJECT_NAME_PREFIX_PLUTO);
        }
        return false;
    }

    protected boolean isWebSphereObject(Object obj) {
        if (obj != null) {
            return obj.getClass().getName().startsWith(OBJECT_NAME_PREFIX_WEBSPHERE);
        }
        return false;
    }

    public PortletContainerFactory getWrapped() {
        return this.wrappedFactory;
    }
}

