/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.container;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ResponseWriter;
import javax.portlet.ActionResponse;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.BridgeFactoryFinder;
import org.portletfaces.bridge.config.BridgeConfig;
import org.portletfaces.bridge.config.BridgeConfigConstants;
import org.portletfaces.bridge.config.BridgeConfigFactory;
import org.portletfaces.bridge.container.PortletContainer;
import org.portletfaces.bridge.context.map.ApplicationMap;
import org.portletfaces.bridge.helper.BooleanHelper;
import org.portletfaces.bridge.renderkit.html_basic.HeadResponseWriter;
import org.portletfaces.bridge.renderkit.html_basic.HeadResponseWriterImpl;
import org.portletfaces.bridge.util.RequestParameter;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContainerImpl
implements PortletContainer {
    private static final Logger logger = LoggerFactory.getLogger(PortletContainerImpl.class);
    private static final String REQUEST_ATTR_PORTLET_REQUEST = "javax.portlet.request";
    private static final String REQUEST_ATTR_QUERY_STRING = "javax.servlet.forward.query_string";
    private Boolean ableToSetHttpStatusCode;
    private Map<String, PortletURL> actionURLCache;
    private ApplicationMap applicationMap;
    private BridgeConfig bridgeConfig;
    private boolean markupHeadElementSupported;
    private PortletRequest portletRequest;
    private Bridge.PortletPhase portletRequestPhase;
    private PortletResponse portletResponse;
    private Map<String, PortletURL> renderURLCache;
    private String requestQueryString;
    private String requestURL;
    private String responseNamespace;
    private Map<String, ResourceURL> resourceURLCache;

    public PortletContainerImpl(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletRequestPhase, String responseNamespace, ApplicationMap applicationMap) {
        this.portletRequest = portletRequest;
        this.portletResponse = portletResponse;
        this.portletRequestPhase = portletRequestPhase;
        this.responseNamespace = responseNamespace;
        this.applicationMap = applicationMap;
        BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
        BridgeConfigFactory bridgeConfigFactory = (BridgeConfigFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.config.BridgeConfigFactory");
        this.bridgeConfig = bridgeConfigFactory.getBridgeConfig();
        String portalVendorClaim = portletRequest.getPortalContext().getProperty("javax.portlet.markup.head.element.support");
        this.markupHeadElementSupported = portalVendorClaim != null;
        this.actionURLCache = new HashMap<String, PortletURL>();
        this.renderURLCache = new HashMap<String, PortletURL>();
        this.resourceURLCache = new HashMap<String, ResourceURL>();
    }

    @Override
    public PortletURL createActionURL(String fromURL) throws MalformedURLException {
        PortletURL actionURL = this.actionURLCache.get(fromURL);
        if (actionURL == null) {
            try {
                logger.debug("createActionURL fromURL=[" + fromURL + "]");
                MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
                actionURL = this.createActionURL(mimeResponse);
                this.copyRequestParameters(fromURL, (BaseURL)actionURL, false);
                this.actionURLCache.put(fromURL, actionURL);
            }
            catch (ClassCastException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        return actionURL;
    }

    @Override
    public ResourceURL createPartialActionURL(String fromURL) throws MalformedURLException {
        logger.debug("createPartialActionURL fromURL=[" + fromURL + "]");
        return this.createResourceURL(fromURL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PortletURL createRedirectURL(String fromURL, Map<String, List<String>> parameters) throws MalformedURLException {
        PortletURL redirectURL = null;
        if (this.portletRequestPhase != Bridge.PortletPhase.RENDER_PHASE && this.portletRequestPhase != Bridge.PortletPhase.RESOURCE_PHASE) throw new UnsupportedOperationException("Unable to create a redirectURL (renderURL) during " + (Object)((Object)this.portletRequestPhase));
        try {
            logger.debug("createRedirectURL fromURL=[" + fromURL + "]");
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            redirectURL = mimeResponse.createRenderURL();
            this.copyRequestParameters(fromURL, (BaseURL)redirectURL, false);
            if (parameters == null) return redirectURL;
            Set<String> parameterNames = parameters.keySet();
            for (String parameterName : parameterNames) {
                List<String> parameterValues = parameters.get(parameterName);
                String[] parameterValuesArray = parameterValues.toArray(new String[parameterValues.size()]);
                redirectURL.setParameter(parameterName, parameterValuesArray);
            }
            return redirectURL;
        }
        catch (ClassCastException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    public PortletURL createRenderURL(String fromURL) throws MalformedURLException {
        PortletURL renderURL = this.renderURLCache.get(fromURL);
        if (renderURL == null && (this.portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE || this.portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE)) {
            try {
                logger.debug("createRenderURL fromURL=[" + fromURL + "]");
                MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
                renderURL = this.createRenderURL(mimeResponse);
                this.copyRequestParameters(fromURL, (BaseURL)renderURL, false);
                this.renderURLCache.put(fromURL, renderURL);
            }
            catch (ClassCastException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        return renderURL;
    }

    @Override
    public ResourceURL createResourceURL(String fromURL) throws MalformedURLException {
        ResourceURL resourceURL = this.resourceURLCache.get(fromURL);
        if (resourceURL == null) {
            try {
                logger.debug("createResourceURL fromURL=[" + fromURL + "]");
                MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
                resourceURL = this.createResourceURL(mimeResponse);
                if (fromURL.indexOf("rfRes") > 0) {
                    fromURL = fromURL.replaceFirst("rfRes", "javax.faces.resource");
                }
                int tokenPos = fromURL.indexOf("javax.faces.resource");
                boolean resourceNameFound = false;
                if (tokenPos >= 0) {
                    int slashPos;
                    String resourceId = fromURL.substring(tokenPos);
                    int queryStringPos = resourceId.indexOf(63);
                    String resourceName = resourceId;
                    if (queryStringPos > 0) {
                        resourceName = resourceName.substring(0, queryStringPos);
                    }
                    if ((slashPos = resourceName.indexOf(47)) > 0) {
                        resourceName = resourceName.substring(slashPos + 1);
                        resourceNameFound = true;
                    } else {
                        logger.error("There is no slash after the [{0}] token in resourceURL=[{1}]", "javax.faces.resource", fromURL);
                    }
                    resourceURL.setParameter("javax.faces.resource", resourceName);
                    logger.debug("Added parameter to portletURL name=[{0}] value=[{1}]", "javax.faces.resource", resourceName);
                }
                this.copyRequestParameters(fromURL, (BaseURL)resourceURL, resourceNameFound);
                this.resourceURLCache.put(fromURL, resourceURL);
            }
            catch (ClassCastException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        return resourceURL;
    }

    @Override
    public String fixRequestParameterValue(String value) {
        return value;
    }

    @Override
    public void redirect(String url) throws IOException {
        if (!(this.portletResponse instanceof ActionResponse)) {
            throw new UnsupportedEncodingException("Unable to redirect during " + (Object)((Object)this.portletRequestPhase) + " (can only be done during ACTION_PHASE)");
        }
        ActionResponse actionResponse = (ActionResponse)this.portletResponse;
        actionResponse.sendRedirect(url);
    }

    protected void copyRequestParameters(String fromURL, BaseURL toURL, boolean facesResource) throws MalformedURLException {
        List<RequestParameter> requestParameters = this.parseRequestParameters(fromURL);
        if (requestParameters != null) {
            for (RequestParameter requestParameter : requestParameters) {
                String name = (String)requestParameter.getName();
                String value = (String)requestParameter.getValue();
                toURL.setParameter(name, value);
                logger.debug("Copied parameter to portletURL name=[{0}] value=[{1}]", name, value);
            }
        }
    }

    protected PortletURL createActionURL(MimeResponse mimeResponse) {
        return mimeResponse.createActionURL();
    }

    protected PortletURL createRenderURL(MimeResponse mimeResponse) {
        return mimeResponse.createRenderURL();
    }

    protected ResourceURL createResourceURL(MimeResponse mimeResponse) {
        return mimeResponse.createResourceURL();
    }

    protected List<RequestParameter> parseRequestParameters(String url) throws MalformedURLException {
        String queryString;
        int pos;
        ArrayList<RequestParameter> requestParameters = null;
        if (url != null && (pos = url.indexOf("?")) > 0 && (queryString = url.substring(pos + 1)) != null && queryString.length() > 0) {
            String[] queryParameters;
            requestParameters = new ArrayList<RequestParameter>();
            for (String queryParameter : queryParameters = queryString.split("[&]")) {
                String[] nameValueArray = queryParameter.split("[=]");
                if (nameValueArray == null) continue;
                if (nameValueArray.length == 2) {
                    String name = nameValueArray[0];
                    String value = nameValueArray[1];
                    requestParameters.add(new RequestParameter(name, value));
                    continue;
                }
                throw new MalformedURLException("invalid name/value pair: " + queryParameter);
            }
        }
        return requestParameters;
    }

    protected ApplicationMap getApplicationMap() {
        return this.applicationMap;
    }

    protected boolean getContextParamAbleToSetHttpStatusCode(boolean defaultValue) {
        String contextParamValue = this.bridgeConfig.getContextParameter(BridgeConfigConstants.CONTEXT_PARAM_CONTAINER_ABLE_TO_SET_HTTP_STATUS_CODE);
        return BooleanHelper.toBoolean(contextParamValue, defaultValue);
    }

    @Override
    public boolean isAbleToAddScriptResourceToHead() {
        return this.isMarkupHeadElementSupported();
    }

    @Override
    public boolean isAbleToAddScriptTextToHead() {
        return this.isMarkupHeadElementSupported();
    }

    @Override
    public boolean isAbleToAddStyleSheetResourceToHead() {
        return this.isMarkupHeadElementSupported();
    }

    protected boolean isMarkupHeadElementSupported() {
        return this.markupHeadElementSupported;
    }

    @Override
    public boolean isAbleToSetHttpStatusCode() {
        if (this.ableToSetHttpStatusCode == null) {
            boolean defaultValue = false;
            this.ableToSetHttpStatusCode = this.getContextParamAbleToSetHttpStatusCode(defaultValue);
        }
        return this.ableToSetHttpStatusCode;
    }

    @Override
    public boolean isAbleToSetResourceResponseBufferSize() {
        return true;
    }

    public HeadResponseWriter getHeadResponseWriter(ResponseWriter wrappableResponseWriter) {
        HeadResponseWriterImpl headResponseWriter = new HeadResponseWriterImpl(wrappableResponseWriter, this.portletResponse);
        return headResponseWriter;
    }

    @Override
    public long getHttpServletRequestDateHeader(String name) {
        return -1L;
    }

    @Override
    public void setMimeResponseContentType(MimeResponse mimeResponse, String contentType) {
        mimeResponse.setContentType(contentType);
    }

    @Override
    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    @Override
    public void setPortletRequest(PortletRequest portletRequest) {
        this.portletRequest = portletRequest;
    }

    @Override
    public PortletResponse getPortletResponse() {
        return this.portletResponse;
    }

    @Override
    public void setPortletResponse(PortletResponse portletResponse) {
        this.portletResponse = portletResponse;
    }

    @Override
    public String getRequestParameter(String name) {
        return this.fixRequestParameterValue(this.getPortletRequest().getParameter(name));
    }

    @Override
    public String[] getRequestParameterValues(String name) {
        String[] values = null;
        String[] originalValues = this.getPortletRequest().getParameterValues(name);
        if (originalValues != null) {
            values = new String[originalValues.length];
            for (int i = 0; i < originalValues.length; ++i) {
                values[i] = this.fixRequestParameterValue(originalValues[i]);
            }
        }
        return values;
    }

    @Override
    public String getRequestQueryString() {
        if (this.requestQueryString == null) {
            Object portletRequestAsObject;
            this.requestQueryString = (String)this.portletRequest.getAttribute(REQUEST_ATTR_QUERY_STRING);
            if (this.requestQueryString == null && (portletRequestAsObject = this.portletRequest.getAttribute(REQUEST_ATTR_PORTLET_REQUEST)) != null && portletRequestAsObject instanceof PortletRequest) {
                this.portletRequest = (PortletRequest)portletRequestAsObject;
                this.requestQueryString = (String)this.portletRequest.getAttribute(REQUEST_ATTR_QUERY_STRING);
            }
        }
        return this.requestQueryString;
    }

    @Override
    public String getRequestURL() {
        if (this.requestURL == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.portletRequest.getScheme());
            buf.append("://");
            buf.append(this.portletRequest.getServerName());
            buf.append(":");
            buf.append(this.portletRequest.getServerPort());
            buf.append(this.portletRequest.getContextPath());
            buf.append("?");
            buf.append(this.getRequestQueryString());
            this.requestURL = buf.toString();
        }
        return this.requestURL;
    }

    protected String getResponseNamespace() {
        return this.responseNamespace;
    }
}

