/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.container.liferay;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletSecurityException;
import org.portletfaces.bridge.container.liferay.ParsedBaseURL;
import org.portletfaces.bridge.context.map.ApplicationMap;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LiferayBaseURL
implements BaseURL {
    private static final Logger logger = LoggerFactory.getLogger(LiferayBaseURL.class);
    ApplicationMap applicationMap;
    Map<String, String[]> parameterMap;
    private ParsedBaseURL parsedLiferayURL;
    private String responseNamespace;
    private String toStringValue;

    public LiferayBaseURL(ParsedBaseURL parsedLiferayURL, String responseNamespace, ApplicationMap applicationMap) {
        this.parsedLiferayURL = parsedLiferayURL;
        this.responseNamespace = responseNamespace;
        this.applicationMap = applicationMap;
        this.parameterMap = new HashMap<String, String[]>();
    }

    public void addProperty(String key, String value) {
    }

    public String encode(String value) {
        String encodedValue = "";
        if (value != null) {
            if (value.length() == 0) {
                encodedValue = " ";
            } else {
                try {
                    encodedValue = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e);
                    encodedValue = " ";
                }
            }
        }
        return encodedValue;
    }

    public void resetToString() {
        this.toStringValue = null;
    }

    public String toString() {
        if (this.toStringValue == null) {
            String portletAuthToken;
            String portalAuthToken;
            StringBuilder url = new StringBuilder();
            url.append(this.parsedLiferayURL.getPrefix());
            boolean firstParameter = true;
            Set<Map.Entry<String, String[]>> mapEntries = this.getParameterMap().entrySet();
            if (mapEntries != null) {
                for (Map.Entry<String, String[]> mapEntry : mapEntries) {
                    String[] values = mapEntry.getValue();
                    if (values == null || values.length <= 0) continue;
                    String parameterName = mapEntry.getKey();
                    String parameterValue = values[0];
                    if (!this.isValidParameter(parameterValue)) continue;
                    this.appendParameterToURL(firstParameter, this.responseNamespace + parameterName, this.encode(parameterValue), url);
                    if (!firstParameter) continue;
                    firstParameter = false;
                }
            }
            if ((portalAuthToken = this.parsedLiferayURL.getPortalAuthToken()) != null) {
                this.appendParameterToURL(firstParameter, "p_auth", portalAuthToken, url);
                if (firstParameter) {
                    firstParameter = false;
                }
            }
            if ((portletAuthToken = this.parsedLiferayURL.getPortletAuthToken()) != null) {
                this.appendParameterToURL(firstParameter, "p_p_auth", portletAuthToken, url);
                if (firstParameter) {
                    firstParameter = false;
                }
            }
            String parameterValue = (String)this.applicationMap.get(this.responseNamespace + "p_p_col_count");
            this.appendParameterToURL(firstParameter, "p_p_col_count", parameterValue, url);
            if (firstParameter) {
                firstParameter = false;
            }
            parameterValue = (String)this.applicationMap.get(this.responseNamespace + "p_p_col_id");
            this.appendParameterToURL(firstParameter, "p_p_col_id", parameterValue, url);
            parameterValue = this.responseNamespace;
            if (parameterValue.startsWith("_")) {
                parameterValue = parameterValue.substring(1);
            }
            if (parameterValue.endsWith("_")) {
                parameterValue = parameterValue.substring(0, parameterValue.length() - 1);
            }
            this.appendParameterToURL(firstParameter, "p_p_id", parameterValue, url);
            parameterValue = (String)this.applicationMap.get(this.responseNamespace + "p_p_col_pos");
            if (parameterValue != null && parameterValue.length() > 0) {
                try {
                    int colPos = Integer.parseInt(parameterValue);
                    if (colPos > 0) {
                        this.appendParameterToURL(firstParameter, "p_p_col_pos", parameterValue, url);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.appendParameterToURL(firstParameter, "p_p_lifecycle", this.getPortletLifecycleId(), url);
            this.toStringValue = url.toString();
        }
        return this.toStringValue;
    }

    public void write(Writer writer) throws IOException {
        writer.write(this.toString());
    }

    public void write(Writer writer, boolean escapeXML) throws IOException {
        writer.write(this.toString());
    }

    protected void appendParameterToURL(boolean firstParameter, String parameterName, String parameterValue, StringBuilder url) {
        if (!firstParameter) {
            url.append("&");
        }
        url.append(parameterName);
        url.append("=");
        url.append(parameterValue);
        logger.debug("Appended param to URL name=[{0}] parameterValue=[{1}]", parameterName, parameterValue);
    }

    public void setParameter(String name, String value) {
        this.parameterMap.put(name, new String[]{value});
        this.resetToString();
    }

    public void setParameter(String name, String[] values) {
        this.parameterMap.put(name, values);
        this.resetToString();
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameterMap.putAll(parameters);
        this.resetToString();
    }

    public abstract String getPortletLifecycleId();

    public void setProperty(String key, String value) {
    }

    protected boolean isValidParameter(String parameterValue) {
        return parameterValue != null;
    }

    public String getResponseNamespace() {
        return this.responseNamespace;
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
    }
}

