/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.container.liferay;

import java.lang.reflect.Method;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.portletfaces.bridge.container.liferay.LiferayThemeDisplay;
import org.portletfaces.bridge.container.liferay.OriginalHttpServletRequest;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class LiferayPortletRequest {
    private static final String REQ_ATTR_LIFERAY_THEME_DISPLAY = "THEME_DISPLAY";
    private static final String METHOD_NAME_GET_ORIGINAL_HTTP_SERVLET_REQUEST = "getOriginalHttpServletRequest";
    Logger logger = LoggerFactory.getLogger(LiferayPortletRequest.class);
    private PortletRequest wrappedPortletRequest;
    private OriginalHttpServletRequest originalHttpServletRequest;
    private LiferayThemeDisplay themeDisplay;

    public LiferayPortletRequest(PortletRequest wrappedPortletRequest) {
        this.wrappedPortletRequest = wrappedPortletRequest;
        try {
            Method method = wrappedPortletRequest.getClass().getMethod(METHOD_NAME_GET_ORIGINAL_HTTP_SERVLET_REQUEST, null);
            this.originalHttpServletRequest = new OriginalHttpServletRequest((HttpServletRequest)method.invoke((Object)wrappedPortletRequest, (Object[])null));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    public long getDateHeader(String name) {
        return this.originalHttpServletRequest.getDateHeader(name);
    }

    public LiferayThemeDisplay getLiferayThemeDisplay() {
        if (this.themeDisplay == null) {
            this.themeDisplay = new LiferayThemeDisplay(this.wrappedPortletRequest.getAttribute(REQ_ATTR_LIFERAY_THEME_DISPLAY));
        }
        return this.themeDisplay;
    }
}

