/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.container.liferay;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.portlet.ActionResponse;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.container.PortletContainerImpl;
import org.portletfaces.bridge.container.liferay.LiferayActionURL;
import org.portletfaces.bridge.container.liferay.LiferayPortletDisplay;
import org.portletfaces.bridge.container.liferay.LiferayPortletRequest;
import org.portletfaces.bridge.container.liferay.LiferayPortletResponse;
import org.portletfaces.bridge.container.liferay.LiferayReleaseInfo;
import org.portletfaces.bridge.container.liferay.LiferayRenderURL;
import org.portletfaces.bridge.container.liferay.LiferayResourceURL;
import org.portletfaces.bridge.container.liferay.LiferayThemeDisplay;
import org.portletfaces.bridge.container.liferay.ParsedBaseURL;
import org.portletfaces.bridge.container.liferay.ParsedPortletURL;
import org.portletfaces.bridge.context.map.ApplicationMap;
import org.portletfaces.bridge.renderkit.html_basic.HeadResponseWriter;
import org.portletfaces.bridge.renderkit.html_basic.HeadResponseWriterLiferayImpl;
import org.portletfaces.bridge.util.RequestParameter;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContainerLiferayImpl
extends PortletContainerImpl {
    private static final Logger logger = LoggerFactory.getLogger(PortletContainerLiferayImpl.class);
    private static final String REQ_PARAM_LIFERAY_BROWSERID = "?browserId=";
    private static final String RENDER_PORTLET_RESOURCE = "RENDER_PORTLET_RESOURCE";
    private String NAMESPACED_P_P_COL_ID;
    private String NAMESPACED_P_P_COL_POS;
    private String NAMESPACED_P_P_COL_COUNT;
    private String NAMESPACED_P_P_MODE;
    private String NAMESPACED_P_P_STATE;
    private boolean ableToAddScriptResourceToHead;
    private boolean ableToAddScriptTextToHead;
    private boolean ableToAddStyleSheetResourceToHead;
    private boolean ableToSetHttpStatusCode;
    private LiferayPortletRequest liferayPortletRequest;
    private ParsedPortletURL parsedLiferayActionURL;
    private ParsedPortletURL parsedLiferayRenderURL;
    private ParsedBaseURL parsedLiferayResourceURL;
    private String requestURL;

    public PortletContainerLiferayImpl(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletRequestPhase, String responseNamespace, ApplicationMap applicationMap) {
        super(portletRequest, portletResponse, portletRequestPhase, responseNamespace, applicationMap);
        try {
            Boolean renderPortletResource;
            boolean runtimePortlet;
            LiferayPortletRequest liferayPortletRequest = new LiferayPortletRequest(portletRequest);
            LiferayThemeDisplay liferayThemeDisplay = liferayPortletRequest.getLiferayThemeDisplay();
            this.liferayPortletRequest = liferayPortletRequest;
            this.NAMESPACED_P_P_COL_ID = responseNamespace + "p_p_col_id";
            this.NAMESPACED_P_P_COL_POS = responseNamespace + "p_p_col_pos";
            this.NAMESPACED_P_P_COL_COUNT = responseNamespace + "p_p_col_count";
            this.NAMESPACED_P_P_MODE = responseNamespace + "p_p_mode";
            this.NAMESPACED_P_P_STATE = responseNamespace + "p_p_state";
            if (portletRequest instanceof RenderRequest) {
                PortletMode portletMode = portletRequest.getPortletMode();
                WindowState windowState = portletRequest.getWindowState();
                this.saveRenderAttributes(portletMode, windowState, liferayThemeDisplay, responseNamespace, applicationMap);
            }
            LiferayReleaseInfo liferayReleaseInfo = new LiferayReleaseInfo();
            int liferayBuildNumber = liferayReleaseInfo.getBuildNumber();
            if (logger.isDebugEnabled()) {
                logger.debug("Detected Liferay build number {0}", Long.toString(liferayBuildNumber));
            }
            boolean defaultValue = false;
            if (liferayBuildNumber >= 6011 || liferayBuildNumber >= 6005 && liferayBuildNumber <= 6010) {
                defaultValue = true;
            }
            boolean bl = runtimePortlet = (renderPortletResource = (Boolean)portletRequest.getAttribute(RENDER_PORTLET_RESOURCE)) != null && renderPortletResource != false;
            if (runtimePortlet) {
                this.ableToAddScriptResourceToHead = false;
                this.ableToAddScriptTextToHead = false;
                this.ableToAddStyleSheetResourceToHead = false;
            } else {
                this.ableToAddScriptResourceToHead = true;
                this.ableToAddScriptTextToHead = true;
                this.ableToAddStyleSheetResourceToHead = true;
            }
            this.ableToSetHttpStatusCode = this.getContextParamAbleToSetHttpStatusCode(defaultValue);
            logger.debug("User-Agent requested URL=[{0}]", this.getRequestURL());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public PortletURL createRedirectURL(String fromURL, Map<String, List<String>> parameters) throws MalformedURLException {
        LiferayPortletResponse liferayPortletResponse = new LiferayPortletResponse(this.getPortletResponse());
        PortletURL redirectURL = liferayPortletResponse.createRenderURL();
        this.copyRequestParameters(fromURL, (BaseURL)redirectURL, false);
        if (parameters != null) {
            Set<String> parameterNames = parameters.keySet();
            for (String parameterName : parameterNames) {
                List<String> parameterValues = parameters.get(parameterName);
                String[] parameterValuesArray = parameterValues.toArray(new String[parameterValues.size()]);
                redirectURL.setParameter(parameterName, parameterValuesArray);
            }
        }
        return redirectURL;
    }

    @Override
    public String fixRequestParameterValue(String value) {
        int pos;
        if (value != null && (pos = value.indexOf(REQ_PARAM_LIFERAY_BROWSERID)) > 0) {
            value = value.substring(0, pos);
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void redirect(String url) throws IOException {
        PortletResponse portletResponse = this.getPortletResponse();
        if (portletResponse instanceof ActionResponse) {
            LiferayPortletResponse liferayActionResponse = new LiferayPortletResponse(portletResponse);
            liferayActionResponse.sendRedirect(url);
            return;
        } else {
            if (!(portletResponse instanceof ResourceResponse)) throw new UnsupportedEncodingException("Can not redirect during the current phase: " + portletResponse.getClass().getSimpleName());
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!facesContext.getPartialViewContext().isPartialRequest()) throw new UnsupportedEncodingException("Can only redirect during RESOURCE_PHASE if a JSF partial/Ajax request has been triggered");
            ResourceResponse resourceResponse = (ResourceResponse)portletResponse;
            resourceResponse.setContentType("text/xml");
            resourceResponse.setCharacterEncoding("UTF-8");
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            PartialResponseWriter partialResponseWriter = responseWriter instanceof PartialResponseWriter ? (PartialResponseWriter)responseWriter : facesContext.getPartialViewContext().getPartialResponseWriter();
            partialResponseWriter.startDocument();
            partialResponseWriter.redirect(url);
            partialResponseWriter.endDocument();
            facesContext.responseComplete();
        }
    }

    @Override
    protected void copyRequestParameters(String fromURL, BaseURL toURL, boolean facesResource) throws MalformedURLException {
        List<RequestParameter> requestParameters = this.parseRequestParameters(fromURL);
        boolean foundLibraryName = false;
        boolean foundVersion = false;
        if (requestParameters != null) {
            for (RequestParameter requestParameter : requestParameters) {
                String name = (String)requestParameter.getName();
                String value = (String)requestParameter.getValue();
                toURL.setParameter(name, value);
                if (facesResource) {
                    if (!foundLibraryName) {
                        foundLibraryName = "ln".equals(name);
                    }
                    if (!foundVersion) {
                        foundVersion = "v".equals(name);
                    }
                }
                logger.debug("Copied parameter to portletURL name=[{0}] value=[{1}]", name, value);
            }
        }
    }

    @Override
    protected PortletURL createActionURL(MimeResponse mimeResponse) {
        return new LiferayActionURL(this.getParsedLiferayActionURL(mimeResponse), this.getResponseNamespace(), this.getApplicationMap());
    }

    @Override
    protected PortletURL createRenderURL(MimeResponse mimeResponse) {
        return new LiferayRenderURL(this.getParsedLiferayRenderURL(mimeResponse), this.getResponseNamespace(), this.getApplicationMap());
    }

    @Override
    protected ResourceURL createResourceURL(MimeResponse mimeResponse) {
        return new LiferayResourceURL(this.getParsedLiferayResourceURL(mimeResponse), this.getResponseNamespace(), this.getApplicationMap());
    }

    protected void saveRenderAttributes(PortletMode portletMode, WindowState windowState, LiferayThemeDisplay themeDisplay, String responseNamespace, ApplicationMap applicationMap) {
        try {
            LiferayPortletDisplay portletDisplay = themeDisplay.getLiferayPortletDisplay();
            applicationMap.put(this.NAMESPACED_P_P_COL_ID, portletDisplay.getColumnId());
            applicationMap.put(this.NAMESPACED_P_P_COL_POS, portletDisplay.getColumnPos());
            applicationMap.put(this.NAMESPACED_P_P_COL_COUNT, portletDisplay.getColumnCount());
            if (portletMode != null) {
                applicationMap.put(this.NAMESPACED_P_P_MODE, portletMode.toString());
            }
            if (windowState != null) {
                applicationMap.put(this.NAMESPACED_P_P_STATE, windowState.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public boolean isAbleToAddScriptResourceToHead() {
        return this.ableToAddScriptResourceToHead;
    }

    @Override
    public boolean isAbleToAddScriptTextToHead() {
        return this.ableToAddScriptTextToHead;
    }

    @Override
    public boolean isAbleToAddStyleSheetResourceToHead() {
        return this.ableToAddStyleSheetResourceToHead;
    }

    @Override
    protected boolean isMarkupHeadElementSupported() {
        return false;
    }

    @Override
    public boolean isAbleToSetHttpStatusCode() {
        return this.ableToSetHttpStatusCode;
    }

    protected String getEncodedRequestParameterValue(PortletRequest portletRequest, String parameterName) {
        String encodedRequestParameterValue = portletRequest.getParameter(parameterName);
        if (encodedRequestParameterValue != null) {
            try {
                encodedRequestParameterValue = URLEncoder.encode(encodedRequestParameterValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return encodedRequestParameterValue;
    }

    @Override
    public HeadResponseWriter getHeadResponseWriter(ResponseWriter wrappableResponseWriter) {
        HeadResponseWriterLiferayImpl headResponseWriter = new HeadResponseWriterLiferayImpl(wrappableResponseWriter, this.getPortletRequest());
        return headResponseWriter;
    }

    @Override
    public long getHttpServletRequestDateHeader(String name) {
        return this.liferayPortletRequest.getDateHeader(name);
    }

    protected ParsedPortletURL getParsedLiferayActionURL(MimeResponse mimeResponse) {
        if (this.parsedLiferayActionURL == null) {
            PortletURL liferayActionURL = mimeResponse.createActionURL();
            this.parsedLiferayActionURL = new ParsedPortletURL(liferayActionURL);
        }
        return this.parsedLiferayActionURL;
    }

    protected ParsedPortletURL getParsedLiferayRenderURL(MimeResponse mimeResponse) {
        if (this.parsedLiferayRenderURL == null) {
            PortletURL liferayRenderURL = mimeResponse.createRenderURL();
            this.parsedLiferayRenderURL = new ParsedPortletURL(liferayRenderURL);
        }
        return this.parsedLiferayRenderURL;
    }

    protected ParsedBaseURL getParsedLiferayResourceURL(MimeResponse mimeResponse) {
        if (this.parsedLiferayResourceURL == null) {
            ResourceURL liferayResourceURL = mimeResponse.createResourceURL();
            this.parsedLiferayResourceURL = new ParsedBaseURL((BaseURL)liferayResourceURL);
        }
        return this.parsedLiferayResourceURL;
    }

    @Override
    public String getRequestURL() {
        if (this.requestURL == null) {
            StringBuilder buf = new StringBuilder();
            LiferayThemeDisplay themeDisplay = this.liferayPortletRequest.getLiferayThemeDisplay();
            buf.append(themeDisplay.getURLPortal());
            buf.append(themeDisplay.getURLCurrent());
            this.requestURL = buf.toString();
        }
        return this.requestURL;
    }
}

