/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.Flash;
import javax.portlet.ClientDataRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.servlet.http.Cookie;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.BridgeFactoryFinder;
import org.portletfaces.bridge.BridgeInvalidViewPathException;
import org.portletfaces.bridge.application.ResourceHandlerImpl;
import org.portletfaces.bridge.config.BridgeConfig;
import org.portletfaces.bridge.config.BridgeConfigFactory;
import org.portletfaces.bridge.container.PortletContainer;
import org.portletfaces.bridge.container.PortletContainerFactory;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.bridge.context.flash.BridgeFlash;
import org.portletfaces.bridge.context.flash.BridgeFlashFactory;
import org.portletfaces.bridge.context.flash.HttpServletResponseAdapter;
import org.portletfaces.bridge.context.map.ApplicationMap;
import org.portletfaces.bridge.context.map.InitParameterMap;
import org.portletfaces.bridge.context.map.RequestAttributeMap;
import org.portletfaces.bridge.context.map.RequestCookieMap;
import org.portletfaces.bridge.context.map.RequestHeaderMap;
import org.portletfaces.bridge.context.map.RequestHeaderValuesMap;
import org.portletfaces.bridge.context.map.RequestParameterMapFactory;
import org.portletfaces.bridge.context.map.SessionMap;
import org.portletfaces.bridge.helper.BooleanHelper;
import org.portletfaces.bridge.lifecycle.CongruousTask;
import org.portletfaces.bridge.lifecycle.LifecycleIncongruityManager;
import org.portletfaces.bridge.lifecycle.LifecycleIncongruityMap;
import org.portletfaces.bridge.util.FacesViewUtil;
import org.portletfaces.bridge.util.FileNameUtil;
import org.portletfaces.bridge.util.LocaleIterator;
import org.portletfaces.bridge.util.StringIterator;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalContextImpl
extends ExternalContext {
    public static final String FACES_VIEW_ID = "_facesViewId";
    private static final Logger logger = LoggerFactory.getLogger(ExternalContextImpl.class);
    private static final String COOKIE_PROPERTY_COMMENT = "comment";
    private static final String COOKIE_PROPERTY_DOMAIN = "domain";
    private static final String COOKIE_PROPERTY_MAX_AGE = "maxAge";
    private static final String COOKIE_PROPERTY_PATH = "path";
    private static final String COOKIE_PROPERTY_SECURE = "secure";
    private static final String NON_NUMERIC_NAMESPACE_PREFIX = "A";
    private PortletContainer portletContainer;
    private PortletContext portletContext;
    private PortletRequest portletRequest;
    private PortletResponse portletResponse;
    private ApplicationMap applicationMap;
    private BridgeConfig bridgeConfig;
    private Map<String, String> defaultViewIdMap;
    private LifecycleIncongruityMap lifecycleIncongruityMap;
    private LifecycleIncongruityManager lifecycleIncongruityManager;
    private PortletConfig portletConfig;
    private Bridge.PortletPhase portletRequestPhase;
    private Map<String, Object> requestAttributeMap;
    private String requestContextPath;
    private Map<String, String> requestHeaderMap;
    private Map<String, String[]> requestHeaderValuesMap;
    private Iterator<Locale> requestLocales;
    private Map<String, String> requestParameterMap;
    private String responseNamespace;
    private Map<String, Object> sessionMap;
    private String authType;
    private BridgeFlash bridgeFlash;
    private Map<String, String> initParameterMap;
    private String portletContextName;
    private String remoteUser;
    private Map<String, Object> requestCookieMap;
    private Map<String, String[]> requestParameterValuesMap;
    private Locale requestLocale;
    private String responseContentType;
    private Principal userPrincipal;

    public ExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.portletContext = portletContext;
        this.portletRequest = portletRequest;
        this.portletResponse = portletResponse;
        try {
            boolean requestChanged = false;
            boolean responseChanged = false;
            this.preInitializeObjects(requestChanged, responseChanged);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void addResponseCookie(String name, String value, Map<String, Object> properties) {
        Cookie cookie = new Cookie(name, value);
        if (properties != null && !properties.isEmpty()) {
            try {
                cookie.setComment((String)properties.get(COOKIE_PROPERTY_COMMENT));
                cookie.setDomain((String)properties.get(COOKIE_PROPERTY_DOMAIN));
                cookie.setMaxAge(((Integer)properties.get(COOKIE_PROPERTY_MAX_AGE)).intValue());
                cookie.setPath((String)properties.get(COOKIE_PROPERTY_PATH));
                cookie.setSecure(((Boolean)properties.get(COOKIE_PROPERTY_SECURE)).booleanValue());
            }
            catch (ClassCastException e) {
                logger.error(e.getMessage(), e);
            }
        }
        this.portletResponse.addProperty(cookie);
    }

    public void addResponseHeader(String name, String value) {
        if (this.portletResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
            resourceResponse.addProperty(name, value);
        } else {
            logger.warn("Unable to call {0} for portletResponse=[{1}] because it is not a ResourceResponse.", "portletResponse.addProperty(String, String)", this.portletResponse.getClass().getName());
        }
    }

    public void dispatch(String path) throws IOException {
        PortletRequestDispatcher portletRequestDispacher = this.portletContext.getRequestDispatcher(path);
        try {
            portletRequestDispacher.forward(this.portletRequest, this.portletResponse);
        }
        catch (PortletException e) {
            logger.error(e.getMessage(), new Object[]{e});
            throw new IOException(e.getMessage());
        }
    }

    public String encodeActionURL(String url) {
        String actionURL = null;
        if (url != null) {
            String viewId = url;
            if (url.startsWith("http")) {
                actionURL = url;
                logger.debug("URL starts with http so assuming that it has already been encoded: url=[{0}]", url);
            } else {
                if (url.startsWith(this.requestContextPath)) {
                    viewId = url.substring(this.requestContextPath.length());
                }
                try {
                    PortletURL portletActionURL = this.portletContainer.createActionURL(url);
                    portletActionURL.setParameter(FACES_VIEW_ID, viewId);
                    actionURL = portletActionURL.toString();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
        } else {
            logger.warn("Unable to encode ActionURL for url=[null]");
        }
        return actionURL;
    }

    public String encodeBookmarkableURL(String baseUrl, Map<String, List<String>> parameters) {
        String renderURL;
        block9: {
            renderURL = null;
            if (baseUrl != null) {
                String viewId = baseUrl;
                if (baseUrl.startsWith(this.requestContextPath)) {
                    viewId = baseUrl.substring(this.requestContextPath.length());
                }
                try {
                    if (this.portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE || this.portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
                        PortletURL portletRenderURL = this.portletContainer.createRenderURL(baseUrl);
                        portletRenderURL.setParameter(FACES_VIEW_ID, viewId);
                        if (parameters != null) {
                            for (Map.Entry<String, List<String>> parameter : parameters.entrySet()) {
                                int size;
                                List<String> values;
                                String name = parameter.getKey();
                                if (name == null || (values = parameter.getValue()) == null || (size = values.size()) <= 0) continue;
                                if (size == 1) {
                                    String value = values.get(0);
                                    if (value == null) continue;
                                    portletRenderURL.setParameter(name, value);
                                    continue;
                                }
                                logger.warn("Unable to append multiple values for parameter name=[{0]", name);
                            }
                        }
                        renderURL = portletRenderURL.toString();
                        break block9;
                    }
                    logger.error("Unable to encode bookmarkable URL during Bridge.PortletPhase.[{0}] -- you should call BridgeUtil.getPortletRequestPhase() and check for Bridge.PortletPhase.RENDER_PHASE or Bridge.PortletPhase.RESOURCE_PHASE before calling ExternalContext.encodeBookmarkableURL(...).", new Object[]{this.portletRequestPhase});
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            } else {
                logger.warn("Unable to encode RenderURL for url=[null]");
            }
        }
        return renderURL;
    }

    public String encodeNamespace(String name) {
        return this.responseNamespace + name;
    }

    public String encodePartialActionURL(String url) {
        String partialActionURL = null;
        if (url != null) {
            String viewId = url;
            if (url.startsWith("http")) {
                partialActionURL = url;
                logger.debug("URL starts with http so assuming that it has already been encoded: url=[{0}]", url);
            } else {
                if (url.startsWith(this.requestContextPath)) {
                    viewId = url.substring(this.requestContextPath.length());
                }
                try {
                    ResourceURL resourceURL = this.portletContainer.createPartialActionURL(url);
                    resourceURL.setParameter(FACES_VIEW_ID, viewId);
                    partialActionURL = resourceURL.toString();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
        } else {
            logger.warn("Unable to encode PartialActionURL for url=[null]");
        }
        return partialActionURL;
    }

    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        String redirectURL = null;
        try {
            PortletURL portletURL = this.portletContainer.createRedirectURL(baseUrl, parameters);
            redirectURL = portletURL.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return redirectURL;
    }

    public String encodeResourceURL(String url) {
        String resourceURL = url;
        if (ResourceHandlerImpl.isFacesResourceURL(url)) {
            if (!ResourceHandlerImpl.isEncodedFacesResourceURL(resourceURL)) {
                try {
                    ResourceURL portletResourceURL = this.portletContainer.createResourceURL(url);
                    resourceURL = portletResourceURL.toString();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
            }
        } else {
            logger.debug("Not bothering to encode non-faces resource URL=[{0}]", url);
        }
        return resourceURL;
    }

    public void invalidateSession() {
        this.portletRequest.getPortletSession(true).invalidate();
    }

    public void log(String message) {
        this.portletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        this.portletContext.log(message, exception);
    }

    public void redirect(String url) throws IOException {
        this.portletContainer.redirect(url);
    }

    public void responseFlushBuffer() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            mimeResponse.flushBuffer();
        } else {
            this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.RESPONSE_FLUSH_BUFFER);
        }
    }

    public void responseReset() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            mimeResponse.reset();
        } else {
            this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.RESPONSE_RESET);
        }
    }

    public void responseSendError(int statusCode, String message) throws IOException {
        String errorMessage = "Status code " + statusCode + ": " + message;
        logger.error(errorMessage);
        throw new IOException(errorMessage);
    }

    protected void preInitializeObjects(boolean requestChanged, boolean responseChanged) {
        BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
        BridgeConfigFactory bridgeConfigFactory = (BridgeConfigFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.config.BridgeConfigFactory");
        this.bridgeConfig = bridgeConfigFactory.getBridgeConfig();
        BridgeContext bridgeContext = (BridgeContext)this.portletRequest.getAttribute("javax.portlet.faces.bridgeContext");
        PortletRequest portletRequestBackup = null;
        if (requestChanged) {
            portletRequestBackup = bridgeContext.getPortletRequest();
            bridgeContext.setPortletRequest(this.portletRequest);
        }
        PortletResponse portletResponseBackup = null;
        if (responseChanged) {
            portletResponseBackup = bridgeContext.getPortletResponse();
            bridgeContext.setPortletResponse(this.portletResponse);
        }
        this.defaultViewIdMap = bridgeContext.getDefaultViewIdMap();
        this.portletRequestPhase = bridgeContext.getPortletRequestPhase();
        this.portletConfig = bridgeContext.getPortletConfig();
        boolean preferPreDestroy = BooleanHelper.toBoolean(this.getInitParameter("org.portletfaces.bridge.preferPreDestroy"), true);
        this.applicationMap = new ApplicationMap(this.portletContext, preferPreDestroy);
        this.requestAttributeMap = new RequestAttributeMap(this.portletRequest, preferPreDestroy);
        this.sessionMap = new SessionMap(this.portletRequest.getPortletSession(true), 2, preferPreDestroy);
        this.lifecycleIncongruityMap = new LifecycleIncongruityMap(this.applicationMap);
        this.lifecycleIncongruityManager = new LifecycleIncongruityManager(this.lifecycleIncongruityMap);
        this.initParameterMap = Collections.unmodifiableMap(new InitParameterMap(this.portletContext));
        this.requestContextPath = this.portletRequest.getContextPath();
        this.requestLocales = new LocaleIterator(this.portletRequest.getLocales());
        this.responseNamespace = this.portletResponse.getNamespace();
        PortletContainerFactory portletContainerFactory = (PortletContainerFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.container.PortletContainerFactory");
        this.portletRequest.setAttribute("org.portletfaces.bridge.ApplicationMap", (Object)this.applicationMap);
        bridgeContext.setAttribute("org.portletfaces.bridge.responseNamespace", this.responseNamespace);
        this.portletContainer = portletContainerFactory.getPortletContainer(bridgeContext);
        this.portletRequest.removeAttribute("org.portletfaces.bridge.ApplicationMap");
        RequestParameterMapFactory requestParameterMapFactory = new RequestParameterMapFactory(this.portletContainer, this.portletRequest, this.portletRequestPhase);
        this.requestParameterMap = requestParameterMapFactory.getRequestParameterMap();
        this.requestParameterValuesMap = requestParameterMapFactory.getRequestParameterValuesMap();
        this.requestHeaderValuesMap = Collections.unmodifiableMap(new RequestHeaderValuesMap(this.portletRequest, this.requestParameterMap));
        this.requestHeaderMap = Collections.unmodifiableMap(new RequestHeaderMap(this.requestHeaderValuesMap));
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            this.responseContentType = mimeResponse.getContentType();
        }
        boolean optimizePortletNamespace = BooleanHelper.toBoolean(this.getInitParameter("org.portletfaces.bridge.optimizePortletNamespace"), true);
        boolean addedNamespacePrefix = false;
        if (optimizePortletNamespace) {
            String namespaceHashCode;
            int namespaceHashCodeLength;
            int hashCode = this.responseNamespace.hashCode();
            if (hashCode < 0) {
                hashCode *= -1;
            }
            if ((namespaceHashCodeLength = (namespaceHashCode = Integer.toString(hashCode)).length()) > 4) {
                namespaceHashCode = namespaceHashCode.substring(namespaceHashCodeLength - 4);
            }
            if (namespaceHashCode.length() < this.responseNamespace.length()) {
                this.responseNamespace = NON_NUMERIC_NAMESPACE_PREFIX + namespaceHashCode;
                addedNamespacePrefix = true;
            }
        }
        if (!addedNamespacePrefix) {
            this.responseNamespace = NON_NUMERIC_NAMESPACE_PREFIX + this.responseNamespace;
        }
        if (requestChanged) {
            bridgeContext.setPortletRequest(portletRequestBackup);
        }
        if (responseChanged) {
            bridgeContext.setPortletResponse(portletResponseBackup);
        }
    }

    protected void saveViewIdRequestParameters(String requestPathInfo) {
    }

    public Map<String, Object> getApplicationMap() {
        return this.applicationMap;
    }

    public String getAuthType() {
        if (this.authType == null) {
            this.authType = this.portletRequest.getAuthType();
        }
        return this.authType;
    }

    public void setBridgeFlash(BridgeFlash bridgeFlash) {
        this.bridgeFlash = bridgeFlash;
    }

    public Object getContext() {
        return this.portletContext;
    }

    public String getContextName() {
        if (this.portletContextName == null) {
            this.portletContextName = this.portletContext.getPortletContextName();
        }
        return this.portletContextName;
    }

    public boolean isResponseCommitted() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            boolean responseCommitted = mimeResponse.isCommitted();
            this.lifecycleIncongruityMap.putResponseCommitted(responseCommitted);
            return responseCommitted;
        }
        return this.lifecycleIncongruityMap.isResponseCommitted();
    }

    public boolean isUserInRole(String role) {
        return this.portletRequest.isUserInRole(role);
    }

    public Flash getFlash() {
        if (this.bridgeFlash == null) {
            this.bridgeFlash = BridgeFlashFactory.getBridgeFlash(this);
        }
        return this.bridgeFlash;
    }

    public String getInitParameter(String name) {
        String initParameter = this.portletConfig.getInitParameter(name);
        if (initParameter == null) {
            initParameter = this.portletContext.getInitParameter(name);
        }
        return initParameter;
    }

    public Map<String, String> getInitParameterMap() {
        return this.initParameterMap;
    }

    public String getMimeType(String fileName) {
        String mimeType = this.portletContext.getMimeType(fileName);
        if (mimeType == null || mimeType.length() == 0) {
            mimeType = FileNameUtil.getFileNameMimeType(fileName);
        }
        return mimeType;
    }

    public String getRealPath(String path) {
        return this.portletContext.getRealPath(path);
    }

    public String getRemoteUser() {
        if (this.remoteUser == null) {
            this.remoteUser = this.portletRequest.getRemoteUser();
        }
        return this.remoteUser;
    }

    public Object getRequest() {
        return this.portletRequest;
    }

    public void setRequest(Object request) {
        this.portletRequest = (PortletRequest)request;
        try {
            boolean requestChanged = true;
            boolean responseChanged = false;
            this.preInitializeObjects(requestChanged, responseChanged);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public String getRequestCharacterEncoding() {
        String requestCharacterEncoding = null;
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            requestCharacterEncoding = clientDataRequest.getCharacterEncoding();
            this.lifecycleIncongruityMap.putRequestCharacterEncoding(requestCharacterEncoding);
        } else {
            requestCharacterEncoding = this.lifecycleIncongruityMap.getRequestCharacterEncoding();
        }
        return requestCharacterEncoding;
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException, IllegalStateException {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            clientDataRequest.setCharacterEncoding(encoding);
        } else {
            this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.SET_REQUEST_CHARACTER_ENCODING);
        }
        this.lifecycleIncongruityMap.putRequestCharacterEncoding(encoding);
    }

    public int getRequestContentLength() {
        int requestContentLength = -1;
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            requestContentLength = clientDataRequest.getContentLength();
            this.lifecycleIncongruityMap.putRequestContentLength(requestContentLength);
        } else {
            requestContentLength = this.lifecycleIncongruityMap.getRequestContentLength();
        }
        return requestContentLength;
    }

    public String getRequestContentType() {
        String requestContentType = null;
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            requestContentType = clientDataRequest.getResponseContentType();
            this.lifecycleIncongruityMap.putRequestContentType(requestContentType);
        } else {
            requestContentType = this.lifecycleIncongruityMap.getRequestContentType();
        }
        return requestContentType;
    }

    public String getRequestContextPath() {
        return this.requestContextPath;
    }

    public Map<String, Object> getRequestCookieMap() {
        if (this.requestCookieMap == null) {
            this.requestCookieMap = new RequestCookieMap(this.portletRequest.getCookies());
        }
        return this.requestCookieMap;
    }

    public Map<String, String> getRequestHeaderMap() {
        return this.requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        return this.requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        if (this.requestLocale == null) {
            this.requestLocale = this.portletRequest.getLocale();
        }
        return this.requestLocale;
    }

    public Iterator<Locale> getRequestLocales() {
        return this.requestLocales;
    }

    public Map<String, Object> getRequestMap() {
        return this.requestAttributeMap;
    }

    public Map<String, String> getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public Iterator<String> getRequestParameterNames() {
        return new StringIterator(this.portletRequest.getParameterNames());
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        return this.requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        String requestPathInfo = (String)this.portletRequest.getAttribute("javax.portlet.faces.viewId");
        if (requestPathInfo == null) {
            String viewPath = (String)this.portletRequest.getAttribute("javax.portlet.faces.viewPath");
            if (viewPath != null) {
                requestPathInfo = this.bridgeConfig.getViewIdFromViewPath(viewPath);
                if (requestPathInfo == null) {
                    throw new BridgeInvalidViewPathException();
                }
                logger.debug("javax.portlet.faces.viewPath=[{0}]", requestPathInfo);
            }
            if (requestPathInfo == null) {
                requestPathInfo = FacesViewUtil.getViewIdFromPriorRedirect();
                if (requestPathInfo == null) {
                    requestPathInfo = this.portletRequest.getParameter(FACES_VIEW_ID);
                    if (requestPathInfo == null) {
                        PortletMode currentPortletMode = this.portletRequest.getPortletMode();
                        requestPathInfo = this.defaultViewIdMap.get(currentPortletMode.toString());
                        logger.debug("portlet.xml viewId=[{0}] portletMode=[{1}]", requestPathInfo, currentPortletMode);
                    } else {
                        logger.debug("request parameter {0}=[{1}]", FACES_VIEW_ID, requestPathInfo);
                    }
                } else {
                    logger.debug("redirect viewId=[{0}]", requestPathInfo);
                }
            }
        } else {
            logger.debug("javax.portlet.faces.viewId=[{0}]", requestPathInfo);
        }
        this.saveViewIdRequestParameters(requestPathInfo);
        return requestPathInfo;
    }

    public String getRequestScheme() {
        return this.portletRequest.getScheme();
    }

    public String getRequestServerName() {
        return this.portletRequest.getServerName();
    }

    public int getRequestServerPort() {
        return this.portletRequest.getServerPort();
    }

    public String getRequestServletPath() {
        return "";
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.portletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.portletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.portletContext.getResourcePaths(path);
    }

    public Object getResponse() {
        if (this.bridgeFlash != null && this.bridgeFlash.isServletResponseRequired()) {
            return new HttpServletResponseAdapter(this.portletResponse, this.getRequestLocale());
        }
        return this.portletResponse;
    }

    public void setResponse(Object response) {
        this.portletResponse = (PortletResponse)response;
        try {
            boolean requestChanged = false;
            boolean responseChanged = true;
            this.preInitializeObjects(requestChanged, responseChanged);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public int getResponseBufferSize() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            int responseBufferSize = mimeResponse.getBufferSize();
            this.lifecycleIncongruityMap.putResponseBufferSize(responseBufferSize);
            return responseBufferSize;
        }
        return this.lifecycleIncongruityMap.getResponseBufferSize();
    }

    public void setResponseBufferSize(int size) {
        if (this.portletContainer.isAbleToSetResourceResponseBufferSize()) {
            if (this.portletResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
                resourceResponse.setBufferSize(size);
            } else {
                this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.SET_RESPONSE_BUFFER_SIZE);
            }
        }
        this.lifecycleIncongruityMap.putResponseBufferSize(size);
    }

    public String getResponseCharacterEncoding() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            String characterEncoding = mimeResponse.getCharacterEncoding();
            this.lifecycleIncongruityMap.putResponseCharacterEncoding(characterEncoding);
            return characterEncoding;
        }
        return this.lifecycleIncongruityMap.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        if (this.portletResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
            resourceResponse.setCharacterEncoding(encoding);
        } else {
            this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.SET_RESPONSE_CHARACTER_ENCODING);
        }
        this.lifecycleIncongruityMap.putResponseCharacterEncoding(encoding);
    }

    public void setResponseContentLength(int length) {
        if (this.portletResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
            resourceResponse.setContentLength(length);
        } else {
            this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.SET_RESPONSE_CONTENT_LENGTH);
        }
        this.lifecycleIncongruityMap.putResponseContentLength(length);
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String contentType) {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            this.portletContainer.setMimeResponseContentType(mimeResponse, contentType);
        } else {
            this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.SET_RESPONSE_CONTENT_TYPE);
        }
        this.lifecycleIncongruityMap.putResponseContentType(contentType);
    }

    public void setResponseHeader(String name, String value) {
        this.addResponseHeader(name, value);
    }

    public OutputStream getResponseOutputStream() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            return mimeResponse.getPortletOutputStream();
        }
        this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.WRITE_RESPONSE_OUTPUT_STREAM);
        return this.lifecycleIncongruityMap.getResponseOutputStream();
    }

    public Writer getResponseOutputWriter() throws IOException {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            return mimeResponse.getWriter();
        }
        this.lifecycleIncongruityManager.addCongruousTask(CongruousTask.WRITE_RESPONSE_OUTPUT_WRITER);
        return this.lifecycleIncongruityMap.getResponseOutputWriter();
    }

    public void setResponseStatus(int statusCode) {
        if (this.portletResponse instanceof ResourceResponse) {
            ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
            resourceResponse.setProperty("portlet.http-status-code", Integer.toString(statusCode));
        }
        this.lifecycleIncongruityMap.putResponseStatus(statusCode);
    }

    public Object getSession(boolean create) {
        return this.portletRequest.getPortletSession(create);
    }

    public Map<String, Object> getSessionMap() {
        return this.sessionMap;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal == null) {
            this.userPrincipal = this.portletRequest.getUserPrincipal();
        }
        return this.userPrincipal;
    }
}

