/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.context.flash;

import java.lang.reflect.Method;
import javax.faces.context.ExternalContext;
import javax.faces.context.Flash;
import org.portletfaces.bridge.context.flash.BridgeFlash;
import org.portletfaces.bridge.context.flash.BridgeFlashFallbackImpl;
import org.portletfaces.bridge.context.flash.BridgeFlashMojarraImpl;
import org.portletfaces.bridge.context.flash.BridgeFlashMyFacesImpl;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class BridgeFlashFactory {
    private static final Logger logger = LoggerFactory.getLogger(BridgeFlashFactory.class);
    private static final String MOJARRA_FLASH_FQCN = "com.sun.faces.context.flash.ELFlash";
    private static final String MOJARRA_GET_FLASH_METHOD_NAME = "getFlash";
    private static final String MYFACES_FLASH_FQCN_NEW = "org.apache.myfaces.shared.context.flash.FlashImpl";
    private static final String MYFACES_FLASH_FQCN_OLD = "org.apache.myfaces.shared_impl.context.flash.FlashImpl";
    private static final String MYFACES_GET_FLASH_METHOD_NAME = "getCurrentInstance";
    private static final String WARNING_MSG = "Unable to create an instance of [{0}]; falling back to [{1}]";
    private static Method mojarraGetFlashMethod;
    private static Method myFacesGetFlashMethod;

    public static BridgeFlash getBridgeFlash(ExternalContext externalContext) {
        BridgeFlash bridgeFlash = null;
        if (mojarraGetFlashMethod != null) {
            try {
                Flash mojarraFlash = (Flash)mojarraGetFlashMethod.invoke(null, new Object[0]);
                bridgeFlash = new BridgeFlashMojarraImpl(mojarraFlash);
            }
            catch (Exception e) {
                logger.warn(WARNING_MSG, MOJARRA_FLASH_FQCN, BridgeFlashFallbackImpl.class.getName());
                bridgeFlash = new BridgeFlashFallbackImpl();
            }
        } else if (myFacesGetFlashMethod != null) {
            try {
                Flash myFacesFlash = (Flash)myFacesGetFlashMethod.invoke(null, externalContext);
                bridgeFlash = new BridgeFlashMyFacesImpl(myFacesFlash);
            }
            catch (Exception e) {
                logger.warn(WARNING_MSG, MYFACES_FLASH_FQCN_NEW, BridgeFlashFallbackImpl.class.getName());
                bridgeFlash = new BridgeFlashFallbackImpl();
            }
        }
        return bridgeFlash;
    }

    static {
        try {
            Class<?> mojarraFlashClass = Class.forName(MOJARRA_FLASH_FQCN);
            mojarraGetFlashMethod = mojarraFlashClass.getMethod(MOJARRA_GET_FLASH_METHOD_NAME, new Class[0]);
        }
        catch (Exception e1) {
            try {
                Class<?> myFacesFlashClass = Class.forName(MYFACES_FLASH_FQCN_NEW);
                myFacesGetFlashMethod = myFacesFlashClass.getMethod(MYFACES_GET_FLASH_METHOD_NAME, ExternalContext.class);
            }
            catch (Exception e2) {
                try {
                    Class<?> myFacesFlashClass = Class.forName(MYFACES_FLASH_FQCN_OLD);
                    myFacesGetFlashMethod = myFacesFlashClass.getMethod(MYFACES_GET_FLASH_METHOD_NAME, ExternalContext.class);
                }
                catch (Exception e3) {
                    logger.error("Classloader unable to find either the Mojarra or MyFaces Flash implementations");
                }
            }
        }
    }
}

