/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.context.map;

import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import org.portletfaces.bridge.context.map.ApplicationMapEntry;
import org.portletfaces.bridge.util.AbstractPropertyMap;
import org.portletfaces.bridge.util.AbstractPropertyMapEntry;
import org.portletfaces.bridge.util.ManagedBeanUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMap
extends AbstractPropertyMap<Object> {
    public static final String REQUEST_ATTR_NAME = "org.portletfaces.bridge.ApplicationMap";
    private PortletContext portletContext;
    private boolean preferPreDestroy;

    public ApplicationMap(PortletContext portletContext, boolean preferPreDestroy) {
        this.portletContext = portletContext;
        this.preferPreDestroy = preferPreDestroy;
    }

    @Override
    public void clear() {
        Set mapEntries = this.entrySet();
        if (mapEntries != null) {
            for (Map.Entry mapEntry : mapEntries) {
                Object potentialManagedBean = mapEntry.getValue();
                ManagedBeanUtil.invokePreDestroyMethods(potentialManagedBean, this.preferPreDestroy);
            }
        }
        super.clear();
    }

    @Override
    public Object remove(Object key) {
        Object potentialManagedBean = super.remove(key);
        ManagedBeanUtil.invokePreDestroyMethods(potentialManagedBean, this.preferPreDestroy);
        return potentialManagedBean;
    }

    @Override
    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new ApplicationMapEntry(this.portletContext, name);
    }

    @Override
    protected void removeProperty(String name) {
        this.portletContext.removeAttribute(name);
    }

    @Override
    protected Object getProperty(String name) {
        return this.portletContext.getAttribute(name);
    }

    @Override
    protected void setProperty(String name, Object value) {
        this.portletContext.setAttribute(name, value);
    }

    @Override
    protected Enumeration<String> getPropertyNames() {
        return this.portletContext.getAttributeNames();
    }
}

