/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.context.map;

import java.util.Enumeration;
import javax.portlet.PortletRequest;
import org.portletfaces.bridge.context.map.RequestAttributeMapEntry;
import org.portletfaces.bridge.util.AbstractPropertyMap;
import org.portletfaces.bridge.util.AbstractPropertyMapEntry;
import org.portletfaces.bridge.util.ManagedBeanUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestAttributeMap
extends AbstractPropertyMap<Object> {
    private static final String PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    private static final String SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    private PortletRequest portletRequest;
    private boolean preferPreDestroy;

    public RequestAttributeMap(PortletRequest portletRequest, boolean preferPreDestroy) {
        this.portletRequest = portletRequest;
        this.preferPreDestroy = preferPreDestroy;
    }

    @Override
    public Object remove(Object key) {
        Object potentialManagedBean = super.remove(key);
        ManagedBeanUtil.invokePreDestroyMethods(potentialManagedBean, this.preferPreDestroy);
        return potentialManagedBean;
    }

    @Override
    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new RequestAttributeMapEntry(this.portletRequest, name);
    }

    @Override
    protected void removeProperty(String name) {
        this.portletRequest.removeAttribute(name);
    }

    @Override
    protected Object getProperty(String name) {
        Object value = null;
        if (name != null && !name.equals(PATH_INFO_ATTRIBUTE) && !name.equals(SERVLET_PATH_ATTRIBUTE)) {
            value = this.portletRequest.getAttribute(name);
        }
        return value;
    }

    @Override
    protected void setProperty(String name, Object value) {
        this.portletRequest.setAttribute(name, value);
    }

    @Override
    protected Enumeration<String> getPropertyNames() {
        return this.portletRequest.getAttributeNames();
    }
}

