/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.context.map;

import java.util.Enumeration;
import java.util.Map;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import org.portletfaces.bridge.context.map.CaseInsensitiveHashMap;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHeaderValuesMap
extends CaseInsensitiveHashMap<String[]> {
    private static final long serialVersionUID = 4910578014366086738L;
    private static final Logger logger = LoggerFactory.getLogger(RequestHeaderValuesMap.class);
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_FACES_REQUEST = "Faces-Request";

    public RequestHeaderValuesMap(PortletRequest portletRequest, Map<String, String> requestParameterMap) {
        String resourceName;
        Enumeration propertyNames = portletRequest.getPropertyNames();
        boolean foundAccept = false;
        boolean foundContentType = false;
        boolean foundFacesRequest = false;
        if (propertyNames != null) {
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                Enumeration values = portletRequest.getProperties(name);
                String[] valuesAsArray = null;
                if (values != null) {
                    int totalValues = 0;
                    while (values.hasMoreElements()) {
                        values.nextElement();
                        ++totalValues;
                    }
                    valuesAsArray = new String[totalValues];
                    values = portletRequest.getProperties(name);
                    int i = 0;
                    while (values.hasMoreElements()) {
                        valuesAsArray[i] = (String)values.nextElement();
                        ++i;
                    }
                }
                this.put(name, valuesAsArray);
                if (valuesAsArray == null || valuesAsArray.length <= 0) continue;
                if (!foundAccept) {
                    foundAccept = name.equalsIgnoreCase(HEADER_ACCEPT);
                }
                if (!foundContentType) {
                    foundContentType = name.equalsIgnoreCase(HEADER_CONTENT_TYPE);
                }
                if (foundFacesRequest) continue;
                foundFacesRequest = name.equalsIgnoreCase(HEADER_FACES_REQUEST);
            }
        }
        if (!foundAccept) {
            this.addAcceptHeader(portletRequest);
        }
        if (!foundContentType) {
            this.addContentTypeHeader(portletRequest);
        }
        if (!foundFacesRequest && portletRequest instanceof ResourceRequest && (resourceName = requestParameterMap.get("javax.faces.resource")) == null) {
            this.put(HEADER_FACES_REQUEST, new String[]{"partial/ajax"});
        }
    }

    protected void addAcceptHeader(PortletRequest portletRequest) {
        StringBuilder header = new StringBuilder();
        header.append(HEADER_ACCEPT);
        header.append(": ");
        Enumeration responseContentTypes = portletRequest.getResponseContentTypes();
        boolean firstElement = true;
        while (responseContentTypes.hasMoreElements()) {
            if (!firstElement) {
                header.append(",");
            }
            String responseContentType = (String)responseContentTypes.nextElement();
            header.append(responseContentType);
            firstElement = false;
        }
        String acceptHeader = header.toString();
        logger.debug("Adding acceptHeader=[{0}] to header map", acceptHeader);
        this.put(HEADER_ACCEPT, new String[]{header.toString()});
    }

    protected void addContentTypeHeader(PortletRequest portletRequest) {
        String contentType = portletRequest.getResponseContentType();
        String characterSetEncoding = null;
        if (portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)portletRequest;
            contentType = clientDataRequest.getContentType();
            characterSetEncoding = clientDataRequest.getCharacterEncoding();
        }
        StringBuilder header = new StringBuilder();
        header.append(HEADER_CONTENT_TYPE);
        header.append(": ");
        header.append(contentType);
        if (characterSetEncoding != null) {
            header.append("; charset=");
            header.append(characterSetEncoding);
        }
        String contentTypeHeader = header.toString();
        logger.debug("Adding contentTypeHeader=[{0}] to header map", contentTypeHeader);
        this.put(HEADER_CONTENT_TYPE, new String[]{header.toString()});
    }

    protected void addFacesRequestPartialAjaxHeader(PortletRequest portletRequest) {
    }
}

