/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.context.map;

import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.container.PortletContainer;
import org.portletfaces.bridge.context.map.RequestParameterMap;
import org.portletfaces.bridge.context.map.RequestParameterMapImpl;
import org.portletfaces.bridge.context.map.RequestParameterMapMultiPartImpl;
import org.portletfaces.bridge.context.map.RequestParameterValuesMap;
import org.portletfaces.bridge.context.map.RequestParameterValuesMapImpl;
import org.portletfaces.bridge.context.map.RequestParameterValuesMapMultiPartImpl;

public class RequestParameterMapFactory {
    private static final String MULTIPART_CONTENT_TYPE_PREFIX = "multipart/";
    private RequestParameterMap requestParameterMap;
    private RequestParameterValuesMap requestParameterValuesMap;

    public RequestParameterMapFactory(PortletContainer portletContainer, PortletRequest portletRequest, Bridge.PortletPhase portletRequestPhase) {
        if (portletRequestPhase == Bridge.PortletPhase.ACTION_PHASE) {
            ActionRequest actionRequest = (ActionRequest)portletRequest;
            String contentType = actionRequest.getContentType();
            if (contentType != null && contentType.toLowerCase().startsWith(MULTIPART_CONTENT_TYPE_PREFIX)) {
                RequestParameterMapMultiPartImpl requestParameterMapMultiPartImpl = new RequestParameterMapMultiPartImpl(portletContainer, actionRequest);
                this.requestParameterMap = requestParameterMapMultiPartImpl;
                this.requestParameterValuesMap = new RequestParameterValuesMapMultiPartImpl(requestParameterMapMultiPartImpl);
            } else {
                this.requestParameterMap = new RequestParameterMapImpl(portletContainer, (PortletRequest)actionRequest);
                this.requestParameterValuesMap = new RequestParameterValuesMapImpl(portletContainer, (PortletRequest)actionRequest);
            }
        } else {
            this.requestParameterMap = new RequestParameterMapImpl(portletContainer, portletRequest);
            this.requestParameterValuesMap = new RequestParameterValuesMapImpl(portletContainer, portletRequest);
        }
    }

    public RequestParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public RequestParameterValuesMap getRequestParameterValuesMap() {
        return this.requestParameterValuesMap;
    }
}

