/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.context.map;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.io.FileUtils;
import org.portletfaces.bridge.UploadedFileImpl;
import org.portletfaces.bridge.component.UploadedFile;
import org.portletfaces.bridge.container.PortletContainer;
import org.portletfaces.bridge.context.map.RequestParameterMap;
import org.portletfaces.bridge.context.map.RequestParameterMapEntryMultiPart;
import org.portletfaces.bridge.util.AbstractPropertyMapEntry;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameterMapMultiPartImpl
extends RequestParameterMap {
    private static final Logger logger = LoggerFactory.getLogger(RequestParameterMapMultiPartImpl.class);
    private static final String CONTEXT_PARAM_UPLOADED_FILES_DIR = "javax.faces.UPLOADED_FILES_DIR";
    private static final String CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE = "javax.faces.UPLOADED_FILE_MAX_SIZE";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final int DEFAULT_FILE_MAX_SIZE = 0x6400000;
    private Map<String, String> requestParameterMap;
    private Map<String, UploadedFile> requestParameterFileMap;

    public RequestParameterMapMultiPartImpl(PortletContainer portletContainer, ActionRequest actionRequest) {
        try {
            PortletSession portletSession = actionRequest.getPortletSession(true);
            PortletContext portletContext = portletSession.getPortletContext();
            String uploadedFilesDir = portletContext.getInitParameter(CONTEXT_PARAM_UPLOADED_FILES_DIR);
            if (uploadedFilesDir == null) {
                uploadedFilesDir = System.getProperty(JAVA_IO_TMPDIR);
                if (logger.isDebugEnabled()) {
                    logger.debug("The web.xml context-param name=[{0}] not found, using default system property=[{1}] value=[{2}]", CONTEXT_PARAM_UPLOADED_FILES_DIR, JAVA_IO_TMPDIR, uploadedFilesDir);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Using web.xml context-param name=[{0}] value=[{1}]", CONTEXT_PARAM_UPLOADED_FILES_DIR, uploadedFilesDir);
            }
            String sessionId = portletSession.getId();
            File uploadedFilesPath = new File(uploadedFilesDir = uploadedFilesDir + "/" + sessionId);
            if (!uploadedFilesPath.exists()) {
                try {
                    uploadedFilesPath.mkdirs();
                }
                catch (SecurityException e) {
                    uploadedFilesDir = System.getProperty(JAVA_IO_TMPDIR) + "/" + sessionId;
                    logger.error("Security exception message=[{0}] when trying to create unique path=[{1}] so using default system property=[{2}] value=[{3}]", e.getMessage(), uploadedFilesPath.toString(), JAVA_IO_TMPDIR, uploadedFilesDir);
                    uploadedFilesPath = new File(uploadedFilesDir);
                    uploadedFilesPath.mkdirs();
                }
            }
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            diskFileItemFactory.setRepository(uploadedFilesPath);
            diskFileItemFactory.setFileCleaningTracker(null);
            diskFileItemFactory.setSizeThreshold(0);
            String uploadedFilesMaxSize = portletContext.getInitParameter(CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE);
            int fileMaxSize = 0x6400000;
            if (uploadedFilesMaxSize == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The web.xml context-param name=[{0}] not found, using default=[{1}] bytes", CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE, 0x6400000);
                }
            } else {
                try {
                    fileMaxSize = Integer.parseInt(uploadedFilesMaxSize);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using web.xml context-param name=[{0}] value=[{1}] bytes", CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE, fileMaxSize);
                    }
                }
                catch (NumberFormatException e) {
                    logger.error("Invalid value=[{0}] for web.xml context-param name=[{1}] using default=[{2}] bytes.", uploadedFilesMaxSize, CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE, 0x6400000);
                }
            }
            PortletFileUpload portletFileUpload = new PortletFileUpload((FileItemFactory)diskFileItemFactory);
            portletFileUpload.setFileSizeMax((long)fileMaxSize);
            this.requestParameterMap = new HashMap<String, String>();
            this.requestParameterFileMap = new HashMap<String, UploadedFile>();
            List diskFileItems = portletFileUpload.parseRequest(actionRequest);
            boolean foundAtLeastOneUploadedFile = false;
            if (diskFileItems != null) {
                for (DiskFileItem diskFileItem : diskFileItems) {
                    Iterator headerNameItr;
                    String fieldName = diskFileItem.getFieldName();
                    if (diskFileItem.isFormField()) {
                        String requestParameterValue = diskFileItem.getString();
                        String fixedRequestParameterValue = portletContainer.fixRequestParameterValue(requestParameterValue);
                        this.requestParameterMap.put(fieldName, fixedRequestParameterValue);
                        logger.debug("{0}=[{1}]", fieldName, fixedRequestParameterValue);
                        continue;
                    }
                    File tempFile = diskFileItem.getStoreLocation();
                    if (!tempFile.exists()) continue;
                    foundAtLeastOneUploadedFile = true;
                    String tempFileName = tempFile.getName();
                    String tempFileAbsolutePath = tempFile.getAbsolutePath();
                    String copiedFileName = this.stripIllegalCharacters(diskFileItem.getName());
                    String copiedFileAbsolutePath = tempFileAbsolutePath.replace(tempFileName, copiedFileName);
                    File copiedFile = new File(copiedFileAbsolutePath);
                    FileUtils.copyFile((File)tempFile, (File)copiedFile);
                    UploadedFileImpl uploadedFile = new UploadedFileImpl();
                    uploadedFile.setAbsolutePath(copiedFileAbsolutePath);
                    uploadedFile.setCharSet(diskFileItem.getCharSet());
                    uploadedFile.setContentType(diskFileItem.getContentType());
                    HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
                    FileItemHeaders fileItemHeaders = diskFileItem.getHeaders();
                    if (fileItemHeaders != null && (headerNameItr = fileItemHeaders.getHeaderNames()) != null) {
                        while (headerNameItr.hasNext()) {
                            String headerName = (String)headerNameItr.next();
                            Iterator headerValuesItr = fileItemHeaders.getHeaders(headerName);
                            ArrayList<String> headerValues = new ArrayList<String>();
                            if (headerValuesItr != null) {
                                while (headerValuesItr.hasNext()) {
                                    String headerValue = (String)headerValuesItr.next();
                                    headerValues.add(headerValue);
                                }
                            }
                            headersMap.put(headerName, headerValues);
                        }
                    }
                    uploadedFile.setHeadersMap(headersMap);
                    String fileName = diskFileItem.getName();
                    uploadedFile.setName(fileName);
                    uploadedFile.setSize(diskFileItem.getSize());
                    this.requestParameterMap.put(fieldName, copiedFileAbsolutePath);
                    this.requestParameterFileMap.put(fieldName, uploadedFile);
                    logger.debug("Received uploaded file fieldName=[{0}] fileName=[{1}]", fieldName, fileName);
                }
                actionRequest.setAttribute("javax.faces.UPLOADED_FILES", this.requestParameterFileMap);
            }
            if (!foundAtLeastOneUploadedFile) {
                logger.warn("No uploaded files are found in the request");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    protected AbstractPropertyMapEntry<String> createPropertyMapEntry(String name) {
        return new RequestParameterMapEntryMultiPart(name, this.requestParameterMap);
    }

    @Override
    protected void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    protected String stripIllegalCharacters(String fileName) {
        String strippedFileName = fileName;
        if (fileName != null) {
            strippedFileName = fileName.replaceAll("[\\\\/\\[\\]:|<>+;=.?\"]", "-");
        }
        return strippedFileName;
    }

    @Override
    protected String getProperty(String name) {
        return this.requestParameterMap.get(name);
    }

    @Override
    protected void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Enumeration<String> getPropertyNames() {
        return Collections.enumeration(this.requestParameterMap.keySet());
    }
}

