/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.context.map;

import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletSession;
import org.portletfaces.bridge.context.map.SessionMapEntry;
import org.portletfaces.bridge.util.AbstractPropertyMap;
import org.portletfaces.bridge.util.AbstractPropertyMapEntry;
import org.portletfaces.bridge.util.ManagedBeanUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionMap
extends AbstractPropertyMap<Object> {
    private PortletSession portletSession;
    private boolean preferPreDestroy;
    private int scope;

    public SessionMap(PortletSession portletSession, int scope, boolean preferPreDestroy) {
        this.portletSession = portletSession;
        this.scope = scope;
        this.preferPreDestroy = preferPreDestroy;
    }

    @Override
    public void clear() {
        Set mapEntries = this.entrySet();
        if (mapEntries != null) {
            for (Map.Entry mapEntry : mapEntries) {
                Object potentialManagedBean = mapEntry.getValue();
                ManagedBeanUtil.invokePreDestroyMethods(potentialManagedBean, this.preferPreDestroy);
            }
        }
        super.clear();
    }

    @Override
    public Object remove(Object key) {
        Object potentialManagedBean = super.remove(key);
        ManagedBeanUtil.invokePreDestroyMethods(potentialManagedBean, this.preferPreDestroy);
        return potentialManagedBean;
    }

    @Override
    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new SessionMapEntry(this.portletSession, name, this.scope);
    }

    @Override
    protected void removeProperty(String name) {
        this.portletSession.removeAttribute(name);
    }

    @Override
    protected Object getProperty(String name) {
        return this.portletSession.getAttribute(name);
    }

    @Override
    protected void setProperty(String name, Object value) {
        this.portletSession.setAttribute(name, value);
    }

    @Override
    protected Enumeration<String> getPropertyNames() {
        return this.portletSession.getAttributeNames();
    }
}

