/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.BridgeUtil;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.bridge.context.map.SessionMap;
import org.portletfaces.bridge.helper.BooleanHelper;
import org.portletfaces.bridge.preference.MutablePreferenceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELResolverImpl
extends ELResolver {
    private static final String ACTION_REQUEST = "actionRequest";
    private static final String ACTION_RESPONSE = "actionResponse";
    private static final String EVENT_REQUEST = "eventRequest";
    private static final String EVENT_RESPONSE = "eventResponse";
    private static final String FLASH = "bridgeFlash";
    private static final String HTTP_SESSION_SCOPE = "httpSessionScope";
    private static final String MUTABLE_PORTLET_PREFERENCES_VALUES = "mutablePortletPreferencesValues";
    private static final String PORTLET_CONFIG = "portletConfig";
    private static final String PORTLET_SESSION = "portletSession";
    private static final String PORTLET_SESSION_SCOPE = "portletSessionScope";
    private static final String PORTLET_PREFERENCES = "portletPreferences";
    private static final String PORTLET_PREFERENCES_VALUES = "portletPreferencesValues";
    private static final String RENDER_REQUEST = "renderRequest";
    private static final String RENDER_RESPONSE = "renderResponse";
    private static final String RESOURCE_REQUEST = "resourceRequest";
    private static final String RESOURCE_RESPONSE = "resourceResponse";
    private static final ArrayList<FeatureDescriptor> FEATURE_DESCRIPTORS = new ArrayList();
    private static final HashSet<String> VAR_NAMES = new HashSet();

    protected static void addFeatureDescriptor(String featureName, Class<?> classType) {
        FeatureDescriptor featureDescriptor = new FeatureDescriptor();
        featureDescriptor.setName(featureName);
        featureDescriptor.setDisplayName(featureName);
        featureDescriptor.setShortDescription(featureName);
        featureDescriptor.setExpert(false);
        featureDescriptor.setHidden(false);
        featureDescriptor.setPreferred(true);
        featureDescriptor.setValue("type", classType);
        featureDescriptor.setValue("resolvableAtDesignTime", true);
        FEATURE_DESCRIPTORS.add(featureDescriptor);
    }

    protected Object resolveProperty(ELContext elContext, Object base, String property) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object resolveVariable(ELContext elContext, String varName) {
        Object value = null;
        if (varName == null) return value;
        if (varName.equals(ACTION_REQUEST)) {
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
            if (portletPhase != Bridge.PortletPhase.ACTION_PHASE) throw new ELException("Unable to get actionRequest during " + (Object)((Object)portletPhase));
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getRequest();
        }
        if (varName.equals(ACTION_RESPONSE)) {
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
            if (portletPhase != Bridge.PortletPhase.ACTION_PHASE) throw new ELException("Unable to get actionResponse during " + (Object)((Object)portletPhase));
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getResponse();
        }
        if (varName.equals(EVENT_REQUEST)) {
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
            if (portletPhase != Bridge.PortletPhase.EVENT_PHASE) throw new ELException("Unable to get eventRequest during " + (Object)((Object)portletPhase));
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getRequest();
        }
        if (varName.equals(EVENT_RESPONSE)) {
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
            if (portletPhase != Bridge.PortletPhase.EVENT_PHASE) throw new ELException("Unable to get eventResponse during " + (Object)((Object)portletPhase));
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getResponse();
        }
        if (varName.equals(FLASH)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getFlash();
        }
        if (varName.equals(HTTP_SESSION_SCOPE)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ExternalContext externalContext = facesContext.getExternalContext();
            PortletSession portletSession = (PortletSession)externalContext.getSession(true);
            boolean preferPreDestroy = BooleanHelper.toBoolean(externalContext.getInitParameter("org.portletfaces.bridge.preferPreDestroy"), true);
            return new SessionMap(portletSession, 1, preferPreDestroy);
        }
        if (varName.equals(MUTABLE_PORTLET_PREFERENCES_VALUES)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            PortletRequest portletRequest = (PortletRequest)facesContext.getExternalContext().getRequest();
            return new MutablePreferenceMap(portletRequest.getPreferences());
        }
        if (varName.equals(PORTLET_CONFIG)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            BridgeContext bridgeContext = (BridgeContext)facesContext.getAttributes().get("javax.portlet.faces.bridgeContext");
            if (bridgeContext == null) return value;
            return bridgeContext.getPortletConfig();
        }
        if (varName.equals(PORTLET_SESSION)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getSession(true);
        }
        if (varName.equals(PORTLET_SESSION_SCOPE)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getSessionMap();
        }
        if (varName.equals(PORTLET_PREFERENCES)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            PortletRequest portletRequest = (PortletRequest)facesContext.getExternalContext().getRequest();
            return portletRequest.getPreferences();
        }
        if (varName.equals(PORTLET_PREFERENCES_VALUES)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            PortletRequest portletRequest = (PortletRequest)facesContext.getExternalContext().getRequest();
            return portletRequest.getPreferences().getMap();
        }
        if (varName.equals(RENDER_REQUEST)) {
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
            if (portletPhase != Bridge.PortletPhase.RENDER_PHASE) throw new ELException("Unable to get renderRequest during " + (Object)((Object)portletPhase));
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getRequest();
        }
        if (varName.equals(RENDER_RESPONSE)) {
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
            if (portletPhase != Bridge.PortletPhase.RENDER_PHASE) throw new ELException("Unable to get renderResponse during " + (Object)((Object)portletPhase));
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getResponse();
        }
        if (varName.equals(RESOURCE_REQUEST)) {
            Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
            if (portletPhase != Bridge.PortletPhase.RESOURCE_PHASE) throw new ELException("Unable to get resourceRequest during " + (Object)((Object)portletPhase));
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return facesContext.getExternalContext().getRequest();
        }
        if (!varName.equals(RESOURCE_RESPONSE)) return value;
        Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
        if (portletPhase != Bridge.PortletPhase.RESOURCE_PHASE) throw new ELException("Unable to get renderResponse during " + (Object)((Object)portletPhase));
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getExternalContext().getResponse();
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        Class<?> commonPropertyType = null;
        return commonPropertyType;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elContext, Object base) {
        return FEATURE_DESCRIPTORS.iterator();
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) {
        if (elContext == null) {
            throw new NullPointerException("elContext may not be null");
        }
        return String.class;
    }

    public Object getValue(ELContext elContext, Object base, Object property) {
        if (elContext == null) {
            throw new NullPointerException("invalid ELContext");
        }
        Object value = null;
        if (base == null) {
            String varName;
            if (property instanceof String && VAR_NAMES.contains(varName = (String)property)) {
                value = this.resolveVariable(elContext, varName);
            }
        } else if (property instanceof String) {
            String propertyName = (String)property;
            value = this.resolveProperty(elContext, base, propertyName);
        }
        if (value != null) {
            elContext.setPropertyResolved(true);
        }
        return value;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        if (elContext == null) {
            throw new NullPointerException("elContext may not be null");
        }
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        return true;
    }

    static {
        VAR_NAMES.add(ACTION_REQUEST);
        VAR_NAMES.add(ACTION_RESPONSE);
        VAR_NAMES.add(EVENT_REQUEST);
        VAR_NAMES.add(EVENT_RESPONSE);
        VAR_NAMES.add(FLASH);
        VAR_NAMES.add(HTTP_SESSION_SCOPE);
        VAR_NAMES.add(MUTABLE_PORTLET_PREFERENCES_VALUES);
        VAR_NAMES.add(PORTLET_CONFIG);
        VAR_NAMES.add(PORTLET_SESSION);
        VAR_NAMES.add(PORTLET_SESSION_SCOPE);
        VAR_NAMES.add(PORTLET_PREFERENCES);
        VAR_NAMES.add(PORTLET_PREFERENCES_VALUES);
        VAR_NAMES.add(RENDER_REQUEST);
        VAR_NAMES.add(RENDER_RESPONSE);
        VAR_NAMES.add(RESOURCE_REQUEST);
        VAR_NAMES.add(RESOURCE_RESPONSE);
        ELResolverImpl.addFeatureDescriptor(ACTION_REQUEST, String.class);
        ELResolverImpl.addFeatureDescriptor(ACTION_RESPONSE, String.class);
        ELResolverImpl.addFeatureDescriptor(EVENT_REQUEST, String.class);
        ELResolverImpl.addFeatureDescriptor(EVENT_RESPONSE, String.class);
        ELResolverImpl.addFeatureDescriptor(FLASH, String.class);
        ELResolverImpl.addFeatureDescriptor(HTTP_SESSION_SCOPE, String.class);
        ELResolverImpl.addFeatureDescriptor(MUTABLE_PORTLET_PREFERENCES_VALUES, String.class);
        ELResolverImpl.addFeatureDescriptor(PORTLET_CONFIG, String.class);
        ELResolverImpl.addFeatureDescriptor(PORTLET_SESSION, String.class);
        ELResolverImpl.addFeatureDescriptor(PORTLET_SESSION_SCOPE, String.class);
        ELResolverImpl.addFeatureDescriptor(PORTLET_PREFERENCES, String.class);
        ELResolverImpl.addFeatureDescriptor(PORTLET_PREFERENCES_VALUES, String.class);
        ELResolverImpl.addFeatureDescriptor(RENDER_REQUEST, String.class);
        ELResolverImpl.addFeatureDescriptor(RENDER_RESPONSE, String.class);
        ELResolverImpl.addFeatureDescriptor(RESOURCE_REQUEST, String.class);
        ELResolverImpl.addFeatureDescriptor(RESOURCE_RESPONSE, String.class);
    }
}

