/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.event;

import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.StateAwareResponse;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.BridgePublicRenderParameterHandler;
import org.portletfaces.bridge.BridgeUtil;
import org.portletfaces.bridge.config.BridgeConfig;
import org.portletfaces.bridge.event.PublicRenderParameter;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class IPCPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 454155161145961729L;
    private static final Logger logger = LoggerFactory.getLogger(IPCPhaseListener.class);
    private BridgeConfig bridgeConfig;
    private PortletContext portletContext;
    private String portletName;
    private PortletRequest portletRequest;
    private PortletResponse portletResponse;

    public IPCPhaseListener(BridgeConfig bridgeConfig, PortletContext portletContext, String portletName, PortletRequest portletRequest, PortletResponse portletResponse) {
        this.bridgeConfig = bridgeConfig;
        this.portletContext = portletContext;
        this.portletName = portletName;
        this.portletRequest = portletRequest;
        this.portletResponse = portletResponse;
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        Bridge.PortletPhase portletPhase;
        FacesContext facesContext = phaseEvent.getFacesContext();
        PhaseId phaseId = phaseEvent.getPhaseId();
        if (phaseId == PhaseId.RESTORE_VIEW) {
            this.processIncomingPublicRenderParameters(facesContext);
            Bridge.PortletPhase portletPhase2 = BridgeUtil.getPortletRequestPhase();
            if (portletPhase2 == Bridge.PortletPhase.EVENT_PHASE) {
                facesContext.renderResponse();
            }
        } else if (phaseId == PhaseId.INVOKE_APPLICATION && ((portletPhase = BridgeUtil.getPortletRequestPhase()) == Bridge.PortletPhase.ACTION_PHASE || portletPhase == Bridge.PortletPhase.EVENT_PHASE)) {
            this.processOutgoingPublicRenderParameters(facesContext);
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    protected void processIncomingPublicRenderParameters(FacesContext facesContext) {
        try {
            Map<String, String[]> publicParameterMappings = this.bridgeConfig.getPublicParameterMappings();
            if (publicParameterMappings != null) {
                boolean invokeHandler = false;
                Map publicParameterMap = this.portletRequest.getPublicParameterMap();
                Set<String> publicRenderParameterNames = publicParameterMappings.keySet();
                for (String parameterName : publicRenderParameterNames) {
                    String[] modelExpressions = publicParameterMappings.get(parameterName);
                    if (modelExpressions == null) continue;
                    for (String originalModelEL : modelExpressions) {
                        String[] parameterValues = (String[])publicParameterMap.get(parameterName);
                        String parameterValue = null;
                        if (parameterValues != null && parameterValues.length > 0) {
                            parameterValue = parameterValues[0];
                        }
                        PublicRenderParameter publicRenderParameter = new PublicRenderParameter(facesContext, parameterValue, originalModelEL, this.portletName);
                        if (logger.isTraceEnabled()) {
                            logger.trace("portletName=[{0}] public render parameter=[{1}] originalModelEL=[{2}] modifiedModelEL=[{3}] injectIntoModel=[{4}]", this.portletName, parameterName, originalModelEL, publicRenderParameter.getModifiedModelEL(), publicRenderParameter.isForThisPortlet());
                        }
                        if (publicRenderParameter.isForThisPortlet()) {
                            logger.debug("Injecting render parameter=[{0}] value=[{1}] into expression=[{2}]", parameterName, parameterValue, publicRenderParameter.getModifiedModelEL());
                            invokeHandler = publicRenderParameter.injectIntoModel();
                            continue;
                        }
                        logger.debug("NOT injecting render parameter=[{0}] value=[{1}] into expression=[{2}] because it is NOT for this portletName=[{3}]", parameterName, parameterValue, publicRenderParameter.getModifiedModelEL(), this.portletName);
                    }
                }
                if (invokeHandler) {
                    String bridgePublicRenderParameterHandlerAttributeName = "javax.portlet.faces." + this.portletName + "." + "bridgePublicRenderParameterHandler";
                    logger.trace("bridgePublicRenderParameterHandlerAttributeName=[{0}]", bridgePublicRenderParameterHandlerAttributeName);
                    BridgePublicRenderParameterHandler bridgePublicRenderParameterHandler = (BridgePublicRenderParameterHandler)this.portletContext.getAttribute(bridgePublicRenderParameterHandlerAttributeName);
                    if (bridgePublicRenderParameterHandler != null) {
                        logger.debug("Invoking {0} for class=[{1}]", bridgePublicRenderParameterHandler, bridgePublicRenderParameterHandler.getClass());
                        bridgePublicRenderParameterHandler.processUpdates(facesContext);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    protected void processOutgoingPublicRenderParameters(FacesContext facesContext) {
        try {
            StateAwareResponse stateAwareResponse = (StateAwareResponse)this.portletResponse;
            Map<String, String[]> publicParameterMappings = this.bridgeConfig.getPublicParameterMappings();
            if (publicParameterMappings != null) {
                Map publicParameterMap = this.portletRequest.getPublicParameterMap();
                Set<String> publicRenderParameterNames = publicParameterMappings.keySet();
                for (String parameterName : publicRenderParameterNames) {
                    String[] modelExpressions = publicParameterMappings.get(parameterName);
                    if (modelExpressions == null) continue;
                    for (String originalModelEL : modelExpressions) {
                        PublicRenderParameter publicRenderParameter;
                        String[] parameterValues = (String[])publicParameterMap.get(parameterName);
                        String parameterValue = null;
                        if (parameterValues != null && parameterValues.length > 0) {
                            parameterValue = parameterValues[0];
                        }
                        if ((publicRenderParameter = new PublicRenderParameter(facesContext, parameterValue, originalModelEL, this.portletName)).isForThisPortlet()) {
                            String modelValue = publicRenderParameter.getModelValue();
                            boolean modelValueHasChanged = publicRenderParameter.isModelValueChanged();
                            if (logger.isTraceEnabled()) {
                                logger.trace("portletName=[{0}] public render parameter=[{1}] parameterValue=[{2}] modelValue=[{3}] modelValueHasChanged=[{4}]", this.portletName, parameterName, parameterValue, modelValue, modelValueHasChanged);
                            }
                            if (modelValueHasChanged) {
                                logger.debug("Setting render parameter=[{0}] in response because modelValue=[{1}] has changed", parameterName, modelValue);
                                stateAwareResponse.setRenderParameter(parameterName, modelValue);
                                continue;
                            }
                            logger.debug("NOT setting render parameter=[{0}] in response because modelValue=[{1}] has NOT changed", parameterName, modelValue);
                            continue;
                        }
                        logger.debug("NOT setting render parameter=[{0}] in response because it is NOT for this portletName=[{1}]", parameterName, this.portletName);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

