/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.event;

import javax.el.ELContext;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class PublicRenderParameter {
    private static final Logger logger = LoggerFactory.getLogger(PublicRenderParameter.class);
    private FacesContext facesContext;
    private boolean forThisPortlet;
    private String modelValue;
    private Boolean modelValueChanged;
    private boolean modelValueRetrieved;
    private String modifiedModelEL;
    private String originalRequestValue;

    public PublicRenderParameter(FacesContext facesContext, String originalRequestValue, String originalModelEL, String portletName) {
        this.facesContext = facesContext;
        this.originalRequestValue = originalRequestValue;
        this.modifiedModelEL = originalModelEL;
        this.forThisPortlet = true;
        int colonPos = originalModelEL.indexOf(58);
        if (colonPos > 0) {
            this.forThisPortlet = false;
            int openCurlyBracePos = originalModelEL.indexOf(123);
            if (openCurlyBracePos > 0) {
                String prefixedPortletName = originalModelEL.substring(openCurlyBracePos + 1, colonPos);
                logger.trace("portletName=[{0}] prefixedPortletName=[{1}]", portletName, prefixedPortletName);
                if (prefixedPortletName != null && prefixedPortletName.length() > 0) {
                    this.modifiedModelEL = originalModelEL.substring(0, openCurlyBracePos + 1) + originalModelEL.substring(colonPos + 1);
                    logger.trace("Stripped prefixedPortletName=[{0}] from originalModelEL=[{1}] so that modifiedModelEL=[{2}]", prefixedPortletName, originalModelEL, this.modifiedModelEL);
                    if (portletName.equals(prefixedPortletName)) {
                        this.forThisPortlet = true;
                    }
                }
            }
        }
    }

    public boolean injectIntoModel() {
        try {
            ELContext elContext = this.facesContext.getELContext();
            ValueExpression valueExpression = this.facesContext.getApplication().getExpressionFactory().createValueExpression(elContext, this.modifiedModelEL, String.class);
            valueExpression.setValue(elContext, (Object)this.originalRequestValue);
            return true;
        }
        catch (PropertyNotFoundException e) {
            String exceptionMessage = e.getMessage();
            if (exceptionMessage == null) {
                logger.error("javax.el.PropertyNotFoundException: model-el=[{0}]", this.modifiedModelEL);
            } else {
                logger.error("javax.el.PropertyNotFoundException: {0}: model-el=[{1}]", exceptionMessage, this.modifiedModelEL);
            }
            return false;
        }
    }

    public boolean isModelValueChanged() {
        if (this.modelValueChanged == null) {
            String retrievedModelValue = this.getModelValue();
            this.modelValueChanged = retrievedModelValue != null && this.originalRequestValue != null ? Boolean.valueOf(!retrievedModelValue.equals(this.originalRequestValue)) : (retrievedModelValue == null ? Boolean.valueOf(this.originalRequestValue != null) : (this.originalRequestValue == null ? Boolean.valueOf(retrievedModelValue != null) : Boolean.FALSE));
        }
        return this.modelValueChanged;
    }

    public String getModelValue() {
        if (!this.modelValueRetrieved) {
            try {
                ELContext elContext = this.facesContext.getELContext();
                ValueExpression valueExpression = this.facesContext.getApplication().getExpressionFactory().createValueExpression(elContext, this.modifiedModelEL, String.class);
                this.modelValue = (String)valueExpression.getValue(elContext);
            }
            catch (PropertyNotFoundException e) {
                String exceptionMessage = e.getMessage();
                if (exceptionMessage == null) {
                    logger.error("javax.el.PropertyNotFoundException: model-el=[{0}]", this.modifiedModelEL);
                }
                logger.error("javax.el.PropertyNotFoundException: {0}: model-el=[{1}]", exceptionMessage, this.modifiedModelEL);
            }
            this.modelValueRetrieved = true;
        }
        return this.modelValue;
    }

    public String getModifiedModelEL() {
        return this.modifiedModelEL;
    }

    public boolean isForThisPortlet() {
        return this.forThisPortlet;
    }
}

