/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.helper;

public class BooleanHelper {
    public static final String[] TRUE_VALUES = new String[]{"1", "t", "true", "y", "yes", "on", "checked"};
    public static final String[] FALSE_VALUES = new String[]{"0", "f", "false", "n", "no", "off", "unchecked"};

    public static boolean toBoolean(String value) {
        return BooleanHelper.toBoolean(value, false);
    }

    public static boolean toBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (BooleanHelper.isTrueToken(value)) {
            return true;
        }
        if (BooleanHelper.isFalseToken(value)) {
            return false;
        }
        return defaultValue;
    }

    public static boolean isBooleanToken(String value) {
        return BooleanHelper.isTrueToken(value) || BooleanHelper.isFalseToken(value);
    }

    public static boolean isFalseToken(String value) {
        boolean flag = false;
        if (value != null) {
            String trimmedValue = value.trim();
            flag = trimmedValue.equalsIgnoreCase(FALSE_VALUES[0]) || trimmedValue.equalsIgnoreCase(FALSE_VALUES[1]) || trimmedValue.equalsIgnoreCase(FALSE_VALUES[2]) || trimmedValue.equalsIgnoreCase(FALSE_VALUES[3]) || trimmedValue.equalsIgnoreCase(FALSE_VALUES[3]) || trimmedValue.equalsIgnoreCase(FALSE_VALUES[4]) || trimmedValue.equalsIgnoreCase(FALSE_VALUES[5]) || trimmedValue.equalsIgnoreCase(FALSE_VALUES[6]);
        }
        return flag;
    }

    public static boolean isTrueToken(String value) {
        boolean flag = false;
        if (value != null) {
            String trimmedValue = value.trim();
            flag = trimmedValue.equalsIgnoreCase(TRUE_VALUES[0]) || trimmedValue.equalsIgnoreCase(TRUE_VALUES[1]) || trimmedValue.equalsIgnoreCase(TRUE_VALUES[2]) || trimmedValue.equalsIgnoreCase(TRUE_VALUES[3]) || trimmedValue.equalsIgnoreCase(TRUE_VALUES[3]) || trimmedValue.equalsIgnoreCase(TRUE_VALUES[4]) || trimmedValue.equalsIgnoreCase(TRUE_VALUES[5]) || trimmedValue.equalsIgnoreCase(TRUE_VALUES[6]);
        }
        return flag;
    }
}

