/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.lifecycle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.ExternalContext;
import org.portletfaces.bridge.lifecycle.CongruousTask;
import org.portletfaces.bridge.lifecycle.DelayedResponseOutputStream;
import org.portletfaces.bridge.lifecycle.DelayedResponseOutputWriter;
import org.portletfaces.bridge.lifecycle.LifecycleIncongruityMap;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class LifecycleIncongruityManager {
    private static final String INCONGRUITY_LIST = "_pfbIncongruityList";
    private static final Logger logger = LoggerFactory.getLogger(LifecycleIncongruityManager.class);
    private List<CongruousTask> congruousTaskList;
    private LifecycleIncongruityMap lifecycleIncongruityMap;

    public LifecycleIncongruityManager(LifecycleIncongruityMap lifecycleIncongruityMap) {
        this.congruousTaskList = (List)lifecycleIncongruityMap.get(INCONGRUITY_LIST);
        if (this.congruousTaskList == null) {
            this.congruousTaskList = new ArrayList<CongruousTask>();
        }
    }

    public void addCongruousTask(CongruousTask congruousTask) {
        this.congruousTaskList.add(congruousTask);
    }

    public void makeCongruous(ExternalContext externalContext) throws IOException {
        logger.debug("congruousTaskList.size()=[{0}]", this.congruousTaskList.size());
        for (CongruousTask congruousTask : this.congruousTaskList) {
            if (congruousTask == CongruousTask.RESPONSE_FLUSH_BUFFER) {
                logger.debug("responseFlushBuffer");
                externalContext.responseFlushBuffer();
                continue;
            }
            if (congruousTask == CongruousTask.RESPONSE_RESET) {
                logger.debug("responseReset");
                externalContext.responseReset();
                continue;
            }
            if (congruousTask == CongruousTask.SET_REQUEST_CHARACTER_ENCODING) {
                String requestCharacterEncoding = this.lifecycleIncongruityMap.getRequestCharacterEncoding();
                logger.debug("setRequestCharacterEncoding(\"{0}\")", requestCharacterEncoding);
                externalContext.setRequestCharacterEncoding(requestCharacterEncoding);
                continue;
            }
            if (congruousTask == CongruousTask.SET_RESPONSE_BUFFER_SIZE) {
                int responseBufferSize = this.lifecycleIncongruityMap.getResponseBufferSize();
                logger.debug("setResponseBufferSize(\"{0}\")", responseBufferSize);
                externalContext.setResponseBufferSize(responseBufferSize);
                continue;
            }
            if (congruousTask == CongruousTask.SET_RESPONSE_CHARACTER_ENCODING) {
                String responseCharacterEncoding = this.lifecycleIncongruityMap.getResponseCharacterEncoding();
                logger.debug("setResponseCharacterEncoding(\"{0}\")", responseCharacterEncoding);
                externalContext.setResponseCharacterEncoding(responseCharacterEncoding);
                continue;
            }
            if (congruousTask == CongruousTask.SET_RESPONSE_CONTENT_LENGTH) {
                int responseContentLength = this.lifecycleIncongruityMap.getResponseContentLength();
                logger.debug("setResponseContentLength(\"{0}\")", responseContentLength);
                externalContext.setResponseContentLength(responseContentLength);
                continue;
            }
            if (congruousTask == CongruousTask.SET_RESPONSE_CONTENT_TYPE) {
                String responseContentType = this.lifecycleIncongruityMap.getResponseContentType();
                logger.debug("setResponseContentType(\"{0}\")", responseContentType);
                externalContext.setResponseContentType(responseContentType);
                continue;
            }
            if (congruousTask == CongruousTask.WRITE_RESPONSE_OUTPUT_WRITER) {
                DelayedResponseOutputWriter delayedResponseOutputWriter = this.lifecycleIncongruityMap.getResponseOutputWriter();
                String delayedOutput = delayedResponseOutputWriter.toString();
                logger.debug("writing responseOutputWriter, delayedOutput=[{0}]", delayedOutput);
                if (delayedOutput != null && delayedOutput.length() > 0) {
                    Writer outputWriter = externalContext.getResponseOutputWriter();
                    outputWriter.write(delayedOutput);
                }
                this.lifecycleIncongruityMap.putResponseOutputWriter(null);
                continue;
            }
            if (congruousTask != CongruousTask.WRITE_RESPONSE_OUTPUT_STREAM) continue;
            DelayedResponseOutputStream delayedResponseOutputStream = this.lifecycleIncongruityMap.getResponseOutputStream();
            byte[] delayedOutputByteArray = delayedResponseOutputStream.toByteArray();
            int length = 0;
            if (delayedOutputByteArray != null) {
                length = delayedOutputByteArray.length;
            }
            logger.debug("writing responseOutputStream, delayedOutputByteArray.length=[{0}]", length);
            if (delayedOutputByteArray != null && length > 0) {
                OutputStream outputStream = externalContext.getResponseOutputStream();
                outputStream.write(delayedOutputByteArray);
            }
            this.lifecycleIncongruityMap.putResponseOutputStream(null);
        }
    }
}

