/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.lifecycle;

import java.util.Map;
import org.portletfaces.bridge.lifecycle.DelayedResponseOutputStream;
import org.portletfaces.bridge.lifecycle.DelayedResponseOutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleIncongruityMap {
    private static final String REQUEST_CHARACTER_ENCODING = "_pfbRequestCharacterEncoding";
    private static final String REQUEST_CONTENT_LENGTH = "_pfbRequestContentLength";
    private static final String REQUEST_CONTENT_TYPE = "_pfbRequestContentType";
    private static final String RESPONSE_TO_BE_RESET = "_pfbResponseToBeReset";
    private static final String RESPONSE_BUFFER_SIZE = "_pfbResponseBufferSize";
    private static final String RESPONSE_CHARACTER_ENCODING = "_pfbResponseCharacterEncoding";
    private static final String RESPONSE_CONTENT_LENGTH = "_pfbResponseContentLength";
    private static final String RESPONSE_COMMITTED = "_pfbResponseCommitted";
    private static final String RESPONSE_CONTENT_TYPE = "_pfbResponseContentType";
    private static final String RESPONSE_OUTPUT_STREAM = "_pfbResponseOutputStream";
    private static final String RESPONSE_OUTPUT_WRITER = "_pfbResponseOutputWriter";
    private static final String RESPONSE_STATUS = "_pfbResponseStatus";
    private Map<String, Object> requestMap;

    public LifecycleIncongruityMap(Map<String, Object> requestMap) {
        this.requestMap = requestMap;
    }

    public Object get(String key) {
        return this.requestMap.get(key);
    }

    public void put(String key, Object value) {
        this.requestMap.put(key, value);
    }

    public void putRequestCharacterEncoding(String requestCharacterEncoding) {
        this.requestMap.put(REQUEST_CHARACTER_ENCODING, requestCharacterEncoding);
    }

    public void putRequestContentLength(int requestContentLength) {
        this.requestMap.put(REQUEST_CONTENT_LENGTH, requestContentLength);
    }

    public void putRequestContentType(String requestContentType) {
        this.requestMap.put(REQUEST_CONTENT_TYPE, requestContentType);
    }

    public void putResponseBufferSize(int responseBufferSize) {
        this.requestMap.put(RESPONSE_BUFFER_SIZE, responseBufferSize);
    }

    public void putResponseCharacterEncoding(String responseCharacterEncoding) {
        this.requestMap.put(RESPONSE_CHARACTER_ENCODING, responseCharacterEncoding);
    }

    public void putResponseCommitted(boolean responseCommitted) {
        this.requestMap.put(RESPONSE_COMMITTED, responseCommitted);
    }

    public void putResponseContentLength(int responseContentLength) {
        this.requestMap.put(RESPONSE_CONTENT_LENGTH, responseContentLength);
    }

    public void putResponseContentType(String responseContentType) {
        this.requestMap.put(RESPONSE_CONTENT_TYPE, responseContentType);
    }

    public void putResponseOutputStream(DelayedResponseOutputStream delayedResponseOutputStream) {
        this.requestMap.put(RESPONSE_OUTPUT_STREAM, delayedResponseOutputStream);
    }

    public void putResponseOutputWriter(DelayedResponseOutputWriter delayedResponseOutputWriter) {
        this.requestMap.put(RESPONSE_OUTPUT_WRITER, delayedResponseOutputWriter);
    }

    public void putResponseStatus(int responseStatus) {
        this.requestMap.put(RESPONSE_STATUS, responseStatus);
    }

    public void putResponseToBeReset(boolean responseToBeReset) {
        this.requestMap.put(RESPONSE_TO_BE_RESET, responseToBeReset);
    }

    public boolean isResponseCommitted() {
        return this.getValueAsBoolean(RESPONSE_COMMITTED, true);
    }

    public String getRequestCharacterEncoding() {
        return (String)this.requestMap.get(REQUEST_CHARACTER_ENCODING);
    }

    public int getRequestContentLength() {
        return this.getValueAsInt(REQUEST_CONTENT_LENGTH, -1);
    }

    public String getRequestContentType() {
        return (String)this.requestMap.get(REQUEST_CONTENT_TYPE);
    }

    public int getResponseBufferSize() {
        return this.getValueAsInt(RESPONSE_BUFFER_SIZE, 0);
    }

    public String getResponseCharacterEncoding() {
        return (String)this.requestMap.get(RESPONSE_CHARACTER_ENCODING);
    }

    public int getResponseContentLength() {
        return this.getValueAsInt(RESPONSE_CONTENT_LENGTH, -1);
    }

    public String getResponseContentType() {
        return (String)this.requestMap.get(RESPONSE_CONTENT_TYPE);
    }

    public DelayedResponseOutputStream getResponseOutputStream() {
        DelayedResponseOutputStream responseOutputstream = (DelayedResponseOutputStream)this.requestMap.get(RESPONSE_OUTPUT_STREAM);
        if (responseOutputstream == null) {
            responseOutputstream = new DelayedResponseOutputStream();
        }
        return responseOutputstream;
    }

    public DelayedResponseOutputWriter getResponseOutputWriter() {
        DelayedResponseOutputWriter responseOutputWriter = (DelayedResponseOutputWriter)this.requestMap.get(RESPONSE_OUTPUT_WRITER);
        if (responseOutputWriter == null) {
            responseOutputWriter = new DelayedResponseOutputWriter();
        }
        return responseOutputWriter;
    }

    public int getResponseStatus() {
        return this.getValueAsInt(RESPONSE_STATUS, 200);
    }

    public boolean isResponseToBeReset() {
        return this.getValueAsBoolean(RESPONSE_TO_BE_RESET, false);
    }

    protected boolean getValueAsBoolean(String key, boolean defaultValue) {
        Boolean value = (Boolean)this.requestMap.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected int getValueAsInt(String key, int defaultValue) {
        Integer value = (Integer)this.requestMap.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

