/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.bridge;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.portletfaces.bridge.component.HtmlInputFile;
import org.portletfaces.bridge.component.UploadedFile;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFileRenderer
extends Renderer {
    private static final Logger logger = LoggerFactory.getLogger(InputFileRenderer.class);

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        super.decode(facesContext, uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestParameterMap = externalContext.getRequestParameterMap();
        String submittedValue = (String)requestParameterMap.get(clientId);
        if (submittedValue != null) {
            HtmlInputFile htmlInputFile = (HtmlInputFile)uiComponent;
            htmlInputFile.setSubmittedValue(submittedValue);
            Map requestAttributeMap = externalContext.getRequestMap();
            Map facesFileMap = (Map)requestAttributeMap.get("javax.faces.UPLOADED_FILES");
            UploadedFile uploadedFile = (UploadedFile)facesFileMap.get(clientId);
            htmlInputFile.setUploadedFile(uploadedFile);
            logger.debug("Setting submittedValue=[{0}]", submittedValue);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        Map attributeMap = uiComponent.getAttributes();
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("input", uiComponent);
        responseWriter.writeAttribute("id", (Object)clientId, null);
        responseWriter.writeAttribute("name", (Object)clientId, null);
        responseWriter.writeAttribute("type", (Object)"file", null);
        this.writePropertyAttribute(responseWriter, "accept", attributeMap);
        this.writePropertyAttribute(responseWriter, "size", attributeMap);
        this.writePropertyAttribute(responseWriter, "styleClass", "class", attributeMap);
        this.writePropertyAttribute(responseWriter, "accesskey", attributeMap);
        this.writePropertyAttribute(responseWriter, "dir", attributeMap);
        this.writePropertyAttribute(responseWriter, "disabled", attributeMap);
        this.writePropertyAttribute(responseWriter, "lang", attributeMap);
        this.writePropertyAttribute(responseWriter, "style", attributeMap);
        this.writePropertyAttribute(responseWriter, "tabIndex", attributeMap);
        this.writePropertyAttribute(responseWriter, "title", attributeMap);
        this.writePropertyAttribute(responseWriter, "xml:lang", attributeMap);
        this.writePropertyAttribute(responseWriter, "onblur", attributeMap);
        this.writePropertyAttribute(responseWriter, "onchange", attributeMap);
        this.writePropertyAttribute(responseWriter, "onclick", attributeMap);
        this.writePropertyAttribute(responseWriter, "ondblclick", attributeMap);
        this.writePropertyAttribute(responseWriter, "onfocus", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmousedown", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmousemove", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmouseout", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmouseover", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmouseup", attributeMap);
        this.writePropertyAttribute(responseWriter, "onkeydown", attributeMap);
        this.writePropertyAttribute(responseWriter, "onkeypress", attributeMap);
        this.writePropertyAttribute(responseWriter, "onkeyup", attributeMap);
        this.writePropertyAttribute(responseWriter, "onselect", attributeMap);
        responseWriter.endElement("input");
    }

    protected void writePropertyAttribute(ResponseWriter responseWriter, String name, Map<String, Object> attributeMap) throws IOException {
        String value = (String)attributeMap.get(name);
        if (value != null) {
            responseWriter.writeAttribute(name, (Object)value, name);
        }
    }

    protected void writePropertyAttribute(ResponseWriter responseWriter, String name, String property, Map<String, Object> attributeMap) throws IOException {
        String value = (String)attributeMap.get(name);
        if (value != null) {
            responseWriter.writeAttribute(name, (Object)value, property);
        }
    }
}

