/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.bridge;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class ResponseWriterBridgeImpl
extends ResponseWriterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWriterBridgeImpl.class);
    private static final String ATTRIBUTE_AUTOCOMPLETE = "autocomplete";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String DOCTYPE_MARKER = "<!DOCTYPE";
    private static final String ELEMENT_CHANGES = "changes";
    private static final String ELEMENT_FORM = "form";
    private static final String ELEMENT_INPUT = "input";
    private static final String ELEMENT_PARTIAL_RESPONSE = "partial-response";
    private static final String ELEMENT_UPDATE = "update";
    private static final String GREATER_THAN = ">";
    private static final String TYPE_HIDDEN = "hidden";
    private static final String VALUE_OFF = "off";
    private static final String XML_MARKER = "<?xml";
    private String currentElementName;
    private boolean insidePartialResponse;
    private boolean insideChanges;
    private boolean insideCData;
    private boolean insideUpdate;
    private boolean viewStateWritten;
    private ResponseWriter wrappedResponseWriter;

    public ResponseWriterBridgeImpl(ResponseWriter wrappedResponseWriter) {
        this.wrappedResponseWriter = wrappedResponseWriter;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new ResponseWriterBridgeImpl(this.wrappedResponseWriter.cloneWithWriter(writer));
    }

    public void endCDATA() throws IOException {
        this.insideCData = false;
        logger.trace("insideCData=[false]");
        super.endCDATA();
    }

    public void endElement(String elementName) throws IOException {
        logger.trace("elementName=[{0}]", elementName);
        this.currentElementName = null;
        if (ELEMENT_PARTIAL_RESPONSE.equals(elementName)) {
            this.insidePartialResponse = false;
        } else if (ELEMENT_CHANGES.equals(elementName)) {
            this.insideChanges = false;
        } else if (ELEMENT_UPDATE.equals(elementName)) {
            this.insideUpdate = false;
        } else if (ELEMENT_FORM.equals(elementName) && this.insidePartialResponse && this.insideChanges && this.insideUpdate && this.insideCData && !this.viewStateWritten) {
            this.startElement(ELEMENT_INPUT, null);
            this.writeAttribute(ATTRIBUTE_TYPE, TYPE_HIDDEN, null);
            this.writeAttribute(ATTRIBUTE_NAME, "javax.faces.ViewState", null);
            this.writeAttribute(ATTRIBUTE_ID, "javax.faces.ViewState", null);
            FacesContext facesContext = FacesContext.getCurrentInstance();
            String viewState = facesContext.getApplication().getStateManager().getViewState(facesContext);
            this.writeAttribute(ATTRIBUTE_VALUE, viewState, null);
            this.writeAttribute(ATTRIBUTE_AUTOCOMPLETE, VALUE_OFF, null);
            this.endElement(ELEMENT_INPUT);
            this.viewStateWritten = true;
        }
        super.endElement(elementName);
    }

    public void startCDATA() throws IOException {
        this.insideCData = true;
        logger.trace("insideCData=[true]");
        super.startCDATA();
    }

    public void startElement(String elementName, UIComponent uiComponent) throws IOException {
        logger.trace("elementName=[{0}]", elementName);
        this.currentElementName = elementName;
        if (ELEMENT_PARTIAL_RESPONSE.equals(elementName)) {
            this.insidePartialResponse = true;
        } else if (ELEMENT_CHANGES.equals(elementName)) {
            this.insideChanges = true;
        } else if (ELEMENT_UPDATE.equals(elementName)) {
            this.insideUpdate = true;
        }
        super.startElement(elementName, uiComponent);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            String data = new String(cbuf, off, len);
            if (data.startsWith(XML_MARKER) || data.startsWith(DOCTYPE_MARKER)) {
                logger.trace("filtering marker");
                int greaterThanPos = data.indexOf(GREATER_THAN);
                if (greaterThanPos > 0) {
                    len -= greaterThanPos + 1;
                    off += greaterThanPos + 1;
                }
            }
            if (len > 0) {
                if (logger.isTraceEnabled()) {
                    String value = new String(cbuf, off, len);
                    logger.trace("writing value=[{0}]", value);
                }
                this.wrappedResponseWriter.write(cbuf, off, len);
            }
        }
    }

    public void writeAttribute(String attributeName, Object attributeValue, String property) throws IOException {
        logger.trace("attributeName=[{0}] attributeValue=[{1}]", attributeName, attributeValue);
        if (attributeName != null && attributeName.equals(ATTRIBUTE_ID)) {
            if (this.insidePartialResponse && this.insideChanges && this.insideUpdate && ELEMENT_UPDATE.equals(this.currentElementName) && "javax.faces.ViewRoot".equals(attributeValue)) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                attributeValue = facesContext.getViewRoot().getContainerClientId(facesContext);
            } else if (ELEMENT_INPUT.equals(this.currentElementName) && "javax.faces.ViewState".equals(attributeValue)) {
                this.viewStateWritten = true;
            }
        }
        super.writeAttribute(attributeName, attributeValue, property);
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }
}

