/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.html_basic;

import java.util.Stack;
import org.portletfaces.bridge.renderkit.html_basic.ElementBlankImpl;
import org.portletfaces.bridge.renderkit.html_basic.ElementWriter;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementWriterStack
extends Stack<ElementWriter> {
    private static final long serialVersionUID = 3761771658484098988L;
    private static final Logger logger = LoggerFactory.getLogger(ElementWriterStack.class);

    @Override
    public synchronized ElementWriter pop() {
        ElementWriter topElementWriter = (ElementWriter)super.pop();
        Element topElement = topElementWriter.getElement();
        boolean done = this.isEmpty();
        while (!done) {
            Element peekedElement = ((ElementWriter)this.peek()).getElement();
            if (peekedElement instanceof ElementBlankImpl) {
                StringBuilder prependedTextContent = new StringBuilder();
                prependedTextContent.append(peekedElement.getTextContent());
                prependedTextContent.append(topElement.getTextContent());
                topElement.setTextContent(prependedTextContent.toString());
                super.pop();
                done = this.isEmpty();
                continue;
            }
            done = true;
        }
        return topElementWriter;
    }

    public synchronized ElementWriter safePeek() {
        if (this.isEmpty()) {
            logger.debug("Stack was empty so created blank element", null);
            this.push(new ElementWriter(new ElementBlankImpl()));
        }
        return (ElementWriter)this.peek();
    }
}

