/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.html_basic;

import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.portletfaces.bridge.renderkit.html_basic.HeadManagedBean;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class HeadPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 8502242430265622811L;
    private static final Logger logger = LoggerFactory.getLogger(HeadPhaseListener.class);

    public void afterPhase(PhaseEvent phaseEvent) {
        if (logger.isDebugEnabled() && phaseEvent.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
            FacesContext facesContext = phaseEvent.getFacesContext();
            String viewId = facesContext.getViewRoot().getViewId();
            logger.debug("After INVOKE_APPLICATION: viewId=[{0}]", viewId);
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
            this.beforeInvokeApplicationPhase(phaseEvent);
        } else if (phaseEvent.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.beforeRenderResponsePhase(phaseEvent);
        }
    }

    protected void beforeInvokeApplicationPhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        Flash flash = facesContext.getExternalContext().getFlash();
        Set headResourceIdsFromFlash = (Set)flash.get((Object)"HEAD_RESOURCE_IDS");
        logger.debug("Before INVOKE_APPLICATION: viewId=[{0}]", facesContext.getViewRoot().getViewId());
        if (headResourceIdsFromFlash == null) {
            HeadManagedBean headManagedBean = HeadManagedBean.getInstance(facesContext);
            flash.put((Object)"HEAD_RESOURCE_IDS", headManagedBean.getHeadResourceIds());
        }
    }

    protected void beforeRenderResponsePhase(PhaseEvent phaseEvent) {
        FacesContext facesContext = phaseEvent.getFacesContext();
        Flash flash = facesContext.getExternalContext().getFlash();
        String viewId = facesContext.getViewRoot().getViewId();
        Set headResourceIdsFromFlash = (Set)flash.get((Object)"HEAD_RESOURCE_IDS");
        if (headResourceIdsFromFlash != null) {
            HeadManagedBean headManagedBean = HeadManagedBean.getInstance(facesContext);
            Set<String> managedBeanResourceIds = headManagedBean.getHeadResourceIds();
            for (String resourceIdFromFlash : headResourceIdsFromFlash) {
                if (managedBeanResourceIds.contains(resourceIdFromFlash)) continue;
                managedBeanResourceIds.add(resourceIdFromFlash);
                logger.debug("Added resourceId=[{0}] from the Flash scope to the list of resourceIds in the HeadManagedBean for viewId=[{1}]", resourceIdFromFlash, viewId);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

