/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.html_basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.PortletRequest;
import org.portletfaces.bridge.BridgeFactoryFinder;
import org.portletfaces.bridge.application.ResourceInfo;
import org.portletfaces.bridge.component.PortletNamingContainerUIViewRoot;
import org.portletfaces.bridge.container.PortletContainer;
import org.portletfaces.bridge.container.PortletContainerFactory;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.bridge.renderkit.bridge.BridgeRenderer;
import org.portletfaces.bridge.renderkit.html_basic.HeadManagedBean;
import org.portletfaces.bridge.renderkit.html_basic.HeadResponseWriter;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class HeadRenderer
extends BridgeRenderer {
    private static final String ADDED = UIComponentBase.class.getName() + ".ADDED";
    private static final Logger logger = LoggerFactory.getLogger(HeadRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        PortletNamingContainerUIViewRoot uiViewRoot = (PortletNamingContainerUIViewRoot)facesContext.getViewRoot();
        List uiComponentResources = uiViewRoot.getComponentResources(facesContext, "head");
        if (uiComponentResources != null) {
            ResourceInfo resourceInfo;
            boolean ajaxRequest = facesContext.getPartialViewContext().isAjaxRequest();
            ArrayList<UIComponent> resourcesForAddingToHead = new ArrayList<UIComponent>();
            ArrayList<UIComponent> resourcesForRelocatingToBody = new ArrayList<UIComponent>();
            ExternalContext externalContext = facesContext.getExternalContext();
            PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
            BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
            PortletContainerFactory portletContainerFactory = (PortletContainerFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.container.PortletContainerFactory");
            BridgeContext bridgeContext = (BridgeContext)facesContext.getAttributes().get("javax.portlet.faces.bridgeContext");
            PortletContainer portletContainer = portletContainerFactory.getPortletContainer(bridgeContext);
            boolean portletContainerAbleToAddScriptResourceToHead = portletContainer.isAbleToAddScriptResourceToHead();
            HeadManagedBean headManagedBean = HeadManagedBean.getInstance(facesContext);
            Set<String> headResourceIdsFromManagedBean = headManagedBean.getHeadResourceIds();
            for (UIComponent uiComponentResource : uiComponentResources) {
                if (ajaxRequest) {
                    resourceInfo = new ResourceInfo(uiComponentResource);
                    boolean alreadyPresentInPortalPageHead = headResourceIdsFromManagedBean.contains(resourceInfo.getId());
                    if (alreadyPresentInPortalPageHead) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Resource already present in head: name=[{0}] library=[{1}] rendererType=[{2}] value=[{3}] className=[{4}]", resourceInfo.getName(), resourceInfo.getLibrary(), resourceInfo.getRendererType(), resourceInfo.getValue(), resourceInfo.getClassName());
                        continue;
                    }
                    logger.debug("Relocating resource to body (since it was added via Ajax and is not yet present in head): name=[{0}] library=[{1}] rendererType=[{2}] value=[{3}] className=[{4}]", resourceInfo.getName(), resourceInfo.getLibrary(), resourceInfo.getRendererType(), resourceInfo.getValue(), resourceInfo.getClassName());
                    resourcesForRelocatingToBody.add(uiComponentResource);
                    continue;
                }
                if (portletContainerAbleToAddScriptResourceToHead) {
                    resourcesForAddingToHead.add(uiComponentResource);
                    continue;
                }
                resourcesForRelocatingToBody.add(uiComponentResource);
            }
            if (portletContainerAbleToAddScriptResourceToHead) {
                ResponseWriter responseWriterBackup = facesContext.getResponseWriter();
                HeadResponseWriter headResponseWriter = (HeadResponseWriter)((Object)portletRequest.getAttribute("headResponseWriter"));
                if (headResponseWriter == null) {
                    headResponseWriter = (HeadResponseWriter)portletContainer.getHeadResponseWriter(responseWriterBackup);
                }
                portletRequest.setAttribute("headResponseWriter", (Object)headResponseWriter);
                facesContext.setResponseWriter((ResponseWriter)headResponseWriter);
                for (UIComponent uiComponentResource : resourcesForAddingToHead) {
                    uiComponentResource.encodeAll(facesContext);
                    ResourceInfo resourceInfo2 = new ResourceInfo(uiComponentResource);
                    headResourceIdsFromManagedBean.add(resourceInfo2.getId());
                }
                facesContext.setResponseWriter(responseWriterBackup);
            }
            for (UIComponent uiComponentResource : resourcesForRelocatingToBody) {
                uiComponentResource.getAttributes().put("originalTarget", "head");
                uiComponentResource.getAttributes().put(ADDED, Boolean.TRUE);
                uiViewRoot.addComponentResource(facesContext, uiComponentResource, "body");
                if (!logger.isDebugEnabled()) continue;
                resourceInfo = new ResourceInfo(uiComponentResource);
                logger.debug("Relocating resource to body: name=[{0}] library=[{1}] rendererType=[{2}] value=[{3}] className=[{4}]", resourceInfo.getName(), resourceInfo.getLibrary(), resourceInfo.getRendererType(), resourceInfo.getValue(), resourceInfo.getClassName());
            }
        }
    }
}

