/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.html_basic;

import java.io.IOException;
import java.io.Writer;
import java.util.EmptyStackException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.portletfaces.bridge.renderkit.html_basic.ElementWriterStack;
import org.w3c.dom.Element;

public abstract class HeadResponseWriter
extends ResponseWriterWrapper {
    public static final String ELEMENT_HEAD = "head";
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    ResponseWriter wrappedResponseWriter;
    ElementWriterStack elementWriterStack;

    public HeadResponseWriter(ResponseWriter wrappedResponseWriter) {
        this.wrappedResponseWriter = wrappedResponseWriter;
        this.elementWriterStack = new ElementWriterStack();
    }

    public abstract Element createElement(String var1);

    public Writer append(CharSequence csq) throws IOException {
        try {
            this.elementWriterStack.safePeek().append(csq);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
        return this;
    }

    public Writer append(char c) throws IOException {
        try {
            this.elementWriterStack.safePeek().append(c);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        try {
            this.elementWriterStack.safePeek().append(csq, start, end);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
        return this;
    }

    public void close() throws IOException {
        try {
            this.elementWriterStack.safePeek().close();
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void endCDATA() throws IOException {
        try {
            this.elementWriterStack.safePeek().write(CDATA_END);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void endDocument() throws IOException {
    }

    public void flush() throws IOException {
        try {
            this.elementWriterStack.safePeek().flush();
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void startCDATA() throws IOException {
        try {
            this.elementWriterStack.safePeek().write(CDATA_BEGIN);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void startDocument() throws IOException {
    }

    public void write(int c) throws IOException {
        try {
            this.elementWriterStack.safePeek().write(c);
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void write(char[] cbuf) throws IOException {
        if (cbuf != null) {
            try {
                this.elementWriterStack.safePeek().write(cbuf);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void write(String str) throws IOException {
        if (str != null) {
            try {
                this.elementWriterStack.safePeek().write(str);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf != null) {
            try {
                this.elementWriterStack.safePeek().write(cbuf, off, len);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (str != null) {
            try {
                this.elementWriterStack.safePeek().write(str, off, len);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        try {
            if (value == null) {
                this.elementWriterStack.safePeek().getElement().setAttribute(name, null);
            } else {
                this.elementWriterStack.safePeek().getElement().setAttribute(name, value.toString());
            }
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            try {
                this.elementWriterStack.safePeek().write(comment.toString());
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (text != null) {
            try {
                this.elementWriterStack.safePeek().write(text.toString());
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (text != null) {
            try {
                this.elementWriterStack.safePeek().write(text.toString());
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (text != null) {
            try {
                this.elementWriterStack.safePeek().write(text, off, len);
            }
            catch (EmptyStackException e) {
                throw new IOException(EmptyStackException.class.getSimpleName());
            }
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.writeAttribute(name, value, property);
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }
}

