/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.html_basic;

import java.io.IOException;
import java.util.EmptyStackException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.portlet.PortletResponse;
import org.portletfaces.bridge.renderkit.html_basic.ElementWriter;
import org.portletfaces.bridge.renderkit.html_basic.HeadResponseWriter;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;
import org.w3c.dom.Element;

public class HeadResponseWriterImpl
extends HeadResponseWriter {
    private static final Logger logger = LoggerFactory.getLogger(HeadResponseWriterImpl.class);
    private PortletResponse portletResponse;

    public HeadResponseWriterImpl(ResponseWriter wrappedResponseWriter, PortletResponse portletResponse) {
        super(wrappedResponseWriter);
        this.portletResponse = portletResponse;
    }

    public Element createElement(String name) {
        return this.portletResponse.createElement(name);
    }

    public void endElement(String name) throws IOException {
        try {
            ElementWriter elementWriter = this.elementWriterStack.pop();
            Element element = elementWriter.getElement();
            String nodeName = element.getNodeName();
            logger.trace("POPPED element name=[{0}]", nodeName);
            if (!"head".equals(nodeName)) {
                this.portletResponse.addProperty("javax.portlet.markup.head.element", element);
                logger.debug("Added resource to portal's <head>...</head> section nodeName=[{0}]", nodeName);
            }
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void startElement(String name, UIComponent component) throws IOException {
        Element element = this.createElement(name);
        ElementWriter elementWriter = new ElementWriter(element);
        this.elementWriterStack.push(elementWriter);
    }
}

