/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.html_basic;

import java.io.IOException;
import java.util.EmptyStackException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.portlet.PortletRequest;
import org.portletfaces.bridge.container.liferay.StringBundlerUtil;
import org.portletfaces.bridge.renderkit.html_basic.ElementImpl;
import org.portletfaces.bridge.renderkit.html_basic.ElementWriter;
import org.portletfaces.bridge.renderkit.html_basic.HeadResponseWriter;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;
import org.w3c.dom.Element;

public class HeadResponseWriterLiferayImpl
extends HeadResponseWriter {
    public static final String LIFERAY_SHARED_PAGE_TOP = "LIFERAY_SHARED_PAGE_TOP";
    private static final Logger logger = LoggerFactory.getLogger(HeadResponseWriterLiferayImpl.class);
    private PortletRequest portletRequest;

    public HeadResponseWriterLiferayImpl(ResponseWriter wrappedResponseWriter, PortletRequest portletRequest) {
        super(wrappedResponseWriter);
        this.portletRequest = portletRequest;
    }

    public Element createElement(String name) {
        return new ElementImpl(name);
    }

    public void endElement(String name) throws IOException {
        try {
            ElementWriter elementWriter = this.elementWriterStack.pop();
            Element element = elementWriter.getElement();
            String nodeName = element.getNodeName();
            logger.trace("POPPED element name=[{0}]", nodeName);
            if (!"head".equals(element.getNodeName())) {
                String elementAsString = element.toString();
                Object stringBundler = this.portletRequest.getAttribute(LIFERAY_SHARED_PAGE_TOP);
                if (stringBundler == null) {
                    stringBundler = StringBundlerUtil.create();
                }
                StringBundlerUtil.append(stringBundler, elementAsString);
                this.portletRequest.setAttribute(LIFERAY_SHARED_PAGE_TOP, stringBundler);
                if (logger.isDebugEnabled()) {
                    logger.debug("Added resource to Liferay's <head>...</head> section element=[" + elementAsString + "]");
                }
            }
        }
        catch (EmptyStackException e) {
            throw new IOException(EmptyStackException.class.getSimpleName());
        }
    }

    public void startElement(String name, UIComponent component) throws IOException {
        Element element = this.createElement(name);
        ElementWriter elementWriter = new ElementWriter(element);
        this.elementWriterStack.push(elementWriter);
        logger.trace("PUSHED element name=[{0}]", name);
    }
}

