/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.renderkit.portlet;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.portlet.BaseURL;
import org.portletfaces.bridge.component.PortletParam;
import org.portletfaces.bridge.component.PortletProperty;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public abstract class BaseURLRenderer
extends Renderer {
    private static final Logger logger = LoggerFactory.getLogger(BaseURLRenderer.class);

    protected void encodeEnd(FacesContext facesContext, UIComponent uiComponent, BaseURL baseURL) throws IOException {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map attributes = uiComponent.getAttributes();
        Boolean escapeXML = (Boolean)attributes.get("escapeXML");
        Boolean secure = (Boolean)attributes.get("secure");
        String varName = (String)attributes.get("var");
        try {
            List children;
            if (escapeXML != null) {
                logger.warn("escapeXML not supported for JSF");
            }
            if (secure != null) {
                baseURL.setSecure(secure.booleanValue());
            }
            if ((children = uiComponent.getChildren()) != null) {
                for (UIComponent child : children) {
                    String value;
                    String name;
                    if (child instanceof PortletParam) {
                        name = ((PortletParam)child).getName();
                        value = (String)((PortletParam)child).getValue();
                        baseURL.setParameter(name, value);
                        continue;
                    }
                    if (!(child instanceof PortletProperty)) continue;
                    name = ((PortletProperty)child).getName();
                    value = (String)((PortletProperty)child).getValue();
                    baseURL.addProperty(name, value);
                }
            }
            String url = baseURL.toString();
            if (varName == null) {
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                responseWriter.write(url);
            } else {
                externalContext.getRequestMap().put(varName, url);
            }
        }
        catch (Exception e) {
            logger.error(e);
            throw new IOException(e.getMessage());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

