/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.scope;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.bridge.scope.BridgeRequestScope;
import org.portletfaces.bridge.scope.FacesContextAttribute;
import org.portletfaces.bridge.scope.RequestAttribute;
import org.portletfaces.bridge.util.FacesMessageWrapper;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeRequestScopeImpl
extends ConcurrentHashMap<String, Object>
implements BridgeRequestScope {
    private static final long serialVersionUID = 7113251688518329851L;
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeImpl.class);
    private static final String BRIDGE_REQ_SCOPE_ATTR_FACES_CONTEXT_ATTRIBUTES = "org.portletfaces.bridge.facescontext.attributes";
    private static final String BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES = "org.portletfaces.bridge.faces.messages";
    private static final String BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT = "org.portletfaces.bridge.faces.view.root";
    private static final String BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES = "org.portletfaces.bridge.faces.request.attributes";
    private static final String EXCLUDED_ATTR_EXTERNAL_CONTEXT = "javax.faces.context.ExternalContext";
    private static final String EXCLUDED_ATTR_FACES_CONTEXT = "javax.faces.context.FacesContext";
    private static final String EXCLUDED_ATTR_HTTP_SESSION = "javax.servlet.HttpSession";
    private static final String EXCLUDED_ATTR_PORTAL_CONTEXT = "javax.portlet.PortalContext";
    private static final String EXCLUDED_ATTR_PORTLET_CONFIG = "javax.portlet.PortletConfig";
    private static final String EXCLUDED_ATTR_PORTLET_CONTEXT = "javax.portlet.PortletContext";
    private static final String EXCLUDED_ATTR_PORTLET_PREFERENCES = "javax.portlet.PortletPreferences";
    private static final String EXCLUDED_ATTR_PORTLET_REQUEST = "javax.portlet.PortletRequest";
    private static final String EXCLUDED_ATTR_PORTLET_RESPONSE = "javax.portlet.PortletResponse";
    private static final String EXCLUDED_ATTR_PORTLET_SESSION = "javax.portlet.PortletSession";
    private static final String EXCLUDED_ATTR_SERVLET_CONFIG = "javax.servlet.ServletConfig";
    private static final String EXCLUDED_ATTR_SERVLET_CONTEXT = "javax.servlet.ServletContext";
    private static final String EXCLUDED_ATTR_SERVLET_REQUEST = "javax.servlet.ServletRequest";
    private static final String EXCLUDED_ATTR_SERVLET_RESPONSE = "javax.servlet.ServletResponse";
    private static Set<String> STANDARD_EXCLUDED_ATTRIBUTE_NAMES = new HashSet<String>(14);
    private static final String EXCLUDED_NAMESPACE_JAVAX_FACES = "javax.faces";
    private static final String EXCLUDED_NAMESPACE_JAVAX_PORTLET = "javax.portlet";
    private static final String EXCLUCED_NAMESPACE_JAVAX_SERVLET = "javax.servlet";
    private static List<String> STANDARD_EXCLUDED_REQUEST_ATTRIBUTE_NAMESPACES = new ArrayList<String>(3);
    private Map<String, Object> attributeMap;
    private Set<String> excludedAttributeNames;
    private Flash flash;
    private String idPrefix;
    private String idSuffix;
    private Map<String, Object> managedBeanMap;
    private PortletMode portletMode;
    private Set<String> preExistingAttributeNames;
    private boolean beganInActionOrEventRequest;

    public BridgeRequestScopeImpl(BridgeContext bridgeContext, String idPrefix) {
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        this.attributeMap = new HashMap<String, Object>();
        long timeInMillis = Calendar.getInstance().getTimeInMillis();
        this.idPrefix = idPrefix;
        this.idSuffix = Long.toString(timeInMillis);
        this.excludedAttributeNames = bridgeContext.getBridgeConfig().getExcludedBridgeRequestScopeAttributes();
        this.preExistingAttributeNames = this.getPreExistingRequestAttributeNames(portletRequest);
        Bridge.PortletPhase portletPhase = bridgeContext.getPortletRequestPhase();
        if (portletPhase == Bridge.PortletPhase.ACTION_PHASE || portletPhase == Bridge.PortletPhase.EVENT_PHASE) {
            this.beganInActionOrEventRequest = true;
        }
    }

    @Override
    public void preserveScopedData(FacesContext facesContext) {
        logger.debug("preserveScopedData(facesContext)");
        ExternalContext externalContext = facesContext.getExternalContext();
        this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT, facesContext.getViewRoot());
        ArrayList<FacesMessageWrapper> facesMessageWrappers = new ArrayList<FacesMessageWrapper>();
        Iterator clientIds = facesContext.getClientIdsWithMessages();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator facesMessages = facesContext.getMessages(clientId);
            while (facesMessages.hasNext()) {
                FacesMessage facesMessage = (FacesMessage)facesMessages.next();
                FacesMessageWrapper facesMessageWrapper = new FacesMessageWrapper(clientId, facesMessage);
                facesMessageWrappers.add(facesMessageWrapper);
            }
        }
        if (facesMessageWrappers.size() > 0) {
            this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES, facesMessageWrappers);
        } else {
            logger.trace("Not saving any faces messages");
        }
        Map currentRequestAttributes = externalContext.getRequestMap();
        if (currentRequestAttributes != null) {
            ArrayList<RequestAttribute> savedRequestAttributes = new ArrayList<RequestAttribute>();
            Iterator itr = currentRequestAttributes.entrySet().iterator();
            if (itr != null) {
                while (itr.hasNext()) {
                    Map.Entry mapEntry = itr.next();
                    String name = (String)mapEntry.getKey();
                    if (this.isExcludedRequestAttribute(name)) {
                        logger.trace("Not saving EXCLUDED attribute name=[{0}]", name);
                        continue;
                    }
                    Object value = mapEntry.getValue();
                    logger.trace("Saving non-excluded request attribute name=[{0}] value=[{1}]", name, value);
                    savedRequestAttributes.add(new RequestAttribute(name, value));
                }
                if (savedRequestAttributes.size() > 0) {
                    this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES, savedRequestAttributes);
                } else {
                    logger.trace("Not saving any non-excluded request attributes");
                }
            }
        } else {
            logger.trace("Not saving any non-excluded request attributes because there are no request attributes!");
        }
        Map currentFacesContextAttributes = facesContext.getAttributes();
        int mapSize = currentFacesContextAttributes.size();
        ArrayList<FacesContextAttribute> savedFacesContextAttributes = new ArrayList<FacesContextAttribute>(mapSize);
        for (Map.Entry mapEntry : currentFacesContextAttributes.entrySet()) {
            Object name = mapEntry.getKey();
            Object value = mapEntry.getValue();
            logger.trace("Saving FacesContext attribute name=[{0}] value=[{1}]", name, value);
            savedFacesContextAttributes.add(new FacesContextAttribute(name, value));
        }
        this.setAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_CONTEXT_ATTRIBUTES, savedFacesContextAttributes);
    }

    @Override
    public boolean restoreScopedData(FacesContext facesContext) {
        if (this.beganInActionOrEventRequest) {
            UIViewRoot uiViewRoot = (UIViewRoot)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_VIEW_ROOT);
            if (uiViewRoot != null) {
                facesContext.setViewRoot(uiViewRoot);
                logger.debug("Restored uiViewRoot=[{0}]", uiViewRoot);
            } else {
                logger.debug("Did not restore uiViewRoot");
            }
            List facesMessages = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_MESSAGES);
            boolean restoredFacesMessages = false;
            if (facesMessages != null) {
                for (FacesMessageWrapper facesMessageWrapper : facesMessages) {
                    String clientId = facesMessageWrapper.getClientId();
                    FacesMessage facesMessage = facesMessageWrapper.getFacesMessage();
                    facesContext.addMessage(clientId, facesMessage);
                    logger.trace("Restored facesMessage=[{0}]", facesMessage.getSummary());
                    restoredFacesMessages = true;
                }
            }
            if (restoredFacesMessages) {
                logger.debug("Restored facesMessages");
            } else {
                logger.debug("Did not restore any facesMessages");
            }
            List savedRequestAttributes = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_REQUEST_ATTRIBUTES);
            boolean restoredNonExcludedRequestAttributes = false;
            if (savedRequestAttributes != null) {
                Map currentRequestAttributes = facesContext.getExternalContext().getRequestMap();
                for (RequestAttribute requestAttribute : savedRequestAttributes) {
                    String name = (String)requestAttribute.getName();
                    Object value = requestAttribute.getValue();
                    logger.trace("Restoring non-excluded request attribute name=[{0}] value=[{1}]", name, value);
                    currentRequestAttributes.put(name, value);
                    restoredNonExcludedRequestAttributes = true;
                }
            }
            if (restoredNonExcludedRequestAttributes) {
                logger.debug("Restored non-excluded request attributes");
            } else {
                logger.debug("Did not restore any non-excluded request attributes");
            }
            List savedFacesContextAttributes = (List)this.getAttribute(BRIDGE_REQ_SCOPE_ATTR_FACES_CONTEXT_ATTRIBUTES);
            boolean restoredFacesContextAttibutes = false;
            if (savedFacesContextAttributes != null) {
                Map currentFacesContextAttributes = facesContext.getAttributes();
                for (FacesContextAttribute facesContextAttribute : savedFacesContextAttributes) {
                    Object name = facesContextAttribute.getName();
                    if ("javax.portlet.faces.bridgeContext".equals(name)) continue;
                    Object value = facesContextAttribute.getValue();
                    logger.trace("Restoring FacesContext attribute name=[{0}] value=[{1}]", name, value);
                    currentFacesContextAttributes.put(name, value);
                    restoredFacesContextAttibutes = true;
                }
            }
            if (restoredFacesContextAttibutes) {
                logger.debug("Restored FacesContext attributes");
            } else {
                logger.debug("Did not restore any FacesContext attributes");
            }
            return true;
        }
        return false;
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    protected boolean isExcludedRequestAttribute(String attributeName) {
        boolean excluded = STANDARD_EXCLUDED_ATTRIBUTE_NAMES.contains(attributeName);
        if (!excluded && this.excludedAttributeNames != null) {
            for (String excludedAttribute : this.excludedAttributeNames) {
                if (!attributeName.equals(excludedAttribute) && !attributeName.matches(excludedAttribute)) continue;
                excluded = true;
                break;
            }
        }
        if (!excluded) {
            for (String namespace : STANDARD_EXCLUDED_REQUEST_ATTRIBUTE_NAMESPACES) {
                if (!attributeName.startsWith(namespace)) continue;
                excluded = true;
                break;
            }
        }
        if (!excluded) {
            excluded = this.preExistingAttributeNames.contains(attributeName);
        }
        return excluded;
    }

    @Override
    public Flash getFlash() {
        return this.flash;
    }

    @Override
    public void setFlash(Flash flash) {
        this.flash = flash;
    }

    @Override
    public String getId() {
        return this.idPrefix + this.idSuffix;
    }

    @Override
    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    public Map<String, Object> getManagedBeanMap() {
        if (this.managedBeanMap == null) {
            this.managedBeanMap = new HashMap<String, Object>();
        }
        return this.managedBeanMap;
    }

    @Override
    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    @Override
    public void setPortletMode(PortletMode portletMode) {
        this.portletMode = portletMode;
    }

    protected Set<String> getPreExistingRequestAttributeNames(PortletRequest portletRequest) {
        HashSet<String> attributeNames = null;
        Enumeration requestAttributeNames = portletRequest.getAttributeNames();
        if (requestAttributeNames != null) {
            attributeNames = new HashSet<String>();
            while (requestAttributeNames.hasMoreElements()) {
                String attributeName = (String)requestAttributeNames.nextElement();
                attributeNames.add(attributeName);
                logger.trace("Saving name of pre-existing request attribute [{0}]", attributeName);
            }
        }
        return attributeNames;
    }

    static {
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_EXTERNAL_CONTEXT);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_FACES_CONTEXT);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_HTTP_SESSION);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_PORTAL_CONTEXT);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_PORTLET_CONFIG);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_PORTLET_CONTEXT);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_PORTLET_PREFERENCES);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_PORTLET_REQUEST);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_PORTLET_RESPONSE);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_PORTLET_SESSION);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_SERVLET_CONFIG);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_SERVLET_CONTEXT);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_SERVLET_REQUEST);
        STANDARD_EXCLUDED_ATTRIBUTE_NAMES.add(EXCLUDED_ATTR_SERVLET_RESPONSE);
        STANDARD_EXCLUDED_REQUEST_ATTRIBUTE_NAMESPACES.add(EXCLUDED_NAMESPACE_JAVAX_FACES);
        STANDARD_EXCLUDED_REQUEST_ATTRIBUTE_NAMESPACES.add(EXCLUDED_NAMESPACE_JAVAX_PORTLET);
        STANDARD_EXCLUDED_REQUEST_ATTRIBUTE_NAMESPACES.add(EXCLUCED_NAMESPACE_JAVAX_SERVLET);
    }
}

