/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.StateAwareResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.portletfaces.bridge.BridgeFactoryFinder;
import org.portletfaces.bridge.context.BridgeContext;
import org.portletfaces.bridge.scope.BridgeRequestScope;
import org.portletfaces.bridge.scope.BridgeRequestScopeCache;
import org.portletfaces.bridge.scope.BridgeRequestScopeFactory;
import org.portletfaces.bridge.scope.BridgeRequestScopeManager;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeRequestScopeManagerImpl
implements BridgeRequestScopeManager {
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestScopeManagerImpl.class);
    private static final int DEFAULT_MAX_MANAGED_REQUEST_SCOPES = 100;
    private static final String ATTR_BRIDGE_REQUEST_SCOPE_CACHE = "org.portletfaces.bridge.bridgeRequestScopeCache";
    private static final String RENDER_PARAM_BRIDGE_REQUEST_SCOPE_ID = "org.portletfaces.bridge.bridgeRequestScopeId";
    private static final String SUPPORTED_PUBLIC_RENDER_PARAMETERS_MAP = "org.portletfaces.bridge.supportedPublicRenderParametersMap";

    @Override
    public void removeBridgeRequestScope(BridgeRequestScope bridgeRequestScope, BridgeContext bridgeContext) {
        this.getBridgeRequestScopeCache(bridgeContext.getPortletContext()).remove(bridgeRequestScope);
    }

    @Override
    public void removeBridgeRequestScopesByPortlet(BridgeContext bridgeContext) {
        Map<String, BridgeRequestScope> bridgeRequestScopeCache;
        Set<Map.Entry<String, BridgeRequestScope>> mapEntries;
        String portletNameToRemove = bridgeContext.getPortletConfig().getPortletName();
        if (portletNameToRemove != null && (mapEntries = (bridgeRequestScopeCache = this.getBridgeRequestScopeCache(bridgeContext.getPortletContext())).entrySet()) != null) {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (Map.Entry<String, BridgeRequestScope> mapEntry : mapEntries) {
                BridgeRequestScope bridgeRequestScope = mapEntry.getValue();
                String bridgeRequestScopeId = bridgeRequestScope.getId();
                String portletName = bridgeRequestScopeId.split("[:][:][:]")[0];
                if (!portletNameToRemove.equals(portletName)) continue;
                keysToRemove.add(mapEntry.getKey());
            }
            for (String key : keysToRemove) {
                bridgeRequestScopeCache.remove(key);
            }
        }
    }

    @Override
    public void removeBridgeRequestScopesBySession(HttpSession httpSession) {
        String httpSessionId = httpSession.getId();
        ServletContext servletContext = httpSession.getServletContext();
        Enumeration attributeNames = servletContext.getAttributeNames();
        if (attributeNames != null) {
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                Object attributeValue = servletContext.getAttribute(attributeName);
                if (attributeValue == null || !(attributeValue instanceof Map)) continue;
                Map map = (Map)attributeValue;
                Set entrySet = null;
                try {
                    entrySet = map.entrySet();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (entrySet == null) continue;
                ArrayList keysToRemove = new ArrayList();
                Iterator i$ = entrySet.iterator();
                while (i$.hasNext()) {
                    BridgeRequestScope bridgeRequestScope;
                    String bridgeRequestScopeSessionId;
                    Map.Entry mapEntryAsObject;
                    Map.Entry mapEntry = mapEntryAsObject = i$.next();
                    Object key = mapEntry.getKey();
                    Object value = mapEntry.getValue();
                    if (value == null || !(value instanceof BridgeRequestScope) || !httpSessionId.equals(bridgeRequestScopeSessionId = (bridgeRequestScope = (BridgeRequestScope)value).getId().split("[:][:][:]")[1])) continue;
                    keysToRemove.add(key);
                }
                for (Map.Entry bridgeRequestScopeId : keysToRemove) {
                    Object bridgeRequestScope = map.remove(bridgeRequestScopeId);
                    logger.debug("Removed bridgeRequestScopeId=[{0}] bridgeRequestScope=[{1}] from cache due to session timeout", bridgeRequestScopeId, bridgeRequestScope);
                }
            }
        }
    }

    @Override
    public BridgeRequestScope getBridgeRequestScope(BridgeContext bridgeContext) {
        BridgeRequestScope bridgeRequestScope = null;
        PortletConfig portletConfig = bridgeContext.getPortletConfig();
        String portletName = portletConfig.getPortletName();
        String renderParameterName = portletName + RENDER_PARAM_BRIDGE_REQUEST_SCOPE_ID;
        PortletContext portletContext = bridgeContext.getPortletContext();
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        PortletResponse portletResponse = bridgeContext.getPortletResponse();
        String bridgeRequestScopeId = portletRequest.getParameter(renderParameterName);
        if (bridgeRequestScopeId != null && (bridgeRequestScope = this.getBridgeRequestScopeCache(portletContext).get(bridgeRequestScopeId)) != null) {
            Map supportedPublicRenderParametersMap = (Map)bridgeRequestScope.get(SUPPORTED_PUBLIC_RENDER_PARAMETERS_MAP);
            Enumeration supportedPublicRenderParameterNames = portletConfig.getPublicRenderParameterNames();
            if (supportedPublicRenderParametersMap != null && supportedPublicRenderParameterNames != null) {
                while (supportedPublicRenderParameterNames.hasMoreElements()) {
                    String name = (String)supportedPublicRenderParameterNames.nextElement();
                    String oldValue = (String)supportedPublicRenderParametersMap.get(name);
                    String newValue = portletRequest.getParameter(name);
                    if (!(oldValue == null && newValue != null || oldValue != null && newValue == null) && (oldValue == null || oldValue.equals(newValue))) continue;
                    logger.debug("Removed bridgeRequestScopeId=[{0}] bridgeRequestScope=[{1}] from cache due since public render parameter name=[{2}] changed from oldValue=[{3}] to newValue=[{4}]", bridgeRequestScopeId, bridgeRequestScope, name, oldValue, newValue);
                    this.getBridgeRequestScopeCache(portletContext).remove(bridgeRequestScopeId);
                    bridgeRequestScopeId = null;
                    bridgeRequestScope = null;
                    break;
                }
            }
        }
        if (bridgeRequestScopeId != null) {
            bridgeRequestScope = this.getBridgeRequestScopeCache(portletContext).get(bridgeRequestScopeId);
            logger.debug("Found render parameter name=[{0}] value=[{1}] and cached bridgeRequestScope=[{2}]", renderParameterName, bridgeRequestScopeId, bridgeRequestScope);
        }
        if (bridgeRequestScope == null) {
            logger.debug("No value found for render parameter name=[{0}]", renderParameterName);
            BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
            BridgeRequestScopeFactory bridgeRequestScopeFactory = (BridgeRequestScopeFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.scope.BridgeRequestScopeFactory");
            String sessionId = portletRequest.getPortletSession(true).getId();
            String idPrefix = portletName + ":::" + sessionId + ":::";
            bridgeRequestScope = bridgeRequestScopeFactory.getBridgeRequestScope(bridgeContext, idPrefix);
            bridgeRequestScopeId = bridgeRequestScope.getId();
            if (portletResponse instanceof StateAwareResponse) {
                logger.debug("Setting render parameter name=[{0}] value=[{1}]", renderParameterName, bridgeRequestScopeId);
                StateAwareResponse stateAwareResponse = (StateAwareResponse)portletResponse;
                stateAwareResponse.setRenderParameter(renderParameterName, bridgeRequestScopeId);
            }
            logger.debug("Caching bridgeRequestScopeId=[{0}] bridgeRequestScope=[{1}]", bridgeRequestScopeId, bridgeRequestScope);
            HashMap<String, String> supportedPublicRenderParametersMap = new HashMap<String, String>();
            Enumeration publicRenderParameterNames = portletConfig.getPublicRenderParameterNames();
            if (publicRenderParameterNames != null) {
                while (publicRenderParameterNames.hasMoreElements()) {
                    String name = (String)publicRenderParameterNames.nextElement();
                    String value = portletRequest.getParameter(name);
                    supportedPublicRenderParametersMap.put(name, value);
                }
            }
            bridgeRequestScope.put(SUPPORTED_PUBLIC_RENDER_PARAMETERS_MAP, supportedPublicRenderParametersMap);
            this.getBridgeRequestScopeCache(portletContext).put(bridgeRequestScopeId, bridgeRequestScope);
        }
        return bridgeRequestScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, BridgeRequestScope> getBridgeRequestScopeCache(PortletContext portletContext) {
        Map<String, BridgeRequestScope> bridgeRequestScopeCache = null;
        PortletContext portletContext2 = portletContext;
        synchronized (portletContext2) {
            bridgeRequestScopeCache = (Map<String, BridgeRequestScope>)portletContext.getAttribute(ATTR_BRIDGE_REQUEST_SCOPE_CACHE);
            if (bridgeRequestScopeCache == null) {
                int maxSize = 100;
                String maxManagedRequestScopes = portletContext.getInitParameter("javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES");
                if (maxManagedRequestScopes != null) {
                    try {
                        maxSize = Integer.parseInt(maxManagedRequestScopes);
                    }
                    catch (NumberFormatException e) {
                        logger.error("Unable to parse portlet.xml init-param name=[{0}] error=[{1}]", "javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES", e.getMessage());
                    }
                }
                bridgeRequestScopeCache = Collections.synchronizedMap(new BridgeRequestScopeCache(maxSize));
                portletContext.setAttribute(ATTR_BRIDGE_REQUEST_SCOPE_CACHE, bridgeRequestScopeCache);
            }
        }
        return bridgeRequestScopeCache;
    }
}

