/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.servlet;

import java.lang.reflect.Method;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import org.portletfaces.bridge.Bridge;
import org.portletfaces.bridge.BridgeFactoryFinder;
import org.portletfaces.bridge.annotation.BridgeRequestScopeAttributeAdded;
import org.portletfaces.bridge.config.BridgeConfig;
import org.portletfaces.bridge.config.BridgeConfigFactory;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class BridgeRequestAttributeListener
implements ServletRequestAttributeListener {
    private static final Logger logger = LoggerFactory.getLogger(BridgeRequestAttributeListener.class);

    public void attributeAdded(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        ServletRequest servletRequest = servletRequestAttributeEvent.getServletRequest();
        Bridge.PortletPhase phase = (Bridge.PortletPhase)((Object)servletRequest.getAttribute("org.portletfaces.bridge.portletLifecyclePhase"));
        if (phase != null && phase != Bridge.PortletPhase.RENDER_PHASE) {
            BridgeFactoryFinder bridgeFactoryFinder = BridgeFactoryFinder.getInstance();
            BridgeConfigFactory bridgeConfigFactory = (BridgeConfigFactory)bridgeFactoryFinder.getFactory("org.portletfaces.bridge.config.BridgeConfigFactory");
            BridgeConfig bridgeConfig = bridgeConfigFactory.getBridgeConfig();
            String attributeName = servletRequestAttributeEvent.getName();
            Set<String> excludedRequestScopeAttributes = bridgeConfig.getExcludedBridgeRequestScopeAttributes();
            if (!excludedRequestScopeAttributes.contains(attributeName)) {
                Method[] methods;
                Object attributeValue = servletRequestAttributeEvent.getValue();
                logger.trace("Attribute added name=[{0}] value=[{1}]", attributeName, attributeValue);
                if (attributeValue != null && (methods = attributeValue.getClass().getMethods()) != null) {
                    for (Method method : methods) {
                        if (method == null || !method.isAnnotationPresent(BridgeRequestScopeAttributeAdded.class)) continue;
                        try {
                            method.invoke(attributeValue, new Object[0]);
                        }
                        catch (Exception e) {
                            logger.error(e);
                        }
                    }
                }
            }
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        String attributeName = servletRequestAttributeEvent.getName();
        Object attributeValue = servletRequestAttributeEvent.getValue();
        logger.trace("Attribute removed name=[{0}] value=[{1}]", attributeName, attributeValue);
    }

    public void attributeReplaced(ServletRequestAttributeEvent servletRequestAttributeEvent) {
        String attributeName = servletRequestAttributeEvent.getName();
        Object attributeValue = servletRequestAttributeEvent.getValue();
        logger.trace("Attribute replaced name=[{0}] value=[{1}]", attributeName, attributeValue);
    }
}

