/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.bridge.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.faces.bean.ManagedBean;
import org.portletfaces.bridge.annotation.BridgePreDestroy;
import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerFactory;

public class ManagedBeanUtil {
    private static final String JAVAX_ANNOTATION_PRE_DESTROY = "javax.annotation.PreDestroy";
    private static final String JAVAX_ANNOTATION_BRIDGE_PRE_DESTROY = BridgePreDestroy.class.getName();
    private static final Logger logger = LoggerFactory.getLogger(ManagedBeanUtil.class);

    public static boolean hasBridgePreDestroyAnnotation(Method method) {
        Annotation[] annotations;
        Class<?>[] parameterTypes;
        if (method.getReturnType() == Void.TYPE && ((parameterTypes = method.getParameterTypes()) == null || parameterTypes.length == 0) && (annotations = method.getAnnotations()) != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().getName().equals(JAVAX_ANNOTATION_BRIDGE_PRE_DESTROY)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasManagedBeanAnnotation(Object object) {
        return object != null && object.getClass().getAnnotation(ManagedBean.class) != null;
    }

    public static boolean hasPreDestroyAnnotation(Method method) {
        Annotation[] annotations;
        Class<?>[] parameterTypes;
        if (method.getReturnType() == Void.TYPE && ((parameterTypes = method.getParameterTypes()) == null || parameterTypes.length == 0) && (annotations = method.getAnnotations()) != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().getName().equals(JAVAX_ANNOTATION_PRE_DESTROY)) continue;
                return true;
            }
        }
        return false;
    }

    public static void invokePreDestroyMethods(Object managedBean, boolean preferPreDestroy) {
        if (managedBean != null) {
            Class<?> clazz = managedBean.getClass();
            Method[] methods = managedBean.getClass().getMethods();
            if (methods != null) {
                for (Method method : methods) {
                    if (preferPreDestroy) {
                        if (!ManagedBeanUtil.hasPreDestroyAnnotation(method)) continue;
                        try {
                            logger.debug("Invoking @PreDestroy method named [{0}] on managedBean class=[{1}]", method.getName(), clazz.getName());
                            method.invoke(managedBean, new Object[0]);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), e);
                        }
                        continue;
                    }
                    if (!ManagedBeanUtil.hasBridgePreDestroyAnnotation(method)) continue;
                    try {
                        logger.debug("Invoking @BridgePreDestroy method named [{0}] on managedBean class=[{1}]", method.getName(), clazz.getName());
                        method.invoke(managedBean, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            }
        }
    }
}

