/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.logging;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import org.portletfaces.logging.Logger;

public class LoggerDefaultImpl
implements Logger {
    private java.util.logging.Logger logger;

    public LoggerDefaultImpl() {
    }

    public LoggerDefaultImpl(String className) {
        this.logger = java.util.logging.Logger.getLogger(className);
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Object ... arguments) {
        if (this.isDebugEnabled()) {
            Throwable throwable = this.getThrowable(arguments);
            if (throwable == null) {
                this.logger.log(Level.FINE, this.formatMessage(message, arguments));
            } else {
                this.logger.log(Level.FINE, this.formatMessage(message, arguments), throwable);
            }
        }
    }

    public void error(Throwable throwable) {
        this.error(throwable.getMessage(), throwable);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Object ... arguments) {
        if (this.isErrorEnabled()) {
            Throwable throwable = this.getThrowable(arguments);
            if (throwable == null) {
                this.logger.log(Level.SEVERE, this.formatMessage(message, arguments));
            } else {
                this.logger.log(Level.SEVERE, this.formatMessage(message, arguments), throwable);
            }
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Object ... arguments) {
        if (this.isInfoEnabled()) {
            Throwable throwable = this.getThrowable(arguments);
            if (throwable == null) {
                this.logger.log(Level.INFO, this.formatMessage(message, arguments));
            } else {
                this.logger.log(Level.INFO, this.formatMessage(message, arguments), throwable);
            }
        }
    }

    public void trace(String message) {
        this.trace(message, null);
    }

    public void trace(String message, Object ... arguments) {
        if (this.isTraceEnabled()) {
            Throwable throwable = this.getThrowable(arguments);
            if (throwable == null) {
                this.logger.log(Level.FINEST, this.formatMessage(message, arguments));
            } else {
                this.logger.log(Level.FINEST, this.formatMessage(message, arguments), throwable);
            }
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Object ... arguments) {
        if (this.isWarnEnabled()) {
            Throwable throwable = this.getThrowable(arguments);
            if (throwable == null) {
                this.logger.log(Level.WARNING, this.formatMessage(message, arguments));
            } else {
                this.logger.log(Level.WARNING, this.formatMessage(message, arguments), throwable);
            }
        }
    }

    protected String formatMessage(String message, Object[] arguments) {
        if (message == null || arguments == null || arguments.length == 0) {
            return message;
        }
        ArrayList<Object> argumentList = new ArrayList<Object>();
        for (Object argument : arguments) {
            if (argument == null || argument instanceof Exception) {
                argumentList.add(null);
                continue;
            }
            if (argument.getClass().isArray()) {
                Object[] argArray = (Object[])argument;
                StringBuilder arrayAsString = new StringBuilder("L[");
                boolean firstArg = true;
                for (Object arg : argArray) {
                    if (firstArg) {
                        firstArg = false;
                    } else {
                        arrayAsString.append(", ");
                    }
                    arrayAsString.append(arg);
                }
                arrayAsString.append("]");
                argumentList.add(arrayAsString.toString());
                continue;
            }
            argumentList.add(argument);
        }
        String formattedMessage = message;
        try {
            formattedMessage = MessageFormat.format(message, argumentList.toArray(new Object[0]));
        }
        catch (IllegalArgumentException e) {
            System.err.println("ERROR " + e.getClass() + ": " + e.getMessage() + ": " + message);
        }
        return formattedMessage;
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    protected Throwable getThrowable(Object[] arguments) {
        Throwable throwable = null;
        if (arguments != null) {
            for (Object arg : arguments) {
                if (arg == null || !(arg instanceof Throwable)) continue;
                throwable = (Throwable)arg;
                break;
            }
        }
        return throwable;
    }
}

