/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.logging;

import org.portletfaces.logging.Logger;
import org.portletfaces.logging.LoggerDefaultImpl;
import org.portletfaces.logging.LoggerLog4JImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerFactory {
    private static final String CLASS_NAME_LOG4J_LOGGER = "org.apache.log4j.Logger";
    private static boolean LOG4J_AVAILABLE = false;

    public static final Logger getLogger(Class<?> clazz) {
        String className = clazz.getName();
        LoggerDefaultImpl logger = null;
        try {
            if (LOG4J_AVAILABLE) {
                logger = new LoggerLog4JImpl(className);
            }
        }
        catch (NoClassDefFoundError e) {
            System.err.println("org.portletfaces.logging.LoggerFactory (WARN): Possibly an incompatible version of log4j.jar in the classpath: " + e.getMessage());
        }
        if (logger == null) {
            logger = new LoggerDefaultImpl(className);
        }
        return logger;
    }

    static {
        try {
            Class.forName(CLASS_NAME_LOG4J_LOGGER);
            LOG4J_AVAILABLE = true;
        }
        catch (Exception e) {
            LOG4J_AVAILABLE = false;
        }
    }
}

