/*
 * Decompiled with CFR 0.152.
 */
package org.portletfaces.logging;

import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.portletfaces.logging.LoggerDefaultImpl;

public class LoggerLog4JImpl
extends LoggerDefaultImpl {
    private static final String CALLING_CLASS_FQCN = LoggerLog4JImpl.class.getName();
    private Logger logger;
    private Boolean traceSupported;

    public LoggerLog4JImpl(String className) {
        try {
            StackTraceElement[] stackTraceElements;
            boolean webappContextStopping = false;
            for (StackTraceElement stackTraceElement : stackTraceElements = Thread.currentThread().getStackTrace()) {
                if (!stackTraceElement.getClassName().equals("org.apache.catalina.core.StandardContext") || !stackTraceElement.getMethodName().equals("stop")) continue;
                webappContextStopping = true;
            }
            if (!webappContextStopping) {
                this.logger = LogManager.getLogger((String)className);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void debug(String message, Object ... arguments) {
        if (this.isDebugEnabled()) {
            try {
                this.logger.log(CALLING_CLASS_FQCN, (Priority)Level.DEBUG, (Object)this.formatMessage(message, arguments), this.getThrowable(arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void error(String message, Object ... arguments) {
        if (this.isErrorEnabled()) {
            try {
                this.logger.log(CALLING_CLASS_FQCN, (Priority)Level.ERROR, (Object)this.formatMessage(message, arguments), this.getThrowable(arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void info(String message, Object ... arguments) {
        if (this.isInfoEnabled()) {
            try {
                this.logger.log(CALLING_CLASS_FQCN, (Priority)Level.INFO, (Object)this.formatMessage(message, arguments), this.getThrowable(arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void trace(String message, Object ... arguments) {
        if (this.isTraceSupported()) {
            if (this.isTraceEnabled()) {
                try {
                    this.logger.log(CALLING_CLASS_FQCN, (Priority)Level.TRACE, (Object)this.formatMessage(message, arguments), this.getThrowable(arguments));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.debug(message, arguments);
        }
    }

    public void warn(String message, Object ... arguments) {
        if (this.isWarnEnabled()) {
            try {
                this.logger.log(CALLING_CLASS_FQCN, (Priority)Level.WARN, (Object)this.formatMessage(message, arguments), this.getThrowable(arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    protected boolean isTraceSupported() {
        if (this.traceSupported == null) {
            try {
                this.isTraceEnabled();
                this.traceSupported = Boolean.TRUE;
            }
            catch (NoSuchMethodError e) {
                this.traceSupported = Boolean.FALSE;
            }
        }
        return this.traceSupported;
    }
}

