/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.manchesterowlsyntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntax;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyHeader;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxTokenizer;
import org.coode.owlapi.manchesterowlsyntax.OntologyAxiomPair;
import org.semanticweb.owlapi.expression.OWLEntityChecker;
import org.semanticweb.owlapi.expression.OWLOntologyChecker;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManchesterOWLSyntaxEditorParser {
    private OWLDataFactory dataFactory;
    private List<ManchesterOWLSyntaxTokenizer.Token> tokens;
    private int tokenIndex;
    private OWLEntityChecker owlEntityChecker;
    private OWLOntologyChecker owlOntologyChecker = new OWLOntologyChecker(){

        public OWLOntology getOntology(String name) {
            return null;
        }
    };
    private String base;
    private Set<String> classNames;
    private Set<String> objectPropertyNames;
    private Set<String> dataPropertyNames;
    private Set<String> individualNames;
    private Set<String> dataTypeNames;
    private Set<String> annotationPropertyNames;
    private Map<String, SWRLBuiltInsVocabulary> ruleBuiltIns = new TreeMap<String, SWRLBuiltInsVocabulary>();
    private DefaultPrefixManager pm = new DefaultPrefixManager();
    public static final String AND = ManchesterOWLSyntax.AND.toString();
    public static final String OR = ManchesterOWLSyntax.OR.toString();
    public static final String INVERSE = ManchesterOWLSyntax.INVERSE.toString();
    public static final String SOME = ManchesterOWLSyntax.SOME.toString();
    public static final String SELF = ManchesterOWLSyntax.SELF.toString();
    public static final String ONLY = ManchesterOWLSyntax.ONLY.toString();
    public static final String VALUE = ManchesterOWLSyntax.VALUE.toString();
    public static final String MIN = ManchesterOWLSyntax.MIN.toString();
    public static final String MAX = ManchesterOWLSyntax.MAX.toString();
    public static final String EXACTLY = ManchesterOWLSyntax.EXACTLY.toString();
    public static final String ONLYSOME = ManchesterOWLSyntax.ONLYSOME.toString();
    public static final String NOT = ManchesterOWLSyntax.NOT.toString();
    public static final String CLASS = ManchesterOWLSyntax.CLASS.toString() + ":";
    public static final String DATATYPE = ManchesterOWLSyntax.DATATYPE.toString() + ":";
    public static final String SUB_CLASS_OF = ManchesterOWLSyntax.SUBCLASS_OF.toString() + ":";
    public static final String SUPER_CLASS_OF = ManchesterOWLSyntax.SUPERCLASS_OF.toString() + ":";
    public static final String INSTANCES = "Instances:";
    public static final String EQUIVALENT_TO = ManchesterOWLSyntax.EQUIVALENT_TO.toString() + ":";
    public static final String EQUIVALENT_CLASSES = ManchesterOWLSyntax.EQUIVALENT_CLASSES.toString() + ":";
    public static final String EQUIVALENT_PROPERTIES = ManchesterOWLSyntax.EQUIVALENT_PROPERTIES.toString() + ":";
    public static final String DISJOINT_WITH = ManchesterOWLSyntax.DISJOINT_WITH.toString() + ":";
    public static final String DISJOINT_UNION_OF = ManchesterOWLSyntax.DISJOINT_UNION_OF.toString() + ":";
    public static final String HAS_KEY = ManchesterOWLSyntax.HAS_KEY.toString() + ":";
    public static final String DISJOINT_CLASSES = ManchesterOWLSyntax.DISJOINT_CLASSES.toString() + ":";
    public static final String DISJOINT_PROPERTIES = ManchesterOWLSyntax.DISJOINT_PROPERTIES.toString() + ":";
    public static final String OBJECT_PROPERTY = ManchesterOWLSyntax.OBJECT_PROPERTY.toString() + ":";
    public static final String DATA_PROPERTY = ManchesterOWLSyntax.DATA_PROPERTY.toString() + ":";
    public static final String ANNOTATION_PROPERTY = ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString() + ":";
    public static final String SUB_PROPERTY_OF = ManchesterOWLSyntax.SUB_PROPERTY_OF.toString() + ":";
    public static final String SUPER_PROPERTY_OF = ManchesterOWLSyntax.SUPER_PROPERTY_OF.toString() + ":";
    public static final String DOMAIN = ManchesterOWLSyntax.DOMAIN.toString() + ":";
    public static final String RANGE = ManchesterOWLSyntax.RANGE.toString() + ":";
    public static final String INVERSES = ManchesterOWLSyntax.INVERSES.toString() + ":";
    public static final String CHARACTERISTICS = ManchesterOWLSyntax.CHARACTERISTICS.toString() + ":";
    public static final String INDIVIDUAL = ManchesterOWLSyntax.INDIVIDUAL.toString() + ":";
    public static final String INDIVIDUALS = ManchesterOWLSyntax.INDIVIDUALS.toString() + ":";
    public static final String ANNOTATIONS = ManchesterOWLSyntax.ANNOTATIONS.toString() + ":";
    public static final String TYPES = ManchesterOWLSyntax.TYPES.toString() + ":";
    public static final String FACTS = ManchesterOWLSyntax.FACTS.toString() + ":";
    public static final String SAME_AS = ManchesterOWLSyntax.SAME_AS.toString() + ":";
    public static final String SAME_INDIVIDUAL = ManchesterOWLSyntax.SAME_INDIVIDUAL.toString() + ":";
    public static final String DIFFERENT_FROM = ManchesterOWLSyntax.DIFFERENT_FROM.toString() + ":";
    public static final String DIFFERENT_INDIVIDUALS = ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.toString() + ":";
    public static final String VALUE_PARTITION = "ValuePartition:";
    public static final String ONTOLOGY = ManchesterOWLSyntax.ONTOLOGY.toString() + ":";
    public static final String PREFIX = ManchesterOWLSyntax.PREFIX.toString() + ":";
    public static final String IMPORT = ManchesterOWLSyntax.IMPORT.toString() + ":";
    public static final String SUB_PROPERTY_CHAIN = ManchesterOWLSyntax.SUB_PROPERTY_CHAIN.toString() + ":";
    public static final String FUNCTIONAL = ManchesterOWLSyntax.FUNCTIONAL.toString();
    public static final String INVERSE_FUNCTIONAL = ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString();
    public static final String SYMMETRIC = ManchesterOWLSyntax.SYMMETRIC.toString();
    public static final String ANTI_SYMMETRIC = ManchesterOWLSyntax.ANTI_SYMMETRIC.toString();
    public static final String ASYMMETRIC = ManchesterOWLSyntax.ASYMMETRIC.toString();
    public static final String TRANSITIVE = ManchesterOWLSyntax.TRANSITIVE.toString();
    public static final String REFLEXIVE = ManchesterOWLSyntax.REFLEXIVE.toString();
    public static final String IRREFLEXIVE = ManchesterOWLSyntax.IRREFLEXIVE.toString();
    public static final String INVERSE_OF = (Object)((Object)ManchesterOWLSyntax.INVERSE_OF) + ":";
    public static final String RULE = (Object)((Object)ManchesterOWLSyntax.RULE) + ":";
    private Set<String> potentialKeywords;
    private OWLOntology defaultOntology = null;
    private boolean allowEmptyFrameSections = true;
    private static Set<String> classFrameSections = new HashSet<String>();
    private static Set<String> objectPropertyFrameSections;
    private static Set<String> dataPropertyFrameSections;
    private static Set<String> individualFrameSections;
    private Map<String, IRI> nameIRIMap = new HashMap<String, IRI>();

    public ManchesterOWLSyntaxEditorParser(OWLDataFactory dataFactory, String s) {
        this.dataFactory = dataFactory;
        this.potentialKeywords = new HashSet<String>();
        this.classNames = new HashSet<String>();
        this.objectPropertyNames = new HashSet<String>();
        this.dataPropertyNames = new HashSet<String>();
        this.individualNames = new HashSet<String>();
        this.dataTypeNames = new HashSet<String>();
        this.annotationPropertyNames = new HashSet<String>();
        this.pm.setPrefix("rdf:", Namespaces.RDF.toString());
        this.pm.setPrefix("rdfs:", Namespaces.RDFS.toString());
        this.pm.setPrefix("owl:", Namespaces.OWL.toString());
        this.pm.setPrefix("dc:", "http://purl.org/dc/elements/1.1/");
        NamespaceUtil u = new NamespaceUtil();
        for (XSDVocabulary xSDVocabulary : XSDVocabulary.values()) {
            this.dataTypeNames.add(xSDVocabulary.getIRI().getFragment());
            this.dataTypeNames.add("xsd:" + xSDVocabulary.getIRI().getFragment());
        }
        this.dataTypeNames.add(OWLRDFVocabulary.RDF_XML_LITERAL.getIRI().getFragment());
        this.dataTypeNames.add("rdf:" + OWLRDFVocabulary.RDF_XML_LITERAL.getIRI().getFragment());
        this.dataTypeNames.add(dataFactory.getTopDatatype().getIRI().getFragment());
        for (IRI iri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            String[] res = u.split(iri.toString(), null);
            this.annotationPropertyNames.add(u.getPrefix(res[0]) + ":" + res[1]);
        }
        for (Enum enum_ : DublinCoreVocabulary.values()) {
            this.annotationPropertyNames.add(((DublinCoreVocabulary)enum_).getQName());
        }
        this.base = "http://www.semanticweb.org#";
        this.owlEntityChecker = new DefaultEntityChecker();
        this.tokens = new ArrayList<ManchesterOWLSyntaxTokenizer.Token>();
        this.tokens.addAll(this.getTokenizer(s).tokenize());
        this.tokenIndex = 0;
        for (Enum enum_ : SWRLBuiltInsVocabulary.values()) {
            this.ruleBuiltIns.put(((SWRLBuiltInsVocabulary)enum_).getShortName(), (SWRLBuiltInsVocabulary)enum_);
            this.ruleBuiltIns.put(((SWRLBuiltInsVocabulary)enum_).getIRI().toQuotedString(), (SWRLBuiltInsVocabulary)enum_);
        }
    }

    protected ManchesterOWLSyntaxTokenizer getTokenizer(String s) {
        return new ManchesterOWLSyntaxTokenizer(s);
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    protected List<ManchesterOWLSyntaxTokenizer.Token> getTokens() {
        return this.tokens;
    }

    protected void reset() {
        this.tokenIndex = 0;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public OWLEntityChecker getOWLEntityChecker() {
        return this.owlEntityChecker;
    }

    public void setOWLEntityChecker(OWLEntityChecker owlEntityChecker) {
        this.owlEntityChecker = owlEntityChecker;
    }

    public boolean isOntologyName(String name) {
        return this.owlOntologyChecker.getOntology(name) != null;
    }

    public boolean isClassName(String name) {
        return this.classNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLClass(name) != null;
    }

    public OWLOntology getOntology(String name) {
        return this.owlOntologyChecker.getOntology(name);
    }

    public void setOWLOntologyChecker(OWLOntologyChecker owlOntologyChecker) {
        this.owlOntologyChecker = owlOntologyChecker;
    }

    public boolean isObjectPropertyName(String name) {
        return this.objectPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLObjectProperty(name) != null;
    }

    public boolean isAnnotationPropertyName(String name) {
        return this.annotationPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLAnnotationProperty(name) != null;
    }

    public boolean isDataPropertyName(String name) {
        return this.dataPropertyNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLDataProperty(name) != null;
    }

    public boolean isIndividualName(String name) {
        return this.individualNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLIndividual(name) != null;
    }

    public boolean isDatatypeName(String name) {
        return this.dataTypeNames.contains(name) || this.owlEntityChecker != null && this.owlEntityChecker.getOWLDatatype(name) != null;
    }

    public boolean isSWRLBuiltin(String name) {
        return this.ruleBuiltIns.containsKey(name);
    }

    public OWLClass getOWLClass(String name) {
        OWLClass cls = this.owlEntityChecker.getOWLClass(name);
        if (cls == null && this.classNames.contains(name)) {
            cls = this.getDataFactory().getOWLClass(this.getIRI(name));
        }
        return cls;
    }

    public OWLObjectProperty getOWLObjectProperty(String name) {
        OWLObjectProperty prop = this.owlEntityChecker.getOWLObjectProperty(name);
        if (prop == null && this.objectPropertyNames.contains(name)) {
            prop = this.getDataFactory().getOWLObjectProperty(this.getIRI(name));
        }
        return prop;
    }

    public OWLIndividual getOWLIndividual(String name) {
        if (name.startsWith("_:")) {
            return this.dataFactory.getOWLAnonymousIndividual(name);
        }
        return this.getOWLNamedIndividual(name);
    }

    private OWLNamedIndividual getOWLNamedIndividual(String name) {
        OWLNamedIndividual ind = this.owlEntityChecker.getOWLIndividual(name);
        if (ind == null && this.individualNames.contains(name)) {
            ind = this.getDataFactory().getOWLNamedIndividual(this.getIRI(name));
        }
        return ind;
    }

    public OWLDataProperty getOWLDataProperty(String name) {
        OWLDataProperty prop = this.owlEntityChecker.getOWLDataProperty(name);
        if (prop == null && this.dataPropertyNames.contains(name)) {
            prop = this.getDataFactory().getOWLDataProperty(this.getIRI(name));
        }
        return prop;
    }

    public OWLDatatype getOWLDatatype(String name) {
        OWLDatatype dt = this.owlEntityChecker.getOWLDatatype(name);
        if (dt == null && this.dataTypeNames.contains(name)) {
            dt = this.getDataFactory().getOWLDatatype(this.getIRI(name));
        }
        return dt;
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
        OWLAnnotationProperty prop = this.owlEntityChecker.getOWLAnnotationProperty(name);
        if (prop == null && this.annotationPropertyNames.contains(name)) {
            prop = this.getDataFactory().getOWLAnnotationProperty(this.getIRI(name));
        }
        return prop;
    }

    protected ManchesterOWLSyntaxTokenizer.Token getLastToken() {
        if (this.tokenIndex - 1 > -1) {
            return this.tokens.get(this.tokenIndex - 1);
        }
        return this.tokens.get(0);
    }

    protected String peekToken() {
        return this.getToken().getToken();
    }

    protected String consumeToken() {
        String token = this.getToken().getToken();
        ++this.tokenIndex;
        return token;
    }

    protected void consumeToken(String expected) throws ParserException {
        String tok = this.consumeToken();
        if (!tok.equals(expected)) {
            throw this.createException(expected);
        }
    }

    public ManchesterOWLSyntaxTokenizer.Token getToken() {
        return this.tokens.get(this.tokenIndex < this.tokens.size() ? this.tokenIndex : this.tokenIndex - 1);
    }

    public int getTokenPos() {
        return this.getToken().getPos();
    }

    public int getTokenCol() {
        return this.getToken().getCol();
    }

    public int getTokenRow() {
        return this.getToken().getRow();
    }

    public OWLClassExpression parseClassExpression() throws ParserException {
        OWLClassExpression desc = this.parseIntersection();
        if (!this.consumeToken().equals("<EOF>")) {
            throw this.createException("<EOF>");
        }
        return desc;
    }

    public OWLClassExpression parseIntersection() throws ParserException {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = AND;
        while (kw.equalsIgnoreCase(AND)) {
            this.potentialKeywords.remove(AND);
            ops.add(this.parseUnion());
            this.potentialKeywords.add(AND);
            kw = this.peekToken();
            if (kw.equalsIgnoreCase(AND)) {
                kw = this.consumeToken();
                continue;
            }
            if (!kw.equalsIgnoreCase("that")) continue;
            this.consumeToken();
            kw = AND;
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    public OWLClassExpression parseUnion() throws ParserException {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        String kw = OR;
        while (kw.equalsIgnoreCase(OR)) {
            this.potentialKeywords.remove(OR);
            ops.add(this.parseNonNaryClassExpression());
            this.potentialKeywords.add(OR);
            kw = this.peekToken();
            if (!kw.equalsIgnoreCase(OR)) continue;
            kw = this.consumeToken();
        }
        if (ops.size() == 1) {
            return (OWLClassExpression)ops.iterator().next();
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    public OWLObjectPropertyExpression parseObjectPropertyExpression(boolean allowUndeclared) throws ParserException {
        String tok = this.consumeToken();
        if (tok.equalsIgnoreCase(INVERSE)) {
            String close;
            String open = this.peekToken();
            boolean brackets = false;
            if (open.equals("(")) {
                this.consumeToken();
                brackets = true;
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            if (brackets && !(close = this.consumeToken()).equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLObjectInverseOf(prop);
        }
        if (!allowUndeclared && !this.isObjectPropertyName(tok)) {
            throw this.createException(false, true, false, false, false, false, INVERSE);
        }
        return this.getOWLObjectProperty(tok);
    }

    public OWLObjectPropertyExpression parseObjectPropertyExpression() throws ParserException {
        return this.parseObjectPropertyExpression(false);
    }

    public OWLPropertyExpression parsePropertyExpression() throws ParserException {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok)) {
            return this.parseObjectPropertyExpression();
        }
        if (tok.equalsIgnoreCase(INVERSE)) {
            return this.parseObjectPropertyExpression();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataProperty();
        }
        this.consumeToken();
        throw this.createException(false, true, true, false, false, false, INVERSE);
    }

    public OWLClassExpression parseRestriction() throws ParserException {
        String tok = this.peekToken();
        if (this.isObjectPropertyName(tok) || tok.equalsIgnoreCase(INVERSE)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        this.consumeToken();
        throw this.createException(false, true, true, false);
    }

    public OWLClassExpression parseNonNaryClassExpression() throws ParserException {
        String tok = this.peekToken();
        if (tok.equalsIgnoreCase(NOT)) {
            this.consumeToken();
            OWLClassExpression complemented = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectComplementOf(complemented);
        }
        if (this.isObjectPropertyName(tok) || tok.equalsIgnoreCase(INVERSE)) {
            return this.parseObjectRestriction();
        }
        if (this.isDataPropertyName(tok)) {
            return this.parseDataRestriction();
        }
        if (tok.equals("{")) {
            return this.parseObjectOneOf();
        }
        if (tok.equals("(")) {
            return this.parseNestedClassExpression(false);
        }
        if (this.isClassName(tok)) {
            this.consumeToken();
            return this.getOWLClass(tok);
        }
        this.consumeToken();
        throw this.createException(true, true, true, false, false, false, "(", "{", NOT, INVERSE);
    }

    public OWLClassExpression parseObjectRestriction() throws ParserException {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            String possSelfToken = this.peekToken();
            if (possSelfToken.equalsIgnoreCase(SELF)) {
                this.consumeToken();
                return this.dataFactory.getOWLObjectHasSelf(prop);
            }
            OWLClassExpression filler = null;
            try {
                filler = this.parseNestedClassExpression(false);
            }
            catch (ParserException e) {
                HashSet<String> keywords = new HashSet<String>();
                keywords.addAll(e.getExpectedKeywords());
                keywords.add(SELF);
                throw this.createException(e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), e.isIndividualNameExpected(), e.isDatatypeNameExpected(), e.isAnnotationPropertyNameExpected(), keywords.toArray(new String[keywords.size()]));
            }
            return this.dataFactory.getOWLObjectSomeValuesFrom(prop, filler);
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLClassExpression filler = this.parseNestedClassExpression(false);
            return this.dataFactory.getOWLObjectAllValuesFrom(prop, filler);
        }
        if (kw.equalsIgnoreCase(VALUE)) {
            String indName = this.consumeToken();
            if (!this.isIndividualName(indName)) {
                throw this.createException(false, false, false, true);
            }
            return this.dataFactory.getOWLObjectHasValue(prop, this.getOWLIndividual(indName));
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectMinCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectMinCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectMaxCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectMaxCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int card = this.parseInteger();
            OWLClassExpression filler = this.parseNestedClassExpression(true);
            if (filler != null) {
                return this.dataFactory.getOWLObjectExactCardinality(card, prop, filler);
            }
            return this.dataFactory.getOWLObjectExactCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(ONLYSOME)) {
            String tok = this.peekToken();
            HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
            if (!tok.equals("[")) {
                descs.add(this.parseIntersection());
            } else {
                descs.addAll(this.parseClassExpressionList("[", "]"));
            }
            HashSet<OWLQuantifiedObjectRestriction> ops = new HashSet<OWLQuantifiedObjectRestriction>();
            for (OWLClassExpression desc : descs) {
                ops.add(this.dataFactory.getOWLObjectSomeValuesFrom(prop, desc));
            }
            OWLClassExpression filler = descs.size() == 1 ? (OWLClassExpression)descs.iterator().next() : this.dataFactory.getOWLObjectUnionOf(descs);
            ops.add(this.dataFactory.getOWLObjectAllValuesFrom(prop, filler));
            return this.dataFactory.getOWLObjectIntersectionOf(ops);
        }
        if (kw.equalsIgnoreCase(SELF)) {
            return this.dataFactory.getOWLObjectHasSelf(prop);
        }
        throw this.createException(SOME, ONLY, VALUE, MIN, MAX, EXACTLY, SELF);
    }

    public OWLClassExpression parseDataRestriction() throws ParserException {
        OWLDataProperty prop = this.parseDataProperty();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataSomeValuesFrom(prop, rng);
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLDataRange rng = this.parseDataRange();
            return this.dataFactory.getOWLDataAllValuesFrom(prop, rng);
        }
        if (kw.equalsIgnoreCase(VALUE)) {
            OWLLiteral con = this.parseConstant();
            return this.dataFactory.getOWLDataHasValue(prop, con);
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataMinCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataMinCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataExactCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataExactCardinality(card, prop);
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int card = this.parseInteger();
            OWLDataRange rng = this.parseDataRange();
            if (rng != null) {
                return this.dataFactory.getOWLDataMaxCardinality(card, prop, rng);
            }
            return this.dataFactory.getOWLDataMaxCardinality(card, prop);
        }
        throw this.createException(SOME, ONLY, VALUE, MIN, EXACTLY, MAX);
    }

    public OWLFacet parseFacet() throws ParserException {
        String facet = this.consumeToken();
        if (facet.equals(">")) {
            if (this.peekToken().equals("=")) {
                this.consumeToken();
                return OWLFacet.MIN_INCLUSIVE;
            }
            return OWLFacet.MIN_EXCLUSIVE;
        }
        if (facet.equals("<")) {
            if (this.peekToken().equals("=")) {
                this.consumeToken();
                return OWLFacet.MAX_INCLUSIVE;
            }
            return OWLFacet.MAX_EXCLUSIVE;
        }
        return OWLFacet.getFacetBySymbolicName(facet);
    }

    public OWLDatatype parseDatatype() throws ParserException {
        String name = this.consumeToken();
        return this.getOWLDatatype(name);
    }

    public OWLDataRange parseDataRange() throws ParserException {
        return this.parseDataIntersectionOf();
    }

    public OWLDataRange parseDataIntersectionOf() throws ParserException {
        String sep = AND;
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (sep.equals(AND)) {
            ranges.add(this.parseDataUnionOf());
            sep = this.peekToken();
            if (!sep.equals(AND)) continue;
            this.consumeToken();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.getDataFactory().getOWLDataIntersectionOf(ranges);
    }

    public OWLDataRange parseDataUnionOf() throws ParserException {
        String sep = OR;
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (sep.equals(OR)) {
            ranges.add(this.parseDataRangePrimary());
            sep = this.peekToken();
            if (!sep.equals(OR)) continue;
            this.consumeToken();
        }
        if (ranges.size() == 1) {
            return (OWLDataRange)ranges.iterator().next();
        }
        return this.getDataFactory().getOWLDataUnionOf(ranges);
    }

    private OWLDataRange parseDataRangePrimary() throws ParserException {
        String tok = this.peekToken();
        if (this.isDatatypeName(tok)) {
            this.consumeToken();
            OWLDatatype datatype = this.getOWLDatatype(tok);
            String next = this.peekToken();
            if (next.equals("[")) {
                this.consumeToken();
                String sep = ",";
                HashSet<OWLFacetRestriction> facetRestrictions = new HashSet<OWLFacetRestriction>();
                while (sep.equals(",")) {
                    OWLFacet fv = this.parseFacet();
                    if (fv == null) {
                        throw this.createException(OWLFacet.getFacets().toArray(new String[OWLFacet.getFacetIRIs().size()]));
                    }
                    OWLLiteral con = this.parseConstant();
                    if (!con.isRDFPlainLiteral()) {
                        con = this.dataFactory.getOWLLiteral(con.getLiteral());
                    }
                    facetRestrictions.add(this.dataFactory.getOWLFacetRestriction(fv, con));
                    sep = this.consumeToken();
                }
                if (!sep.equals("]")) {
                    throw this.createException("]");
                }
                return this.dataFactory.getOWLDatatypeRestriction(datatype, facetRestrictions);
            }
            return datatype;
        }
        if (tok.equalsIgnoreCase(NOT)) {
            return this.parseDataComplementOf();
        }
        if (tok.equals("{")) {
            return this.parseDataOneOf();
        }
        if (tok.equals("(")) {
            this.consumeToken();
            OWLDataRange rng = this.parseDataRange();
            this.consumeToken(")");
            return rng;
        }
        if (!tok.equals("<EOF>")) {
            this.consumeToken();
            throw this.createException(false, false, false, false, true, false, NOT, "{");
        }
        return null;
    }

    public Set<OWLDataRange> parseDataRangeList() throws ParserException {
        String sep = ",";
        HashSet<OWLDataRange> ranges = new HashSet<OWLDataRange>();
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            OWLDataRange rng = this.parseDataRange();
            ranges.add(rng);
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return ranges;
    }

    private OWLDataRange parseDataOneOf() throws ParserException {
        this.consumeToken();
        HashSet<OWLLiteral> cons = new HashSet<OWLLiteral>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLLiteral con = this.parseConstant();
            cons.add(con);
            sep = this.consumeToken();
        }
        if (!sep.equals("}")) {
            throw this.createException(",", "}");
        }
        return this.dataFactory.getOWLDataOneOf(cons);
    }

    private OWLDataRange parseDataComplementOf() throws ParserException {
        String not = this.consumeToken();
        if (!not.equalsIgnoreCase(NOT)) {
            throw this.createException(NOT);
        }
        OWLDataRange complementedDataRange = this.parseDataRangePrimary();
        return this.dataFactory.getOWLDataComplementOf(complementedDataRange);
    }

    public OWLLiteral parseConstant() throws ParserException {
        String tok = this.consumeToken();
        if (tok.startsWith("\"")) {
            String lit = "";
            if (tok.length() > 2) {
                lit = tok.substring(1, tok.length() - 1).trim();
            }
            if (this.peekToken().equals("^")) {
                this.consumeToken();
                if (!this.peekToken().equals("^")) {
                    throw this.createException("^");
                }
                this.consumeToken();
                return this.dataFactory.getOWLLiteral(lit, this.parseDatatype());
            }
            if (this.peekToken().startsWith("@")) {
                String lang = this.consumeToken().substring(1);
                return this.dataFactory.getOWLLiteral(lit, lang);
            }
            return this.dataFactory.getOWLLiteral(lit);
        }
        try {
            int i = Integer.parseInt(tok);
            return this.dataFactory.getOWLLiteral(i);
        }
        catch (NumberFormatException e) {
            if (tok.endsWith("f")) {
                try {
                    float f = Float.parseFloat(tok);
                    return this.dataFactory.getOWLLiteral(f);
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                }
            }
            try {
                double d = Double.parseDouble(tok);
                return this.dataFactory.getOWLLiteral(d);
            }
            catch (NumberFormatException numberFormatException) {
                if (tok.equals("true")) {
                    return this.dataFactory.getOWLLiteral(true);
                }
                if (tok.equals("false")) {
                    return this.dataFactory.getOWLLiteral(false);
                }
                throw this.createException(false, false, false, false, false, false, "true", "false", "$integer$", "$float$", "$double$", "\"$Literal$\"", "\"$Literal$\"^^<datatype>", "\"$Literal$\"@<lang>");
            }
        }
    }

    public int parseInteger() throws ParserException {
        String i = this.consumeToken();
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            throw new ParserException(Arrays.asList(this.getToken().getToken()), this.getTokenPos(), this.getTokenRow(), true, this.getTokenCol());
        }
    }

    public String getLineCol() {
        return "Encountered " + this.getLastToken() + " at " + this.getTokenRow() + ":" + this.getTokenCol() + " ";
    }

    private OWLClassExpression parseNestedClassExpression(boolean lookaheadCheck) throws ParserException {
        String tok = this.peekToken();
        if (tok.equals("(")) {
            this.consumeToken();
            OWLClassExpression desc = this.parseIntersection();
            String closeBracket = this.consumeToken();
            if (!closeBracket.equals(")")) {
                throw this.createException(")");
            }
            return desc;
        }
        if (tok.equals("{")) {
            return this.parseObjectOneOf();
        }
        if (this.isClassName(tok)) {
            String name = this.consumeToken();
            return this.getOWLClass(name);
        }
        if (!tok.equals("<EOF>") || !lookaheadCheck) {
            this.consumeToken();
            throw this.createException(true, false, false, false, false, false, "(", "{");
        }
        return null;
    }

    public OWLClassExpression parseObjectOneOf() throws ParserException {
        String open = this.consumeToken();
        if (!open.equals("{")) {
            throw this.createException("{");
        }
        String sep = ",";
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        while (sep.equals(",")) {
            OWLIndividual ind = this.parseIndividual();
            inds.add(ind);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        String close = this.consumeToken();
        if (!close.equals("}")) {
            throw this.createException("}", ",");
        }
        return this.dataFactory.getOWLObjectOneOf(inds);
    }

    public Set<OntologyAxiomPair> parseFrames() throws ParserException {
        String tok;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<String> possible = new HashSet<String>();
        this.resetPossible(possible);
        while (true) {
            if ((tok = this.peekToken()).equalsIgnoreCase(CLASS)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseClassFrame());
                possible.addAll(Arrays.asList(SUB_CLASS_OF, EQUIVALENT_TO, DISJOINT_WITH, HAS_KEY));
                possible.add(SUPER_CLASS_OF);
                possible.add(DISJOINT_CLASSES);
                continue;
            }
            if (tok.equalsIgnoreCase(OBJECT_PROPERTY)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseObjectPropertyFrame());
                possible.addAll(Arrays.asList(SUB_PROPERTY_OF, SUB_PROPERTY_CHAIN, EQUIVALENT_TO, DISJOINT_WITH, INVERSES, CHARACTERISTICS, DOMAIN, RANGE));
                continue;
            }
            if (tok.equalsIgnoreCase(DATA_PROPERTY)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseDataPropertyFrame());
                possible.addAll(Arrays.asList(SUB_PROPERTY_OF, EQUIVALENT_TO, DISJOINT_WITH, CHARACTERISTICS, DOMAIN, RANGE));
                continue;
            }
            if (tok.equalsIgnoreCase(ANNOTATION_PROPERTY)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseAnnotationPropertyFrame());
                possible.addAll(Arrays.asList(SUB_PROPERTY_OF, DOMAIN, RANGE));
                continue;
            }
            if (tok.equalsIgnoreCase(INDIVIDUAL)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseIndividualFrame());
                possible.addAll(Arrays.asList(TYPES, FACTS, DIFFERENT_FROM, SAME_AS));
                continue;
            }
            if (tok.equalsIgnoreCase(DATATYPE)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                axioms.addAll(this.parseDatatypeFrame());
                possible.add(EQUIVALENT_TO);
                continue;
            }
            if (tok.equalsIgnoreCase(VALUE_PARTITION)) {
                this.potentialKeywords.clear();
                this.resetPossible(possible);
                this.parseValuePartitionFrame();
                continue;
            }
            if (!tok.equalsIgnoreCase(RULE)) break;
            this.potentialKeywords.clear();
            this.resetPossible(possible);
            axioms.addAll(this.parseRuleFrame());
        }
        if (!tok.equals("<EOF>")) {
            this.consumeToken();
            throw this.createException(possible.toArray(new String[possible.size()]));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseDatatypeFrame() throws ParserException {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!tok.equalsIgnoreCase(DATATYPE)) {
            throw this.createException(DATATYPE);
        }
        String subj = this.consumeToken();
        OWLDatatype datatype = this.getOWLDatatype(subj);
        if (datatype == null) {
            throw this.createException(false, false, false, false, true, false, new String[0]);
        }
        axioms.add(new OntologyAxiomPair(this.defaultOntology, this.getDataFactory().getOWLDeclarationAxiom(datatype)));
        block0: while (true) {
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                Set<OWLOntology> onts = this.getOntologies();
                Set<OWLDataRange> drs = this.parseDataRangeList();
                Iterator<OWLOntology> i$ = onts.iterator();
                block1: while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLOntology ont = i$.next();
                    Iterator<OWLDataRange> i$2 = drs.iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block1;
                        OWLDataRange dr = i$2.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDatatypeDefinitionAxiom(datatype, dr)));
                    }
                    break;
                }
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(datatype.getIRI()));
        }
        return axioms;
    }

    private void resetPossible(Set<String> possible) {
        possible.clear();
        possible.add(ANNOTATIONS);
        possible.add(ANNOTATION_PROPERTY);
        possible.add(CLASS);
        possible.add(OBJECT_PROPERTY);
        possible.add(DATATYPE);
        possible.add(DATA_PROPERTY);
        possible.add(INDIVIDUAL);
        possible.add(VALUE_PARTITION);
        possible.add(RULE);
    }

    public Set<OntologyAxiomPair> parseNaryEquivalentClasses() throws ParserException {
        Set<Object> annotations;
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(EQUIVALENT_CLASSES)) {
            throw this.createException(EQUIVALENT_CLASSES);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        String next = this.peekToken();
        if (next.equalsIgnoreCase(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList(false);
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.getDataFactory().getOWLEquivalentClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseNaryEquivalentProperties() throws ParserException {
        OWLNaryPropertyAxiom<OWLObjectPropertyExpression> propertyAxiom;
        Set<Object> annotations;
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(EQUIVALENT_PROPERTIES)) {
            throw this.createException(EQUIVALENT_PROPERTIES);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        String next = this.peekToken();
        if (next.equalsIgnoreCase(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLPropertyExpression> properties = this.parsePropertyList();
        if (properties.iterator().next().isObjectPropertyExpression()) {
            HashSet<OWLObjectPropertyExpression> ope = new HashSet<OWLObjectPropertyExpression>();
            for (OWLPropertyExpression pe : properties) {
                ope.add((OWLObjectPropertyExpression)pe);
            }
            propertyAxiom = this.getDataFactory().getOWLEquivalentObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet<OWLDataPropertyExpression> dpe = new HashSet<OWLDataPropertyExpression>();
            for (OWLPropertyExpression pe : properties) {
                dpe.add((OWLDataPropertyExpression)pe);
            }
            propertyAxiom = this.getDataFactory().getOWLEquivalentDataPropertiesAxiom(dpe, annotations);
        }
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, propertyAxiom));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseAnnotations(OWLAnnotationSubject subject) throws ParserException {
        String header = this.consumeToken();
        if (!header.equals(ANNOTATIONS)) {
            throw this.createException(ANNOTATIONS);
        }
        Set<OWLOntology> onts = this.getOntologies();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        if (!this.isAllowableEmptyClassFrameSection()) {
            Set<OWLAnnotation> annos = this.parseAnnotationList();
            for (OWLOntology ont : onts) {
                for (OWLAnnotation anno : annos) {
                    OWLAnnotationAssertionAxiom ax = this.getDataFactory().getOWLAnnotationAssertionAxiom(subject, anno);
                    pairs.add(new OntologyAxiomPair(ont, ax));
                }
            }
        }
        return pairs;
    }

    private Set<OWLAnnotation> parseAnnotationList() throws ParserException {
        String sep = ",";
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
        while (sep.equals(",")) {
            this.potentialKeywords.clear();
            annos.addAll(this.parseAnnotation());
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return annos;
    }

    private Set<OWLAnnotation> parseAnnotation() throws ParserException {
        OWLAnnotationProperty annoProp = this.parseAnnotationProperty();
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>();
        String obj = this.peekToken();
        if (this.isIndividualName(obj) || this.isClassName(obj) || this.isObjectPropertyName(obj) || this.isDataPropertyName(obj)) {
            this.consumeToken();
            OWLAnnotation anno = this.dataFactory.getOWLAnnotation(annoProp, this.getIRI(obj));
            annos.add(anno);
        } else if (obj.startsWith("<")) {
            IRI value = this.parseIRI();
            annos.add(this.dataFactory.getOWLAnnotation(annoProp, value));
        } else {
            OWLLiteral con = this.parseConstant();
            OWLAnnotation anno = this.dataFactory.getOWLAnnotation(annoProp, con);
            annos.add(anno);
        }
        return annos;
    }

    public Set<OntologyAxiomPair> parseClassFrame() throws ParserException {
        return this.parseClassFrame(false);
    }

    public Set<OntologyAxiomPair> parseClassFrameEOF() throws ParserException {
        return this.parseClassFrame(true);
    }

    private Set<OntologyAxiomPair> parseClassFrame(boolean eof) throws ParserException {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!tok.equalsIgnoreCase(CLASS)) {
            throw this.createException(CLASS);
        }
        String subj = this.consumeToken();
        OWLClass cls = this.getOWLClass(subj);
        if (cls == null) {
            throw this.createException(true, false, false, false);
        }
        axioms.add(new OntologyAxiomPair(this.defaultOntology, this.getDataFactory().getOWLDeclarationAxiom(cls)));
        this.parseClassFrameSections(eof, axioms, cls);
        return axioms;
    }

    private Set<OWLOntology> parseOntologyList() throws ParserException {
        this.potentialKeywords.clear();
        this.consumeToken("[");
        this.consumeToken("in");
        String sep = ",";
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>();
        while (sep.equals(",")) {
            String tok = this.consumeToken();
            if (this.isOntologyName(tok)) {
                OWLOntology ont = this.getOntology(tok);
                if (ont != null) {
                    onts.add(ont);
                }
            } else {
                throw this.createException(true);
            }
            sep = this.consumeToken();
            if (sep.equals("]")) break;
            if (sep.equals(",")) continue;
            throw this.createException(",", "]");
        }
        return onts;
    }

    private Set<OWLOntology> getOntologies() throws ParserException {
        if (this.peekToken().equals("[")) {
            return this.parseOntologyList();
        }
        return Collections.singleton(this.defaultOntology);
    }

    public void setDefaultOntology(OWLOntology defaultOntology) {
        this.defaultOntology = defaultOntology;
    }

    private boolean isAllowableEmptyClassFrameSection() {
        if (!this.allowEmptyFrameSections) {
            return false;
        }
        String next = this.peekToken();
        return classFrameSections.contains(next) || next.equals("<EOF>");
    }

    private void parseClassFrameSections(boolean eof, Set<OntologyAxiomPair> axioms, OWLClass cls) throws ParserException {
        String sect;
        block0: while (true) {
            OWLOntology ont;
            Iterator<OWLOntology> i$;
            OWLClassExpression desc;
            Iterator<OWLObject> i$2;
            OWLOntology ont2;
            Iterator<OWLOntology> i$3;
            Object descs;
            Set<OWLOntology> onts;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_CLASS_OF)) {
                this.consumeToken();
                onts = this.getOntologies();
                if (this.isAllowableEmptyClassFrameSection()) continue;
                descs = this.parseAnnotatedClassExpressionList();
                i$3 = onts.iterator();
                block1: while (true) {
                    if (!i$3.hasNext()) continue block0;
                    ont2 = i$3.next();
                    i$2 = descs.keySet().iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block1;
                        desc = i$2.next();
                        axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLSubClassOfAxiom(cls, desc, (Set)descs.get(desc))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(EQUIVALENT_TO)) {
                this.consumeToken();
                onts = this.getOntologies();
                if (this.isAllowableEmptyClassFrameSection()) continue;
                descs = this.parseAnnotatedClassExpressionList();
                i$3 = onts.iterator();
                block3: while (true) {
                    if (!i$3.hasNext()) continue block0;
                    ont2 = i$3.next();
                    i$2 = descs.keySet().iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block3;
                        desc = i$2.next();
                        axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLEquivalentClassesAxiom(CollectionFactory.createSet(cls, desc), (Set)descs.get(desc))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_WITH)) {
                this.consumeToken();
                onts = this.getOntologies();
                if (this.isAllowableEmptyClassFrameSection()) continue;
                descs = this.parseAnnotatedClassExpressionList();
                i$3 = onts.iterator();
                block5: while (true) {
                    if (!i$3.hasNext()) continue block0;
                    ont2 = i$3.next();
                    i$2 = descs.keySet().iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block5;
                        desc = i$2.next();
                        Set<OWLClassExpression> pair = CollectionFactory.createSet(cls, desc);
                        axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLDisjointClassesAxiom(pair, (Set)descs.get(desc))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_CLASSES)) {
                Set<Object> annotations;
                this.consumeToken();
                onts = this.getOntologies();
                if (this.isAllowableEmptyClassFrameSection()) continue;
                if (this.peekToken().equalsIgnoreCase(ANNOTATIONS)) {
                    this.consumeToken();
                    annotations = this.parseAnnotationList();
                } else {
                    annotations = Collections.emptySet();
                }
                Set<OWLClassExpression> descs2 = this.parseClassExpressionList(false);
                i$ = onts.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    descs2.add(cls);
                    axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDisjointClassesAxiom(descs2, annotations)));
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_UNION_OF)) {
                this.consumeToken();
                onts = this.getOntologies();
                if (this.isAllowableEmptyClassFrameSection()) continue;
                descs = this.parseClassExpressionList(false);
                i$3 = onts.iterator();
                while (true) {
                    if (!i$3.hasNext()) continue block0;
                    ont2 = i$3.next();
                    axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLDisjointUnionAxiom(cls, (Set<? extends OWLClassExpression>)descs)));
                }
            }
            if (sect.equalsIgnoreCase(HAS_KEY)) {
                Set<Object> annos;
                this.consumeToken();
                onts = this.getOntologies();
                if (this.isAllowableEmptyClassFrameSection()) continue;
                if (this.peekToken().equalsIgnoreCase(ANNOTATIONS)) {
                    this.consumeToken();
                    annos = this.parseAnnotationList();
                } else {
                    annos = Collections.emptySet();
                }
                Set<OWLPropertyExpression> props = this.parsePropertyList();
                i$ = onts.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLHasKeyAxiom((OWLClassExpression)cls, props, annos)));
                }
            }
            if (sect.equals(SUPER_CLASS_OF)) {
                this.consumeToken();
                onts = this.getOntologies();
                if (this.isAllowableEmptyClassFrameSection()) continue;
                Map<OWLClassExpression, Set<OWLAnnotation>> ces = this.parseAnnotatedClassExpressionList();
                i$3 = onts.iterator();
                block10: while (true) {
                    if (!i$3.hasNext()) continue block0;
                    ont2 = i$3.next();
                    i$2 = ces.keySet().iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block10;
                        OWLClassExpression ce = i$2.next();
                        axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLSubClassOfAxiom(ce, cls, ces.get(ce))));
                    }
                    break;
                }
            }
            if (sect.equals(INDIVIDUALS)) {
                this.consumeToken();
                onts = this.getOntologies();
                if (this.isAllowableEmptyClassFrameSection() || !this.isAllowableEmptyClassFrameSection()) continue;
                Set<OWLIndividual> inds = this.parseIndividualList();
                i$3 = onts.iterator();
                block12: while (true) {
                    if (!i$3.hasNext()) continue block0;
                    ont2 = i$3.next();
                    i$2 = inds.iterator();
                    while (true) {
                        if (!i$2.hasNext()) continue block12;
                        OWLIndividual ind = (OWLIndividual)i$2.next();
                        axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLClassAssertionAxiom(cls, ind)));
                    }
                    break;
                }
            }
            if (!sect.equals(ANNOTATIONS)) break;
            axioms.addAll(this.parseAnnotations(cls.getIRI()));
        }
        if (eof && !sect.equals("<EOF>")) {
            this.consumeToken();
            throw this.createException(SUB_CLASS_OF, SUPER_CLASS_OF, EQUIVALENT_TO, DISJOINT_WITH, HAS_KEY, ANNOTATIONS);
        }
    }

    public Set<OntologyAxiomPair> parseObjectPropertyFrame() throws ParserException {
        return this.parseObjectPropertyFrame(false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Set<OntologyAxiomPair> parseObjectPropertyFrame(boolean eof) throws ParserException {
        axioms = new HashSet<OntologyAxiomPair>();
        this.consumeToken(ManchesterOWLSyntaxEditorParser.OBJECT_PROPERTY);
        prop = this.parseObjectPropertyExpression();
        if (prop == null) {
            throw this.createException(false, true, false, false);
        }
        if (!prop.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.defaultOntology, this.dataFactory.getOWLDeclarationAxiom(prop.asOWLObjectProperty())));
        }
        block0: while (true) {
            if ((sect = this.peekToken()).equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.SUB_PROPERTY_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                props = this.parseAnnotatedObjectPropertyList();
                i$ = onts.iterator();
                block1: while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    i$ = props.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block1;
                        pe = i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLSubObjectPropertyOfAxiom(prop, pe, props.get(pe))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.SUPER_PROPERTY_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                props = this.parseAnnotatedObjectPropertyList();
                i$ = onts.iterator();
                block3: while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    i$ = props.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block3;
                        pe = i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLSubObjectPropertyOfAxiom(pe, prop, props.get(pe))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                props = this.parseAnnotatedObjectPropertyList();
                i$ = onts.iterator();
                block5: while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    i$ = props.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block5;
                        pe = i$.next();
                        ax = this.dataFactory.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet(new OWLObjectPropertyExpression[]{prop, pe}), props.get(pe));
                        axioms.add(new OntologyAxiomPair(ont, ax));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.DISJOINT_WITH)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                props = this.parseAnnotatedObjectPropertyList();
                i$ = onts.iterator();
                block7: while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    i$ = props.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block7;
                        pe = i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet(new OWLObjectPropertyExpression[]{prop, pe}), props.get(pe))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.DOMAIN)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                domains = this.parseAnnotatedClassExpressionList();
                i$ = onts.iterator();
                block9: while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    i$ = domains.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block9;
                        dom = (OWLClassExpression)i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLObjectPropertyDomainAxiom(prop, dom, domains.get(dom))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.RANGE)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                ranges = this.parseAnnotatedClassExpressionList();
                i$ = onts.iterator();
                block11: while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    i$ = ranges.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block11;
                        rng = (OWLClassExpression)i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, rng, ranges.get(rng))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.INVERSES) || sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.INVERSE_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                inverses = this.parseAnnotatedObjectPropertyList();
                i$ = onts.iterator();
                block13: while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    i$ = inverses.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block13;
                        inv = (OWLObjectPropertyExpression)i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLInverseObjectPropertiesAxiom(prop, inv, inverses.get(inv))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.CHARACTERISTICS)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                axs = this.parseObjectPropertyCharacteristicList(prop);
                i$ = onts.iterator();
                block15: while (true) {
                    if (!i$.hasNext()) continue block0;
                    ont = i$.next();
                    i$ = axs.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block15;
                        ax = (OWLAxiom)i$.next();
                        axioms.add(new OntologyAxiomPair(ont, ax));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.ANNOTATIONS)) {
                this.potentialKeywords.clear();
                axioms.addAll(this.parseAnnotations(prop.asOWLObjectProperty().getIRI()));
                continue;
            }
            if (!sect.equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.SUB_PROPERTY_CHAIN)) break;
            this.potentialKeywords.clear();
            this.consumeToken();
            onts = this.getOntologies();
            if (this.peekToken().equalsIgnoreCase(ManchesterOWLSyntaxEditorParser.ANNOTATIONS)) {
                this.consumeToken();
                annotations /* !! */  = this.parseAnnotationList();
            } else {
                annotations /* !! */  = Collections.emptySet();
            }
            props = this.parseObjectPropertyChain();
            ax = this.dataFactory.getOWLSubPropertyChainOfAxiom(props, prop, annotations /* !! */ );
            i$ = onts.iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block0;
                ont = (OWLOntology)i$.next();
                axioms.add(new OntologyAxiomPair(ont, ax));
            }
            break;
        }
        if (eof && !sect.equals("<EOF>")) {
            this.consumeToken();
            throw this.createException(new String[]{ManchesterOWLSyntaxEditorParser.SUB_PROPERTY_OF, ManchesterOWLSyntaxEditorParser.EQUIVALENT_TO, ManchesterOWLSyntaxEditorParser.DISJOINT_WITH, ManchesterOWLSyntaxEditorParser.ANNOTATIONS, ManchesterOWLSyntaxEditorParser.DOMAIN, ManchesterOWLSyntaxEditorParser.RANGE, ManchesterOWLSyntaxEditorParser.INVERSES, ManchesterOWLSyntaxEditorParser.CHARACTERISTICS, ManchesterOWLSyntaxEditorParser.SUB_PROPERTY_CHAIN});
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseDataPropertyFrame() throws ParserException {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(DATA_PROPERTY)) {
            throw this.createException(DATA_PROPERTY);
        }
        String subj = this.consumeToken();
        OWLDataProperty prop = this.getOWLDataProperty(subj);
        if (prop == null) {
            throw this.createException(false, false, true, false);
        }
        block0: while (true) {
            OWLDataProperty pe;
            Iterator<OWLObject> i$;
            OWLOntology ont;
            Iterator<OWLOntology> i$2;
            Map<OWLDataProperty, Set<OWLAnnotation>> props;
            Set<OWLOntology> onts;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_PROPERTY_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                props = this.parseAnnotatedDataPropertyList();
                i$2 = onts.iterator();
                block1: while (true) {
                    if (!i$2.hasNext()) continue block0;
                    ont = i$2.next();
                    i$ = props.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block1;
                        pe = i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLSubDataPropertyOfAxiom(prop, pe, props.get(pe))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(EQUIVALENT_TO)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                props = this.parseAnnotatedDataPropertyList();
                i$2 = onts.iterator();
                block3: while (true) {
                    if (!i$2.hasNext()) continue block0;
                    ont = i$2.next();
                    i$ = props.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block3;
                        pe = i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet(prop, pe), props.get(pe))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(DISJOINT_WITH)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                props = this.parseAnnotatedDataPropertyList();
                i$2 = onts.iterator();
                block5: while (true) {
                    if (!i$2.hasNext()) continue block0;
                    ont = i$2.next();
                    i$ = props.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block5;
                        pe = i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet(prop, pe), props.get(pe))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(DOMAIN)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                Map<OWLClassExpression, Set<OWLAnnotation>> domains = this.parseAnnotatedClassExpressionList();
                i$2 = onts.iterator();
                block7: while (true) {
                    if (!i$2.hasNext()) continue block0;
                    ont = i$2.next();
                    i$ = domains.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block7;
                        OWLClassExpression dom = (OWLClassExpression)i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDataPropertyDomainAxiom(prop, dom, domains.get(dom))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(RANGE)) {
                Set<Object> annotations;
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                if (this.peekToken().equalsIgnoreCase(ANNOTATIONS)) {
                    this.consumeToken();
                    annotations = this.parseAnnotationList();
                } else {
                    annotations = Collections.emptySet();
                }
                Set<OWLDataRange> ranges = this.parseDataRangeList();
                Iterator<OWLOntology> i$3 = onts.iterator();
                block9: while (true) {
                    if (!i$3.hasNext()) continue block0;
                    OWLOntology ont2 = i$3.next();
                    Iterator<OWLDataRange> i$4 = ranges.iterator();
                    while (true) {
                        if (!i$4.hasNext()) continue block9;
                        OWLDataRange rng = i$4.next();
                        axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLDataPropertyRangeAxiom(prop, rng, annotations)));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(CHARACTERISTICS)) {
                Set<Object> annos;
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                String next = this.peekToken();
                if (next.equals(ANNOTATIONS)) {
                    this.consumeToken();
                    annos = this.parseAnnotationList();
                } else {
                    annos = Collections.emptySet();
                }
                String characteristic = this.consumeToken();
                if (!characteristic.equals(FUNCTIONAL)) {
                    throw this.createException(FUNCTIONAL);
                }
                i$ = onts.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    OWLOntology ont3 = (OWLOntology)i$.next();
                    axioms.add(new OntologyAxiomPair(ont3, this.dataFactory.getOWLFunctionalDataPropertyAxiom(prop, annos)));
                }
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(prop.getIRI()));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseAnnotationPropertyFrame() throws ParserException {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(ANNOTATION_PROPERTY)) {
            throw this.createException(ANNOTATION_PROPERTY);
        }
        String subj = this.consumeToken();
        OWLAnnotationProperty prop = this.getOWLAnnotationProperty(subj);
        if (prop == null) {
            throw this.createException(false, false, true, false);
        }
        block0: while (true) {
            Iterator<OWLObject> i$;
            OWLOntology ont;
            Iterator<OWLOntology> i$2;
            Set<OWLOntology> onts;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(SUB_PROPERTY_OF)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                Set<OWLAnnotationProperty> props = this.parseAnnotationPropertyList();
                i$2 = onts.iterator();
                block1: while (true) {
                    if (!i$2.hasNext()) continue block0;
                    ont = i$2.next();
                    i$ = props.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block1;
                        OWLAnnotationProperty pe = i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLSubAnnotationPropertyOfAxiom(prop, pe)));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(DOMAIN)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                Set<IRI> domains = this.parseNameList();
                i$2 = onts.iterator();
                block3: while (true) {
                    if (!i$2.hasNext()) continue block0;
                    ont = i$2.next();
                    i$ = domains.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block3;
                        IRI dom = (IRI)i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLAnnotationPropertyDomainAxiom(prop, dom)));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(RANGE)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                Set<IRI> ranges = this.parseNameList();
                i$2 = onts.iterator();
                block5: while (true) {
                    if (!i$2.hasNext()) continue block0;
                    ont = i$2.next();
                    i$ = ranges.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block5;
                        IRI rng = (IRI)i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLAnnotationPropertyRangeAxiom(prop, rng)));
                    }
                    break;
                }
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            axioms.addAll(this.parseAnnotations(prop.getIRI()));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseIndividualFrame() throws ParserException {
        String tok = this.consumeToken();
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        if (!tok.equalsIgnoreCase(INDIVIDUAL)) {
            throw this.createException(INDIVIDUAL);
        }
        String subj = this.consumeToken();
        OWLIndividual ind = this.getOWLIndividual(subj);
        if (ind == null) {
            throw this.createException(false, false, false, true);
        }
        if (!ind.isAnonymous()) {
            axioms.add(new OntologyAxiomPair(this.getOntology(null), this.getDataFactory().getOWLDeclarationAxiom(ind.asOWLNamedIndividual())));
        }
        block2: while (true) {
            Set<OWLIndividual> inds;
            Iterator<OWLObject> i$;
            OWLOntology ont;
            Iterator<OWLOntology> i$2;
            Set<OWLOntology> onts;
            String sect;
            if ((sect = this.peekToken()).equalsIgnoreCase(TYPES)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                Map<OWLClassExpression, Set<OWLAnnotation>> descs = this.parseAnnotatedClassExpressionList();
                i$2 = onts.iterator();
                block3: while (true) {
                    if (!i$2.hasNext()) continue block2;
                    ont = i$2.next();
                    i$ = descs.keySet().iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block3;
                        OWLClassExpression desc = i$.next();
                        axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLClassAssertionAxiom(desc, ind, descs.get(desc))));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(FACTS)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                String sep = ",";
                while (true) {
                    SWRLPredicate p;
                    String prop;
                    Set<Object> annos;
                    if (!sep.equals(",")) continue block2;
                    String next = this.peekToken();
                    if (next.equals(ANNOTATIONS)) {
                        this.consumeToken();
                        annos = this.parseAnnotationList();
                    } else {
                        annos = Collections.emptySet();
                    }
                    boolean negative = false;
                    if (this.peekToken().equals(NOT)) {
                        this.consumeToken();
                        negative = true;
                    }
                    if (this.isDataPropertyName(prop = this.peekToken())) {
                        p = this.parseDataProperty();
                        OWLLiteral con = this.parseConstant();
                        if (!negative) {
                            for (OWLOntology ont2 : onts) {
                                axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, ind, con, (Set<? extends OWLAnnotation>)annos)));
                            }
                        } else {
                            for (OWLOntology ont2 : onts) {
                                axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)p, ind, con, (Set<? extends OWLAnnotation>)annos)));
                            }
                        }
                    } else if (this.isObjectPropertyName(prop)) {
                        p = this.parseObjectPropertyExpression();
                        OWLIndividual obj = this.parseIndividual();
                        for (OWLOntology ont2 : onts) {
                            if (!negative) {
                                axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)p, ind, obj, annos)));
                                continue;
                            }
                            axioms.add(new OntologyAxiomPair(ont2, this.dataFactory.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)p, ind, obj, annos)));
                        }
                    } else if (this.isAnnotationPropertyName(prop)) {
                        OWLAnnotation annotation;
                        OWLAnnotationProperty annotationProp = this.getOWLAnnotationProperty(prop);
                        String object = this.peekToken();
                        IRI iri = this.getIRI(object);
                        if (iri.toURI().isAbsolute()) {
                            annotation = this.dataFactory.getOWLAnnotation(annotationProp, iri);
                        } else {
                            OWLLiteral con;
                            try {
                                con = this.parseConstant();
                            }
                            catch (ParserException e) {
                                throw this.createException(e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), true, e.isDatatypeNameExpected(), e.isAnnotationPropertyNameExpected(), e.getExpectedKeywords().toArray(new String[e.getExpectedKeywords().size()]));
                            }
                            annotation = this.dataFactory.getOWLAnnotation(annotationProp, con);
                        }
                        for (OWLOntology ont3 : onts) {
                            if (ind.isAnonymous()) {
                                axioms.add(new OntologyAxiomPair(ont3, this.dataFactory.getOWLAnnotationAssertionAxiom(ind.asOWLAnonymousIndividual(), annotation, annos)));
                                continue;
                            }
                            axioms.add(new OntologyAxiomPair(ont3, this.dataFactory.getOWLAnnotationAssertionAxiom(ind.asOWLNamedIndividual().getIRI(), annotation, annos)));
                        }
                    } else {
                        this.consumeToken();
                        throw this.createException(false, true, true, false, false, true, ",");
                    }
                    if (!(sep = this.peekToken()).equals(",")) continue;
                    this.consumeToken();
                }
            }
            if (sect.equalsIgnoreCase(SAME_AS)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                inds = this.parseIndividualList();
                inds.add(ind);
                OWLSameIndividualAxiom ax = this.dataFactory.getOWLSameIndividualAxiom(inds);
                Iterator<OWLOntology> i$3 = onts.iterator();
                while (true) {
                    if (!i$3.hasNext()) continue block2;
                    OWLOntology ont4 = i$3.next();
                    axioms.add(new OntologyAxiomPair(ont4, ax));
                }
            }
            if (sect.equalsIgnoreCase(DIFFERENT_FROM)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                inds = this.parseIndividualList();
                i$2 = onts.iterator();
                block11: while (true) {
                    if (!i$2.hasNext()) continue block2;
                    ont = i$2.next();
                    i$ = inds.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block11;
                        OWLIndividual i = (OWLIndividual)i$.next();
                        OWLDifferentIndividualsAxiom ax = this.dataFactory.getOWLDifferentIndividualsAxiom(ind, i);
                        axioms.add(new OntologyAxiomPair(ont, ax));
                    }
                    break;
                }
            }
            if (sect.equalsIgnoreCase(DIFFERENT_INDIVIDUALS)) {
                this.potentialKeywords.clear();
                this.consumeToken();
                onts = this.getOntologies();
                inds = this.parseIndividualList();
                i$2 = onts.iterator();
                while (true) {
                    if (!i$2.hasNext()) continue block2;
                    ont = i$2.next();
                    axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLDifferentIndividualsAxiom(inds)));
                }
            }
            if (!sect.equalsIgnoreCase(ANNOTATIONS)) break;
            this.potentialKeywords.clear();
            if (ind.isAnonymous()) {
                axioms.addAll(this.parseAnnotations(ind.asOWLAnonymousIndividual()));
                continue;
            }
            axioms.addAll(this.parseAnnotations(ind.asOWLNamedIndividual().getIRI()));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseValuePartitionFrame() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(VALUE_PARTITION)) {
            throw this.createException(VALUE_PARTITION);
        }
        Set<OWLOntology> onts = this.getOntologies();
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String clsName = this.consumeToken();
        if (clsName.equals("<EOF>")) {
            throw this.createException(false, true, false, false, false, false, new String[0]);
        }
        OWLClass cls = this.getOWLClass(clsName);
        if (cls == null) {
            throw this.createException(true, false, false, false);
        }
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        axioms.addAll(this.parseValuePartitionValues(onts, cls));
        for (OWLOntology ont : onts) {
            axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop)));
            axioms.add(new OntologyAxiomPair(ont, this.dataFactory.getOWLObjectPropertyRangeAxiom(prop, cls)));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseValuePartitionValues(Set<OWLOntology> onts, OWLClass superclass) throws ParserException {
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        HashSet<OWLClass> siblings = new HashSet<OWLClass>();
        this.consumeToken("[");
        String sep = ",";
        while (sep.equals(",")) {
            String clsName = this.consumeToken();
            OWLClass cls = this.getOWLClass(clsName);
            if (cls == null) {
                throw this.createException(true, false, false, false);
            }
            siblings.add(cls);
            OWLSubClassOfAxiom ax = this.getDataFactory().getOWLSubClassOfAxiom(cls, superclass);
            for (OWLOntology ont : onts) {
                axioms.add(new OntologyAxiomPair(ont, ax));
            }
            if (this.peekToken().equals("[")) {
                axioms.addAll(this.parseValuePartitionValues(onts, cls));
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            this.consumeToken();
        }
        this.consumeToken("]");
        OWLDisjointClassesAxiom ax = this.getDataFactory().getOWLDisjointClassesAxiom(siblings);
        for (OWLOntology ont : onts) {
            axioms.add(new OntologyAxiomPair(ont, ax));
        }
        return axioms;
    }

    public Set<OntologyAxiomPair> parseRuleFrame() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(RULE)) {
            throw this.createException(RULE);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        List<SWRLAtom> body = this.parseRuleAtoms();
        String tok = this.consumeToken();
        if (!tok.equals("-")) {
            throw this.createException("-", ",");
        }
        this.consumeToken(">");
        List<SWRLAtom> head = this.parseRuleAtoms();
        SWRLRule rule = this.dataFactory.getSWRLRule(new LinkedHashSet<SWRLAtom>(body), new LinkedHashSet<SWRLAtom>(head));
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, rule));
        }
        return pairs;
    }

    public List<SWRLAtom> parseRuleAtoms() throws ParserException {
        String sep = ",";
        ArrayList<SWRLAtom> atoms = new ArrayList<SWRLAtom>();
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            SWRLAtom atom = this.parseRuleAtom();
            atoms.add(atom);
            sep = this.peekToken();
            if (sep.equals(",")) {
                this.consumeToken();
            }
            this.potentialKeywords.add(",");
        }
        return atoms;
    }

    public SWRLAtom parseRuleAtom() throws ParserException {
        String predicate = this.peekToken();
        if (this.isClassName(predicate)) {
            return this.parseClassAtom();
        }
        if (this.isObjectPropertyName(predicate)) {
            return this.parseObjectPropertyAtom();
        }
        if (this.isDataPropertyName(predicate)) {
            return this.parseDataPropertyAtom();
        }
        if (predicate.equals(ManchesterOWLSyntax.DIFFERENT_FROM.toString())) {
            return this.parseDifferentFromAtom();
        }
        if (predicate.equals(ManchesterOWLSyntax.SAME_AS.toString())) {
            return this.parseSameAsAtom();
        }
        if (this.isSWRLBuiltin(predicate) || predicate.startsWith("<")) {
            return this.parseBuiltInAtom();
        }
        this.consumeToken();
        TreeSet<String> kw = new TreeSet<String>();
        kw.addAll(this.ruleBuiltIns.keySet());
        kw.add(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        kw.add(ManchesterOWLSyntax.SAME_AS.toString());
        throw this.createException(true, true, true, false, false, false, kw.toArray(new String[this.ruleBuiltIns.size()]));
    }

    public SWRLAtom parseDataPropertyAtom() throws ParserException {
        String predicate = this.consumeToken();
        if (!this.isDataPropertyName(predicate)) {
            throw this.createException(false, false, true, false);
        }
        this.consumeToken("(");
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(",");
        SWRLDArgument obj2 = this.parseDObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLDataPropertyAtom(this.getOWLDataProperty(predicate), obj1, obj2);
    }

    public SWRLAtom parseObjectPropertyAtom() throws ParserException {
        String predicate = this.consumeToken();
        if (!this.isObjectPropertyName(predicate)) {
            throw this.createException(false, true, false, false);
        }
        this.consumeToken("(");
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(",");
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLObjectPropertyAtom(this.getOWLObjectProperty(predicate), obj1, obj2);
    }

    public SWRLAtom parseClassAtom() throws ParserException {
        String predicate = this.consumeToken();
        if (!this.isClassName(predicate)) {
            throw this.createException(true, false, false, false);
        }
        this.consumeToken("(");
        SWRLIArgument obj = this.parseIObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLClassAtom(this.getOWLClass(predicate), obj);
    }

    public SWRLDifferentIndividualsAtom parseDifferentFromAtom() throws ParserException {
        this.consumeToken(ManchesterOWLSyntax.DIFFERENT_FROM.toString());
        this.consumeToken("(");
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(",");
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLDifferentIndividualsAtom(obj1, obj2);
    }

    public SWRLSameIndividualAtom parseSameAsAtom() throws ParserException {
        this.consumeToken(ManchesterOWLSyntax.SAME_AS.toString());
        this.consumeToken("(");
        SWRLIArgument obj1 = this.parseIObject();
        this.consumeToken(",");
        SWRLIArgument obj2 = this.parseIObject();
        this.consumeToken(")");
        return this.dataFactory.getSWRLSameIndividualAtom(obj1, obj2);
    }

    public SWRLIArgument parseIObject() throws ParserException {
        String s = this.peekToken();
        if (this.isIndividualName(s)) {
            return this.parseIIndividualObject();
        }
        if (s.equals("?")) {
            return this.parseIVariable();
        }
        this.consumeToken();
        throw this.createException(false, false, false, true, false, false, "?$var$");
    }

    public IRI getVariableIRI(String var) {
        if (var.startsWith("<") || var.endsWith(">")) {
            return IRI.create(var.substring(1, var.length() - 1));
        }
        return IRI.create(this.base + var);
    }

    public SWRLVariable parseIVariable() throws ParserException {
        IRI var = this.parseVariable();
        return this.dataFactory.getSWRLVariable(var);
    }

    public SWRLIndividualArgument parseIIndividualObject() throws ParserException {
        OWLIndividual ind = this.parseIndividual();
        return this.dataFactory.getSWRLIndividualArgument(ind);
    }

    public IRI parseVariable() throws ParserException {
        this.consumeToken("?");
        return this.parseIRI();
    }

    public SWRLDArgument parseDObject() throws ParserException {
        String s = this.peekToken();
        if (s.equals("?")) {
            return this.parseDVariable();
        }
        try {
            return this.parseLiteralObject();
        }
        catch (ParserException e) {
            HashSet<String> kw = new HashSet<String>(e.getExpectedKeywords());
            kw.add("?");
            throw new ParserException(e.getTokenSequence(), e.getStartPos(), e.getLineNumber(), e.getColumnNumber(), e.isClassNameExpected(), e.isObjectPropertyNameExpected(), e.isDataPropertyNameExpected(), e.isIndividualNameExpected(), e.isDatatypeNameExpected(), e.isAnnotationPropertyNameExpected(), kw);
        }
    }

    public SWRLVariable parseDVariable() throws ParserException {
        IRI var = this.parseVariable();
        return this.dataFactory.getSWRLVariable(var);
    }

    public SWRLLiteralArgument parseLiteralObject() throws ParserException {
        OWLLiteral lit = this.parseConstant();
        return this.dataFactory.getSWRLLiteralArgument(lit);
    }

    public SWRLBuiltInAtom parseBuiltInAtom() throws ParserException {
        String predicate = this.consumeToken();
        this.consumeToken("(");
        SWRLBuiltInsVocabulary v = null;
        IRI iri = null;
        if (!this.ruleBuiltIns.containsKey(predicate)) {
            iri = this.getIRI(predicate);
        } else {
            v = this.ruleBuiltIns.get(predicate);
            iri = v.getIRI();
        }
        ArrayList<SWRLDArgument> args = new ArrayList<SWRLDArgument>();
        if (v != null && v.getMaxArity() >= 0) {
            for (int i = 0; i < v.getMaxArity(); ++i) {
                SWRLDArgument obj = this.parseDObject();
                args.add(obj);
                if (i < v.getMinArity() - 1) {
                    this.consumeToken(",");
                    continue;
                }
                if (i >= v.getMaxArity() - 1) continue;
                if (this.peekToken().equals(",")) {
                    this.consumeToken();
                    continue;
                }
                break;
            }
        } else {
            String sep = ",";
            while (sep.equals(",")) {
                SWRLDArgument arg = this.parseDObject();
                args.add(arg);
                sep = this.peekToken();
                if (!sep.equals(",")) continue;
                this.consumeToken();
            }
        }
        this.consumeToken(")");
        return this.dataFactory.getSWRLBuiltInAtom(iri, args);
    }

    public Set<OntologyAxiomPair> parseDisjointClasses() throws ParserException {
        Set<Object> annotations;
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DISJOINT_CLASSES)) {
            throw this.createException(DISJOINT_CLASSES);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        if (this.peekToken().equals(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLClassExpression> classExpressions = this.parseClassExpressionList(false);
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.getDataFactory().getOWLDisjointClassesAxiom(classExpressions, annotations)));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseSameIndividual() throws ParserException {
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(SAME_INDIVIDUAL)) {
            throw this.createException(SAME_INDIVIDUAL);
        }
        Set<OWLIndividual> individuals = this.parseIndividualList();
        Set<OWLOntology> ontologies = this.getOntologies();
        Set<Object> annotations = this.peekToken().equals(ANNOTATIONS) ? this.parseAnnotationList() : Collections.emptySet();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, this.getDataFactory().getOWLSameIndividualAxiom(individuals, annotations)));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseDisjointProperties() throws ParserException {
        OWLNaryPropertyAxiom<OWLObjectPropertyExpression> propertiesAxiom;
        Set<Object> annotations;
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DISJOINT_PROPERTIES)) {
            throw this.createException(DISJOINT_PROPERTIES);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        if (this.peekToken().equalsIgnoreCase(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLPropertyExpression> props = this.parsePropertyList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        if (props.iterator().next().isObjectPropertyExpression()) {
            HashSet<OWLObjectPropertyExpression> ope = new HashSet<OWLObjectPropertyExpression>();
            for (OWLPropertyExpression pe : props) {
                ope.add((OWLObjectPropertyExpression)pe);
            }
            propertiesAxiom = this.getDataFactory().getOWLDisjointObjectPropertiesAxiom(ope, annotations);
        } else {
            HashSet<OWLDataPropertyExpression> dpe = new HashSet<OWLDataPropertyExpression>();
            for (OWLPropertyExpression pe : props) {
                dpe.add((OWLDataPropertyExpression)pe);
            }
            propertiesAxiom = this.getDataFactory().getOWLDisjointDataPropertiesAxiom(dpe, annotations);
        }
        for (OWLOntology ont : ontologies) {
            pairs.add(new OntologyAxiomPair(ont, propertiesAxiom));
        }
        return pairs;
    }

    public Set<OntologyAxiomPair> parseDifferentIndividuals() throws ParserException {
        Set<Object> annotations;
        String section = this.consumeToken();
        if (!section.equalsIgnoreCase(DIFFERENT_INDIVIDUALS)) {
            throw this.createException(DIFFERENT_INDIVIDUALS);
        }
        Set<OWLOntology> ontologies = this.getOntologies();
        if (this.peekToken().equalsIgnoreCase(ANNOTATIONS)) {
            this.consumeToken();
            annotations = this.parseAnnotationList();
        } else {
            annotations = Collections.emptySet();
        }
        Set<OWLIndividual> individuals = this.parseIndividualList();
        HashSet<OntologyAxiomPair> pairs = new HashSet<OntologyAxiomPair>();
        for (OWLOntology ontology : ontologies) {
            pairs.add(new OntologyAxiomPair(ontology, this.getDataFactory().getOWLDifferentIndividualsAxiom(individuals, annotations)));
        }
        return pairs;
    }

    public Set<OWLAxiom> parseObjectPropertyCharacteristicList(OWLObjectPropertyExpression prop) throws ParserException {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            String characteristic = this.consumeToken();
            if (characteristic.equalsIgnoreCase(FUNCTIONAL)) {
                axioms.add(this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop, annos));
            } else if (characteristic.equalsIgnoreCase(INVERSE_FUNCTIONAL)) {
                axioms.add(this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop, annos));
            } else if (characteristic.equalsIgnoreCase(SYMMETRIC)) {
                axioms.add(this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop, annos));
            } else if (characteristic.equalsIgnoreCase(ANTI_SYMMETRIC) || characteristic.equalsIgnoreCase(ASYMMETRIC)) {
                axioms.add(this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop, annos));
            } else if (characteristic.equalsIgnoreCase(TRANSITIVE)) {
                axioms.add(this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop, annos));
            } else if (characteristic.equalsIgnoreCase(REFLEXIVE)) {
                axioms.add(this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop, annos));
            } else if (characteristic.equalsIgnoreCase(IRREFLEXIVE)) {
                axioms.add(this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop, annos));
            } else {
                throw this.createException(FUNCTIONAL, INVERSE_FUNCTIONAL, SYMMETRIC, ANTI_SYMMETRIC, TRANSITIVE, REFLEXIVE, IRREFLEXIVE);
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            sep = this.consumeToken();
        }
        return axioms;
    }

    public Map<OWLClassExpression, Set<OWLAnnotation>> parseAnnotatedClassExpressionList() throws ParserException {
        HashMap<OWLClassExpression, Set<OWLAnnotation>> descs = new HashMap<OWLClassExpression, Set<OWLAnnotation>>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            this.potentialKeywords.remove(",");
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            descs.put(this.parseIntersection(), annos);
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        return descs;
    }

    public Set<OWLClassExpression> parseClassExpressionList(boolean allowAnnotations) throws ParserException {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        String sep = ",";
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                Set<OWLAnnotation> annos = this.parseAnnotationList();
            }
            descs.add(this.parseIntersection());
            this.potentialKeywords.add(",");
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        return descs;
    }

    public Set<OWLClassExpression> parseClassExpressionList(String expectedOpen, String expectedClose) throws ParserException {
        String open = this.consumeToken();
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        if (!open.equals(expectedOpen)) {
            throw this.createException(expectedOpen);
        }
        String sep = ",";
        while (sep.equals(",")) {
            this.potentialKeywords.remove(",");
            OWLClassExpression desc = this.parseIntersection();
            this.potentialKeywords.add(",");
            descs.add(desc);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            sep = this.consumeToken();
        }
        String close = this.consumeToken();
        if (!close.equals(expectedClose)) {
            throw this.createException(expectedClose);
        }
        return descs;
    }

    public Set<OWLDataProperty> parseDataPropertyList() throws ParserException {
        HashSet<OWLDataProperty> props = new HashSet<OWLDataProperty>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLDataProperty prop = this.parseDataProperty();
            props.add(prop);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Map<OWLDataProperty, Set<OWLAnnotation>> parseAnnotatedDataPropertyList() throws ParserException {
        HashMap<OWLDataProperty, Set<OWLAnnotation>> props = new HashMap<OWLDataProperty, Set<OWLAnnotation>>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            OWLDataProperty prop = this.parseDataProperty();
            props.put(prop, annos);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLAnnotationProperty> parseAnnotationPropertyList() throws ParserException {
        HashSet<OWLAnnotationProperty> props = new HashSet<OWLAnnotationProperty>();
        String sep = ",";
        while (sep.equals(",")) {
            sep = this.peekToken();
            OWLAnnotationProperty prop = this.parseAnnotationProperty();
            props.add(prop);
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Map<OWLPropertyExpression, Set<OWLAnnotation>> parseAnnotatedPropertyList() throws ParserException {
        HashMap<OWLPropertyExpression, Set<OWLAnnotation>> props = new HashMap<OWLPropertyExpression, Set<OWLAnnotation>>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            OWLPropertyExpression prop = this.parsePropertyExpression();
            props.put(prop, annos);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLPropertyExpression> parsePropertyList() throws ParserException {
        HashSet<OWLPropertyExpression> props = new HashSet<OWLPropertyExpression>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLPropertyExpression prop = this.parsePropertyExpression();
            props.add(prop);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLObjectPropertyExpression> parseObjectPropertyList() throws ParserException {
        HashSet<OWLObjectPropertyExpression> props = new HashSet<OWLObjectPropertyExpression>();
        String sep = ",";
        while (sep.equals(",")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            props.add(prop);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Map<OWLObjectPropertyExpression, Set<OWLAnnotation>> parseAnnotatedObjectPropertyList() throws ParserException {
        HashMap<OWLObjectPropertyExpression, Set<OWLAnnotation>> props = new HashMap<OWLObjectPropertyExpression, Set<OWLAnnotation>>();
        String sep = ",";
        while (sep.equals(",")) {
            Set<Object> annos;
            String next = this.peekToken();
            if (next.equals(ANNOTATIONS)) {
                this.consumeToken();
                annos = this.parseAnnotationList();
            } else {
                annos = Collections.emptySet();
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            props.put(prop, annos);
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return props;
    }

    public Set<OWLIndividual> parseIndividualList() throws ParserException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        String sep = ",";
        while (sep.equals(",")) {
            inds.add(this.parseIndividual());
            sep = this.peekToken();
            if (!sep.equals(",")) continue;
            this.consumeToken();
        }
        return inds;
    }

    public List<OWLObjectPropertyExpression> parseObjectPropertyChain() throws ParserException {
        String delim = "o";
        ArrayList<OWLObjectPropertyExpression> properties = new ArrayList<OWLObjectPropertyExpression>();
        while (delim.equals("o")) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            properties.add(prop);
            delim = this.peekToken();
            if (!delim.equals("o")) continue;
            this.consumeToken();
        }
        return properties;
    }

    public OWLSubPropertyChainOfAxiom parsePropertyChainSubPropertyAxiom() throws ParserException {
        List<OWLObjectPropertyExpression> props = this.parseObjectPropertyChain();
        String imp = this.consumeToken() + this.consumeToken();
        if (!imp.equals("->")) {
            throw this.createException("->", "o");
        }
        OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression();
        return this.dataFactory.getOWLSubPropertyChainOfAxiom(props, superProp);
    }

    public OWLClassAxiom parseClassAxiom() throws ParserException {
        OWLClassExpression lhs = this.parseIntersection();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.SUBCLASS_OF.toString())) {
            OWLClassExpression rhs = this.parseIntersection();
            return this.dataFactory.getOWLSubClassOfAxiom(lhs, rhs);
        }
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.EQUIVALENT_TO.toString())) {
            OWLClassExpression rhs = this.parseIntersection();
            return this.dataFactory.getOWLEquivalentClassesAxiom(lhs, rhs);
        }
        if (kw.equalsIgnoreCase(ManchesterOWLSyntax.DISJOINT_WITH.toString())) {
            OWLClassExpression rhs = this.parseIntersection();
            return this.dataFactory.getOWLDisjointClassesAxiom(lhs, rhs);
        }
        throw this.createException(ManchesterOWLSyntax.SUBCLASS_OF.toString(), ManchesterOWLSyntax.EQUIVALENT_TO.toString(), ManchesterOWLSyntax.DISJOINT_WITH.toString());
    }

    public OWLObjectPropertyAxiom parseObjectPropertyAxiom() throws ParserException {
        String tok = this.peekToken();
        if (tok.equals(ManchesterOWLSyntax.FUNCTIONAL.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLInverseFunctionalObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.TRANSITIVE.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLTransitiveObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.SYMMETRIC.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLSymmetricObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.REFLEXIVE.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLReflexiveObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.IRREFLEXIVE.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLIrreflexiveObjectPropertyAxiom(prop);
        }
        if (tok.equals(ManchesterOWLSyntax.ASYMMETRIC.toString())) {
            this.consumeToken();
            String open = this.consumeToken();
            if (!open.equals("(")) {
                throw this.createException("(");
            }
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            String close = this.consumeToken();
            if (!close.equals(")")) {
                throw this.createException(")");
            }
            return this.dataFactory.getOWLAsymmetricObjectPropertyAxiom(prop);
        }
        return null;
    }

    public OWLIndividual parseIndividual() throws ParserException {
        String name = this.consumeToken();
        if (!this.isIndividualName(name) && !name.startsWith("_:")) {
            throw this.createException(false, false, false, true);
        }
        return this.getOWLIndividual(name);
    }

    public OWLIndividual parseIndividual(boolean defined) throws ParserException {
        String name = this.consumeToken();
        if (defined && !this.isIndividualName(name)) {
            throw this.createException(false, false, false, true);
        }
        return this.getOWLIndividual(name);
    }

    public OWLDataProperty parseDataProperty() throws ParserException {
        String name = this.consumeToken();
        if (!this.isDataPropertyName(name)) {
            throw this.createException(false, false, true, false);
        }
        return this.getOWLDataProperty(name);
    }

    public OWLAnnotationProperty parseAnnotationProperty() throws ParserException {
        String name = this.consumeToken();
        if (!this.isAnnotationPropertyName(name)) {
            throw this.createException(false, false, false, false, false, true, new String[0]);
        }
        return this.getOWLAnnotationProperty(name);
    }

    public Map<String, IRI> parsePrefixDeclaration() throws ParserException {
        this.consumeToken(PREFIX);
        HashMap<String, IRI> map = new HashMap<String, IRI>(2);
        String prefixName = this.consumeToken();
        String delim = this.peekToken();
        if (delim.equals("=")) {
            this.consumeToken();
        }
        IRI iri = this.parseIRI();
        map.put(prefixName, iri);
        return map;
    }

    public OWLImportsDeclaration parseImportsDeclaration(OWLOntology ont) throws ParserException {
        this.consumeToken(IMPORT);
        IRI importedOntologyIRI = this.parseIRI();
        return this.dataFactory.getOWLImportsDeclaration(importedOntologyIRI);
    }

    public IRI parseIRI() throws ParserException {
        String iriString = this.consumeToken();
        if (!iriString.startsWith("<") || !iriString.endsWith(">")) {
            throw this.createException("<$IRI$>");
        }
        return IRI.create(iriString.substring(1, iriString.length() - 1));
    }

    public Set<IRI> parseNameList() throws ParserException {
        String sep = ",";
        HashSet<IRI> iris = new HashSet<IRI>();
        while (sep.equals(",")) {
            this.potentialKeywords.clear();
            String token = this.peekToken();
            if (this.isClassName(token)) {
                iris.add(this.owlEntityChecker.getOWLClass(token).getIRI());
                this.consumeToken();
            } else if (this.isObjectPropertyName(token)) {
                iris.add(this.owlEntityChecker.getOWLObjectProperty(token).getIRI());
                this.consumeToken();
            } else if (this.isDataPropertyName(token)) {
                iris.add(this.owlEntityChecker.getOWLDataProperty(token).getIRI());
                this.consumeToken();
            } else if (this.isIndividualName(token)) {
                iris.add(this.owlEntityChecker.getOWLIndividual(token).getIRI());
                this.consumeToken();
            } else if (this.isAnnotationPropertyName(token)) {
                iris.add(this.owlEntityChecker.getOWLAnnotationProperty(token).getIRI());
                this.consumeToken();
            } else if (this.isDatatypeName(token)) {
                iris.add(this.owlEntityChecker.getOWLDatatype(token).getIRI());
                this.consumeToken();
            } else if (this.isOntologyName(token)) {
                iris.add(this.getOntology(token).getOntologyID().getOntologyIRI());
                this.consumeToken();
            } else if (token.equals("<")) {
                IRI iri = this.parseIRI();
                iris.add(iri);
            } else {
                throw this.createException(true, true, true, true, true, true, "<$URI$>");
            }
            if (!(sep = this.peekToken()).equals(",")) continue;
            this.consumeToken();
        }
        return iris;
    }

    private void processDeclaredEntities() {
        for (int i = 0; i < this.tokens.size(); ++i) {
            ManchesterOWLSyntaxTokenizer.Token tok = this.tokens.get(i);
            if (tok.getToken().equalsIgnoreCase(CLASS)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.classNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(OBJECT_PROPERTY)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.objectPropertyNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(DATA_PROPERTY)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.dataPropertyNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(INDIVIDUAL)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.individualNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(DATATYPE)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.dataTypeNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (tok.getToken().equalsIgnoreCase(ANNOTATION_PROPERTY)) {
                if (i + 1 >= this.tokens.size()) continue;
                this.annotationPropertyNames.add(this.tokens.get(i + 1).getToken());
                continue;
            }
            if (!tok.getToken().equalsIgnoreCase(VALUE_PARTITION)) continue;
            if (i + 1 < this.tokens.size()) {
                this.objectPropertyNames.add(this.tokens.get(i + 1).getToken());
            }
            if (i + 2 >= this.tokens.size()) continue;
            this.classNames.add(this.tokens.get(i + 2).getToken());
        }
    }

    private static void addNamesToSet(String buffer, String sectionName, Set<String> names) {
        Pattern p = Pattern.compile("(" + sectionName + "\\s*)(\\S*)");
        Matcher matcher = p.matcher(buffer);
        while (matcher.find()) {
            names.add(matcher.group(2));
        }
    }

    public void parseOntology(OWLOntologyManager manager, OWLOntology ont) throws ParserException, UnloadableImportException {
        String section;
        HashSet<OntologyAxiomPair> axioms = new HashSet<OntologyAxiomPair>();
        OWLOntologyID ontologyID = new OWLOntologyID();
        HashSet<AddImport> imports = new HashSet<AddImport>();
        HashSet<AddOntologyAnnotation> ontologyAnnotations = new HashSet<AddOntologyAnnotation>();
        this.defaultOntology = ont;
        this.processDeclaredEntities();
        block0: while (true) {
            if ((section = this.peekToken()).equals(ONTOLOGY)) {
                ManchesterOWLSyntaxOntologyHeader header = this.parseOntologyHeader(false);
                for (OWLImportsDeclaration decl : header.getImportsDeclarations()) {
                    manager.makeLoadImportRequest(decl);
                    imports.add(new AddImport(ont, decl));
                }
                for (OWLAnnotation anno : header.getAnnotations()) {
                    ontologyAnnotations.add(new AddOntologyAnnotation(ont, anno));
                }
                ontologyID = header.getOntologyID();
                continue;
            }
            if (section.equalsIgnoreCase(CLASS)) {
                axioms.addAll(this.parseClassFrame());
                continue;
            }
            if (section.equalsIgnoreCase(OBJECT_PROPERTY)) {
                axioms.addAll(this.parseObjectPropertyFrame());
                continue;
            }
            if (section.equalsIgnoreCase(DATA_PROPERTY)) {
                axioms.addAll(this.parseDataPropertyFrame());
                continue;
            }
            if (section.equalsIgnoreCase(INDIVIDUAL)) {
                axioms.addAll(this.parseIndividualFrame());
                continue;
            }
            if (section.equalsIgnoreCase(DATATYPE)) {
                axioms.addAll(this.parseDatatypeFrame());
                continue;
            }
            if (section.equalsIgnoreCase(ANNOTATION_PROPERTY)) {
                axioms.addAll(this.parseAnnotationPropertyFrame());
                continue;
            }
            if (section.equalsIgnoreCase(VALUE_PARTITION)) {
                axioms.addAll(this.parseValuePartitionFrame());
                continue;
            }
            if (section.equalsIgnoreCase(IMPORT)) {
                OWLImportsDeclaration decl = this.parseImportsDeclaration(ont);
                imports.add(new AddImport(ont, decl));
                manager.makeLoadImportRequest(decl);
                continue;
            }
            if (section.equalsIgnoreCase(PREFIX)) {
                Map<String, IRI> nsMap = this.parsePrefixDeclaration();
                Iterator<Object> i$ = nsMap.keySet().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    String ns = (String)i$.next();
                    this.pm.setPrefix(ns, nsMap.get(ns).toString());
                }
            }
            if (section.equalsIgnoreCase(DISJOINT_CLASSES)) {
                axioms.addAll(this.parseDisjointClasses());
                continue;
            }
            if (section.equalsIgnoreCase(EQUIVALENT_CLASSES)) {
                axioms.addAll(this.parseNaryEquivalentClasses());
                continue;
            }
            if (section.equalsIgnoreCase(EQUIVALENT_PROPERTIES)) {
                axioms.addAll(this.parseNaryEquivalentProperties());
                continue;
            }
            if (section.equalsIgnoreCase(DISJOINT_PROPERTIES)) {
                axioms.addAll(this.parseDisjointProperties());
                continue;
            }
            if (section.equalsIgnoreCase(DIFFERENT_INDIVIDUALS)) {
                axioms.addAll(this.parseDifferentIndividuals());
                continue;
            }
            if (section.equalsIgnoreCase(SAME_INDIVIDUAL)) {
                axioms.addAll(this.parseSameIndividual());
                continue;
            }
            if (!section.equalsIgnoreCase(RULE)) break;
            axioms.addAll(this.parseRuleFrame());
        }
        if (!section.equals("<EOF>")) {
            this.consumeToken();
            throw this.createException(CLASS, OBJECT_PROPERTY, DATA_PROPERTY, INDIVIDUAL, DATATYPE, ANNOTATION_PROPERTY, IMPORT, VALUE_PARTITION, PREFIX, EQUIVALENT_CLASSES, DISJOINT_CLASSES, DISJOINT_PROPERTIES, DIFFERENT_INDIVIDUALS, SAME_INDIVIDUAL);
        }
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(axioms.size());
        changes.addAll(imports);
        changes.addAll(ontologyAnnotations);
        for (OntologyAxiomPair pair : axioms) {
            changes.add(new AddAxiom(ont, pair.getAxiom()));
        }
        changes.add(new SetOntologyID(ont, ontologyID));
        manager.applyChanges(changes);
    }

    public ManchesterOWLSyntaxOntologyHeader parseOntologyHeader(boolean toEOF) throws ParserException {
        String section;
        String tok = this.consumeToken();
        if (!tok.equalsIgnoreCase(ONTOLOGY)) {
            throw this.createException(ONTOLOGY);
        }
        IRI ontologyIRI = null;
        IRI versionIRI = null;
        if (this.peekToken().startsWith("<")) {
            ontologyIRI = this.parseIRI();
            if (this.peekToken().startsWith("<")) {
                versionIRI = this.parseIRI();
            }
        }
        HashSet<OWLAnnotation> annotations = new HashSet<OWLAnnotation>();
        HashSet<OWLImportsDeclaration> imports = new HashSet<OWLImportsDeclaration>();
        while (true) {
            if ((section = this.peekToken()).equals(IMPORT)) {
                this.consumeToken();
                tok = this.peekToken();
                IRI importedIRI = null;
                if (tok.startsWith("<")) {
                    importedIRI = this.parseIRI();
                } else if (this.isOntologyName(tok)) {
                    this.consumeToken();
                    OWLOntology ont = this.getOntology(tok);
                    if (ont != null) {
                        importedIRI = ont.getOntologyID().getOntologyIRI();
                    }
                } else {
                    this.consumeToken();
                    this.throwOntologyNameOrURIExpectedException();
                }
                imports.add(this.getDataFactory().getOWLImportsDeclaration(importedIRI));
                continue;
            }
            if (!section.equals(ANNOTATIONS)) break;
            this.consumeToken();
            annotations.addAll(this.parseAnnotationList());
        }
        if (!section.equalsIgnoreCase("<EOF>") && toEOF) {
            throw this.createException(IMPORT, ANNOTATIONS);
        }
        return new ManchesterOWLSyntaxOntologyHeader(ontologyIRI, versionIRI, annotations, imports);
    }

    protected ParserException createException(boolean ontologyNameExpected) throws ParserException {
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        return new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), ontologyNameExpected, new String[0]);
    }

    protected void throwOntologyNameOrURIExpectedException() throws ParserException {
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        throw new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), true, "<$ONTOLOGYYURI$>");
    }

    protected ParserException createException(String ... keywords) throws ParserException {
        HashSet<String> theKeywords = new HashSet<String>();
        theKeywords.addAll(Arrays.asList(keywords));
        theKeywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        return new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), false, false, false, false, false, false, theKeywords);
    }

    protected ParserException createException(boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected, boolean datatypeNameExpected, boolean annotationPropertyNameExpected, String ... keywords) throws ParserException {
        HashSet<String> theKeywords = new HashSet<String>();
        theKeywords.addAll(Arrays.asList(keywords));
        if (objectPropertyNameExpected) {
            theKeywords.add(INVERSE);
        }
        theKeywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        return new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, datatypeNameExpected, annotationPropertyNameExpected, theKeywords);
    }

    protected ParserException createException(boolean classNameExpected, boolean objectPropertyNameExpected, boolean dataPropertyNameExpected, boolean individualNameExpected) throws ParserException {
        HashSet<String> keywords = new HashSet<String>();
        if (objectPropertyNameExpected) {
            keywords.add(INVERSE);
        }
        keywords.addAll(this.potentialKeywords);
        this.potentialKeywords.clear();
        ManchesterOWLSyntaxTokenizer.Token lastToken = this.getLastToken();
        return new ParserException(this.getTokenSequence(), lastToken.getPos(), lastToken.getRow(), lastToken.getCol(), classNameExpected, objectPropertyNameExpected, dataPropertyNameExpected, individualNameExpected, false, false, keywords);
    }

    protected List<String> getTokenSequence() {
        ArrayList<String> seq = new ArrayList<String>();
        int index = this.tokenIndex - 1;
        if (index < 0) {
            index = 0;
        }
        while (index < this.tokens.size() && seq.size() < 4 && seq.indexOf("<EOF>") == -1) {
            seq.add(this.tokens.get(index).getToken());
            ++index;
        }
        if (seq.size() == 0) {
            seq.add("<EOF>");
        }
        return seq;
    }

    public IRI getIRI(String name) {
        IRI uri;
        boolean fullIRI = name.equals("<");
        if (fullIRI) {
            name = this.consumeToken();
            this.consumeToken();
        }
        if ((uri = this.nameIRIMap.get(name)) != null) {
            return uri;
        }
        if (fullIRI) {
            uri = IRI.create(name);
        } else {
            int colonIndex = name.indexOf(58);
            if (colonIndex == -1) {
                name = ":" + name;
            }
            uri = this.pm.getIRI(name);
        }
        this.nameIRIMap.put(name, uri);
        return uri;
    }

    public OWLAxiom parseAxiom() throws ParserException {
        String token = this.peekToken();
        if (this.isClassName(token)) {
            return this.parseAxiomWithClassExpressionStart();
        }
        if (this.isObjectPropertyName(token)) {
            return this.parseAxiomWithObjectPropertyStart();
        }
        if (this.isDataPropertyName(token)) {
            return this.parseAxiomWithDataPropertyStart();
        }
        if (!this.isIndividualName(token)) {
            if (token.equalsIgnoreCase("inv")) {
                return this.parseAxiomWithObjectPropertyStart();
            }
            if (token.equalsIgnoreCase("(")) {
                return this.parseAxiomWithClassExpressionStart();
            }
            if (token.equalsIgnoreCase("{")) {
                return this.parseAxiomWithClassExpressionStart();
            }
            if (token.equalsIgnoreCase(FUNCTIONAL)) {
                return this.parseFunctionPropertyAxiom();
            }
            if (token.equalsIgnoreCase(INVERSE_FUNCTIONAL)) {
                return this.parseInverseFunctionalPropertyAxiom();
            }
            if (token.equalsIgnoreCase(SYMMETRIC)) {
                return this.parseSymmetricPropertyAxiom();
            }
            if (token.equalsIgnoreCase(ASYMMETRIC)) {
                return this.parseAsymmetricPropertyAxiom();
            }
            if (token.equalsIgnoreCase(TRANSITIVE)) {
                return this.parseTransitivePropertyAxiom();
            }
            if (token.equalsIgnoreCase(REFLEXIVE)) {
                return this.parseReflexivePropertyAxiom();
            }
            if (token.equalsIgnoreCase(IRREFLEXIVE)) {
                return this.parseIrreflexivePropertyAxiom();
            }
            throw this.createException(true, true, true, true, false, false, "(", "{", "inv", FUNCTIONAL, INVERSE_FUNCTIONAL, SYMMETRIC, ASYMMETRIC, TRANSITIVE, REFLEXIVE, IRREFLEXIVE);
        }
        return null;
    }

    public OWLAxiom parseAxiomWithClassExpressionStart() throws ParserException {
        OWLClassExpression ce = this.parseIntersection();
        return this.parseClassAxiomRemainder(ce);
    }

    public OWLAxiom parseClassAxiomRemainder(OWLClassExpression startExpression) throws ParserException {
        String kw = this.consumeToken();
        System.out.println("Parse class axiom rem: " + startExpression);
        if (kw.equalsIgnoreCase(SUB_CLASS_OF)) {
            OWLClassExpression superClass = this.parseClassExpression();
            return this.getDataFactory().getOWLSubClassOfAxiom(startExpression, superClass);
        }
        if (kw.equalsIgnoreCase(DISJOINT_WITH)) {
            OWLClassExpression disjointClass = this.parseClassExpression();
            return this.getDataFactory().getOWLDisjointClassesAxiom(startExpression, disjointClass);
        }
        if (kw.equalsIgnoreCase(EQUIVALENT_TO)) {
            OWLClassExpression equivClass = this.parseClassExpression();
            return this.getDataFactory().getOWLEquivalentClassesAxiom(startExpression, equivClass);
        }
        if (kw.equalsIgnoreCase(AND)) {
            OWLClassExpression conjunct = this.parseIntersection();
            Set<OWLClassExpression> conjuncts = conjunct.asConjunctSet();
            conjuncts.add(startExpression);
            OWLObjectIntersectionOf ce = this.getDataFactory().getOWLObjectIntersectionOf(conjuncts);
            return this.parseClassAxiomRemainder(ce);
        }
        if (kw.equalsIgnoreCase(OR)) {
            OWLClassExpression disjunct = this.parseIntersection();
            Set<OWLClassExpression> disjuncts = disjunct.asDisjunctSet();
            disjuncts.add(startExpression);
            OWLObjectUnionOf ce = this.getDataFactory().getOWLObjectUnionOf(disjuncts);
            return this.parseClassAxiomRemainder(ce);
        }
        System.out.println("Throwing exception!");
        throw this.createException(SUB_CLASS_OF, DISJOINT_WITH, EQUIVALENT_TO, AND, OR);
    }

    public OWLAxiom parseAxiomWithObjectPropertyStart() throws ParserException {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        String kw = this.consumeToken();
        if (kw.equalsIgnoreCase(SOME)) {
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLObjectSomeValuesFrom(prop, filler));
        }
        if (kw.equalsIgnoreCase(ONLY)) {
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLObjectAllValuesFrom(prop, filler));
        }
        if (kw.equalsIgnoreCase(MIN)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLObjectMinCardinality(cardi, prop, filler));
        }
        if (kw.equalsIgnoreCase(MAX)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLObjectMaxCardinality(cardi, prop, filler));
        }
        if (kw.equalsIgnoreCase(EXACTLY)) {
            int cardi = this.parseInteger();
            OWLClassExpression filler = this.parseIntersection();
            return this.parseClassAxiomRemainder(this.getDataFactory().getOWLObjectExactCardinality(cardi, prop, filler));
        }
        if (kw.equalsIgnoreCase(SUB_PROPERTY_OF)) {
            OWLObjectPropertyExpression superProperty = this.parseObjectPropertyExpression();
            return this.getDataFactory().getOWLSubObjectPropertyOfAxiom(prop, superProperty);
        }
        if (kw.equalsIgnoreCase(EQUIVALENT_TO)) {
            OWLObjectPropertyExpression equivProp = this.parseObjectPropertyExpression();
            return this.getDataFactory().getOWLEquivalentObjectPropertiesAxiom(prop, equivProp);
        }
        if (kw.equalsIgnoreCase(INVERSE_OF)) {
            OWLObjectPropertyExpression invProp = this.parseObjectPropertyExpression();
            return this.getDataFactory().getOWLInverseObjectPropertiesAxiom(prop, invProp);
        }
        if (kw.equalsIgnoreCase(DISJOINT_WITH)) {
            OWLObjectPropertyExpression disjProp = this.parseObjectPropertyExpression();
            return this.getDataFactory().getOWLDisjointObjectPropertiesAxiom(prop, disjProp);
        }
        if (kw.equals(DOMAIN)) {
            OWLClassExpression domain = this.parseClassExpression();
            return this.getDataFactory().getOWLObjectPropertyDomainAxiom(prop, domain);
        }
        if (kw.equals(RANGE)) {
            OWLClassExpression range = this.parseClassExpression();
            return this.getDataFactory().getOWLObjectPropertyRangeAxiom(prop, range);
        }
        if (kw.equalsIgnoreCase("o")) {
            String sep = kw;
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
            chain.add(prop);
            while (sep.equals("o")) {
                OWLObjectPropertyExpression chainProp = this.parseObjectPropertyExpression();
                chain.add(chainProp);
                sep = this.consumeToken();
            }
            if (!sep.equalsIgnoreCase(SUB_PROPERTY_OF)) {
                throw this.createException(SUB_PROPERTY_OF);
            }
            OWLObjectPropertyExpression superProp = this.parseObjectPropertyExpression();
            return this.getDataFactory().getOWLSubPropertyChainOfAxiom(chain, superProp);
        }
        throw this.createException(SOME, ONLY, MIN, MAX, EXACTLY, SUB_PROPERTY_OF, EQUIVALENT_TO, INVERSE_OF, DISJOINT_WITH, DOMAIN, RANGE, "o");
    }

    public OWLAxiom parseAxiomWithDataPropertyStart() throws ParserException {
        OWLDataProperty prop = this.parseDataProperty();
        return null;
    }

    public OWLAxiom parseInverseFunctionalPropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(INVERSE_FUNCTIONAL)) {
            throw this.createException(INVERSE_FUNCTIONAL);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.getDataFactory().getOWLInverseFunctionalObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseSymmetricPropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(SYMMETRIC)) {
            throw this.createException(SYMMETRIC);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.getDataFactory().getOWLSymmetricObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseAsymmetricPropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(ASYMMETRIC)) {
            throw this.createException(ASYMMETRIC);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.getDataFactory().getOWLAsymmetricObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseTransitivePropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(TRANSITIVE)) {
            throw this.createException(TRANSITIVE);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.getDataFactory().getOWLTransitiveObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseReflexivePropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(REFLEXIVE)) {
            throw this.createException(REFLEXIVE);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.getDataFactory().getOWLReflexiveObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseIrreflexivePropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(IRREFLEXIVE)) {
            throw this.createException(IRREFLEXIVE);
        }
        OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
        return this.getDataFactory().getOWLIrreflexiveObjectPropertyAxiom(prop);
    }

    public OWLAxiom parseFunctionPropertyAxiom() throws ParserException {
        String kw = this.consumeToken();
        if (!kw.equalsIgnoreCase(FUNCTIONAL)) {
            throw this.createException(FUNCTIONAL);
        }
        String name = this.peekToken();
        if (this.isObjectPropertyName(name)) {
            OWLObjectPropertyExpression prop = this.parseObjectPropertyExpression();
            return this.getDataFactory().getOWLFunctionalObjectPropertyAxiom(prop);
        }
        if (this.isDataPropertyName(name)) {
            OWLDataProperty prop = this.parseDataProperty();
            return this.getDataFactory().getOWLFunctionalDataPropertyAxiom(prop);
        }
        this.consumeToken();
        throw this.createException(false, true, true, false);
    }

    static {
        classFrameSections.add(ANNOTATIONS);
        classFrameSections.add(SUB_CLASS_OF);
        classFrameSections.add(EQUIVALENT_TO);
        classFrameSections.add(EQUIVALENT_CLASSES);
        classFrameSections.add(DISJOINT_WITH);
        classFrameSections.add(DISJOINT_CLASSES);
        classFrameSections.add(DISJOINT_UNION_OF);
        classFrameSections.add(HAS_KEY);
        classFrameSections.add(SUPER_CLASS_OF);
        classFrameSections.add(INDIVIDUALS);
        objectPropertyFrameSections = new HashSet<String>();
        objectPropertyFrameSections.add(ANNOTATIONS);
        objectPropertyFrameSections.add(SUB_PROPERTY_OF);
        objectPropertyFrameSections.add(EQUIVALENT_TO);
        objectPropertyFrameSections.add(EQUIVALENT_PROPERTIES);
        objectPropertyFrameSections.add(DISJOINT_WITH);
        objectPropertyFrameSections.add(DISJOINT_PROPERTIES);
        objectPropertyFrameSections.add(DOMAIN);
        objectPropertyFrameSections.add(RANGE);
        objectPropertyFrameSections.add(CHARACTERISTICS);
        objectPropertyFrameSections.add(SUB_PROPERTY_CHAIN);
        dataPropertyFrameSections = new HashSet<String>();
        dataPropertyFrameSections.add(ANNOTATIONS);
        dataPropertyFrameSections.add(SUB_PROPERTY_OF);
        dataPropertyFrameSections.add(EQUIVALENT_TO);
        dataPropertyFrameSections.add(EQUIVALENT_PROPERTIES);
        dataPropertyFrameSections.add(DISJOINT_WITH);
        dataPropertyFrameSections.add(DISJOINT_PROPERTIES);
        dataPropertyFrameSections.add(DOMAIN);
        dataPropertyFrameSections.add(RANGE);
        dataPropertyFrameSections.add(CHARACTERISTICS);
        individualFrameSections = new HashSet<String>();
        individualFrameSections.add(ANNOTATIONS);
        individualFrameSections.add(TYPES);
        individualFrameSections.add(FACTS);
        individualFrameSections.add(SAME_AS);
        individualFrameSections.add(SAME_INDIVIDUAL);
        individualFrameSections.add(DIFFERENT_FROM);
        individualFrameSections.add(DIFFERENT_INDIVIDUALS);
    }

    private class DefaultEntityChecker
    implements OWLEntityChecker {
        private Map<String, OWLDatatype> dataTypeNameMap = new HashMap<String, OWLDatatype>();

        public DefaultEntityChecker() {
            for (XSDVocabulary v : XSDVocabulary.values()) {
                this.dataTypeNameMap.put(v.getIRI().getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(v.getIRI()));
                this.dataTypeNameMap.put("xsd:" + v.getIRI().getFragment(), ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(v.getIRI()));
            }
        }

        public OWLClass getOWLClass(String name) {
            if (name.equals("Thing") || name.equals("owl:Thing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLThing();
            }
            if (name.equals("Nothing") || name.equals("owl:Nothing")) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLNothing();
            }
            if (ManchesterOWLSyntaxEditorParser.this.classNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLClass(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLObjectProperty getOWLObjectProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.objectPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLObjectProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLDataProperty getOWLDataProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.dataPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDataProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLNamedIndividual getOWLIndividual(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.individualNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLNamedIndividual(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLDatatype getOWLDatatype(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.dataTypeNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLDatatype(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }

        public OWLAnnotationProperty getOWLAnnotationProperty(String name) {
            if (ManchesterOWLSyntaxEditorParser.this.annotationPropertyNames.contains(name)) {
                return ManchesterOWLSyntaxEditorParser.this.dataFactory.getOWLAnnotationProperty(ManchesterOWLSyntaxEditorParser.this.getIRI(name));
            }
            return null;
        }
    }
}

