/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.coode.owlapi.obo.parser.OBOConsumer;
import org.coode.owlapi.obo.parser.TagValueHandler;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

public abstract class AbstractTagValueHandler
implements TagValueHandler {
    private Logger logger = Logger.getLogger(AbstractTagValueHandler.class.getName());
    private String tag;
    private OBOConsumer consumer;

    public AbstractTagValueHandler(String tag, OBOConsumer consumer) {
        this.tag = tag;
        this.consumer = consumer;
    }

    public String getTag() {
        return this.tag;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.consumer.getOWLOntologyManager();
    }

    public OWLOntology getOntology() {
        return this.consumer.getOntology();
    }

    public void applyChange(OWLOntologyChange change) {
        this.consumer.getOWLOntologyManager().applyChange(change);
    }

    public OBOConsumer getConsumer() {
        return this.consumer;
    }

    public OWLDataFactory getDataFactory() {
        return this.consumer.getOWLOntologyManager().getOWLDataFactory();
    }

    public IRI getIRIFromValue(String s) {
        return this.consumer.getIRI(s);
    }

    public OWLClass getClassFromId(String s) {
        return this.getDataFactory().getOWLClass(this.getIRIFromValue(s));
    }

    public OWLClass getCurrentClass() {
        return this.getDataFactory().getOWLClass(this.getIRIFromValue(this.consumer.getCurrentId()));
    }

    protected OWLClass getOWLClass(String id) {
        return this.getDataFactory().getOWLClass(this.getIRIFromValue(id));
    }

    protected OWLObjectProperty getOWLObjectProperty(String id) {
        return this.getDataFactory().getOWLObjectProperty(this.getIRIFromValue(id));
    }

    protected OWLClassExpression getOWLClassOrRestriction(String termList) {
        StringTokenizer tok = new StringTokenizer(termList, " ", false);
        String id0 = null;
        String id1 = null;
        id0 = tok.nextToken();
        if (tok.hasMoreTokens()) {
            id1 = tok.nextToken();
        }
        if (id1 == null) {
            return this.getDataFactory().getOWLClass(this.getIRIFromValue(id0));
        }
        OWLObjectProperty prop = this.getDataFactory().getOWLObjectProperty(this.getIRIFromValue(id0));
        OWLClass filler = this.getDataFactory().getOWLClass(this.getIRIFromValue(id1));
        return this.getDataFactory().getOWLObjectSomeValuesFrom(prop, filler);
    }

    protected OWLLiteral getBooleanConstant(Boolean b) {
        if (b.booleanValue()) {
            return this.getDataFactory().getOWLLiteral("true", this.getDataFactory().getOWLDatatype(XSDVocabulary.BOOLEAN.getIRI()));
        }
        return this.getDataFactory().getOWLLiteral("false", this.getDataFactory().getOWLDatatype(XSDVocabulary.BOOLEAN.getIRI()));
    }

    protected void addAnnotation(String id, String uriID, OWLLiteral value) {
        IRI subject = this.getIRIFromValue(id);
        OWLAnnotationProperty annotationProperty = this.getDataFactory().getOWLAnnotationProperty(this.getIRIFromValue(uriID));
        OWLAnnotationAssertionAxiom ax = this.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, subject, value);
        this.applyChange(new AddAxiom(this.getOntology(), ax));
    }
}

