/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.AbstractLiteralTripleHandler;
import org.coode.owlapi.rdfxml.parser.AbstractResourceTripleHandler;
import org.coode.owlapi.rdfxml.parser.AnonymousNodeChecker;
import org.coode.owlapi.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owlapi.rdfxml.parser.ClassExpressionListItemTranslator;
import org.coode.owlapi.rdfxml.parser.ClassExpressionTranslator;
import org.coode.owlapi.rdfxml.parser.ClassExpressionTranslatorSelector;
import org.coode.owlapi.rdfxml.parser.DataPropertyListItemTranslator;
import org.coode.owlapi.rdfxml.parser.DataRangeListItemTranslator;
import org.coode.owlapi.rdfxml.parser.GTPAnnotationLiteralHandler;
import org.coode.owlapi.rdfxml.parser.GTPAnnotationResourceTripleHandler;
import org.coode.owlapi.rdfxml.parser.GTPDataPropertyAssertionHandler;
import org.coode.owlapi.rdfxml.parser.GTPObjectPropertyAssertionHandler;
import org.coode.owlapi.rdfxml.parser.IRIProvider;
import org.coode.owlapi.rdfxml.parser.IndividualListItemTranslator;
import org.coode.owlapi.rdfxml.parser.OWLFacetRestrictionListItemTranslator;
import org.coode.owlapi.rdfxml.parser.ObjectPropertyListItemTranslator;
import org.coode.owlapi.rdfxml.parser.OptimisedListTranslator;
import org.coode.owlapi.rdfxml.parser.SKOSClassTripleHandler;
import org.coode.owlapi.rdfxml.parser.SKOSObjectTripleHandler;
import org.coode.owlapi.rdfxml.parser.SWRLRuleTranslator;
import org.coode.owlapi.rdfxml.parser.TPAllValuesFromHandler;
import org.coode.owlapi.rdfxml.parser.TPAnnotatedSourceHandler;
import org.coode.owlapi.rdfxml.parser.TPComplementOfHandler;
import org.coode.owlapi.rdfxml.parser.TPDataPropertDomainHandler;
import org.coode.owlapi.rdfxml.parser.TPDataPropertyRangeHandler;
import org.coode.owlapi.rdfxml.parser.TPDeclaredAsHandler;
import org.coode.owlapi.rdfxml.parser.TPDifferentFromHandler;
import org.coode.owlapi.rdfxml.parser.TPDisjointDataPropertiesHandler;
import org.coode.owlapi.rdfxml.parser.TPDisjointObjectPropertiesHandler;
import org.coode.owlapi.rdfxml.parser.TPDisjointUnionHandler;
import org.coode.owlapi.rdfxml.parser.TPDisjointWithHandler;
import org.coode.owlapi.rdfxml.parser.TPDistinctMembersHandler;
import org.coode.owlapi.rdfxml.parser.TPEquivalentClassHandler;
import org.coode.owlapi.rdfxml.parser.TPEquivalentDataPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TPEquivalentObjectPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TPEquivalentPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TPFirstLiteralHandler;
import org.coode.owlapi.rdfxml.parser.TPFirstResourceHandler;
import org.coode.owlapi.rdfxml.parser.TPHasKeyHandler;
import org.coode.owlapi.rdfxml.parser.TPImportsHandler;
import org.coode.owlapi.rdfxml.parser.TPIntersectionOfHandler;
import org.coode.owlapi.rdfxml.parser.TPInverseOfHandler;
import org.coode.owlapi.rdfxml.parser.TPObjectPropertyDomainHandler;
import org.coode.owlapi.rdfxml.parser.TPObjectPropertyRangeHandler;
import org.coode.owlapi.rdfxml.parser.TPOnPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TPOneOfHandler;
import org.coode.owlapi.rdfxml.parser.TPPropertyChainAxiomHandler;
import org.coode.owlapi.rdfxml.parser.TPPropertyDisjointWithHandler;
import org.coode.owlapi.rdfxml.parser.TPPropertyDomainHandler;
import org.coode.owlapi.rdfxml.parser.TPPropertyRangeHandler;
import org.coode.owlapi.rdfxml.parser.TPRestHandler;
import org.coode.owlapi.rdfxml.parser.TPSameAsHandler;
import org.coode.owlapi.rdfxml.parser.TPSomeValuesFromHandler;
import org.coode.owlapi.rdfxml.parser.TPSubClassOfHandler;
import org.coode.owlapi.rdfxml.parser.TPSubDataPropertyOfHandler;
import org.coode.owlapi.rdfxml.parser.TPSubObjectPropertyOfHandler;
import org.coode.owlapi.rdfxml.parser.TPSubPropertyOfHandler;
import org.coode.owlapi.rdfxml.parser.TPTypeHandler;
import org.coode.owlapi.rdfxml.parser.TPUnionOfHandler;
import org.coode.owlapi.rdfxml.parser.TPVersionIRIHandler;
import org.coode.owlapi.rdfxml.parser.TranslatedUnloadedImportException;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.coode.owlapi.rdfxml.parser.TypeAllDifferentHandler;
import org.coode.owlapi.rdfxml.parser.TypeAllDisjointClassesHandler;
import org.coode.owlapi.rdfxml.parser.TypeAllDisjointPropertiesHandler;
import org.coode.owlapi.rdfxml.parser.TypeAnnotationHandler;
import org.coode.owlapi.rdfxml.parser.TypeAnnotationPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeAntisymmetricPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeAsymmetricPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeAxiomHandler;
import org.coode.owlapi.rdfxml.parser.TypeClassHandler;
import org.coode.owlapi.rdfxml.parser.TypeDataPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeDataRangeHandler;
import org.coode.owlapi.rdfxml.parser.TypeDataRestrictionHandler;
import org.coode.owlapi.rdfxml.parser.TypeDatatypeHandler;
import org.coode.owlapi.rdfxml.parser.TypeDeprecatedClassHandler;
import org.coode.owlapi.rdfxml.parser.TypeDeprecatedPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeFunctionalDataPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeFunctionalObjectPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeFunctionalPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeInverseFunctionalPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeIrreflexivePropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeListHandler;
import org.coode.owlapi.rdfxml.parser.TypeNamedIndividualHandler;
import org.coode.owlapi.rdfxml.parser.TypeNegativeDataPropertyAssertionHandler;
import org.coode.owlapi.rdfxml.parser.TypeNegativePropertyAssertionHandler;
import org.coode.owlapi.rdfxml.parser.TypeObjectPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeObjectRestrictionHandler;
import org.coode.owlapi.rdfxml.parser.TypeOntologyHandler;
import org.coode.owlapi.rdfxml.parser.TypePropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeRDFPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeRDFSClassHandler;
import org.coode.owlapi.rdfxml.parser.TypeReflexivePropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeRestrictionHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLAtomListHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLBuiltInAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLBuiltInHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLClassAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLDataRangeAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLDataValuedPropertyAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLDifferentIndividualsAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLImpHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLIndividualPropertyAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLSameIndividualAtomHandler;
import org.coode.owlapi.rdfxml.parser.TypeSWRLVariableHandler;
import org.coode.owlapi.rdfxml.parser.TypeSelfRestrictionHandler;
import org.coode.owlapi.rdfxml.parser.TypeSymmetricPropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypeTransitivePropertyHandler;
import org.coode.owlapi.rdfxml.parser.TypedConstantListItemTranslator;
import org.semanticweb.owlapi.io.RDFOntologyFormat;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.rdf.syntax.RDFConsumer;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SKOSVocabulary;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLRDFConsumer
implements RDFConsumer {
    public static final Logger logger = Logger.getLogger(OWLRDFConsumer.class.getName());
    private static final Logger tripleProcessor = Logger.getLogger("Triple processor");
    private boolean strict = false;
    private OWLOntologyManager owlOntologyManager;
    private IRI xmlBase;
    private AnonymousNodeChecker anonymousNodeChecker;
    private Set<IRI> owlClassIRIs;
    private Set<IRI> objectPropertyIRIs;
    private Set<IRI> dataPropertyIRIs;
    private Set<IRI> propertyIRIs;
    private Set<IRI> individualIRIs;
    private Set<IRI> annotationPropertyIRIs;
    private Set<IRI> annotationIRIs;
    private Map<IRI, OWLAnnotation> annotationIRI2Annotation;
    private Set<IRI> ontologyPropertyIRIs;
    private Set<IRI> dataRangeIRIs;
    private IRI firstOntologyIRI;
    private Set<IRI> ontologyIRIs;
    private Set<IRI> restrictionIRIs;
    private Set<IRI> listIRIs;
    private Map<IRI, IRI> listRestTripleMap;
    private Map<IRI, IRI> listFirstResourceTripleMap;
    private Map<IRI, OWLLiteral> listFirstLiteralTripleMap;
    private Set<IRI> axioms = new HashSet<IRI>();
    private Map<IRI, Set<OWLAnnotation>> annotationsBySubject;
    private Map<IRI, Object> sharedAnonymousNodes = new HashMap<IRI, Object>();
    private OptimisedListTranslator<OWLClassExpression> classExpressionListTranslator;
    private OptimisedListTranslator<OWLIndividual> individualListTranslator;
    private OptimisedListTranslator<OWLObjectPropertyExpression> objectPropertyListTranslator;
    private OptimisedListTranslator<OWLLiteral> constantListTranslator;
    private OptimisedListTranslator<OWLDataPropertyExpression> dataPropertyListTranslator;
    private OptimisedListTranslator<OWLDataRange> dataRangeListTranslator;
    private OptimisedListTranslator<OWLFacetRestriction> faceRestrictionListTranslator;
    private Map<IRI, BuiltInTypeHandler> builtInTypeTripleHandlers;
    private Map<IRI, BuiltInTypeHandler> axiomTypeTripleHandlers = new HashMap<IRI, BuiltInTypeHandler>();
    private Map<IRI, TriplePredicateHandler> predicateHandlers;
    private Map<IRI, AbstractLiteralTripleHandler> skosLiteralTripleHandlers;
    private List<AbstractLiteralTripleHandler> literalTripleHandlers;
    private List<AbstractResourceTripleHandler> resourceTripleHandlers;
    private Set<OWLAnnotation> pendingAnnotations = new HashSet<OWLAnnotation>();
    private Map<IRI, Set<IRI>> annotatedAnonSource2AnnotationMap = new HashMap<IRI, Set<IRI>>();
    private OWLOntology ontology;
    private RDFXMLOntologyFormat rdfxmlOntologyFormat;
    private OWLDataFactory dataFactory;
    private ClassExpressionTranslatorSelector classExpressionTranslatorSelector;
    private OWLAxiom lastAddedAxiom;
    private Map<IRI, IRI> synonymMap;
    private Set<IRI> swrlRules;
    private Set<IRI> swrlIndividualPropertyAtoms;
    private Set<IRI> swrlDataValuedPropertyAtoms;
    private Set<IRI> swrlClassAtoms;
    private Set<IRI> swrlDataRangeAtoms;
    private Set<IRI> swrlBuiltInAtoms;
    private Set<IRI> swrlVariables;
    private Set<IRI> swrlSameAsAtoms;
    private Set<IRI> swrlDifferentFromAtoms;
    private IRIProvider iriProvider;
    private GTPObjectPropertyAssertionHandler objectPropertyAssertionHandler;
    private Map<String, IRI> IRIMap = CollectionFactory.createMap();
    int currentBaseCount = 0;
    private int count = 0;
    private int addCount = 0;
    private Map<IRI, OWLObjectPropertyExpression> translatedProperties = new HashMap<IRI, OWLObjectPropertyExpression>();
    private Map<IRI, OWLClassExpression> translatedClassExpression = new HashMap<IRI, OWLClassExpression>();
    private Map<IRI, Map<IRI, Set<IRI>>> resTriplesBySubject = CollectionFactory.createMap();
    private Map<IRI, Map<IRI, IRI>> singleValuedResTriplesByPredicate = CollectionFactory.createMap();
    private Map<IRI, Map<IRI, Set<OWLLiteral>>> litTriplesBySubject = CollectionFactory.createMap();
    private Map<IRI, Map<IRI, OWLLiteral>> singleValuedLitTriplesByPredicate = CollectionFactory.createMap();

    public OWLRDFConsumer(OWLOntologyManager owlOntologyManager, OWLOntology ontology, AnonymousNodeChecker checker) {
        this.classExpressionTranslatorSelector = new ClassExpressionTranslatorSelector(this);
        this.owlOntologyManager = owlOntologyManager;
        this.ontology = ontology;
        this.dataFactory = owlOntologyManager.getOWLDataFactory();
        this.anonymousNodeChecker = checker;
        this.owlClassIRIs = CollectionFactory.createSet();
        this.objectPropertyIRIs = CollectionFactory.createSet();
        this.dataPropertyIRIs = CollectionFactory.createSet();
        this.individualIRIs = CollectionFactory.createSet();
        this.annotationPropertyIRIs = CollectionFactory.createSet();
        for (IRI iri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            this.annotationPropertyIRIs.add(iri);
        }
        this.annotationIRIs = new HashSet<IRI>();
        this.annotationIRI2Annotation = new HashMap<IRI, OWLAnnotation>();
        this.annotationsBySubject = new HashMap<IRI, Set<OWLAnnotation>>();
        this.ontologyPropertyIRIs = CollectionFactory.createSet();
        this.ontologyPropertyIRIs.add(OWLRDFVocabulary.OWL_PRIOR_VERSION.getIRI());
        this.ontologyPropertyIRIs.add(OWLRDFVocabulary.OWL_BACKWARD_COMPATIBLE_WITH.getIRI());
        this.ontologyPropertyIRIs.add(OWLRDFVocabulary.OWL_INCOMPATIBLE_WITH.getIRI());
        this.addDublinCoreAnnotationIRIs();
        this.dataRangeIRIs = CollectionFactory.createSet();
        this.propertyIRIs = CollectionFactory.createSet();
        this.restrictionIRIs = CollectionFactory.createSet();
        this.ontologyIRIs = CollectionFactory.createSet();
        this.listIRIs = CollectionFactory.createSet();
        this.listFirstLiteralTripleMap = CollectionFactory.createMap();
        this.listFirstResourceTripleMap = CollectionFactory.createMap();
        this.listRestTripleMap = CollectionFactory.createMap();
        this.classExpressionListTranslator = new OptimisedListTranslator<OWLClassExpression>(this, new ClassExpressionListItemTranslator(this));
        this.individualListTranslator = new OptimisedListTranslator<OWLIndividual>(this, new IndividualListItemTranslator(this));
        this.constantListTranslator = new OptimisedListTranslator<OWLLiteral>(this, new TypedConstantListItemTranslator(this));
        this.objectPropertyListTranslator = new OptimisedListTranslator<OWLObjectPropertyExpression>(this, new ObjectPropertyListItemTranslator(this));
        this.dataPropertyListTranslator = new OptimisedListTranslator<OWLDataPropertyExpression>(this, new DataPropertyListItemTranslator(this));
        this.dataRangeListTranslator = new OptimisedListTranslator<OWLDataRange>(this, new DataRangeListItemTranslator(this));
        this.faceRestrictionListTranslator = new OptimisedListTranslator<OWLFacetRestriction>(this, new OWLFacetRestrictionListItemTranslator(this));
        this.builtInTypeTripleHandlers = CollectionFactory.createMap();
        this.setupTypeTripleHandlers();
        this.setupPredicateHandlers();
        this.literalTripleHandlers = new ArrayList<AbstractLiteralTripleHandler>();
        this.literalTripleHandlers.add(new GTPAnnotationLiteralHandler(this));
        this.literalTripleHandlers.add(new GTPDataPropertyAssertionHandler(this));
        this.literalTripleHandlers.add(new TPFirstLiteralHandler(this));
        this.resourceTripleHandlers = new ArrayList<AbstractResourceTripleHandler>();
        this.resourceTripleHandlers.add(new GTPAnnotationResourceTripleHandler(this));
        this.objectPropertyAssertionHandler = new GTPObjectPropertyAssertionHandler(this);
        this.resourceTripleHandlers.add(this.objectPropertyAssertionHandler);
        for (OWL2Datatype dt : OWL2Datatype.values()) {
            this.dataRangeIRIs.add(dt.getIRI());
        }
        this.dataRangeIRIs.add(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        for (OWL2Datatype dt : OWL2Datatype.values()) {
            this.dataRangeIRIs.add(dt.getIRI());
        }
        this.swrlRules = new HashSet<IRI>();
        this.swrlIndividualPropertyAtoms = new HashSet<IRI>();
        this.swrlDataValuedPropertyAtoms = new HashSet<IRI>();
        this.swrlClassAtoms = new HashSet<IRI>();
        this.swrlDataRangeAtoms = new HashSet<IRI>();
        this.swrlBuiltInAtoms = new HashSet<IRI>();
        this.swrlVariables = new HashSet<IRI>();
        this.swrlSameAsAtoms = new HashSet<IRI>();
        this.swrlDifferentFromAtoms = new HashSet<IRI>();
        this.owlClassIRIs.add(OWLRDFVocabulary.OWL_THING.getIRI());
        this.owlClassIRIs.add(OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.objectPropertyIRIs.add(OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
        this.objectPropertyIRIs.add(OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
        this.dataPropertyIRIs.add(OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
        this.dataPropertyIRIs.add(OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
        this.setupSynonymMap();
        this.setupSinglePredicateMaps();
        this.setupSKOSMachinery();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setIRIProvider(IRIProvider iriProvider) {
        this.iriProvider = iriProvider;
    }

    private void addSingleValuedResPredicate(OWLRDFVocabulary v) {
        Map map = CollectionFactory.createMap();
        this.singleValuedResTriplesByPredicate.put(v.getIRI(), map);
    }

    private void addDublinCoreAnnotationIRIs() {
        for (DublinCoreVocabulary v : DublinCoreVocabulary.values()) {
            this.annotationPropertyIRIs.add(v.getIRI());
        }
    }

    private void setupSinglePredicateMaps() {
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_PROPERTY);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_SOME_VALUES_FROM);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ALL_VALUES_FROM);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_CLASS);
        this.addSingleValuedResPredicate(OWLRDFVocabulary.OWL_ON_DATA_RANGE);
    }

    private void setupSynonymMap() {
        this.synonymMap = CollectionFactory.createMap();
        this.synonymMap.put(IRI.create((Object)((Object)Namespaces.OWL) + "valuesFrom"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_SUBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_PREDICATE.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_OBJECT.getIRI(), OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI());
        this.synonymMap.put(IRI.create((Object)((Object)Namespaces.OWL) + "cardinalityType"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(IRI.create((Object)((Object)Namespaces.OWL) + "dataComplementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_ANTI_SYMMETRIC_PROPERTY.getIRI(), OWLRDFVocabulary.OWL_ASYMMETRIC_PROPERTY.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_DATA_RANGE.getIRI(), OWLRDFVocabulary.OWL_DATATYPE.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#subClassOf"), OWLRDFVocabulary.RDFS_SUBCLASS_OF.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#imports"), OWLRDFVocabulary.OWL_IMPORTS.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#range"), OWLRDFVocabulary.RDFS_RANGE.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#hasValue"), OWLRDFVocabulary.OWL_HAS_VALUE.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#type"), OWLRDFVocabulary.RDF_TYPE.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#domain"), OWLRDFVocabulary.RDFS_DOMAIN.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#versionInfo"), OWLRDFVocabulary.OWL_VERSION_INFO.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#comment"), OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#onProperty"), OWLRDFVocabulary.OWL_ON_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#toClass"), OWLRDFVocabulary.OWL_ALL_VALUES_FROM.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#hasClass"), OWLRDFVocabulary.OWL_SOME_VALUES_FROM.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#Restriction"), OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#Class"), OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#Thing"), OWLRDFVocabulary.OWL_THING.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#Nothing"), OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#minCardinality"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#cardinality"), OWLRDFVocabulary.OWL_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#maxCardinality"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#inverseOf"), OWLRDFVocabulary.OWL_INVERSE_OF.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#samePropertyAs"), OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#hasClassQ"), OWLRDFVocabulary.OWL_ON_CLASS.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#cardinalityQ"), OWLRDFVocabulary.OWL_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#maxCardinalityQ"), OWLRDFVocabulary.OWL_MAX_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#minCardinalityQ"), OWLRDFVocabulary.OWL_MIN_CARDINALITY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#complementOf"), OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#unionOf"), OWLRDFVocabulary.OWL_UNION_OF.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#intersectionOf"), OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#label"), OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#ObjectProperty"), OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
        this.synonymMap.put(IRI.create("http://www.daml.org/2001/03/daml+oil#DatatypeProperty"), OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI());
        this.setupLegacyOWLSpecStuff();
    }

    private void setupLegacyOWLSpecStuff() {
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLRDFVocabulary.values()) {
            this.addLegacyMapping(oWLRDFVocabulary);
        }
        for (Enum enum_ : OWLFacet.values()) {
            this.synonymMap.put(IRI.create(Namespaces.OWL.toString() + ((OWLFacet)enum_).getShortName()), ((OWLFacet)enum_).getIRI());
            this.synonymMap.put(IRI.create(Namespaces.OWL11.toString() + ((OWLFacet)enum_).getShortName()), ((OWLFacet)enum_).getIRI());
            this.synonymMap.put(IRI.create(Namespaces.OWL2.toString() + ((OWLFacet)enum_).getShortName()), ((OWLFacet)enum_).getIRI());
        }
        for (Enum enum_ : OWLFacet.values()) {
            this.synonymMap.put(IRI.create(Namespaces.OWL2.toString() + ((OWLFacet)enum_).getShortName()), ((OWLFacet)enum_).getIRI());
        }
        this.synonymMap.put(OWLRDFVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
        this.synonymMap.put(OWLRDFVocabulary.OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION.getIRI(), OWLRDFVocabulary.OWL_NEGATIVE_PROPERTY_ASSERTION.getIRI());
    }

    private void addLegacyMapping(OWLRDFVocabulary v) {
        this.synonymMap.put(IRI.create(Namespaces.OWL2.toString() + v.getShortName()), v.getIRI());
        this.synonymMap.put(IRI.create(Namespaces.OWL11.toString() + v.getShortName()), v.getIRI());
    }

    private void setupSKOSMachinery() {
        this.skosLiteralTripleHandlers = new HashMap<IRI, AbstractLiteralTripleHandler>();
        for (SKOSVocabulary v : SKOSVocabulary.values()) {
            if (v.getEntityType().equals(EntityType.ANNOTATION_PROPERTY)) {
                this.annotationIRIs.add(v.getIRI());
                continue;
            }
            if (v.getEntityType().equals(EntityType.OBJECT_PROPERTY)) {
                this.addPredicateHandler(new SKOSObjectTripleHandler(this, v));
                continue;
            }
            if (!v.getEntityType().equals(EntityType.CLASS)) continue;
            this.addBuiltInTypeTripleHandler(new SKOSClassTripleHandler(this, v));
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public RDFXMLOntologyFormat getOntologyFormat() {
        return this.rdfxmlOntologyFormat;
    }

    public void setOntologyFormat(RDFXMLOntologyFormat format) {
        this.rdfxmlOntologyFormat = format;
    }

    private void addBuiltInTypeTripleHandler(BuiltInTypeHandler handler) {
        this.builtInTypeTripleHandlers.put(handler.getTypeIRI(), handler);
    }

    private void addAxiomTypeTripleHandler(BuiltInTypeHandler handler) {
        this.axiomTypeTripleHandlers.put(handler.getTypeIRI(), handler);
    }

    private void setupTypeTripleHandlers() {
        this.setupBasicTypeHandlers();
        this.setupAxiomTypeHandlers();
    }

    private void setupBasicTypeHandlers() {
        this.addBuiltInTypeTripleHandler(new TypeAntisymmetricPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAsymmetricPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDataPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDatatypeHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeFunctionalDataPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeFunctionalObjectPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeFunctionalPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeInverseFunctionalPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeIrreflexivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeObjectPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeReflexivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSymmetricPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeTransitivePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeObjectRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDataRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeListHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAnnotationPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDeprecatedClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDeprecatedPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeDataRangeHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeOntologyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeNegativeDataPropertyAssertionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeRDFPropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeRDFSClassHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSelfRestrictionHandler(this));
        this.addBuiltInTypeTripleHandler(new TypePropertyHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeNamedIndividualHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeAnnotationHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLAtomListHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLBuiltInAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLBuiltInHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLClassAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLDataRangeAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLDataValuedPropertyAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLDifferentIndividualsAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLImpHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLIndividualPropertyAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLSameIndividualAtomHandler(this));
        this.addBuiltInTypeTripleHandler(new TypeSWRLVariableHandler(this));
    }

    private void setupAxiomTypeHandlers() {
        this.addAxiomTypeTripleHandler(new TypeAxiomHandler(this));
        this.addAxiomTypeTripleHandler(new TypeAllDifferentHandler(this));
        this.addAxiomTypeTripleHandler(new TypeAllDisjointClassesHandler(this));
        this.addAxiomTypeTripleHandler(new TypeAllDisjointPropertiesHandler(this));
        this.addAxiomTypeTripleHandler(new TypeAllDifferentHandler(this));
        this.addAxiomTypeTripleHandler(new TypeNegativePropertyAssertionHandler(this));
    }

    private void addPredicateHandler(TriplePredicateHandler predicateHandler) {
        this.predicateHandlers.put(predicateHandler.getPredicateIRI(), predicateHandler);
    }

    private void setupPredicateHandlers() {
        this.predicateHandlers = CollectionFactory.createMap();
        this.addPredicateHandler(new TPDataPropertDomainHandler(this));
        this.addPredicateHandler(new TPDataPropertyRangeHandler(this));
        this.addPredicateHandler(new TPDifferentFromHandler(this));
        this.addPredicateHandler(new TPDisjointDataPropertiesHandler(this));
        this.addPredicateHandler(new TPDisjointObjectPropertiesHandler(this));
        this.addPredicateHandler(new TPDisjointUnionHandler(this));
        this.addPredicateHandler(new TPDisjointWithHandler(this));
        this.addPredicateHandler(new TPEquivalentClassHandler(this));
        this.addPredicateHandler(new TPEquivalentDataPropertyHandler(this));
        this.addPredicateHandler(new TPEquivalentObjectPropertyHandler(this));
        this.addPredicateHandler(new TPEquivalentPropertyHandler(this));
        this.addPredicateHandler(new TPObjectPropertyDomainHandler(this));
        this.addPredicateHandler(new TPObjectPropertyRangeHandler(this));
        this.addPredicateHandler(new TPPropertyDomainHandler(this));
        this.addPredicateHandler(new TPPropertyRangeHandler(this));
        this.addPredicateHandler(new TPSameAsHandler(this));
        this.addPredicateHandler(new TPSubClassOfHandler(this));
        this.addPredicateHandler(new TPSubDataPropertyOfHandler(this));
        this.addPredicateHandler(new TPSubObjectPropertyOfHandler(this));
        this.addPredicateHandler(new TPSubPropertyOfHandler(this));
        this.addPredicateHandler(new TPTypeHandler(this));
        this.addPredicateHandler(new TPInverseOfHandler(this));
        this.addPredicateHandler(new TPDistinctMembersHandler(this));
        this.addPredicateHandler(new TPImportsHandler(this));
        this.addPredicateHandler(new TPIntersectionOfHandler(this));
        this.addPredicateHandler(new TPUnionOfHandler(this));
        this.addPredicateHandler(new TPComplementOfHandler(this));
        this.addPredicateHandler(new TPOneOfHandler(this));
        this.addPredicateHandler(new TPOnPropertyHandler(this));
        this.addPredicateHandler(new TPSomeValuesFromHandler(this));
        this.addPredicateHandler(new TPAllValuesFromHandler(this));
        this.addPredicateHandler(new TPRestHandler(this));
        this.addPredicateHandler(new TPFirstResourceHandler(this));
        this.addPredicateHandler(new TPDeclaredAsHandler(this));
        this.addPredicateHandler(new TPHasKeyHandler(this));
        this.addPredicateHandler(new TPVersionIRIHandler(this));
        this.addPredicateHandler(new TPPropertyChainAxiomHandler(this));
        this.addPredicateHandler(new TPAnnotatedSourceHandler(this));
        this.addPredicateHandler(new TPPropertyDisjointWithHandler(this));
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public Set<OWLAnnotation> getPendingAnnotations() {
        if (!this.pendingAnnotations.isEmpty()) {
            HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>(this.pendingAnnotations);
            this.pendingAnnotations.clear();
            return annos;
        }
        return Collections.emptySet();
    }

    public void setPendingAnnotations(Set<OWLAnnotation> annotations) {
        if (!this.pendingAnnotations.isEmpty()) {
            throw new OWLRuntimeException(this.pendingAnnotations.size() + " pending annotations should have been used by now.");
        }
        this.pendingAnnotations.addAll(annotations);
    }

    private IRI getIRI(String s) {
        IRI iri = null;
        if (this.iriProvider != null) {
            iri = this.iriProvider.getIRI(s);
        }
        if (iri != null) {
            return iri;
        }
        iri = this.IRIMap.get(s);
        if (iri == null) {
            iri = IRI.create(s);
            this.IRIMap.put(s, iri);
        }
        return iri;
    }

    public void importsClosureChanged() {
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            for (OWLAnnotationProperty prop : ont.getAnnotationPropertiesInSignature()) {
                this.annotationPropertyIRIs.add(prop.getIRI());
            }
        }
    }

    protected boolean isAnonymousNode(IRI iri) {
        return this.anonymousNodeChecker.isAnonymousNode(iri);
    }

    protected boolean isSharedAnonymousNode(IRI iri) {
        return this.anonymousNodeChecker.isAnonymousSharedNode(iri.toString());
    }

    protected void addSharedAnonymousNode(IRI iri, Object translation) {
        this.sharedAnonymousNodes.put(iri, translation);
    }

    protected Object getSharedAnonymousNode(IRI iri) {
        return this.sharedAnonymousNodes.get(iri);
    }

    protected void addAxiom(OWLAxiom axiom) {
        this.owlOntologyManager.applyChange(new AddAxiom(this.ontology, axiom));
        this.lastAddedAxiom = axiom;
    }

    protected void applyChange(OWLOntologyChange change) {
        this.owlOntologyManager.applyChange(change);
    }

    protected void setOntologyID(OWLOntologyID ontologyID) {
        this.applyChange(new SetOntologyID(this.ontology, ontologyID));
    }

    protected void addOntologyAnnotation(OWLAnnotation annotation) {
        this.applyChange(new AddOntologyAnnotation(this.getOntology(), annotation));
    }

    protected void addImport(OWLImportsDeclaration declaration) {
        this.applyChange(new AddImport(this.ontology, declaration));
    }

    public OWLAxiom getLastAddedAxiom() {
        return this.lastAddedAxiom;
    }

    protected void addOWLClass(IRI iri) {
        this.owlClassIRIs.add(iri);
    }

    protected void addOWLObjectProperty(IRI iri) {
        this.objectPropertyIRIs.add(iri);
    }

    protected void addIndividual(IRI iri) {
        this.individualIRIs.add(iri);
    }

    protected boolean isIndividual(IRI iri) {
        return this.individualIRIs.contains(iri);
    }

    protected void addRDFProperty(IRI iri) {
        this.propertyIRIs.add(iri);
    }

    protected boolean isRDFProperty(IRI iri) {
        return this.propertyIRIs.contains(iri);
    }

    protected void addOWLDataProperty(IRI iri) {
        this.dataPropertyIRIs.add(iri);
    }

    protected void addOWLDatatype(IRI iri) {
        this.dataRangeIRIs.add(iri);
    }

    public void addOWLDataRange(IRI iri) {
        this.dataRangeIRIs.add(iri);
    }

    protected void addRestriction(IRI iri) {
        this.restrictionIRIs.add(iri);
    }

    protected void addAnnotationProperty(IRI iri) {
        this.annotationPropertyIRIs.add(iri);
    }

    protected void addAnnotationIRI(IRI iri) {
        this.annotationIRIs.add(iri);
    }

    protected boolean isAnnotation(IRI iri) {
        return this.annotationIRIs.contains(iri);
    }

    public boolean isRestriction(IRI iri) {
        return this.restrictionIRIs.contains(iri);
    }

    protected boolean isClass(IRI iri) {
        if (this.owlClassIRIs.contains(iri)) {
            return true;
        }
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            if (!ont.containsClassInSignature(iri)) continue;
            return true;
        }
        return false;
    }

    protected boolean isObjectPropertyOnly(IRI iri) {
        if (iri == null) {
            return false;
        }
        if (this.dataPropertyIRIs.contains(iri)) {
            return false;
        }
        if (this.objectPropertyIRIs.contains(iri)) {
            return true;
        }
        boolean containsObjectPropertyReference = false;
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            if (ont.containsDataPropertyInSignature(iri)) {
                this.dataPropertyIRIs.add(iri);
                return false;
            }
            if (!ont.containsObjectPropertyInSignature(iri)) continue;
            containsObjectPropertyReference = true;
            this.objectPropertyIRIs.add(iri);
        }
        return containsObjectPropertyReference;
    }

    protected boolean isDataPropertyOnly(IRI iri) {
        if (this.objectPropertyIRIs.contains(iri)) {
            return false;
        }
        if (this.dataPropertyIRIs.contains(iri)) {
            return true;
        }
        boolean containsDataPropertyReference = false;
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            if (ont.containsObjectPropertyInSignature(iri)) {
                return false;
            }
            if (!ont.containsDataPropertyInSignature(iri)) continue;
            containsDataPropertyReference = true;
        }
        return containsDataPropertyReference;
    }

    protected boolean isOntologyProperty(IRI iri) {
        return this.ontologyPropertyIRIs.contains(iri);
    }

    protected boolean isAnnotationProperty(IRI iri) {
        if (this.annotationPropertyIRIs.contains(iri)) {
            return true;
        }
        for (OWLOntology ont : this.owlOntologyManager.getImportsClosure(this.ontology)) {
            if (ont.equals(this.ontology)) continue;
            for (OWLAnnotationProperty prop : ont.getAnnotationPropertiesInSignature()) {
                this.annotationPropertyIRIs.add(prop.getIRI());
            }
        }
        return false;
    }

    protected boolean isOntology(IRI iri) {
        return this.ontologyIRIs.contains(iri);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    public void addAnnotatedSource(IRI annotatedAnonSource, IRI annotationMainNode) {
        Set<IRI> annotationMainNodes = this.annotatedAnonSource2AnnotationMap.get(annotatedAnonSource);
        if (annotationMainNodes == null) {
            annotationMainNodes = new HashSet<IRI>();
            this.annotatedAnonSource2AnnotationMap.put(annotatedAnonSource, annotationMainNodes);
        }
        annotationMainNodes.add(annotationMainNode);
    }

    public Set<IRI> getAnnotatedSourceAnnotationMainNodes(IRI source) {
        Set<IRI> mainNodes = this.annotatedAnonSource2AnnotationMap.get(source);
        if (mainNodes != null) {
            return mainNodes;
        }
        return Collections.emptySet();
    }

    protected OWLClass getOWLClass(IRI iri) {
        return this.getDataFactory().getOWLClass(iri);
    }

    protected OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.getDataFactory().getOWLObjectProperty(iri);
    }

    protected OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.getDataFactory().getOWLDataProperty(iri);
    }

    protected OWLIndividual getOWLIndividual(IRI iri) {
        if (this.isAnonymousNode(iri)) {
            return this.getDataFactory().getOWLAnonymousIndividual(iri.toString());
        }
        return this.getDataFactory().getOWLNamedIndividual(iri);
    }

    protected void consumeTriple(IRI subject, IRI predicate, IRI object) {
        this.isTriplePresent(subject, predicate, object, true);
    }

    protected void consumeTriple(IRI subject, IRI predicate, OWLLiteral con) {
        this.isTriplePresent(subject, predicate, con, true);
    }

    protected void addSWRLRule(IRI iri) {
        this.swrlRules.add(iri);
    }

    protected boolean isSWRLRule(IRI iri) {
        return this.swrlRules.contains(iri);
    }

    protected void addSWRLIndividualPropertyAtom(IRI iri) {
        this.swrlIndividualPropertyAtoms.add(iri);
    }

    protected boolean isSWRLIndividualPropertyAtom(IRI iri) {
        return this.swrlIndividualPropertyAtoms.contains(iri);
    }

    protected void addSWRLDataPropertyAtom(IRI iri) {
        this.swrlDataValuedPropertyAtoms.add(iri);
    }

    protected boolean isSWRLDataValuedPropertyAtom(IRI iri) {
        return this.swrlDataValuedPropertyAtoms.contains(iri);
    }

    protected void addSWRLClassAtom(IRI iri) {
        this.swrlClassAtoms.add(iri);
    }

    protected boolean isSWRLClassAtom(IRI iri) {
        return this.swrlClassAtoms.contains(iri);
    }

    protected void addSWRLSameAsAtom(IRI iri) {
        this.swrlSameAsAtoms.add(iri);
    }

    protected boolean isSWRLSameAsAtom(IRI iri) {
        return this.swrlSameAsAtoms.contains(iri);
    }

    protected void addSWRLDifferentFromAtom(IRI iri) {
        this.swrlDifferentFromAtoms.add(iri);
    }

    protected boolean isSWRLDifferentFromAtom(IRI iri) {
        return this.swrlDifferentFromAtoms.contains(iri);
    }

    protected void addSWRLDataRangeAtom(IRI iri) {
        this.swrlDataRangeAtoms.add(iri);
    }

    protected boolean isSWRLDataRangeAtom(IRI iri) {
        return this.swrlDataRangeAtoms.contains(iri);
    }

    protected void addSWRLBuiltInAtom(IRI iri) {
        this.swrlBuiltInAtoms.add(iri);
    }

    protected boolean isSWRLBuiltInAtom(IRI iri) {
        return this.swrlBuiltInAtoms.contains(iri);
    }

    protected void addSWRLVariable(IRI iri) {
        this.swrlVariables.add(iri);
    }

    protected boolean isSWRLVariable(IRI iri) {
        return this.swrlVariables.contains(iri);
    }

    public void handle(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        block5: {
            block3: {
                block4: {
                    if (!predicate.equals(OWLRDFVocabulary.RDF_TYPE.getIRI())) break block3;
                    BuiltInTypeHandler typeHandler = this.builtInTypeTripleHandlers.get(object);
                    if (typeHandler == null) break block4;
                    typeHandler.handleTriple(subject, predicate, object);
                    break block5;
                }
                if (this.axiomTypeTripleHandlers.get(object) != null) break block5;
                OWLIndividual ind = this.translateIndividual(subject);
                OWLClassExpression ce = this.translateClassExpression(object);
                this.addAxiom(this.dataFactory.getOWLClassAssertionAxiom(ce, ind, this.getPendingAnnotations()));
                break block5;
            }
            AbstractResourceTripleHandler handler = this.predicateHandlers.get(predicate);
            if (handler != null && handler.canHandle(subject, predicate, object)) {
                handler.handleTriple(subject, predicate, object);
            } else {
                for (AbstractResourceTripleHandler resHandler : this.resourceTripleHandlers) {
                    if (!resHandler.canHandle(subject, predicate, object)) continue;
                    resHandler.handleTriple(subject, predicate, object);
                    break;
                }
            }
        }
    }

    public void handle(IRI subject, IRI predicate, OWLLiteral object) {
        for (AbstractLiteralTripleHandler handler : this.literalTripleHandlers) {
            if (!handler.canHandle(subject, predicate, object)) continue;
            handler.handleTriple(subject, predicate, object);
            break;
        }
    }

    private static void printTriple(Object subject, Object predicate, Object object, PrintWriter w) {
        w.append(subject.toString());
        w.append(" -> ");
        w.append(predicate.toString());
        w.append(" -> ");
        w.append(object.toString());
        w.append("\n");
    }

    private void dumpRemainingTriples() {
        Set objects;
        OWLAnnotationValue object;
        Map<IRI, Object> map;
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        for (IRI predicate : this.singleValuedResTriplesByPredicate.keySet()) {
            map = this.singleValuedResTriplesByPredicate.get(predicate);
            for (IRI subject : map.keySet()) {
                object = (IRI)map.get(subject);
                OWLRDFConsumer.printTriple(subject, predicate, object, w);
            }
        }
        for (IRI predicate : this.singleValuedLitTriplesByPredicate.keySet()) {
            map = this.singleValuedLitTriplesByPredicate.get(predicate);
            for (IRI subject : map.keySet()) {
                object = (OWLLiteral)map.get(subject);
                OWLRDFConsumer.printTriple(subject, predicate, object, w);
            }
        }
        for (IRI subject : new ArrayList<IRI>(this.resTriplesBySubject.keySet())) {
            map = this.resTriplesBySubject.get(subject);
            for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                objects = (Set)map.get(predicate);
                for (OWLAnnotationValue object2 : objects) {
                    OWLRDFConsumer.printTriple(subject, predicate, object2, w);
                }
            }
        }
        for (IRI subject : new ArrayList<IRI>(this.litTriplesBySubject.keySet())) {
            map = this.litTriplesBySubject.get(subject);
            for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                objects = (Set)map.get(predicate);
                for (OWLAnnotationValue object2 : objects) {
                    OWLRDFConsumer.printTriple(subject, predicate, object2, w);
                }
            }
        }
        w.flush();
        logger.fine(sw.getBuffer().toString());
    }

    private void incrementTripleCount() {
        ++this.count;
        if (tripleProcessor.isLoggable(Level.FINE) && this.count % 10000 == 0) {
            tripleProcessor.fine("Parsed: " + this.count + " triples");
        }
    }

    @Override
    public void startModel(String string) throws SAXException {
        this.count = 0;
    }

    @Override
    public void endModel() throws SAXException {
        try {
            IRI ontologyIRIToSet;
            this.IRIMap.clear();
            tripleProcessor.fine("Total number of triples: " + this.count);
            RDFXMLOntologyFormat format = this.getOntologyFormat();
            this.consumeSWRLRules();
            this.iterateResourceTriples(new ResourceTripleIterator<UnloadableImportException>(){

                @Override
                public void handleResourceTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
                    OWLRDFConsumer.this.handle(subject, predicate, object);
                }
            });
            this.iterateLiteralTriples(new LiteralTripleIterator<UnloadableImportException>(){

                @Override
                public void handleLiteralTriple(IRI subject, IRI predicate, OWLLiteral object) throws UnloadableImportException {
                    OWLRDFConsumer.this.handle(subject, predicate, object);
                }
            });
            this.consumeNonReservedPredicateTriples();
            this.consumeAnnotatedAxioms();
            if (format != null) {
                RDFOntologyFormat.ParserMetaData metaData = new RDFOntologyFormat.ParserMetaData(this.count, RDFOntologyFormat.OntologyHeaderStatus.PARSED_ONE_HEADER);
                format.setParserMetaData(metaData);
            }
            if ((ontologyIRIToSet = this.chooseOntologyIRI()) != null) {
                IRI versionIRI = this.ontology.getOntologyID().getVersionIRI();
                this.applyChange(new SetOntologyID(this.ontology, new OWLOntologyID(ontologyIRIToSet, versionIRI)));
            }
            if (tripleProcessor.isLoggable(Level.FINE)) {
                tripleProcessor.fine("Loaded " + this.ontology.getOntologyID());
            }
            this.dumpRemainingTriples();
            this.cleanup();
        }
        catch (UnloadableImportException e) {
            throw new TranslatedUnloadedImportException(e);
        }
    }

    private void consumeNonReservedPredicateTriples() throws UnloadableImportException {
        this.iterateResourceTriples(new ResourceTripleIterator<UnloadableImportException>(){

            @Override
            public void handleResourceTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
                if (!predicate.isReservedVocabulary()) {
                    for (AbstractResourceTripleHandler resTripHandler : OWLRDFConsumer.this.resourceTripleHandlers) {
                        if (!resTripHandler.canHandle(subject, predicate, object)) continue;
                        resTripHandler.handleTriple(subject, predicate, object);
                        break;
                    }
                }
            }
        });
    }

    private void consumeSWRLRules() {
        SWRLRuleTranslator translator = new SWRLRuleTranslator(this);
        for (IRI ruleIRI : this.swrlRules) {
            translator.translateRule(ruleIRI);
        }
    }

    private void consumeAnnotatedAxioms() throws UnloadableImportException {
        this.iterateResourceTriples(new ResourceTripleIterator<UnloadableImportException>(){

            @Override
            public void handleResourceTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
                BuiltInTypeHandler builtInTypeHandler = (BuiltInTypeHandler)OWLRDFConsumer.this.axiomTypeTripleHandlers.get(object);
                if (builtInTypeHandler != null && builtInTypeHandler.canHandle(subject, predicate, object)) {
                    builtInTypeHandler.handleTriple(subject, predicate, object);
                }
            }
        });
    }

    private IRI chooseOntologyIRI() {
        IRI ontologyIRIToSet = null;
        if (!this.ontologyIRIs.isEmpty()) {
            if (this.ontologyIRIs.size() == 1) {
                IRI ontologyIRI = this.ontologyIRIs.iterator().next();
                if (!this.isAnonymousNode(ontologyIRI)) {
                    ontologyIRIToSet = ontologyIRI;
                }
            } else {
                HashSet<IRI> candidateIRIs = new HashSet<IRI>(this.ontologyIRIs);
                for (OWLAnnotation anno : this.ontology.getAnnotations()) {
                    IRI iri;
                    if (!(anno.getValue() instanceof IRI) || !this.ontologyIRIs.contains(iri = (IRI)anno.getValue())) continue;
                    candidateIRIs.remove(iri);
                }
                if (candidateIRIs.contains(this.firstOntologyIRI)) {
                    ontologyIRIToSet = this.firstOntologyIRI;
                } else if (!candidateIRIs.isEmpty()) {
                    ontologyIRIToSet = (IRI)candidateIRIs.iterator().next();
                }
            }
        }
        return ontologyIRIToSet;
    }

    private void cleanup() {
        this.owlClassIRIs.clear();
        this.objectPropertyIRIs.clear();
        this.dataPropertyIRIs.clear();
        this.dataRangeIRIs.clear();
        this.restrictionIRIs.clear();
        this.listFirstLiteralTripleMap.clear();
        this.listFirstResourceTripleMap.clear();
        this.listRestTripleMap.clear();
        this.translatedClassExpression.clear();
        this.listIRIs.clear();
        this.resTriplesBySubject.clear();
        this.litTriplesBySubject.clear();
        this.singleValuedLitTriplesByPredicate.clear();
        this.singleValuedResTriplesByPredicate.clear();
    }

    @Override
    public void addModelAttribte(String string, String string1) throws SAXException {
    }

    @Override
    public void includeModel(String string, String string1) throws SAXException {
    }

    @Override
    public void logicalURI(String string) throws SAXException {
    }

    public IRI checkForSynonym(IRI original) {
        IRI synonymIRI;
        if (!this.strict && (synonymIRI = this.synonymMap.get(original)) != null) {
            return synonymIRI;
        }
        return original;
    }

    @Override
    public void statementWithLiteralValue(String subject, String predicate, String object, String lang, String datatype) throws SAXException {
        this.incrementTripleCount();
        IRI subjectIRI = this.getIRI(subject);
        IRI predicateIRI = this.getIRI(predicate);
        predicateIRI = this.checkForSynonym(predicateIRI);
        this.handleStreaming(subjectIRI, predicateIRI, object, datatype, lang);
    }

    @Override
    public void statementWithResourceValue(String subject, String predicate, String object) throws SAXException {
        try {
            this.incrementTripleCount();
            IRI subjectIRI = this.getIRI(subject);
            IRI predicateIRI = this.getIRI(predicate);
            predicateIRI = this.checkForSynonym(predicateIRI);
            IRI objectIRI = this.checkForSynonym(this.getIRI(object));
            this.handleStreaming(subjectIRI, predicateIRI, objectIRI);
        }
        catch (UnloadableImportException e) {
            throw new TranslatedUnloadedImportException(e);
        }
    }

    private void handleStreaming(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        boolean consumed = false;
        if (predicate.equals(OWLRDFVocabulary.RDF_TYPE.getIRI())) {
            BuiltInTypeHandler handler = this.builtInTypeTripleHandlers.get(object);
            if (handler != null) {
                if (handler.canHandleStreaming(subject, predicate, object)) {
                    handler.handleTriple(subject, predicate, object);
                    consumed = true;
                }
            } else if (this.axiomTypeTripleHandlers.get(object) == null) {
                this.addIndividual(subject);
            } else {
                this.addAxiom(subject);
            }
        } else {
            AbstractResourceTripleHandler handler = this.predicateHandlers.get(predicate);
            if (handler != null && handler.canHandleStreaming(subject, predicate, object)) {
                handler.handleTriple(subject, predicate, object);
                consumed = true;
            }
        }
        if (!consumed) {
            this.addTriple(subject, predicate, object);
        }
    }

    private void handleStreaming(IRI subject, IRI predicate, String literal, String datatype, String lang) {
        OWLLiteral con = this.getOWLLiteral(literal, datatype, lang);
        AbstractLiteralTripleHandler skosHandler = this.skosLiteralTripleHandlers.get(predicate);
        if (skosHandler != null) {
            skosHandler.handleTriple(subject, predicate, con);
            return;
        }
        for (AbstractLiteralTripleHandler handler : this.literalTripleHandlers) {
            if (!handler.canHandleStreaming(subject, predicate, con)) continue;
            handler.handleTriple(subject, predicate, con);
            return;
        }
        this.addTriple(subject, predicate, con);
    }

    private OWLLiteral getOWLLiteral(String literal, String datatype, String lang) {
        if (datatype != null) {
            return this.dataFactory.getOWLLiteral(literal, this.dataFactory.getOWLDatatype(this.getIRI(datatype)));
        }
        return this.dataFactory.getOWLLiteral(literal, lang);
    }

    public OWLDataRange translateDataRange(IRI iri) {
        IRI oneOfObject = this.getResourceObject(iri, OWLRDFVocabulary.OWL_ONE_OF.getIRI(), true);
        if (oneOfObject != null) {
            Set<OWLLiteral> literals = this.translateToConstantSet(oneOfObject);
            return this.dataFactory.getOWLDataOneOf(literals);
        }
        IRI intersectionOfObject = this.getResourceObject(iri, OWLRDFVocabulary.OWL_INTERSECTION_OF.getIRI(), true);
        if (intersectionOfObject != null) {
            Set<OWLDataRange> dataRanges = this.translateToDataRangeSet(intersectionOfObject);
            return this.dataFactory.getOWLDataIntersectionOf(dataRanges);
        }
        IRI unionOfObject = this.getResourceObject(iri, OWLRDFVocabulary.OWL_UNION_OF.getIRI(), true);
        if (unionOfObject != null) {
            Set<OWLDataRange> dataRanges = this.translateToDataRangeSet(unionOfObject);
            return this.dataFactory.getOWLDataUnionOf(dataRanges);
        }
        IRI complementOfObject = this.getResourceObject(iri, OWLRDFVocabulary.OWL_DATATYPE_COMPLEMENT_OF.getIRI(), true);
        if (!this.strict && complementOfObject == null) {
            complementOfObject = this.getResourceObject(iri, OWLRDFVocabulary.OWL_COMPLEMENT_OF.getIRI(), true);
        }
        if (complementOfObject != null) {
            OWLDataRange operand = this.translateDataRange(complementOfObject);
            return this.dataFactory.getOWLDataComplementOf(operand);
        }
        IRI onDatatypeObject = this.getResourceObject(iri, OWLRDFVocabulary.OWL_ON_DATA_TYPE.getIRI(), true);
        if (onDatatypeObject != null) {
            OWLDatatype restrictedDataRange = (OWLDatatype)this.translateDataRange(onDatatypeObject);
            this.getResourceObject(iri, OWLRDFVocabulary.RDF_TYPE.getIRI(), true);
            HashSet<OWLFacetRestriction> restrictions = new HashSet();
            IRI facetRestrictionList = this.getResourceObject(iri, OWLRDFVocabulary.OWL_WITH_RESTRICTIONS.getIRI(), true);
            if (facetRestrictionList != null) {
                restrictions = this.translateToFacetRestrictionSet(facetRestrictionList);
            } else if (!this.strict) {
                for (IRI facetIRI : OWLFacet.FACET_IRIS) {
                    OWLLiteral val;
                    while ((val = this.getLiteralObject(iri, facetIRI, true)) != null) {
                        restrictions.add(this.dataFactory.getOWLFacetRestriction(OWLFacet.getFacet(facetIRI), val));
                    }
                }
            }
            return this.dataFactory.getOWLDatatypeRestriction(restrictedDataRange, restrictions);
        }
        return this.dataFactory.getOWLDatatype(iri);
    }

    public OWLDataPropertyExpression translateDataPropertyExpression(IRI iri) {
        return this.dataFactory.getOWLDataProperty(iri);
    }

    public OWLObjectPropertyExpression translateObjectPropertyExpression(IRI mainNode) {
        OWLObjectPropertyExpression prop = this.translatedProperties.get(mainNode);
        if (prop != null) {
            return prop;
        }
        if (!this.isAnonymousNode(mainNode)) {
            prop = this.getDataFactory().getOWLObjectProperty(mainNode);
            this.translatedProperties.put(mainNode, prop);
            return prop;
        }
        IRI inverseOfObject = this.getResourceObject(mainNode, OWLRDFVocabulary.OWL_INVERSE_OF.getIRI(), true);
        if (inverseOfObject != null) {
            OWLObjectPropertyExpression otherProperty = this.translateObjectPropertyExpression(inverseOfObject);
            prop = this.getDataFactory().getOWLObjectInverseOf(otherProperty);
        } else {
            prop = this.getDataFactory().getOWLObjectInverseOf(this.getDataFactory().getOWLObjectProperty(mainNode));
        }
        this.translatedProperties.put(mainNode, prop);
        return prop;
    }

    public OWLIndividual translateIndividual(IRI node) {
        return this.getOWLIndividual(node);
    }

    public Set<OWLAnnotation> translateAnnotations(IRI mainNode) {
        HashSet<OWLAnnotation> annosOnMainNodeAnnotations = new HashSet<OWLAnnotation>();
        Set<IRI> annotationMainNodes = this.getAnnotatedSourceAnnotationMainNodes(mainNode);
        if (!annotationMainNodes.isEmpty()) {
            for (IRI annotationMainNode : annotationMainNodes) {
                annosOnMainNodeAnnotations.addAll(this.translateAnnotations(annotationMainNode));
            }
        }
        HashSet<OWLAnnotation> mainNodeAnnotations = new HashSet<OWLAnnotation>();
        Set<IRI> predicates = this.getPredicatesBySubject(mainNode);
        for (IRI predicate : predicates) {
            if (!this.isAnnotationProperty(predicate)) continue;
            IRI resVal = this.getResourceObject(mainNode, predicate, true);
            while (resVal != null) {
                OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(predicate);
                OWLAnnotationValue val = this.isAnonymousNode(resVal) ? this.getDataFactory().getOWLAnonymousIndividual(resVal.toString()) : resVal;
                mainNodeAnnotations.add(this.getDataFactory().getOWLAnnotation(prop, val, annosOnMainNodeAnnotations));
                resVal = this.getResourceObject(mainNode, predicate, true);
            }
            OWLLiteral litVal = this.getLiteralObject(mainNode, predicate, true);
            while (litVal != null) {
                OWLAnnotationProperty prop = this.getDataFactory().getOWLAnnotationProperty(predicate);
                mainNodeAnnotations.add(this.getDataFactory().getOWLAnnotation(prop, litVal, annosOnMainNodeAnnotations));
                litVal = this.getLiteralObject(mainNode, predicate, true);
            }
        }
        return mainNodeAnnotations;
    }

    public OWLClassExpression translateClassExpression(IRI mainNode) {
        if (!this.isAnonymousNode(mainNode)) {
            return this.dataFactory.getOWLClass(mainNode);
        }
        OWLClassExpression desc = this.translatedClassExpression.get(mainNode);
        if (desc == null) {
            ClassExpressionTranslator translator = this.classExpressionTranslatorSelector.getClassExpressionTranslator(mainNode);
            if (translator != null) {
                desc = translator.translate(mainNode);
                this.translatedClassExpression.put(mainNode, desc);
                this.restrictionIRIs.remove(mainNode);
            } else {
                return this.dataFactory.getOWLClass(mainNode);
            }
        }
        return desc;
    }

    public OWLClassExpression getClassExpressionIfTranslated(IRI mainNode) {
        return this.translatedClassExpression.get(mainNode);
    }

    public List<OWLObjectPropertyExpression> translateToObjectPropertyList(IRI mainNode) {
        return this.objectPropertyListTranslator.translateList(mainNode);
    }

    public List<OWLDataPropertyExpression> translateToDataPropertyList(IRI mainNode) {
        return this.dataPropertyListTranslator.translateList(mainNode);
    }

    public Set<OWLClassExpression> translateToClassExpressionSet(IRI mainNode) {
        return this.classExpressionListTranslator.translateToSet(mainNode);
    }

    public Set<OWLLiteral> translateToConstantSet(IRI mainNode) {
        return this.constantListTranslator.translateToSet(mainNode);
    }

    public Set<OWLIndividual> translateToIndividualSet(IRI mainNode) {
        return this.individualListTranslator.translateToSet(mainNode);
    }

    public Set<OWLDataRange> translateToDataRangeSet(IRI mainNode) {
        return this.dataRangeListTranslator.translateToSet(mainNode);
    }

    public Set<OWLFacetRestriction> translateToFacetRestrictionSet(IRI mainNode) {
        return this.faceRestrictionListTranslator.translateToSet(mainNode);
    }

    public Set<IRI> getPredicatesBySubject(IRI subject) {
        Map<IRI, Set<OWLLiteral>> predObjMapLit;
        HashSet<IRI> IRIs = new HashSet<IRI>();
        Map<IRI, Set<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null) {
            IRIs.addAll(predObjMap.keySet());
        }
        if ((predObjMapLit = this.litTriplesBySubject.get(subject)) != null) {
            IRIs.addAll(predObjMapLit.keySet());
        }
        return IRIs;
    }

    public IRI getResourceObject(IRI subject, IRI predicate, boolean consume) {
        Set<IRI> objects;
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            IRI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<IRI, Set<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            IRI object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
                if (predObjMap.isEmpty()) {
                    this.resTriplesBySubject.remove(subject);
                }
            }
            return object;
        }
        return null;
    }

    public OWLLiteral getLiteralObject(IRI subject, IRI predicate, boolean consume) {
        Set<OWLLiteral> objects;
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLLiteral obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj;
        }
        Map<IRI, Set<OWLLiteral>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null && !objects.isEmpty()) {
            OWLLiteral object = objects.iterator().next();
            if (consume) {
                objects.remove(object);
            }
            if (objects.isEmpty()) {
                predObjMap.remove(predicate);
            }
            return object;
        }
        return null;
    }

    public boolean isTriplePresent(IRI subject, IRI predicate, IRI object, boolean consume) {
        Set<IRI> objects;
        Map<IRI, IRI> subjPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            IRI obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<IRI, Set<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            if (objects.contains(object)) {
                if (consume) {
                    objects.remove(object);
                    if (objects.isEmpty()) {
                        predObjMap.remove(predicate);
                        if (predObjMap.isEmpty()) {
                            this.resTriplesBySubject.remove(subject);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isTriplePresent(IRI subject, IRI predicate, OWLLiteral object, boolean consume) {
        Set<OWLLiteral> objects;
        Map<IRI, OWLLiteral> subjPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjPredMap != null) {
            OWLLiteral obj = subjPredMap.get(subject);
            if (consume) {
                subjPredMap.remove(subject);
            }
            return obj != null;
        }
        Map<IRI, Set<OWLLiteral>> predObjMap = this.litTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            if (objects.contains(object)) {
                if (consume) {
                    objects.remove(object);
                    if (objects.isEmpty()) {
                        predObjMap.remove(predicate);
                        if (predObjMap.isEmpty()) {
                            this.litTriplesBySubject.remove(subject);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasPredicate(IRI subject, IRI predicate) {
        boolean b;
        Map<IRI, IRI> resPredMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (resPredMap != null) {
            return resPredMap.containsKey(subject);
        }
        Map<IRI, OWLLiteral> litPredMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (litPredMap != null) {
            return litPredMap.containsKey(subject);
        }
        Map<IRI, Set<IRI>> resPredObjMap = this.resTriplesBySubject.get(subject);
        if (resPredObjMap != null && (b = resPredObjMap.containsKey(predicate))) {
            return true;
        }
        Map<IRI, Set<OWLLiteral>> litPredObjMap = this.litTriplesBySubject.get(subject);
        if (litPredObjMap != null) {
            return litPredObjMap.containsKey(predicate);
        }
        return false;
    }

    public boolean hasPredicateObject(IRI subject, IRI predicate, IRI object) {
        Set<IRI> objects;
        Map<IRI, IRI> predMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (predMap != null) {
            IRI objectIRI = predMap.get(subject);
            if (objectIRI == null) {
                return false;
            }
            return objectIRI.equals(object);
        }
        Map<IRI, Set<IRI>> predObjMap = this.resTriplesBySubject.get(subject);
        if (predObjMap != null && (objects = predObjMap.get(predicate)) != null) {
            return objects.contains(object);
        }
        return false;
    }

    public void addList(IRI iri) {
        this.listIRIs.add(iri);
    }

    public boolean isList(IRI iri, boolean consume) {
        if (consume) {
            return this.listIRIs.remove(iri);
        }
        return this.listIRIs.contains(iri);
    }

    public void addRest(IRI subject, IRI object) {
        this.listRestTripleMap.put(subject, object);
    }

    public void addFirst(IRI subject, IRI object) {
        this.listFirstResourceTripleMap.put(subject, object);
    }

    public IRI getFirstResource(IRI subject, boolean consume) {
        if (consume) {
            return this.listFirstResourceTripleMap.remove(subject);
        }
        return this.listFirstResourceTripleMap.get(subject);
    }

    public OWLLiteral getFirstLiteral(IRI subject) {
        return this.listFirstLiteralTripleMap.get(subject);
    }

    public IRI getRest(IRI subject, boolean consume) {
        if (consume) {
            return this.listRestTripleMap.remove(subject);
        }
        return this.listRestTripleMap.get(subject);
    }

    public void addFirst(IRI subject, OWLLiteral object) {
        this.listFirstLiteralTripleMap.put(subject, object);
    }

    public void addOntology(IRI iri) {
        if (this.ontologyIRIs.isEmpty()) {
            this.firstOntologyIRI = iri;
        }
        this.ontologyIRIs.add(iri);
    }

    public Set<IRI> getOntologies() {
        return this.ontologyIRIs;
    }

    public void addAxiom(IRI axiomIRI) {
        this.axioms.add(axiomIRI);
    }

    public boolean isAxiom(IRI iri) {
        return this.axioms.contains(iri);
    }

    public boolean isDataRange(IRI iri) {
        return this.dataRangeIRIs.contains(iri);
    }

    public <E extends Throwable> void iterateResourceTriples(ResourceTripleIterator<E> iterator) throws E {
        for (IRI subject : new ArrayList<IRI>(this.resTriplesBySubject.keySet())) {
            Map<IRI, Set<IRI>> map = this.resTriplesBySubject.get(subject);
            if (map == null) continue;
            for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                Set<IRI> objects = map.get(predicate);
                if (objects == null) continue;
                for (IRI object : new ArrayList<IRI>(objects)) {
                    iterator.handleResourceTriple(subject, predicate, object);
                }
            }
        }
    }

    public <E extends Throwable> void iterateLiteralTriples(LiteralTripleIterator<E> iterator) throws E {
        for (IRI subject : new ArrayList<IRI>(this.litTriplesBySubject.keySet())) {
            Map<IRI, Set<OWLLiteral>> map = this.litTriplesBySubject.get(subject);
            if (map == null) continue;
            for (IRI predicate : new ArrayList<IRI>(map.keySet())) {
                Set<OWLLiteral> objects = map.get(predicate);
                for (OWLLiteral object : new ArrayList<OWLLiteral>(objects)) {
                    iterator.handleLiteralTriple(subject, predicate, object);
                }
            }
        }
    }

    public void addTriple(IRI subject, IRI predicate, IRI object) {
        Map<IRI, IRI> subjObjMap = this.singleValuedResTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, object);
        } else {
            Set<IRI> objects;
            Map<IRI, Set<IRI>> map = this.resTriplesBySubject.get(subject);
            if (map == null) {
                map = CollectionFactory.createMap();
                this.resTriplesBySubject.put(subject, map);
            }
            if ((objects = map.get(predicate)) == null) {
                objects = new FakeSet<IRI>();
                map.put(predicate, objects);
            }
            objects.add(object);
        }
    }

    public void addTriple(IRI subject, IRI predicate, OWLLiteral con) {
        Map<IRI, OWLLiteral> subjObjMap = this.singleValuedLitTriplesByPredicate.get(predicate);
        if (subjObjMap != null) {
            subjObjMap.put(subject, con);
        } else {
            Set<OWLLiteral> objects;
            Map<IRI, Set<OWLLiteral>> map = this.litTriplesBySubject.get(subject);
            if (map == null) {
                map = CollectionFactory.createMap();
                this.litTriplesBySubject.put(subject, map);
            }
            if ((objects = map.get(predicate)) == null) {
                objects = new FakeSet<OWLLiteral>();
                map.put(predicate, objects);
            }
            objects.add(con);
        }
    }

    public void setXMLBase(String base) {
        this.xmlBase = IRI.create(base);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeSet<O>
    extends ArrayList<O>
    implements Set<O> {
        public FakeSet() {
        }

        public FakeSet(Collection<? extends O> c) {
            super(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LiteralTripleIterator<E extends Throwable> {
        public void handleLiteralTriple(IRI var1, IRI var2, OWLLiteral var3) throws E;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ResourceTripleIterator<E extends Throwable> {
        public void handleResourceTriple(IRI var1, IRI var2, IRI var3) throws E;
    }
}

