/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import org.coode.owlapi.rdfxml.parser.AbstractLiteralTripleHandler;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.vocab.SKOSVocabulary;

public class SKOSDataTripleHandler
extends AbstractLiteralTripleHandler {
    private IRI iri;

    public SKOSDataTripleHandler(OWLRDFConsumer consumer, SKOSVocabulary v) {
        super(consumer);
        this.iri = v.getIRI();
    }

    public void handleTriple(IRI subject, IRI predicate, OWLLiteral object) {
        OWLNamedIndividual subj = this.getDataFactory().getOWLNamedIndividual(subject);
        OWLDataProperty prop = this.getDataFactory().getOWLDataProperty(predicate);
        this.addAxiom(this.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)prop, (OWLIndividual)subj, object));
    }

    public boolean canHandle(IRI subject, IRI predicate, OWLLiteral object) {
        return predicate.equals(this.iri);
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, OWLLiteral object) {
        return true;
    }
}

