/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Set;
import org.coode.owlapi.rdfxml.parser.BuiltInTypeHandler;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAxiomHandler
extends BuiltInTypeHandler {
    public TypeAxiomHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_AXIOM.getIRI());
    }

    public TypeAxiomHandler(OWLRDFConsumer consumer, IRI typeIRI) {
        super(consumer, typeIRI);
    }

    @Override
    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        return false;
    }

    protected IRI getTargetTriplePredicate() {
        return OWLRDFVocabulary.OWL_ANNOTATED_TARGET.getIRI();
    }

    protected IRI getPropertyTriplePredicate() {
        return OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY.getIRI();
    }

    protected IRI getSourceTriplePredicate() {
        return OWLRDFVocabulary.OWL_ANNOTATED_SOURCE.getIRI();
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        this.consumeTriple(subject, predicate, object);
        IRI annotatedSource = this.getObjectOfSourceTriple(subject);
        IRI annotatedProperty = this.getObjectOfPropertyTriple(subject);
        IRI annotatedTarget = this.getObjectOfTargetTriple(subject);
        OWLLiteral annotatedTargetLiteral = null;
        if (annotatedTarget == null) {
            annotatedTargetLiteral = this.getTargetLiteral(subject);
        }
        Set<OWLAnnotation> annotations = this.getConsumer().translateAnnotations(subject);
        this.getConsumer().setPendingAnnotations(annotations);
        if (annotatedTarget != null) {
            this.getConsumer().handle(annotatedSource, annotatedProperty, annotatedTarget);
        } else {
            this.getConsumer().handle(annotatedSource, annotatedProperty, annotatedTargetLiteral);
        }
        if (!annotations.isEmpty()) {
            OWLAxiom ax = this.getConsumer().getLastAddedAxiom();
            this.getConsumer().applyChange(new RemoveAxiom(this.getConsumer().getOntology(), ax.getAxiomWithoutAnnotations()));
        }
    }

    protected OWLAxiom handleAxiomTriples(IRI subjectTriple, IRI predicateTriple, IRI objectTriple, Set<OWLAnnotation> annotations) {
        return this.getConsumer().getLastAddedAxiom();
    }

    protected OWLAxiom handleAxiomTriples(IRI subjectTripleObject, IRI predicateTripleObject, OWLLiteral con, Set<OWLAnnotation> annotations) {
        this.getConsumer().handle(subjectTripleObject, predicateTripleObject, con);
        return this.getConsumer().getLastAddedAxiom();
    }

    private OWLLiteral getTargetLiteral(IRI subject) {
        OWLLiteral con = this.getConsumer().getLiteralObject(subject, this.getTargetTriplePredicate(), true);
        if (con == null) {
            con = this.getConsumer().getLiteralObject(subject, OWLRDFVocabulary.RDF_OBJECT.getIRI(), true);
        }
        return con;
    }

    private IRI getObjectOfTargetTriple(IRI mainNode) {
        IRI objectTripleObject = this.getConsumer().getResourceObject(mainNode, this.getTargetTriplePredicate(), true);
        if (objectTripleObject == null) {
            objectTripleObject = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.RDF_OBJECT.getIRI(), true);
        }
        if (objectTripleObject == null) {
            objectTripleObject = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.OWL_PROPERTY_CHAIN.getIRI(), true);
        }
        return objectTripleObject;
    }

    private IRI getObjectOfPropertyTriple(IRI subject) {
        IRI predicateTripleObject = this.getConsumer().getResourceObject(subject, this.getPropertyTriplePredicate(), true);
        if (predicateTripleObject == null) {
            predicateTripleObject = this.getConsumer().getResourceObject(subject, OWLRDFVocabulary.RDF_PREDICATE.getIRI(), true);
        }
        return predicateTripleObject;
    }

    private IRI getObjectOfSourceTriple(IRI mainNode) {
        IRI subjectTripleObject = this.getConsumer().getResourceObject(mainNode, this.getSourceTriplePredicate(), true);
        if (subjectTripleObject == null) {
            subjectTripleObject = this.getConsumer().getResourceObject(mainNode, OWLRDFVocabulary.RDF_SUBJECT.getIRI(), true);
        }
        return subjectTripleObject;
    }
}

