/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxiomType<C extends OWLAxiom> {
    private String name;
    private boolean owl2Axiom;
    private boolean nonSyntacticOWL2Axiom;
    private boolean isLogical;
    public final int index;
    public static final Set<AxiomType> AXIOM_TYPES;
    private static final Map<String, AxiomType> NAME_TYPE_MAP;
    private static int count;
    public static final AxiomType<OWLDeclarationAxiom> DECLARATION;
    public static final AxiomType<OWLEquivalentClassesAxiom> EQUIVALENT_CLASSES;
    public static final AxiomType<OWLSubClassOfAxiom> SUBCLASS_OF;
    public static final AxiomType<OWLDisjointClassesAxiom> DISJOINT_CLASSES;
    public static final AxiomType<OWLDisjointUnionAxiom> DISJOINT_UNION;
    public static final AxiomType<OWLClassAssertionAxiom> CLASS_ASSERTION;
    public static final AxiomType<OWLSameIndividualAxiom> SAME_INDIVIDUAL;
    public static final AxiomType<OWLDifferentIndividualsAxiom> DIFFERENT_INDIVIDUALS;
    public static final AxiomType<OWLObjectPropertyAssertionAxiom> OBJECT_PROPERTY_ASSERTION;
    public static final AxiomType<OWLNegativeObjectPropertyAssertionAxiom> NEGATIVE_OBJECT_PROPERTY_ASSERTION;
    public static final AxiomType<OWLDataPropertyAssertionAxiom> DATA_PROPERTY_ASSERTION;
    public static final AxiomType<OWLNegativeDataPropertyAssertionAxiom> NEGATIVE_DATA_PROPERTY_ASSERTION;
    public static final AxiomType<OWLEquivalentObjectPropertiesAxiom> EQUIVALENT_OBJECT_PROPERTIES;
    public static final AxiomType<OWLSubObjectPropertyOfAxiom> SUB_OBJECT_PROPERTY;
    public static final AxiomType<OWLInverseObjectPropertiesAxiom> INVERSE_OBJECT_PROPERTIES;
    public static final AxiomType<OWLFunctionalObjectPropertyAxiom> FUNCTIONAL_OBJECT_PROPERTY;
    public static final AxiomType<OWLInverseFunctionalObjectPropertyAxiom> INVERSE_FUNCTIONAL_OBJECT_PROPERTY;
    public static final AxiomType<OWLSymmetricObjectPropertyAxiom> SYMMETRIC_OBJECT_PROPERTY;
    public static final AxiomType<OWLAsymmetricObjectPropertyAxiom> ASYMMETRIC_OBJECT_PROPERTY;
    public static final AxiomType<OWLTransitiveObjectPropertyAxiom> TRANSITIVE_OBJECT_PROPERTY;
    public static final AxiomType<OWLReflexiveObjectPropertyAxiom> REFLEXIVE_OBJECT_PROPERTY;
    public static final AxiomType<OWLIrreflexiveObjectPropertyAxiom> IRREFLEXIVE_OBJECT_PROPERTY;
    public static final AxiomType<OWLObjectPropertyDomainAxiom> OBJECT_PROPERTY_DOMAIN;
    public static final AxiomType<OWLObjectPropertyRangeAxiom> OBJECT_PROPERTY_RANGE;
    public static final AxiomType<OWLDisjointObjectPropertiesAxiom> DISJOINT_OBJECT_PROPERTIES;
    public static final AxiomType<OWLSubPropertyChainOfAxiom> SUB_PROPERTY_CHAIN_OF;
    public static final AxiomType<OWLEquivalentDataPropertiesAxiom> EQUIVALENT_DATA_PROPERTIES;
    public static final AxiomType<OWLSubDataPropertyOfAxiom> SUB_DATA_PROPERTY;
    public static final AxiomType<OWLFunctionalDataPropertyAxiom> FUNCTIONAL_DATA_PROPERTY;
    public static final AxiomType<OWLDataPropertyDomainAxiom> DATA_PROPERTY_DOMAIN;
    public static final AxiomType<OWLDataPropertyRangeAxiom> DATA_PROPERTY_RANGE;
    public static final AxiomType<OWLDisjointDataPropertiesAxiom> DISJOINT_DATA_PROPERTIES;
    public static final AxiomType<OWLHasKeyAxiom> HAS_KEY;
    public static final AxiomType<SWRLRule> SWRL_RULE;
    public static final AxiomType<OWLAnnotationAssertionAxiom> ANNOTATION_ASSERTION;
    public static final AxiomType<OWLSubAnnotationPropertyOfAxiom> SUB_ANNOTATION_PROPERTY_OF;
    public static final AxiomType<OWLAnnotationPropertyRangeAxiom> ANNOTATION_PROPERTY_RANGE;
    public static final AxiomType<OWLAnnotationPropertyDomainAxiom> ANNOTATION_PROPERTY_DOMAIN;
    public static final AxiomType<OWLDatatypeDefinitionAxiom> DATATYPE_DEFINITION;

    private AxiomType(String name, boolean owl2Axiom, boolean nonSyntacticOWL2Axiom, boolean isLogical) {
        this.name = name;
        this.owl2Axiom = owl2Axiom;
        this.nonSyntacticOWL2Axiom = nonSyntacticOWL2Axiom;
        this.isLogical = isLogical;
        this.index = count++;
    }

    public String toString() {
        return this.name;
    }

    public boolean isOWL2Axiom() {
        return this.owl2Axiom;
    }

    public boolean isNonSyntacticOWL2Axiom() {
        return this.nonSyntacticOWL2Axiom;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLogical() {
        return this.isLogical;
    }

    public static Set<OWLAxiom> getAxiomsWithoutTypes(Set<OWLAxiom> sourceAxioms, AxiomType ... axiomType) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>(sourceAxioms);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (!((OWLAxiom)it.next()).isOfType(axiomType)) continue;
            it.remove();
        }
        return result;
    }

    public static Set<OWLAxiom> getAxiomsOfTypes(Set<OWLAxiom> sourceAxioms, AxiomType ... axiomType) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>(sourceAxioms);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            if (((OWLAxiom)it.next()).isOfType(axiomType)) continue;
            it.remove();
        }
        return result;
    }

    public static AxiomType getAxiomType(String name) {
        return NAME_TYPE_MAP.get(name);
    }

    public boolean isAxiomType(String name) {
        return NAME_TYPE_MAP.containsKey(name);
    }

    static {
        count = 0;
        DECLARATION = new AxiomType("Declaration", true, true, false);
        EQUIVALENT_CLASSES = new AxiomType("EquivalentClasses", false, false, true);
        SUBCLASS_OF = new AxiomType("SubClassOf", false, false, true);
        DISJOINT_CLASSES = new AxiomType("DisjointClasses", false, false, true);
        DISJOINT_UNION = new AxiomType("DisjointUnion", true, false, true);
        CLASS_ASSERTION = new AxiomType("ClassAssertion", false, false, true);
        SAME_INDIVIDUAL = new AxiomType("SameIndividual", false, false, true);
        DIFFERENT_INDIVIDUALS = new AxiomType("DifferentIndividuals", false, false, true);
        OBJECT_PROPERTY_ASSERTION = new AxiomType("ObjectPropertyAssertion", false, false, true);
        NEGATIVE_OBJECT_PROPERTY_ASSERTION = new AxiomType("NegativeObjectPropertyAssertion", true, false, true);
        DATA_PROPERTY_ASSERTION = new AxiomType("DataPropertyAssertion", false, false, true);
        NEGATIVE_DATA_PROPERTY_ASSERTION = new AxiomType("NegativeDataPropertyAssertion", true, false, true);
        EQUIVALENT_OBJECT_PROPERTIES = new AxiomType("EquivalentObjectProperties", false, false, true);
        SUB_OBJECT_PROPERTY = new AxiomType("SubObjectPropertyOf", false, false, true);
        INVERSE_OBJECT_PROPERTIES = new AxiomType("InverseObjectProperties", false, false, true);
        FUNCTIONAL_OBJECT_PROPERTY = new AxiomType("FunctionalObjectProperty", false, false, true);
        INVERSE_FUNCTIONAL_OBJECT_PROPERTY = new AxiomType("InverseFunctionalObjectProperty", false, false, true);
        SYMMETRIC_OBJECT_PROPERTY = new AxiomType("SymmetricObjectProperty", false, false, true);
        ASYMMETRIC_OBJECT_PROPERTY = new AxiomType("AsymmetricObjectProperty", true, true, true);
        TRANSITIVE_OBJECT_PROPERTY = new AxiomType("TransitiveObjectProperty", false, false, true);
        REFLEXIVE_OBJECT_PROPERTY = new AxiomType("ReflexiveObjectProperty", true, true, true);
        IRREFLEXIVE_OBJECT_PROPERTY = new AxiomType("IrrefexiveObjectProperty", true, true, true);
        OBJECT_PROPERTY_DOMAIN = new AxiomType("ObjectPropertyDomain", false, false, true);
        OBJECT_PROPERTY_RANGE = new AxiomType("ObjectPropertyRange", false, false, true);
        DISJOINT_OBJECT_PROPERTIES = new AxiomType("DisjointObjectProperties", true, true, true);
        SUB_PROPERTY_CHAIN_OF = new AxiomType("SubPropertyChainOf", true, true, true);
        EQUIVALENT_DATA_PROPERTIES = new AxiomType("EquivalentDataProperties", false, false, true);
        SUB_DATA_PROPERTY = new AxiomType("SubDataPropertyOf", false, false, true);
        FUNCTIONAL_DATA_PROPERTY = new AxiomType("FunctionalDataProperty", false, false, true);
        DATA_PROPERTY_DOMAIN = new AxiomType("DataPropertyDomain", false, false, true);
        DATA_PROPERTY_RANGE = new AxiomType("DataPropertyRange", false, false, true);
        DISJOINT_DATA_PROPERTIES = new AxiomType("DisjointDataProperties", true, true, true);
        HAS_KEY = new AxiomType("HasKey", true, true, true);
        SWRL_RULE = new AxiomType("Rule", false, false, true);
        ANNOTATION_ASSERTION = new AxiomType("AnnotationAssertion", false, false, false);
        SUB_ANNOTATION_PROPERTY_OF = new AxiomType("SubAnnotationPropertyOf", true, true, false);
        ANNOTATION_PROPERTY_RANGE = new AxiomType("AnnotationPropertyRangeOf", true, true, false);
        ANNOTATION_PROPERTY_DOMAIN = new AxiomType("AnnotationPropertyDomain", true, true, false);
        DATATYPE_DEFINITION = new AxiomType("DatatypeDefinition", true, true, true);
        AXIOM_TYPES = new HashSet<AxiomType>();
        AXIOM_TYPES.add(SUBCLASS_OF);
        AXIOM_TYPES.add(EQUIVALENT_CLASSES);
        AXIOM_TYPES.add(DISJOINT_CLASSES);
        AXIOM_TYPES.add(CLASS_ASSERTION);
        AXIOM_TYPES.add(SAME_INDIVIDUAL);
        AXIOM_TYPES.add(DIFFERENT_INDIVIDUALS);
        AXIOM_TYPES.add(OBJECT_PROPERTY_ASSERTION);
        AXIOM_TYPES.add(NEGATIVE_OBJECT_PROPERTY_ASSERTION);
        AXIOM_TYPES.add(DATA_PROPERTY_ASSERTION);
        AXIOM_TYPES.add(NEGATIVE_DATA_PROPERTY_ASSERTION);
        AXIOM_TYPES.add(OBJECT_PROPERTY_DOMAIN);
        AXIOM_TYPES.add(OBJECT_PROPERTY_RANGE);
        AXIOM_TYPES.add(DISJOINT_OBJECT_PROPERTIES);
        AXIOM_TYPES.add(SUB_OBJECT_PROPERTY);
        AXIOM_TYPES.add(EQUIVALENT_OBJECT_PROPERTIES);
        AXIOM_TYPES.add(INVERSE_OBJECT_PROPERTIES);
        AXIOM_TYPES.add(SUB_PROPERTY_CHAIN_OF);
        AXIOM_TYPES.add(FUNCTIONAL_OBJECT_PROPERTY);
        AXIOM_TYPES.add(INVERSE_FUNCTIONAL_OBJECT_PROPERTY);
        AXIOM_TYPES.add(SYMMETRIC_OBJECT_PROPERTY);
        AXIOM_TYPES.add(ASYMMETRIC_OBJECT_PROPERTY);
        AXIOM_TYPES.add(TRANSITIVE_OBJECT_PROPERTY);
        AXIOM_TYPES.add(REFLEXIVE_OBJECT_PROPERTY);
        AXIOM_TYPES.add(IRREFLEXIVE_OBJECT_PROPERTY);
        AXIOM_TYPES.add(DATA_PROPERTY_DOMAIN);
        AXIOM_TYPES.add(DATA_PROPERTY_RANGE);
        AXIOM_TYPES.add(DISJOINT_DATA_PROPERTIES);
        AXIOM_TYPES.add(SUB_DATA_PROPERTY);
        AXIOM_TYPES.add(EQUIVALENT_DATA_PROPERTIES);
        AXIOM_TYPES.add(FUNCTIONAL_DATA_PROPERTY);
        AXIOM_TYPES.add(DATATYPE_DEFINITION);
        AXIOM_TYPES.add(DISJOINT_UNION);
        AXIOM_TYPES.add(DECLARATION);
        AXIOM_TYPES.add(SWRL_RULE);
        AXIOM_TYPES.add(ANNOTATION_ASSERTION);
        AXIOM_TYPES.add(SUB_ANNOTATION_PROPERTY_OF);
        AXIOM_TYPES.add(ANNOTATION_PROPERTY_DOMAIN);
        AXIOM_TYPES.add(ANNOTATION_PROPERTY_RANGE);
        AXIOM_TYPES.add(HAS_KEY);
        NAME_TYPE_MAP = new HashMap<String, AxiomType>();
        for (AxiomType type : AXIOM_TYPES) {
            NAME_TYPE_MAP.put(type.name, type);
        }
    }
}

