/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.profiles.CycleInDatatypeDefinition;
import org.semanticweb.owlapi.profiles.DatatypeIRIAlsoUsedAsClassIRI;
import org.semanticweb.owlapi.profiles.OWL2Profile;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.UseOfBuiltInDatatypeInDatatypeDefinition;
import org.semanticweb.owlapi.profiles.UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.profiles.UseOfNonSimplePropertyInCardinalityRestriction;
import org.semanticweb.owlapi.profiles.UseOfNonSimplePropertyInDisjointPropertiesAxiom;
import org.semanticweb.owlapi.profiles.UseOfNonSimplePropertyInFunctionalPropertyAxiom;
import org.semanticweb.owlapi.profiles.UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.profiles.UseOfNonSimplePropertyInIrreflexivePropertyAxiom;
import org.semanticweb.owlapi.profiles.UseOfNonSimplePropertyInObjectHasSelf;
import org.semanticweb.owlapi.profiles.UseOfPropertyInChainCausesCycle;
import org.semanticweb.owlapi.profiles.UseOfReservedVocabularyForAnnotationPropertyIRI;
import org.semanticweb.owlapi.profiles.UseOfReservedVocabularyForClassIRI;
import org.semanticweb.owlapi.profiles.UseOfReservedVocabularyForDataPropertyIRI;
import org.semanticweb.owlapi.profiles.UseOfReservedVocabularyForIndividualIRI;
import org.semanticweb.owlapi.profiles.UseOfReservedVocabularyForObjectPropertyIRI;
import org.semanticweb.owlapi.profiles.UseOfReservedVocabularyForOntologyIRI;
import org.semanticweb.owlapi.profiles.UseOfReservedVocabularyForVersionIRI;
import org.semanticweb.owlapi.profiles.UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom;
import org.semanticweb.owlapi.profiles.UseOfUndeclaredAnnotationProperty;
import org.semanticweb.owlapi.profiles.UseOfUndeclaredClass;
import org.semanticweb.owlapi.profiles.UseOfUndeclaredDataProperty;
import org.semanticweb.owlapi.profiles.UseOfUndeclaredDatatype;
import org.semanticweb.owlapi.profiles.UseOfUndeclaredObjectProperty;
import org.semanticweb.owlapi.profiles.UseOfUnknownDatatype;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2DLProfile
implements OWLProfile {
    public String getName() {
        return "OWL 2 DL";
    }

    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2Profile owl2Profile = new OWL2Profile();
        OWLProfileReport report = owl2Profile.checkOntology(ontology);
        LinkedHashSet<OWLProfileViolation> violations = new LinkedHashSet<OWLProfileViolation>();
        if (!report.isInProfile()) {
            violations.addAll(report.getViolations());
        }
        OWLOntologyWalker walker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2DLProfileObjectVisitor visitor = new OWL2DLProfileObjectVisitor(walker, ontology.getOWLOntologyManager());
        walker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWL2DLProfileObjectVisitor
    extends OWLOntologyWalkerVisitor {
        private OWLObjectPropertyManager objectPropertyManager;
        private OWLOntologyManager manager;
        private Set<OWLProfileViolation> profileViolations;

        private OWL2DLProfileObjectVisitor(OWLOntologyWalker walker, OWLOntologyManager manager) {
            super(walker);
            this.objectPropertyManager = null;
            this.profileViolations = new HashSet<OWLProfileViolation>();
            this.manager = manager;
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        private OWLObjectPropertyManager getPropertyManager() {
            if (this.objectPropertyManager == null) {
                this.objectPropertyManager = new OWLObjectPropertyManager(this.manager, this.getCurrentOntology());
            }
            return this.objectPropertyManager;
        }

        @Override
        public Object visit(OWLOntology ontology) {
            OWLOntologyID ontologyID = ontology.getOntologyID();
            if (!ontologyID.isAnonymous()) {
                IRI versionIRI;
                if (ontologyID.getOntologyIRI().isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfReservedVocabularyForOntologyIRI(this.getCurrentOntology()));
                }
                if ((versionIRI = ontologyID.getVersionIRI()) != null && versionIRI.isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfReservedVocabularyForVersionIRI(this.getCurrentOntology()));
                }
            }
            this.objectPropertyManager = null;
            return super.visit(ontology);
        }

        @Override
        public Object visit(OWLClass desc) {
            if (!desc.isBuiltIn() && desc.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            if (!desc.isBuiltIn() && !this.getCurrentOntology().isDeclared(desc, true)) {
                this.profileViolations.add(new UseOfUndeclaredClass(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            if (this.getCurrentOntology().containsDatatypeInSignature(desc.getIRI())) {
                this.profileViolations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), desc.getIRI()));
            }
            return null;
        }

        @Override
        public Object visit(OWLDatatype datatype) {
            if (!OWL2Datatype.isBuiltIn(datatype.getIRI())) {
                if (!datatype.getIRI().toString().startsWith(Namespaces.XSD.toString()) && !datatype.isTopDatatype() && datatype.getIRI().isReservedVocabulary()) {
                    this.profileViolations.add(new UseOfUnknownDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), datatype));
                }
                if (!datatype.isTopDatatype() && datatype.isBuiltIn() && this.getCurrentOntology().isDeclared(datatype, true)) {
                    this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), this.getCurrentAxiom(), datatype));
                }
            }
            if (this.getCurrentOntology().containsClassInSignature(datatype.getIRI(), true)) {
                this.profileViolations.add(new DatatypeIRIAlsoUsedAsClassIRI(this.getCurrentOntology(), this.getCurrentAxiom(), datatype.getIRI()));
            }
            return null;
        }

        @Override
        public Object visit(OWLDatatypeDefinitionAxiom axiom) {
            if (axiom.getDatatype().getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfBuiltInDatatypeInDatatypeDefinition(this.getCurrentOntology(), axiom));
            }
            HashSet<OWLDatatype> datatypes = new HashSet<OWLDatatype>();
            LinkedHashSet<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();
            axioms.add(axiom);
            this.getDatatypesInSignature(datatypes, axiom.getDataRange(), axioms);
            if (datatypes.contains(axiom.getDatatype())) {
                this.profileViolations.add(new CycleInDatatypeDefinition(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        private void getDatatypesInSignature(Set<OWLDatatype> datatypes, OWLObject obj, Set<OWLAxiom> axioms) {
            for (OWLDatatype dt : obj.getDatatypesInSignature()) {
                if (!datatypes.add(dt)) continue;
                for (OWLOntology ont : this.getCurrentOntology().getImportsClosure()) {
                    for (OWLDatatypeDefinitionAxiom ax : ont.getDatatypeDefinitions(dt)) {
                        axioms.add(ax);
                        this.getDatatypesInSignature(datatypes, ax.getDataRange(), axioms);
                    }
                }
            }
        }

        @Override
        public Object visit(OWLObjectProperty property) {
            if (!property.isOWLTopObjectProperty() && !property.isOWLBottomObjectProperty() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForObjectPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, true)) {
                this.profileViolations.add(new UseOfUndeclaredObjectProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), true)) {
                // empty if block
            }
            if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), true)) {
                // empty if block
            }
            return null;
        }

        @Override
        public Object visit(OWLDataProperty property) {
            if (!property.isOWLTopDataProperty() && !property.isOWLBottomDataProperty() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForDataPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, true)) {
                this.profileViolations.add(new UseOfUndeclaredDataProperty(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), true)) {
                // empty if block
            }
            if (this.getCurrentOntology().containsAnnotationPropertyInSignature(property.getIRI(), true)) {
                // empty if block
            }
            return null;
        }

        @Override
        public Object visit(OWLAnnotationProperty property) {
            if (!property.isBuiltIn() && property.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForAnnotationPropertyIRI(this.getCurrentOntology(), this.getCurrentAxiom(), property));
            }
            if (!property.isBuiltIn() && !this.getCurrentOntology().isDeclared(property, true)) {
                this.profileViolations.add(new UseOfUndeclaredAnnotationProperty(this.getCurrentOntology(), this.getCurrentAxiom(), this.getCurrentAnnotation(), property));
            }
            if (this.getCurrentOntology().containsObjectPropertyInSignature(property.getIRI(), true)) {
                // empty if block
            }
            if (this.getCurrentOntology().containsDataPropertyInSignature(property.getIRI(), true)) {
                // empty if block
            }
            return null;
        }

        @Override
        public Object visit(OWLNamedIndividual individual) {
            if (!individual.isAnonymous() && individual.getIRI().isReservedVocabulary()) {
                this.profileViolations.add(new UseOfReservedVocabularyForIndividualIRI(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
            }
            return null;
        }

        @Override
        public Object visit(OWLSubDataPropertyOfAxiom axiom) {
            if (((OWLDataPropertyExpression)axiom.getSubProperty()).isOWLTopDataProperty()) {
                this.profileViolations.add(new UseOfTopDataPropertyAsSubPropertyInSubPropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        @Override
        public Object visit(OWLObjectMinCardinality desc) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            return null;
        }

        @Override
        public Object visit(OWLObjectMaxCardinality desc) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            return null;
        }

        @Override
        public Object visit(OWLObjectExactCardinality desc) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInCardinalityRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            return null;
        }

        @Override
        public Object visit(OWLObjectHasSelf desc) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)desc.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInObjectHasSelf(this.getCurrentOntology(), this.getCurrentAxiom(), desc));
            }
            return null;
        }

        @Override
        public Object visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInFunctionalPropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        @Override
        public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInInverseFunctionalObjectPropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        @Override
        public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInIrreflexivePropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        @Override
        public Object visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (this.getPropertyManager().isNonSimple((OWLObjectPropertyExpression)axiom.getProperty())) {
                this.profileViolations.add(new UseOfNonSimplePropertyInAsymmetricObjectPropertyAxiom(this.getCurrentOntology(), axiom));
            }
            return null;
        }

        @Override
        public Object visit(OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!this.getPropertyManager().isNonSimple(prop)) continue;
                this.profileViolations.add(new UseOfNonSimplePropertyInDisjointPropertiesAxiom(this.getCurrentOntology(), axiom, prop));
            }
            return null;
        }

        @Override
        public Object visit(OWLSubPropertyChainOfAxiom axiom) {
            OWLObjectPropertyExpression superProp;
            if (axiom.getPropertyChain().size() > 2 && !(superProp = axiom.getSuperProperty()).isOWLTopObjectProperty() && !axiom.isEncodingOfTransitiveProperty()) {
                int i;
                List<OWLObjectPropertyExpression> chain = axiom.getPropertyChain();
                if (chain.get(0).equals(superProp)) {
                    for (i = 1; i < chain.size(); ++i) {
                        if (this.getPropertyManager().isLessThan(chain.get(i), superProp)) continue;
                        this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, chain.get(i)));
                    }
                } else if (chain.get(chain.size() - 1).equals(superProp)) {
                    for (i = 0; i < chain.size() - 1; ++i) {
                        if (this.getPropertyManager().isLessThan(chain.get(i), superProp)) continue;
                        this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, chain.get(i)));
                    }
                }
                for (OWLObjectPropertyExpression sub : axiom.getPropertyChain()) {
                    if (this.getPropertyManager().isLessThan(sub, superProp)) continue;
                    this.profileViolations.add(new UseOfPropertyInChainCausesCycle(this.getCurrentOntology(), axiom, sub));
                }
            }
            return null;
        }
    }
}

