/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.UseOfAnonymousIndividual;
import org.semanticweb.owlapi.profiles.UseOfIllegalAxiom;
import org.semanticweb.owlapi.profiles.UseOfIllegalDataRange;
import org.semanticweb.owlapi.profiles.UseOfNonAtomicClassExpression;
import org.semanticweb.owlapi.profiles.UseOfNonSubClassExpression;
import org.semanticweb.owlapi.profiles.UseOfNonSuperClassExpression;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWL2QLProfile
implements OWLProfile {
    private Set<IRI> allowedDatatypes = new HashSet<IRI>();
    private OWL2QLSubClassExpressionChecker subClassExpressionChecker = new OWL2QLSubClassExpressionChecker();
    private OWL2QLSuperClassExpressionChecker superClassExpressionChecker = new OWL2QLSuperClassExpressionChecker();

    public OWL2QLProfile() {
        this.allowedDatatypes.add(OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI());
        this.allowedDatatypes.add(OWLRDFVocabulary.RDF_XML_LITERAL.getIRI());
        this.allowedDatatypes.add(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.OWL_REAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.OWL_RATIONAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_DECIMAL.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_INTEGER.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NON_NEGATIVE_INTEGER.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_STRING.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NORMALIZED_STRING.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_TOKEN.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NAME.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NCNAME.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_NMTOKEN.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_HEX_BINARY.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_BASE_64_BINARY.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_ANY_URI.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_DATE_TIME.getIRI());
        this.allowedDatatypes.add(OWL2Datatype.XSD_DATE_TIME_STAMP.getIRI());
    }

    public String getName() {
        return "OWL 2 QL";
    }

    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWL2DLProfile profile = new OWL2DLProfile();
        OWLProfileReport report = profile.checkOntology(ontology);
        HashSet<OWLProfileViolation> violations = new HashSet<OWLProfileViolation>();
        violations.addAll(report.getViolations());
        OWLOntologyWalker walker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2QLObjectVisitor visitor = new OWL2QLObjectVisitor(walker);
        walker.walkStructure(visitor);
        violations.addAll(visitor.getProfileViolations());
        return new OWLProfileReport(this, violations);
    }

    private boolean isOWL2QLSubClassExpression(OWLClassExpression ce) {
        return ce.accept(this.subClassExpressionChecker);
    }

    public boolean isOWL2QLSuperClassExpression(OWLClassExpression ce) {
        return ce.accept(this.superClassExpressionChecker);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWL2QLSuperClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        private OWL2QLSuperClassExpressionChecker() {
        }

        @Override
        public Boolean visit(OWLClass desc) {
            return true;
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf desc) {
            for (OWLClassExpression ce : desc.getOperands()) {
                if (ce.accept(this).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visit(OWLObjectUnionOf desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectComplementOf desc) {
            return OWL2QLProfile.this.isOWL2QLSubClassExpression(desc.getOperand());
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom desc) {
            return !((OWLClassExpression)desc.getFiller()).isAnonymous();
        }

        @Override
        public Boolean visit(OWLObjectAllValuesFrom desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectHasValue desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectMinCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectExactCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectMaxCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectHasSelf desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectOneOf desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom desc) {
            return true;
        }

        @Override
        public Boolean visit(OWLDataAllValuesFrom desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataHasValue desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataMinCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataExactCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataMaxCardinality desc) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWL2QLSubClassExpressionChecker
    implements OWLClassExpressionVisitorEx<Boolean> {
        private OWL2QLSubClassExpressionChecker() {
        }

        @Override
        public Boolean visit(OWLClass desc) {
            return true;
        }

        @Override
        public Boolean visit(OWLObjectIntersectionOf desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectUnionOf desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectComplementOf desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectSomeValuesFrom desc) {
            return ((OWLClassExpression)desc.getFiller()).isOWLThing();
        }

        @Override
        public Boolean visit(OWLObjectAllValuesFrom desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectHasValue desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectMinCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectExactCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectMaxCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectHasSelf desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLObjectOneOf desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataSomeValuesFrom desc) {
            return true;
        }

        @Override
        public Boolean visit(OWLDataAllValuesFrom desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataHasValue desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataMinCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataExactCardinality desc) {
            return false;
        }

        @Override
        public Boolean visit(OWLDataMaxCardinality desc) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWL2QLObjectVisitor
    extends OWLOntologyWalkerVisitor {
        private Set<OWLProfileViolation> profileViolations;

        private OWL2QLObjectVisitor(OWLOntologyWalker walker) {
            super(walker);
            this.profileViolations = new HashSet<OWLProfileViolation>();
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        @Override
        public Object visit(OWLDatatype node) {
            if (!OWL2QLProfile.this.allowedDatatypes.contains(node.getIRI())) {
                this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
            return null;
        }

        @Override
        public Object visit(OWLAnonymousIndividual individual) {
            this.profileViolations.add(new UseOfAnonymousIndividual(this.getCurrentOntology(), this.getCurrentAxiom(), individual));
            return null;
        }

        @Override
        public Object visit(OWLHasKeyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLSubClassOfAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSubClassExpression(axiom.getSubClass())) {
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), axiom, axiom.getSubClass()));
            }
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getSuperClass())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), axiom, axiom.getSuperClass()));
            }
            return null;
        }

        @Override
        public Object visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (OWL2QLProfile.this.isOWL2QLSubClassExpression(ce)) continue;
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), axiom, ce));
            }
            return null;
        }

        @Override
        public Object visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (OWL2QLProfile.this.isOWL2QLSubClassExpression(ce)) continue;
                this.profileViolations.add(new UseOfNonSubClassExpression(this.getCurrentOntology(), axiom, ce));
            }
            return null;
        }

        @Override
        public Object visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getDomain())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), axiom, axiom.getDomain()));
            }
            return null;
        }

        @Override
        public Object visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression((OWLClassExpression)axiom.getRange())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), axiom, (OWLClassExpression)axiom.getRange()));
            }
            return null;
        }

        @Override
        public Object visit(OWLSubPropertyChainOfAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLDataPropertyDomainAxiom axiom) {
            if (!OWL2QLProfile.this.isOWL2QLSuperClassExpression(axiom.getDomain())) {
                this.profileViolations.add(new UseOfNonSuperClassExpression(this.getCurrentOntology(), axiom, axiom.getDomain()));
            }
            return null;
        }

        @Override
        public Object visit(OWLClassAssertionAxiom axiom) {
            if (axiom.getClassExpression().isAnonymous()) {
                this.profileViolations.add(new UseOfNonAtomicClassExpression(this.getCurrentOntology(), axiom, axiom.getClassExpression()));
            }
            return null;
        }

        @Override
        public Object visit(OWLSameIndividualAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLDisjointUnionAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), axiom));
            return null;
        }

        @Override
        public Object visit(SWRLRule rule) {
            this.profileViolations.add(new UseOfIllegalAxiom(this.getCurrentOntology(), rule));
            return null;
        }

        @Override
        public Object visit(OWLDataComplementOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            return null;
        }

        @Override
        public Object visit(OWLDataOneOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            return null;
        }

        @Override
        public Object visit(OWLDatatypeRestriction node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            return null;
        }

        @Override
        public Object visit(OWLDataUnionOf node) {
            this.profileViolations.add(new UseOfIllegalDataRange(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            return null;
        }
    }
}

