/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.structural;

import org.semanticweb.owlapi.apibinding.OWLFunctionalSyntaxFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ConsoleProgressMonitor;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.structural.StructuralReasoner;
import org.semanticweb.owlapi.util.DefaultPrefixManager;

public class TestStructuralReasoner {
    public static void main(String[] args) {
        try {
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            NullReasonerProgressMonitor progressMonitor = new NullReasonerProgressMonitor();
            OWLOntology ont = man.loadOntologyFromOntologyDocument(IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl"));
            System.out.println("Loaded: " + ont);
            SimpleConfiguration configuration = new SimpleConfiguration(new ConsoleProgressMonitor());
            StructuralReasoner reasoner = new StructuralReasoner(ont, configuration, BufferingMode.NON_BUFFERING);
            long t0 = System.currentTimeMillis();
            reasoner.precomputeInferences(InferenceType.CLASS_HIERARCHY);
            long t1 = System.currentTimeMillis();
            System.out.println("Time to computeHierarchy reasoner: " + (t1 - t0));
            reasoner.dumpObjectPropertyHierarchy(false);
            Node<OWLClass> top = reasoner.getTopClassNode();
            for (Node node : reasoner.getSubClasses(top.getRepresentativeElement(), true)) {
                for (Node node2 : reasoner.getSubClasses((OWLClassExpression)node.getRepresentativeElement(), true)) {
                    System.out.println(node2);
                }
            }
            OWLDeclarationAxiom ax = OWLFunctionalSyntaxFactory.Declaration(OWLFunctionalSyntaxFactory.Class(IRI.create("http://www.co-ode.org/ontologies/pizza/pizza.owl#X")));
            DefaultPrefixManager defaultPrefixManager = new DefaultPrefixManager("http://www.co-ode.org/ontologies/pizza/pizza.owl#");
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            man.addAxiom(ont, ax);
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            man.addAxiom(ont, OWLFunctionalSyntaxFactory.SubClassOf(OWLFunctionalSyntaxFactory.Class("X", defaultPrefixManager), OWLFunctionalSyntaxFactory.Class("Y", defaultPrefixManager)));
            man.addAxiom(ont, OWLFunctionalSyntaxFactory.SubClassOf(OWLFunctionalSyntaxFactory.Class("Y", defaultPrefixManager), OWLFunctionalSyntaxFactory.Class("X", defaultPrefixManager)));
            man.addAxiom(ont, OWLFunctionalSyntaxFactory.SubClassOf(OWLFunctionalSyntaxFactory.Class("E", defaultPrefixManager), OWLFunctionalSyntaxFactory.Class("F", defaultPrefixManager)));
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            reasoner.isConsistent();
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }
}

