/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionFactory {
    public static <T> Set<T> createSet() {
        return new HashSet();
    }

    public static <T> Set<T> createSet(Collection<T> c) {
        return new HashSet<T>(c);
    }

    public static <T> Set<T> createSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <K, V> Map<K, V> createMap() {
        return new HashMap();
    }

    public static <T> Set<T> createSet(T ... elements) {
        Set<T> result = CollectionFactory.createSet();
        for (T t : elements) {
            result.add(t);
        }
        return result;
    }

    public static <T> Set<T> createSyncSet() {
        return new SyncSet();
    }

    public static <K, V> Map<K, V> createSyncMap() {
        return new ConcurrentHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SyncSet<T>
    implements Set<T> {
        private final ConcurrentHashMap<T, Set<T>> backingMap;

        public SyncSet(ConcurrentHashMap<T, Set<T>> map) {
            this.backingMap = map;
        }

        public SyncSet() {
            this(new ConcurrentHashMap());
        }

        @Override
        public boolean add(T e) {
            return this.backingMap.put(e, this) == null;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean toReturn = false;
            for (T o : c) {
                toReturn = toReturn || this.add(o);
            }
            return toReturn;
        }

        @Override
        public void clear() {
            this.backingMap.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.backingMap.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            boolean toReturn = true;
            for (Object o : c) {
                if (toReturn = toReturn && this.contains(o)) continue;
                return toReturn;
            }
            return toReturn;
        }

        @Override
        public boolean isEmpty() {
            return this.backingMap.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.backingMap.keySet().iterator();
        }

        @Override
        public int size() {
            return this.backingMap.size();
        }

        @Override
        public boolean remove(Object o) {
            return this.backingMap.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean toReturn = false;
            for (Object o : c) {
                toReturn = toReturn || this.remove(o);
            }
            return toReturn;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean toReturn = false;
            for (Map.Entry<T, Set<T>> e : this.backingMap.entrySet()) {
                if (c.contains(e.getKey())) continue;
                toReturn = true;
                this.backingMap.remove(e.getKey());
            }
            return toReturn;
        }

        @Override
        public Object[] toArray() {
            return this.backingMap.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.backingMap.keySet().toArray(a);
        }
    }
}

