/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPrefixManager
implements PrefixManager,
ShortFormProvider,
IRIShortFormProvider {
    private Map<String, String> prefix2NamespaceMap;

    public DefaultPrefixManager() {
        this.prefix2NamespaceMap = new HashMap<String, String>();
        this.setupDefaultPrefixes();
    }

    public DefaultPrefixManager(PrefixManager pm) {
        this.prefix2NamespaceMap = new HashMap<String, String>();
        for (String prefixName : pm.getPrefixNames()) {
            this.prefix2NamespaceMap.put(prefixName, pm.getPrefix(prefixName));
        }
        this.setupDefaultPrefixes();
    }

    public void clear() {
        this.prefix2NamespaceMap.clear();
    }

    @Override
    public Set<String> getPrefixNames() {
        return new HashSet<String>(this.prefix2NamespaceMap.keySet());
    }

    public DefaultPrefixManager(String defaultPrefix) {
        this.prefix2NamespaceMap = new TreeMap<String, String>(new StringLengthComparator());
        if (defaultPrefix != null) {
            this.setDefaultPrefix(defaultPrefix);
        }
        this.setupDefaultPrefixes();
    }

    private void setupDefaultPrefixes() {
        this.setPrefix("owl:", Namespaces.OWL.toString());
        this.setPrefix("rdfs:", Namespaces.RDFS.toString());
        this.setPrefix("rdf:", Namespaces.RDF.toString());
        this.setPrefix("xsd:", Namespaces.XSD.toString());
        this.setPrefix("skos:", Namespaces.SKOS.toString());
        this.setPrefix("xml:", Namespaces.XML.toString());
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.setPrefix(":", defaultPrefix);
    }

    @Override
    public String getPrefixIRI(IRI iri) {
        String iriString = iri.toString();
        for (String prefixName : this.prefix2NamespaceMap.keySet()) {
            String prefix = this.prefix2NamespaceMap.get(prefixName);
            if (!iriString.startsWith(prefix)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(prefixName);
            String localName = iriString.substring(prefix.length());
            sb.append(localName);
            return sb.toString();
        }
        return null;
    }

    @Override
    public String getDefaultPrefix() {
        return this.prefix2NamespaceMap.get(":");
    }

    @Override
    public boolean containsPrefixMapping(String prefix) {
        return this.prefix2NamespaceMap.containsKey(prefix) && this.prefix2NamespaceMap.get(prefix) != null;
    }

    @Override
    public IRI getIRI(String curie) {
        if (curie.startsWith("<")) {
            return IRI.create(curie.substring(1, curie.length() - 1));
        }
        int sep = curie.indexOf(58);
        if (sep == -1) {
            if (this.getDefaultPrefix() != null) {
                return IRI.create(this.getDefaultPrefix() + curie);
            }
            return IRI.create(curie);
        }
        String prefixName = curie.substring(0, sep + 1);
        if (!this.containsPrefixMapping(prefixName)) {
            throw new RuntimeException("Prefix not registered for prefix name: " + prefixName);
        }
        String prefix = this.getPrefix(prefixName);
        String localName = curie.substring(sep + 1);
        return IRI.create(prefix + localName);
    }

    @Override
    public Map<String, String> getPrefixName2PrefixMap() {
        return Collections.unmodifiableMap(this.prefix2NamespaceMap);
    }

    @Override
    public String getPrefix(String prefixName) {
        return this.prefix2NamespaceMap.get(prefixName);
    }

    public void setPrefix(String prefixName, String prefix) {
        if (prefix == null) {
            throw new NullPointerException("Prefix name must not be null");
        }
        if (!prefixName.endsWith(":")) {
            throw new IllegalArgumentException("Prefix names must end with a colon (:)");
        }
        this.prefix2NamespaceMap.put(prefixName, prefix);
    }

    public void unregisterNamespace(String namespace) {
        Iterator<String> it = this.prefix2NamespaceMap.values().iterator();
        while (it.hasNext()) {
            if (!it.next().equals(namespace)) continue;
            it.remove();
            return;
        }
    }

    @Override
    public String getShortForm(IRI iri) {
        String sf = this.getPrefixIRI(iri);
        if (sf == null) {
            return iri.toQuotedString();
        }
        return sf;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        return this.getShortForm(entity.getIRI());
    }

    @Override
    public void dispose() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringLengthComparator
    implements Comparator<String> {
        private StringLengthComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int diff = o1.length() - o2.length();
            if (diff != 0) {
                return diff;
            }
            return o1.compareTo(o2);
        }
    }
}

