/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owlapi.util.InferredDataPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentDataPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredInverseObjectPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredObjectPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredPropertyAssertionGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubDataPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubObjectPropertyAxiomGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferredOntologyGenerator {
    private OWLReasoner reasoner;
    private List<InferredAxiomGenerator<? extends OWLAxiom>> axiomGenerators;

    public InferredOntologyGenerator(OWLReasoner reasoner, List<InferredAxiomGenerator<? extends OWLAxiom>> axiomGenerators) {
        this.reasoner = reasoner;
        this.axiomGenerators = axiomGenerators;
    }

    public InferredOntologyGenerator(OWLReasoner reasoner) {
        this.reasoner = reasoner;
        this.axiomGenerators = new ArrayList<InferredAxiomGenerator<? extends OWLAxiom>>();
        this.axiomGenerators.add(new InferredClassAssertionAxiomGenerator());
        this.axiomGenerators.add(new InferredDataPropertyCharacteristicAxiomGenerator());
        this.axiomGenerators.add(new InferredEquivalentClassAxiomGenerator());
        this.axiomGenerators.add(new InferredEquivalentDataPropertiesAxiomGenerator());
        this.axiomGenerators.add(new InferredEquivalentObjectPropertyAxiomGenerator());
        this.axiomGenerators.add(new InferredInverseObjectPropertiesAxiomGenerator());
        this.axiomGenerators.add(new InferredObjectPropertyCharacteristicAxiomGenerator());
        this.axiomGenerators.add(new InferredPropertyAssertionGenerator());
        this.axiomGenerators.add(new InferredSubClassAxiomGenerator());
        this.axiomGenerators.add(new InferredSubDataPropertyAxiomGenerator());
        this.axiomGenerators.add(new InferredSubObjectPropertyAxiomGenerator());
    }

    public List<InferredAxiomGenerator> getAxiomGenerators() {
        return new ArrayList<InferredAxiomGenerator>(this.axiomGenerators);
    }

    public void addGenerator(InferredAxiomGenerator<?> generator) {
        if (!this.axiomGenerators.contains(generator)) {
            this.axiomGenerators.add(generator);
        }
    }

    public void removeGenerator(InferredAxiomGenerator generator) {
        this.axiomGenerators.remove(generator);
    }

    public void fillOntology(OWLOntologyManager manager, OWLOntology ontology) throws OWLOntologyChangeException {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (InferredAxiomGenerator<? extends OWLAxiom> axiomGenerator : this.axiomGenerators) {
            for (OWLAxiom oWLAxiom : axiomGenerator.createAxioms(manager, this.reasoner)) {
                changes.add(new AddAxiom(ontology, oWLAxiom));
            }
        }
        manager.applyChanges(changes);
    }
}

