/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectWalker<O extends OWLObject> {
    private OWLOntology ontology;
    private Set<O> objects;
    private OWLObjectVisitorEx<?> visitor;
    private boolean visitDuplicates;
    private OWLAxiom axiom;
    private OWLAnnotation annotation;
    private List<OWLClassExpression> classExpressionPath = new ArrayList<OWLClassExpression>();
    private List<OWLDataRange> dataRangePath = new ArrayList<OWLDataRange>();

    public OWLObjectWalker(Set<O> objects) {
        this(objects, true);
    }

    public OWLObjectWalker(Set<O> objects, boolean visitDuplicates) {
        this.objects = new HashSet<O>(objects);
        this.visitDuplicates = visitDuplicates;
    }

    public void walkStructure(OWLObjectVisitorEx visitor) {
        this.visitor = visitor;
        StructureWalker walker = new StructureWalker();
        for (OWLObject o : this.objects) {
            o.accept(walker);
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLAxiom getAxiom() {
        return this.axiom;
    }

    public OWLAnnotation getAnnotation() {
        return this.annotation;
    }

    public List<OWLClassExpression> getClassExpressionPath() {
        return new ArrayList<OWLClassExpression>(this.classExpressionPath);
    }

    public boolean isFirstClassExpressionInPath(OWLClassExpression classExpression) {
        return !this.classExpressionPath.isEmpty() && this.classExpressionPath.get(0).equals(classExpression);
    }

    private void pushClassExpression(OWLClassExpression ce) {
        this.classExpressionPath.add(ce);
    }

    private void popClassExpression() {
        if (!this.classExpressionPath.isEmpty()) {
            this.classExpressionPath.remove(this.classExpressionPath.size() - 1);
        }
    }

    public List<OWLDataRange> getDataRangePath() {
        return new ArrayList<OWLDataRange>(this.dataRangePath);
    }

    private void pushDataRange(OWLDataRange dr) {
        this.dataRangePath.add(dr);
    }

    private void popDataRange() {
        if (!this.dataRangePath.isEmpty()) {
            this.dataRangePath.remove(this.dataRangePath.size() - 1);
        }
    }

    private class StructureWalker
    implements OWLObjectVisitor {
        private Set<OWLObject> visited = new HashSet<OWLObject>();

        private StructureWalker() {
        }

        private void process(OWLObject object) {
            if (!OWLObjectWalker.this.visitDuplicates) {
                if (!this.visited.contains(object)) {
                    this.visited.add(object);
                    object.accept(OWLObjectWalker.this.visitor);
                }
            } else {
                object.accept(OWLObjectWalker.this.visitor);
            }
        }

        public void visit(IRI iri) {
            this.process(iri);
        }

        public void visit(OWLOntology ontology) {
            OWLObjectWalker.this.ontology = ontology;
            OWLObjectWalker.this.axiom = null;
            this.process(ontology);
            for (OWLAnnotation anno : ontology.getAnnotations()) {
                anno.accept(this);
            }
            for (OWLAxiom ax : ontology.getAxioms()) {
                ax.accept(this);
            }
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getIndividual().accept(this);
            axiom.getClassExpression().accept(this);
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getSubject().accept(this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLLiteral)axiom.getObject()).accept(this);
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getDomain().accept(this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLDataRange)axiom.getRange()).accept(this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
            ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        }

        public void visit(OWLDeclarationAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getEntity().accept(this);
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLIndividual ind : axiom.getIndividuals()) {
                ind.accept(this);
            }
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                desc.accept(this);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                prop.accept(this);
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                prop.accept(this);
            }
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getOWLClass().accept(this);
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                desc.accept(this);
            }
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getSubject().accept(this);
            axiom.getAnnotation().accept(this);
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getProperty().accept(this);
            axiom.getDomain().accept(this);
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getProperty().accept(this);
            axiom.getRange().accept(this);
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getSubProperty().accept(this);
            axiom.getSuperProperty().accept(this);
        }

        public void visit(OWLAnnotation node) {
            this.process(node);
            OWLObjectWalker.this.annotation = node;
            node.getProperty().accept(this);
            node.getValue().accept(this);
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                desc.accept(this);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                prop.accept(this);
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                prop.accept(this);
            }
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getFirstProperty().accept(this);
            axiom.getSecondProperty().accept(this);
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getSubject().accept(this);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLLiteral)axiom.getObject()).accept(this);
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getSubject().accept(this);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLIndividual)axiom.getObject()).accept(this);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getSubject().accept(this);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLIndividual)axiom.getObject()).accept(this);
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
                prop.accept(this);
            }
            axiom.getSuperProperty().accept(this);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getDomain().accept(this);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            ((OWLClassExpression)axiom.getRange()).accept(this);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
            ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            for (OWLIndividual ind : axiom.getIndividuals()) {
                ind.accept(this);
            }
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getSubClass().accept(this);
            axiom.getSuperClass().accept(this);
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        public void visit(SWRLRule rule) {
            this.process(rule);
            OWLObjectWalker.this.axiom = rule;
            for (SWRLAtom at : rule.getBody()) {
                at.accept(this);
            }
            for (SWRLAtom at : rule.getHead()) {
                at.accept(this);
            }
        }

        public void visit(OWLHasKeyAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getClassExpression().accept(this);
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : axiom.getObjectPropertyExpressions()) {
                oWLObjectPropertyExpression.accept(this);
            }
            for (OWLDataPropertyExpression oWLDataPropertyExpression : axiom.getDataPropertyExpressions()) {
                oWLDataPropertyExpression.accept(this);
            }
        }

        public void visit(OWLClass desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            desc.getIRI().accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLDataAllValuesFrom desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLDataExactCardinality desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLDataMaxCardinality desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLDataMinCardinality desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLDataRange)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLDataHasValue desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            ((OWLLiteral)desc.getValue()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLClassExpression)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectComplementOf desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            desc.getOperand().accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectExactCardinality desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLClassExpression)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectIntersectionOf desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            for (OWLClassExpression op : desc.getOperands()) {
                op.accept(this);
            }
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectMaxCardinality desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLClassExpression)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectMinCardinality desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLClassExpression)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectOneOf desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            for (OWLIndividual ind : desc.getIndividuals()) {
                ind.accept(this);
            }
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectHasSelf desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLClassExpression)desc.getFiller()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectUnionOf desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            for (OWLClassExpression op : desc.getOperands()) {
                op.accept(this);
            }
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLObjectHasValue desc) {
            OWLObjectWalker.this.pushClassExpression(desc);
            this.process(desc);
            ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            ((OWLIndividual)desc.getValue()).accept(this);
            OWLObjectWalker.this.popClassExpression();
        }

        public void visit(OWLDataComplementOf node) {
            OWLObjectWalker.this.pushDataRange(node);
            this.process(node);
            node.getDataRange().accept(this);
            OWLObjectWalker.this.popDataRange();
        }

        public void visit(OWLDataOneOf node) {
            OWLObjectWalker.this.pushDataRange(node);
            this.process(node);
            for (OWLLiteral con : node.getValues()) {
                con.accept(this);
            }
            OWLObjectWalker.this.popDataRange();
        }

        public void visit(OWLDataIntersectionOf node) {
            OWLObjectWalker.this.pushDataRange(node);
            this.process(node);
            for (OWLDataRange rng : node.getOperands()) {
                rng.accept(this);
            }
            OWLObjectWalker.this.popDataRange();
        }

        public void visit(OWLDataUnionOf node) {
            OWLObjectWalker.this.pushDataRange(node);
            this.process(node);
            for (OWLDataRange rng : node.getOperands()) {
                rng.accept(this);
            }
            OWLObjectWalker.this.popDataRange();
        }

        public void visit(OWLFacetRestriction node) {
            this.process(node);
            node.getFacetValue().accept(this);
        }

        public void visit(OWLDatatypeRestriction node) {
            OWLObjectWalker.this.pushDataRange(node);
            this.process(node);
            node.getDatatype().accept(this);
            for (OWLFacetRestriction fr : node.getFacetRestrictions()) {
                fr.accept(this);
            }
            OWLObjectWalker.this.popDataRange();
        }

        public void visit(OWLDatatype node) {
            OWLObjectWalker.this.pushDataRange(node);
            this.process(node);
            OWLObjectWalker.this.popDataRange();
        }

        public void visit(OWLLiteral node) {
            this.process(node);
            node.getDatatype().accept(this);
            OWLObjectWalker.this.popDataRange();
        }

        public void visit(OWLAnnotationProperty property) {
            this.process(property);
            property.getIRI().accept(this);
        }

        public void visit(OWLDataProperty property) {
            this.process(property);
            property.getIRI().accept(this);
        }

        public void visit(OWLObjectProperty property) {
            this.process(property);
            property.getIRI().accept(this);
        }

        public void visit(OWLObjectInverseOf property) {
            this.process(property);
            property.getInverse().accept(this);
        }

        public void visit(OWLNamedIndividual individual) {
            this.process(individual);
            individual.getIRI().accept(this);
        }

        public void visit(OWLAnonymousIndividual individual) {
            this.process(individual);
        }

        public void visit(SWRLLiteralArgument node) {
            this.process(node);
            node.getLiteral().accept(this);
        }

        public void visit(SWRLVariable node) {
            this.process(node);
        }

        public void visit(SWRLIndividualArgument node) {
            this.process(node);
            node.getIndividual().accept(this);
        }

        public void visit(SWRLBuiltInAtom node) {
            this.process(node);
            for (SWRLDArgument at : node.getArguments()) {
                at.accept(this);
            }
        }

        public void visit(SWRLClassAtom node) {
            this.process(node);
            ((SWRLIArgument)node.getArgument()).accept(this);
            node.getPredicate().accept(this);
        }

        public void visit(SWRLDataRangeAtom node) {
            this.process(node);
            ((SWRLDArgument)node.getArgument()).accept(this);
            node.getPredicate().accept(this);
        }

        public void visit(SWRLDataPropertyAtom node) {
            this.process(node);
            node.getPredicate().accept(this);
            ((SWRLIArgument)node.getFirstArgument()).accept(this);
            ((SWRLDArgument)node.getSecondArgument()).accept(this);
        }

        public void visit(SWRLDifferentIndividualsAtom node) {
            this.process(node);
            ((SWRLIArgument)node.getFirstArgument()).accept(this);
            ((SWRLIArgument)node.getSecondArgument()).accept(this);
        }

        public void visit(SWRLObjectPropertyAtom node) {
            this.process(node);
            node.getPredicate().accept(this);
            ((SWRLIArgument)node.getFirstArgument()).accept(this);
            ((SWRLIArgument)node.getSecondArgument()).accept(this);
        }

        public void visit(SWRLSameIndividualAtom node) {
            this.process(node);
            ((SWRLIArgument)node.getFirstArgument()).accept(this);
            ((SWRLIArgument)node.getSecondArgument()).accept(this);
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
            this.process(axiom);
            OWLObjectWalker.this.axiom = axiom;
            axiom.getDatatype().accept(this);
            axiom.getDataRange().accept(this);
        }
    }
}

