/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLAnnotationPropertyDomainAxiomImpl
extends OWLAxiomImpl
implements OWLAnnotationPropertyDomainAxiom {
    private OWLAnnotationProperty property;
    private IRI domain;

    public OWLAnnotationPropertyDomainAxiomImpl(OWLDataFactory dataFactory, OWLAnnotationProperty property, IRI domain, Collection<? extends OWLAnnotation> annotations) {
        super(dataFactory, annotations);
        this.domain = domain;
        this.property = property;
    }

    @Override
    public OWLAnnotationPropertyDomainAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return this.getOWLDataFactory().getOWLAnnotationPropertyDomainAxiom(this.getProperty(), this.getDomain());
    }

    @Override
    public OWLAnnotationPropertyDomainAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return this.getOWLDataFactory().getOWLAnnotationPropertyDomainAxiom(this.getProperty(), this.getDomain(), this.mergeAnnos(annotations));
    }

    @Override
    public IRI getDomain() {
        return this.domain;
    }

    @Override
    public OWLAnnotationProperty getProperty() {
        return this.property;
    }

    public AxiomType getAxiomType() {
        return AxiomType.ANNOTATION_PROPERTY_DOMAIN;
    }

    @Override
    public boolean isLogicalAxiom() {
        return false;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLAnnotationPropertyDomainAxiom other = (OWLAnnotationPropertyDomainAxiom)object;
        int diff = this.property.compareTo(other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return this.domain.compareTo(other.getDomain());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLAnnotationPropertyDomainAxiom)) {
            return false;
        }
        OWLAnnotationPropertyDomainAxiom other = (OWLAnnotationPropertyDomainAxiom)obj;
        return this.property.equals(other.getProperty()) && this.domain.equals(other.getDomain()) && ((Object)this.getAnnotations()).equals(other.getAnnotations());
    }
}

